// NOTE: A minified copy of this script will be generated by grunt. Only the minified file will be included in zipped releases.

/**
 * Callback for the 'onload' and 'onerror' events of <link>/<script> tags for page resources.
 *
 * @param {HTMLElement} el
 * @param {boolean}     is_error
 */
function et_core_page_resource_fallback( el, is_error ) {
	if ( 'undefined' === typeof is_error ) {
		// This is an onload event (Internet Explorer doesn't fire 'onerror' for link tags)
		is_error = el.sheet.cssRules && 0 === el.sheet.cssRules.length;
	}

	if ( ! is_error ) {
		return;
	}

	// Prevent infinite recursion
	el.onerror = null;
	el.onload  = null;

	if ( el.href ) {

		el.href = et_site_url + '/?et_core_page_resource=' + el.id + et_post_id;
	} else if ( el.src ) {
		el.src = et_site_url + '/?et_core_page_resource=' + el.id + et_post_id;
	}
}

