<?php

	/*
	*
	*	Uplift Functions
	*	------------------------------------------------
	*	Swift Framework
	* 	Copyright Swift Ideas 2015 - http://www.swiftideas.com
	*
	*	VARIABLE DEFINITIONS
	*	PLUGIN INCLUDES
	*	THEME UPDATER
	*	THEME SUPPORT
	*	THUMBNAIL SIZES
	*	CONTENT WIDTH
	*	LOAD THEME LANGUAGE
	*	uplift_custom_content_functions()
	*	uplift_include_framework()
	*	uplift_enqueue_styles()
	*	uplift_enqueue_scripts()
	*	uplift_load_custom_scripts()
	*	uplift_admin_scripts()
	*	uplift_layerslider_overrides()
	*
	*/


	/* VARIABLE DEFINITIONS
	================================================== */
	define('UPLIFT_TEMPLATE_PATH', get_template_directory());
	define('UPLIFT_INCLUDES_PATH', UPLIFT_TEMPLATE_PATH . '/includes');
	define('UPLIFT_FRAMEWORK_PATH', UPLIFT_TEMPLATE_PATH . '/swift-framework');
	define('UPLIFT_LOCAL_PATH', get_template_directory_uri());

	/* PLUGIN INCLUDES
	================================================== */
	require_once(UPLIFT_INCLUDES_PATH . '/plugins/aq_resizer.php');
 	include_once(UPLIFT_INCLUDES_PATH . '/plugin-includes.php');
	require_once(UPLIFT_INCLUDES_PATH . '/theme_update_check.php');
	$UpliftUpdateChecker = new ThemeUpdateChecker(
	    "uplift",
	    "https://kernl.us/api/v1/theme-updates/56e6f9e32b402cc12fbc1ae2/"
	);
	
	/* ENVATO REQUIREMENTS DATE
	================================================== */
	if ( get_option( 'envato_requirements' ) == false ) {
		update_option( 'envato_requirements', 'may2019' );
	}

	
	/* THEME SETUP
	================================================== */
	if (!function_exists('uplift_theme_setup')) {
		function uplift_theme_setup() {

			/* SF THEME OPTION CHECK
			================================================== */
			if ( get_option( 'sf_theme' ) == false ) {
				update_option( "sf_theme", "uplift" );
			}

			/* THEME SUPPORT
			================================================== */
			add_theme_support( 'structured-post-formats', array('audio', 'gallery', 'image', 'link', 'video') );
			add_theme_support( 'post-formats', array('aside', 'chat', 'quote', 'status') );
			add_theme_support( 'automatic-feed-links' );
			add_theme_support( 'post-thumbnails' );
			add_theme_support( 'title-tag' );
			add_theme_support( 'custom-logo' );
			add_theme_support( 'custom-background' );
			add_theme_support( 'woocommerce' );
			add_theme_support( 'wc-product-gallery-zoom' );
			add_theme_support( 'wc-product-gallery-lightbox' );
			add_theme_support( 'wc-product-gallery-slider' );
			add_theme_support( 'customize-selective-refresh-widgets' );
			add_theme_support( "swiftframework", array(
				'font-awesome-v5'			=> true,
				'widgets'					=> true,
				'swift-smartscript'			=> true,
				'slideout-menu'				=> true,
				'pushnav-menu'				=> true,
				'split-nav-menu'			=> true,
				'page-heading-woocommerce'	=> false,
				'pagination-fullscreen'		=> false,
				'bordered-button'			=> true,
				'3drotate-button'			=> false,
				'rounded-button'			=> true,
				'product-inner-heading'		=> false,
				'product-summary-tabs'		=> false,
				'product-layout-opts'		=> true,
				'mobile-shop-filters' 		=> true,
				'mobile-logo-override'		=> true,
				'product-multi-masonry'		=> true,
				'product-preview-slider'	=> true,
				'super-search-config'		=> true,
				'advanced-row-styling'		=> true,
				'gizmo-icon-font'			=> false,
				'icon-mind-font'			=> false,
				'nucleo-general-font'		=> true,
				'nucleo-interface-font'		=> true,
				'nucleo-svg-icons'			=> true,
				'menu-new-badge'			=> true,
				'menu-button-advanced'		=> true,
				'advanced-map-styles'		=> true,
				'minimal-team-hover'		=> true,
				'posts-showcase'			=> true,
				'alt-gallery-hover'			=> true,
				'counter-hr-divide-icon'	=> true,
				'alt-recent-post-list'		=> true,
				'page-heading-woo-description' => true,
				'header-aux-modals'			=> true,
				'max-mega-menu'				=> true,
				'swift-smartsidebar'		=> true,
				'spb-team-ajax'				=> true,
				'spb-port-showcase-alt'		=> true,
				'transparent-sticky-header' => true,
				'hamburger-css' 			=> true
			) );

			/* THUMBNAIL SIZES
			================================================== */
			set_post_thumbnail_size( 220, 150, true);
			add_image_size( 'sf-thumb-image', 600, 450, true);
			add_image_size( 'sf-thumb-image-twocol', 900, 675, true);
			add_image_size( 'sf-image-onecol', 1800, 1200, true);
			add_image_size( 'sf-large-square', 1200, 1200, true);

			/* CONTENT WIDTH
			================================================== */
			if ( ! isset( $content_width ) ) $content_width = 1140;

			/* LOAD THEME LANGUAGE
			================================================== */
			load_theme_textdomain('uplift', UPLIFT_TEMPLATE_PATH.'/language');

			uplift_migrate_old_theme_data();

		}
		add_action( 'after_setup_theme', 'uplift_theme_setup' );
	}

	/* MIGRATION
	================================================== */
	function uplift_migrate_old_theme_data() {
		$uplift_options = get_option('sf_uplift_options');

		// LOGO
		if (isset($uplift_options['logo_upload']) && !has_custom_logo()) {
			
			// get logo data
			$logo = $uplift_options['logo_upload'];
			if ( isset($logo['id']) ) {
				$logo_id = $logo['id'];

				// save to customizer
				set_theme_mod( 'custom_logo', $logo_id );
				set_theme_mod( 'delete_logo_option', true );
			}

		}
	}

	function uplift_delete_old_theme_opts() {
		global $reduxConfig;

		// delete logo
		if ( get_theme_mod('delete_logo_option') ) {
			$reduxConfig->ReduxFramework->set('logo_upload', '');
			remove_theme_mod('delete_logo_option');
		}
	}
	add_action('init', 'uplift_delete_old_theme_opts', 99);


	/* INCLUDE SIDEBARS / OVERRIDES
	================================================== */
	include_once( UPLIFT_FRAMEWORK_PATH . '/core/sf-sidebars.php' );
	require_once(UPLIFT_INCLUDES_PATH . '/overrides/sf-theme-overrides.php');
	
	
	/* LOAD META BOXES
	================================================== */
	include_once(UPLIFT_INCLUDES_PATH . '/meta-boxes.php');
	
	
	/* INCLUDE FRAMEWORK
	================================================== */
	if (!function_exists('uplift_include_framework')) {
		function uplift_include_framework() {
			
			// Overrides
			require_once(UPLIFT_INCLUDES_PATH . '/overrides/sf-theme-functions.php');
			require_once(UPLIFT_INCLUDES_PATH . '/overrides/sf-header-overrides.php');
			require_once(UPLIFT_INCLUDES_PATH . '/overrides/sf-blog-overrides.php');
			require_once(UPLIFT_INCLUDES_PATH . '/overrides/sf-portfolio-overrides.php');
			require_once(UPLIFT_INCLUDES_PATH . '/overrides/sf-gallery-overrides.php');
			require_once(UPLIFT_INCLUDES_PATH . '/overrides/sf-spb-overrides.php');
			
			// Base Framework
			require_once(UPLIFT_FRAMEWORK_PATH . '/swift-framework.php');	
			
			// Customizer functionality
			require_once(UPLIFT_INCLUDES_PATH . '/customizer/customizer.php');

			// Style Switcher
			include_once(UPLIFT_INCLUDES_PATH . '/sf-styleswitcher/sf-styleswitcher.php');
			
			// Category Colors
			include_once(UPLIFT_INCLUDES_PATH . '/sf-category-colors.php');
			
			// Framework overrides
			include_once(UPLIFT_INCLUDES_PATH . '/overrides/sf-framework-overrides.php');
			
			// WooCommerce
			require_once(UPLIFT_INCLUDES_PATH . '/overrides/sf-woocommerce-overrides.php');
		}
		add_action('init', 'uplift_include_framework', 5);
	}
	

	/* THEME OPTIONS FRAMEWORK
	================================================== */
	if (!function_exists('uplift_include_theme_options')) {
		function uplift_include_theme_options() {
			require_once( UPLIFT_INCLUDES_PATH . '/option-extensions/loader.php' );
			require_once( UPLIFT_INCLUDES_PATH . '/sf-options.php' );
			global $sf_uplift_options, $uplift_options;
			$uplift_options = $sf_uplift_options;
		}
		add_action('init', 'uplift_include_theme_options', 10);
	}
	
	
	/* THEME OPTIONS VAR RETRIEVAL
	================================================== */
	if (!function_exists('uplift_get_theme_opts')) {
		function uplift_get_theme_opts() {
			global $sf_uplift_options;
			return $sf_uplift_options;
		}
	}

	
	/* LOVE IT INCLUDE
	================================================== */
	if (!function_exists('uplift_love_it_include')) {
		function uplift_love_it_include() {
			$uplift_options = uplift_get_theme_opts();
			$disable_loveit = false;
			if (isset($uplift_options['disable_loveit'])) {
			$disable_loveit = $uplift_options['disable_loveit'];
			}

			if (!$disable_loveit) {
			include_once(UPLIFT_INCLUDES_PATH . '/plugins/love-it-pro/love-it-pro.php');
			}
		}
		add_action('init', 'uplift_love_it_include', 20);
	}


	/* LOAD STYLESHEETS
	================================================== */
	if (!function_exists('uplift_enqueue_styles')) {
		function uplift_enqueue_styles() {

			global $is_IE;
			$uplift_options = uplift_get_theme_opts();
			$enable_responsive = $uplift_options['enable_responsive'];
			$enable_rtl = $uplift_options['enable_rtl'];

		    wp_enqueue_style('bootstrap', UPLIFT_LOCAL_PATH . '/css/bootstrap.min.css', array(), NULL, 'all');
		    wp_enqueue_style('font-awesome-v5', UPLIFT_LOCAL_PATH .'/css/font-awesome.min.css', array(), '5.2.0', 'all');
		    wp_enqueue_style('font-awesome-v4shims', UPLIFT_LOCAL_PATH .'/css/v4-shims.min.css', array(), NULL, 'all');

			wp_enqueue_style('uplift-iconfont', UPLIFT_LOCAL_PATH . '/css/iconfont.css', array(), NULL, 'all');
		    wp_enqueue_style('uplift-main', UPLIFT_LOCAL_PATH . '/css/main.css', array(), NULL, 'all');

		    if (uplift_woocommerce_activated()) {
		    	wp_enqueue_style('uplift-woocommerce', UPLIFT_LOCAL_PATH . '/css/sf-woocommerce.css', array(), NULL, 'all');
		    }

		    if (is_rtl() || $enable_rtl || isset($_GET['RTL'])) {
		    	wp_enqueue_style('uplift-rtl', UPLIFT_LOCAL_PATH . '/rtl.css', array(), NULL, 'all');
		    }

		    if ($enable_responsive) {
		    	wp_enqueue_style('uplift-responsive', UPLIFT_LOCAL_PATH . '/css/sf-responsive.css', array(), NULL, 'all');
		    }

			wp_enqueue_style('uplift-style', get_stylesheet_directory_uri() . '/style.css', array(), NULL, 'all');
		}
		add_action('wp_enqueue_scripts', 'uplift_enqueue_styles');
	}


	/* LOAD FRONTEND SCRIPTS
	================================================== */
	if (!function_exists('uplift_enqueue_scripts')) {
		function uplift_enqueue_scripts() {

			// Variables
			global $post;
			$uplift_options = uplift_get_theme_opts();
		    $enable_rtl = $uplift_options['enable_rtl'];
			$post_type = get_query_var('post_type');
			$product_zoom = $uplift_options['enable_product_zoom'];
			$header_left_config  = $uplift_options['header_left_config'];
            $header_right_config = $uplift_options['header_right_config'];
			$product_zoom_mobile = false;
			if ( isset($_GET['product_zoom']) ) {
				$product_zoom = true;
			}
			if ( isset ( $uplift_options['enable_product_zoom_mobile'] ) ) {
				$product_zoom_mobile = true;
			}
			$gmaps_api_key = get_option('sf_gmaps_api_key');

		    // Enqueue
		    wp_enqueue_script('jquery');
		    wp_enqueue_script('js-cookie', UPLIFT_LOCAL_PATH . '/js/lib/js.cookie.js', array(), NULL, TRUE);
		    wp_enqueue_script('plyr', UPLIFT_LOCAL_PATH . '/js/lib/plyr.js', array(), NULL, FALSE);	
			if ( is_singular() && comments_open() && get_option('thread_comments') ) {
				wp_enqueue_script( 'comment-reply' );
			}
    		wp_enqueue_script('modernizr', UPLIFT_LOCAL_PATH . '/js/lib/modernizr.js', array(), NULL, TRUE);
    		wp_enqueue_script('bootstrap', UPLIFT_LOCAL_PATH . '/js/lib/bootstrap.min.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-ui', UPLIFT_LOCAL_PATH . '/js/lib/jquery-ui-1.11.4.custom.min.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('lightslider', UPLIFT_LOCAL_PATH . '/js/lib/lightslider.min.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('imagesloaded', UPLIFT_LOCAL_PATH . '/js/lib/imagesloaded.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-equalHeights', UPLIFT_LOCAL_PATH . '/js/lib/jquery.equalHeights.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-smartresize', UPLIFT_LOCAL_PATH . '/js/lib/jquery.smartresize.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-infinitescroll', UPLIFT_LOCAL_PATH . '/js/lib/jquery.infinitescroll.min.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-stickyplugin', UPLIFT_LOCAL_PATH . '/js/lib/jquery.stickyplugin.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-touchswipe', UPLIFT_LOCAL_PATH . '/js/lib/jquery.touchSwipe.min.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-transit', UPLIFT_LOCAL_PATH . '/js/lib/jquery.transit.min.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-appear', UPLIFT_LOCAL_PATH . '/js/lib/jquery.appear.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-autoGrowInput', UPLIFT_LOCAL_PATH . '/js/lib/jquery.auto-grow-input.min.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-waypoints', UPLIFT_LOCAL_PATH . '/js/lib/jquery.waypoints.min.js', array('jquery'), NULL, TRUE);
			wp_enqueue_script('ilightbox', UPLIFT_LOCAL_PATH . '/js/lib/ilightbox.min.js', 'jquery', NULL, TRUE);
			wp_enqueue_script('owlcarousel', UPLIFT_LOCAL_PATH . '/js/lib/owl.carousel.min.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-isotope', UPLIFT_LOCAL_PATH . '/js/lib/jquery.isotope.min.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-dotdotdot', UPLIFT_LOCAL_PATH . '/js/lib/jquery.dotdotdot.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-easing', UPLIFT_LOCAL_PATH . '/js/lib/jquery.easing.1.3.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-fittext', UPLIFT_LOCAL_PATH . '/js/lib/jquery.fittext.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-hoverIntent', UPLIFT_LOCAL_PATH . '/js/lib/jquery.hoverIntent.min.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-stellar', UPLIFT_LOCAL_PATH . '/js/lib/jquery.stellar.min.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-stickem', UPLIFT_LOCAL_PATH . '/js/lib/jquery.stickem.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-timeago', UPLIFT_LOCAL_PATH . '/js/lib/jquery.timeago.js', array('jquery'), NULL, TRUE);
    		wp_enqueue_script('jquery-viewport', UPLIFT_LOCAL_PATH . '/js/lib/jquery.viewport.js', array('jquery'), NULL, TRUE);	
    		wp_enqueue_script('jquery-visible', UPLIFT_LOCAL_PATH . '/js/lib/jquery.visible.min.js', array('jquery'), NULL, TRUE);	
    		wp_enqueue_script('google-maps', '//maps.google.com/maps/api/js?key=' . $gmaps_api_key, array('jquery'), NULL, TRUE);
    		wp_enqueue_script('uplift-functions', UPLIFT_LOCAL_PATH . '/js/functions.js', array('jquery'), NULL, TRUE);
		}
		add_action('wp_enqueue_scripts', 'uplift_enqueue_scripts');
	}


	/* LOAD BACKEND SCRIPTS
	================================================== */
	function uplift_admin_scripts( $hook ) {    				
		wp_enqueue_script('admin-functions', get_template_directory_uri() . '/js/sf-admin.js', 'jquery', '1.0', TRUE);				
		if ( 'nav-menus.php' == $hook ) {
			wp_enqueue_style('fontawesome', get_template_directory_uri() .'/css/font-awesome.min.css', array(), NULL, 'all');
			wp_enqueue_style('uplift-iconfont', get_template_directory_uri() . '/css/iconfont.css', array(), NULL, 'all');
		}
	}
	add_action('admin_enqueue_scripts', 'uplift_admin_scripts');


	/* WOO CHECKOUT BUTTON
	================================================== */
	if ( ! function_exists( 'uplift_woocommerce_button_proceed_to_checkout' ) ) {
		function uplift_woocommerce_button_proceed_to_checkout() {
			$checkout_url = wc_get_checkout_url();
			?>
			<a class="sf-button standard checkout-button accent" href="<?php echo esc_url($checkout_url); ?>">
				<span class="text"><?php _e( 'Checkout', 'uplift' ); ?></span>
			</a>
			<?php
		}
	}


	/* CHECK THEME FEATURE SUPPORT
    ================================================== */
    if ( !function_exists( 'uplift_theme_supports' ) ) {
        function uplift_theme_supports( $feature ) {
        	$supports = get_theme_support( "swiftframework" );
        	$supports = $supports[0];
    		if ( !isset($supports[ $feature ]) || $supports[ $feature ] == "") {
    			return false;
    		} else {
        		return isset( $supports[ $feature ] );
        	}
        }
    }


    /* GET CAROUSEL ID
	================================================== */
	if (!function_exists('uplift_get_carousel_id')) {
		function uplift_get_carousel_id() {
			global $sf_carouselID;
			if ($sf_carouselID == "") {
			$sf_carouselID = 1;
			} else {
			$sf_carouselID++;
			}
			return $sf_carouselID;
		}
	}


	/* GET SUPER SEARCH COUNT
	================================================== */
	if (!function_exists('uplift_get_supersearch_count')) {
		function uplift_get_supersearch_count() {
			global $uplift_supersearch_count;
			if ($uplift_supersearch_count == "") {
				$uplift_supersearch_count = 1;
			} else {
				$uplift_supersearch_count++;
			}
			return $uplift_supersearch_count;
		}
	}

	/* GET PRODUCT DISPLAY
	================================================== */
	if (!function_exists('uplift_get_product_display')) {
		function uplift_get_product_display() {
			global $uplift_product_multimasonry, $uplift_product_display_type, $uplift_product_display_layout;

			// Return array
            $product_display = array(
                "multi-masonry"   => $uplift_product_multimasonry,
                "display-type" 	  => $uplift_product_display_type,
                "display-layout"  => $uplift_product_display_layout
            );

            return $product_display;
		}
	}
	function uplift_set_product_multimasonry($bool) {
		global $uplift_product_multimasonry;
		$uplift_product_multimasonry = $bool;
	}


	/* GET CATALOG MODE
	================================================== */
	if (!function_exists('uplift_get_catalog_mode')) {
		function uplift_get_catalog_mode() {
			$uplift_options = uplift_get_theme_opts();
			$enable_catalog_mode = false;
			// Catalog Mode
			if ( isset( $uplift_options['enable_catalog_mode'] ) ) {
				$enable_catalog_mode = $uplift_options['enable_catalog_mode'];
			}
			if ( isset( $_GET['catalog_mode'] ) ) {
			    $enable_catalog_mode = $_GET['catalog_mode'];
			}

			return $enable_catalog_mode;
		}
	}
    
    
    /* HEADER ACTION
    ================================================== */
    if ( !function_exists( 'uplift_head_action_adjust' ) ) {
	    function uplift_head_action_adjust() {
	        global $post;
	        $uplift_options = uplift_get_theme_opts();
	        $page_header_type = "";
	        $page_layout      = $uplift_options['page_layout'];
	        $header_layout    = $uplift_options['header_layout'];
	        	        
	        if (isset($_GET['header'])) {
	        	$header_layout = $_GET['header'];
	        }
	        if ( isset( $_GET['layout'] ) ) {
	            $page_layout = $_GET['layout'];
	        }
	        if ( is_page() && $post ) {
	            $page_header_type = uplift_get_post_meta( $post->ID, 'sf_page_header_type', true );
	        }
			if ( $page_header_type == "below-slider" && $page_layout == "boxed" ) {
				add_action( 'uplift_before_page_container', 'uplift_pageslider', 20 );
	        } else if ( $page_header_type == "below-slider" && ( $header_layout != "header-vert" || $header_layout != "header-vert-right" ) ) {
	            add_action( 'uplift_container_start', 'uplift_pageslider', 5 );
	        } else {
	            add_action( 'uplift_container_start', 'uplift_pageslider', 30 );
	        }
	
	        if ( $page_header_type == "naked-light" || $page_header_type == "naked-dark" ) {
	            remove_action( 'uplift_main_container_start', 'uplift_breadcrumbs', 20 );
	        }
	    }
	    add_action( 'wp_head', 'uplift_head_action_adjust' );
    }
    

    /* SIDEBAR FILTERS
	================================================== */
	function uplift_sidebar_before_title() {
		return '<div class="widget-heading title-wrap clearfix"><h3 class="spb-heading"><span>';
	}
	add_filter('uplift_sidebar_before_title', 'uplift_sidebar_before_title');

	function uplift_sidebar_after_title() {
		return '</span></h3></div>';
	}
	add_filter('uplift_sidebar_after_title', 'uplift_sidebar_after_title');


	/* FOOTER FILTERS
	================================================== */
	function uplift_footer_before_title() {
		return '<div class="widget-heading title-wrap clearfix"><h3 class="spb-heading"><span>';
	}
	add_filter('uplift_footer_before_title', 'uplift_footer_before_title');

	function uplift_footer_after_title() {
		return '</span></h3></div>';
	}
	add_filter('uplift_footer_after_title', 'uplift_footer_after_title');

	/* META BOX MISSING FALLBACK
    ================================================== */
	if (!function_exists('rwmb_meta')) {
		function rwmb_meta($key, $args, $postID = null) {
			if (!$postID) {
				$postID = get_the_ID();
			}
			return get_post_meta($postID, $key, true);
		}
	}

	/* SWIFT FRAMEWORK CHECK
    ================================================== */
    if ( ! function_exists( 'uplift_framework_check' ) ) {
        function uplift_framework_check() {

        	if ( class_exists( 'swiftframework' ) || !( current_user_can('editor') || current_user_can('administrator') ) ) {
        		return;
        	}

            $class = 'notice notice-error';
            $message = __( 'Please install/activate the Swift Framework plugin. If you have not installed the plugin, please go to Appearance > Install Plugins.', 'uplift' );

            printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) ); 
        }
        add_action( 'admin_notices', 'uplift_framework_check' );
    }
    
    /* REDUX CHECK
    ================================================== */
    if ( ! function_exists( 'uplift_redux_check' ) ) {
        function uplift_redux_check() {

        	if ( class_exists( 'ReduxFramework' ) || !( current_user_can('editor') || current_user_can('administrator') ) ) {
        		return;
        	}

            $class = 'notice notice-error';
            $message = __( 'Please install/activate the Redux Framework plugin. If you have not installed the plugin, please go to Appearance > Install Plugins.', 'uplift' );

            printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) ); 
        }
        add_action( 'admin_notices', 'uplift_redux_check' );
    }

    /* META BOX CHECK
    ================================================== */
    if ( ! function_exists( 'uplift_metabox_check' ) ) {
        function uplift_metabox_check() {

        	if ( class_exists( 'RW_Meta_Box' ) || !( current_user_can('editor') || current_user_can('administrator') ) ) {
        		return;
        	}

            $class = 'notice notice-error';
            $message = __( 'Please install/activate the Meta Box plugin. If you have not installed the plugin, please go to Appearance > Install Plugins.', 'uplift' );

            printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) ); 
        }
        add_action( 'admin_notices', 'uplift_metabox_check' );
    }
		
		
		function register_session(){
    if( !session_id() )
        session_start();
}
add_action('init','register_session');
		
/**/
function health_function() {
	//$link = the_permalink();
	$output .= '<div class="container hlthroW">
				<div class="hlthroWinner">
				<div class="row toproW">
					<div class="spb-row-no-cols-wrapper spb-row-multi-col clearfix"> <section class="row ">
	<div class="spb-animated-headline spb_content_element col-sm-12">
		<div class="spb-asset-content">
			<div class="sf-headline text-left letters type impact-text-large" style="color:#0093d0;">
				HEALTH CARE PROFESSIONAL INFORMATION
				<span class="sf-words-wrapper">
					<b class="is-visible" style="opacity: 1;"></b>
				</span>
			</div>
		</div>
	</div> </section>
 <section class="row ">
	<div class="spb-animated-headline spb_content_element col-sm-12 bolD2">
		<div class="spb-asset-content">
			<h1 class="sf-headline text-left rotate-1 " style="color:#015ca3;">
				FERRRING REPRODUCTIVE HEALTH OBSTETRICS PRODUCTS
				<span class="sf-words-wrapper" style="width: 10px;">
					<b class="is-visible"></b>
				</span>
			</h1>
		</div>
	</div> </section>
 <section class="row "><div class="divider-wrap col-sm-12"><div class="spb_divider standard spb_content_element seperatoR" style="margin-top: 0px; margin-bottom: 0px;"></div>
</div></section>
 </div>
 
				</div><br /><br />
				<div class="row">
					<div class="col-xs-6"></div>
					<div class="col-xs-6">
						<div class="col-xs-4">
							<img class="img-responsive" src="'.get_template_directory_uri().'/images/window.jpg" />
						</div>
						<div class="col-xs-8">							
								<h3 class="purple">INDUCTION OF LABOUR (IOL) RESOURCE CENTRE</h3>							
							<div class="col-xs-6">
								<img class="img-responsive" src="'.get_template_directory_uri().'/images/Cervidil_CMYK-v2.png" />
							</div>
							<div class="col-xs-6">
								<a class="purplebtn" href="'.$link.'/ferring/en/induction-of-labour-iol/">LEARN MORE</a>
							</div>
						</div>
						</div>
				</div>
				<br />
						<div class="row">
							<div class="col-xs-6"></div>
							<div class="col-xs-6">
								<div class="col-xs-4">
									<img class="img-responsive" src="'.get_template_directory_uri().'/images/hospital-bed.jpg" />
								</div>
								<div class="col-xs-8">							
										<h3 class="lightpurple">POSTPARTUM HAEMORRHAGE RESOURCE CENTRE</h3>							
									<div class="col-xs-6">
										<img class="img-responsive" src="'.get_template_directory_uri().'/images/DURATOCIN_logo_example-(with-Pr)2.png" />
									</div>
									<div class="col-xs-6">
			<a class="lightpurplebtn" href="'.$link.'/ferring/en/postpardum-haemorrhage-resource-centre-pph/">COMING SOON</a>
									</div>
								</div>
							</div>
						</div>
						<br />
					<div class="row">
						<div class="col-xs-6"></div>
							<div class="col-xs-6">
								<div class="col-xs-12">
								<p class="bluefonT">
									<span>EMAIL:</span> <a href="mailto:CA0-MEDICALINFORMATI@FERRING.COM">CA0-MEDICALINFORMATI@FERRING.COM</a>
										<br />
									<span>PHONE:</span> <a href="tel:1-866-384-1314">1-866-384-1314</a>
								</p>
								</div>					
							</div>
					</div>
					</div>
					</div>';
	return $output;
}
add_shortcode( 'health', 'health_function' );

function login_function() {
	//$link = the_permalink();
	$output = '<form action="'.get_site_url().'/user-lock.php" method="post" class="wpcf7-form" novalidate="novalidate">
					
					<div class="row">
					<p class="col-sm-8"><span class="wpcf7-form-control-wrap password"><input type="text" name="mpassword" value="" size="40" class="wpcf7-form-control wpcf7-text" aria-invalid="false" placeholder="Password"></span></p>
					<p class="col-sm-4"><input type="submit" value="SIGN IN" class="wpcf7-form-control wpcf7-submit"><span class="ajax-loader"></span></p>
					</div>
					<div class="wpcf7-response-output wpcf7-display-none" aria-hidden="true"></div>
				</form>';
	return $output;
}
add_shortcode( 'login-form', 'login_function' );		
/**/		



/** Mine Menu Shortcode Start ***/
function print_menu_shortcode($atts, $content = null) {
extract(shortcode_atts(array( 							
							'name' 				=> null, 
							'class' 			=> null ), $atts));
							
							if($_SESSION['user_login_custom'])
							{ 
								 return wp_nav_menu( array( 
									'menu' 				=> $name, 
									'menu_class' 		=> 'mega-menu max-mega-menu mega-menu-horizontal', 
									'container_class'   => 'std-menu clearfix othermenU',							
									'echo'				=> false ) ); 
							}							
}
add_shortcode('minemenu', 'print_menu_shortcode');
/** Mine Menu Shortcode End *****/