<?php
	/*
	*
	*	Swift Framework - Page Builder Overrides
	*	------------------------------------------------
	*	Uplift specific functionality
	* 	Copyright Swift Ideas 2015 - http://www.swiftideas.com
	*
	*/
	
	
	/* ADD SVG ICONS
	================================================== */
	if ( ! function_exists( 'uplift_spb_svg_icons_list' ) ) {
	    function uplift_spb_svg_icons_list( $icons ) {
	    	$coloured_svg_icons = array(
                'arrows-color-1_cloud-download-95' => 'arrows-color-1_cloud-download-95', 
                'arrows-color-1_cloud-upload-96' => 'arrows-color-1_cloud-upload-96', 
                'arrows-color-2_file-download-87' => 'arrows-color-2_file-download-87', 
                'arrows-color-2_file-upload-86' => 'arrows-color-2_file-upload-86', 
                'arrows-color-2_lines' => 'arrows-color-2_lines', 
                'arrows-color-2_replay' => 'arrows-color-2_replay', 
                'arrows-color-3_cloud-refresh' => 'arrows-color-3_cloud-refresh', 
                'business-color_agenda' => 'business-color_agenda', 
                'business-color_award-48' => 'business-color_award-48', 
                'business-color_award-49' => 'business-color_award-49', 
                'business-color_badge' => 'business-color_badge', 
                'business-color_board-28' => 'business-color_board-28', 
                'business-color_board-29' => 'business-color_board-29', 
                'business-color_board-30' => 'business-color_board-30', 
                'business-color_briefcase-26' => 'business-color_briefcase-26', 
                'business-color_building' => 'business-color_building', 
                'business-color_bulb-63' => 'business-color_bulb-63', 
                'business-color_business-contact-85' => 'business-color_business-contact-85', 
                'business-color_business-contact-86' => 'business-color_business-contact-86', 
                'business-color_business-contact-87' => 'business-color_business-contact-87', 
                'business-color_business-contact-88' => 'business-color_business-contact-88', 
                'business-color_businessman-03' => 'business-color_businessman-03', 
                'business-color_calculator' => 'business-color_calculator', 
                'business-color_cheque' => 'business-color_cheque', 
                'business-color_connect' => 'business-color_connect', 
                'business-color_factory' => 'business-color_factory', 
                'business-color_globe' => 'business-color_globe', 
                'business-color_goal-64' => 'business-color_goal-64', 
                'business-color_gold' => 'business-color_gold', 
                'business-color_hammer' => 'business-color_hammer', 
                'business-color_handout' => 'business-color_handout', 
                'business-color_handshake' => 'business-color_handshake', 
                'business-color_hierarchy-55' => 'business-color_hierarchy-55', 
                'business-color_payment' => 'business-color_payment', 
                'business-color_pig' => 'business-color_pig', 
                'business-color_pin' => 'business-color_pin', 
                'business-color_progress' => 'business-color_progress', 
                'business-color_safe' => 'business-color_safe', 
                'business-color_signature' => 'business-color_signature', 
                'emoticons-color_bomb' => 'emoticons-color_bomb', 
                'emoticons-color_manga-62' => 'emoticons-color_manga-62', 
                'emoticons-color_sad' => 'emoticons-color_sad', 
                'emoticons-color_smile' => 'emoticons-color_smile', 
                'envir-color_recycling' => 'envir-color_recycling', 
                'envir-color_save-planet' => 'envir-color_save-planet', 
                'food-color_beer-95' => 'food-color_beer-95', 
                'food-color_carrot' => 'food-color_carrot', 
                'food-color_cocktail' => 'food-color_cocktail', 
                'food-color_cutlery-77' => 'food-color_cutlery-77', 
                'food-color_donut' => 'food-color_donut', 
                'food-color_fish' => 'food-color_fish', 
                'food-color_grape' => 'food-color_grape', 
                'food-color_moka' => 'food-color_moka', 
                'food-color_mug' => 'food-color_mug', 
                'food-color_pizza-slice' => 'food-color_pizza-slice', 
                'gestures-color_double-tap' => 'gestures-color_double-tap', 
                'gestures-color_pinch' => 'gestures-color_pinch', 
                'gestures-color_scroll-horitontal' => 'gestures-color_scroll-horitontal', 
                'gestures-color_scroll-vertical' => 'gestures-color_scroll-vertical', 
                'gestures-color_stretch' => 'gestures-color_stretch', 
                'gestures-color_touch-id' => 'gestures-color_touch-id', 
                'holidays-color_cockade' => 'holidays-color_cockade', 
                'holidays-color_gift' => 'holidays-color_gift', 
                'holidays-color_gift-exchange' => 'holidays-color_gift-exchange', 
                'holidays-color_message' => 'holidays-color_message', 
                'location-color_appointment' => 'location-color_appointment', 
                'location-color_flag-complex' => 'location-color_flag-complex', 
                'location-color_map-gps' => 'location-color_map-gps', 
                'location-color_map-pin' => 'location-color_map-pin', 
                'location-color_treasure-map-40' => 'location-color_treasure-map-40', 
                'location-color_world-pin' => 'location-color_world-pin', 
                'media-color-1_action-74' => 'media-color-1_action-74', 
                'media-color-1_album' => 'media-color-1_album', 
                'media-color-1_audio-91' => 'media-color-1_audio-91', 
                'media-color-1_camera-18' => 'media-color-1_camera-18', 
                'media-color-1_flash-24' => 'media-color-1_flash-24', 
                'media-color-1_frame-12' => 'media-color-1_frame-12', 
                'media-color-1_grid' => 'media-color-1_grid', 
                'media-color-1_image-01' => 'media-color-1_image-01', 
                'media-color-1_kid' => 'media-color-1_kid', 
                'media-color-1_layers' => 'media-color-1_layers', 
                'media-color-1_play-69' => 'media-color-1_play-69', 
                'media-color-1_polaroid-user' => 'media-color-1_polaroid-user', 
                'media-color-1_sd' => 'media-color-1_sd', 
                'media-color-1_shake' => 'media-color-1_shake', 
                'media-color-1_speaker' => 'media-color-1_speaker', 
                'media-color-1_sport' => 'media-color-1_sport', 
                'media-color-1_ticket-76' => 'media-color-1_ticket-76', 
                'media-color-1_touch' => 'media-color-1_touch', 
                'media-color-1_videocamera-71' => 'media-color-1_videocamera-71', 
                'media-color-2_guitar' => 'media-color-2_guitar', 
                'media-color-2_music-cloud' => 'media-color-2_music-cloud', 
                'media-color-2_note-03' => 'media-color-2_note-03', 
                'media-color-2_radio' => 'media-color-2_radio', 
                'media-color-2_remix' => 'media-color-2_remix', 
                'media-color-2_sound-wave' => 'media-color-2_sound-wave', 
                'nature-color_chicken' => 'nature-color_chicken', 
                'nature-color_forest' => 'nature-color_forest', 
                'nature-color_mountain' => 'nature-color_mountain', 
                'nature-color_tree-02' => 'nature-color_tree-02', 
                'objects-color_anchor' => 'objects-color_anchor', 
                'objects-color_battery' => 'objects-color_battery', 
                'objects-color_bow' => 'objects-color_bow', 
                'objects-color_cone' => 'objects-color_cone', 
                'objects-color_diamond' => 'objects-color_diamond', 
                'objects-color_globe' => 'objects-color_globe', 
                'objects-color_key-25' => 'objects-color_key-25', 
                'objects-color_key-26' => 'objects-color_key-26', 
                'objects-color_lamp' => 'objects-color_lamp', 
                'objects-color_leaf-38' => 'objects-color_leaf-38', 
                'objects-color_planet' => 'objects-color_planet', 
                'objects-color_puzzle-09' => 'objects-color_puzzle-09', 
                'objects-color_puzzle-10' => 'objects-color_puzzle-10', 
                'objects-color_spaceship' => 'objects-color_spaceship', 
                'objects-color_support-16' => 'objects-color_support-16', 
                'objects-color_support-17' => 'objects-color_support-17', 
                'objects-color_umbrella-13' => 'objects-color_umbrella-13', 
                'tech-color_computer-old' => 'tech-color_computer-old', 
                'tech-color_headphones' => 'tech-color_headphones', 
                'tech-color_keyboard-wifi' => 'tech-color_keyboard-wifi', 
                'tech-color_laptop-front' => 'tech-color_laptop-front', 
                'tech-color_mobile-button' => 'tech-color_mobile-button', 
                'tech-color_print' => 'tech-color_print', 
                'tech-color_tablet' => 'tech-color_tablet', 
                'tech-color_tv-old' => 'tech-color_tv-old', 
                'tech-color_watch' => 'tech-color_watch', 
                'tech-color_webcam-38' => 'tech-color_webcam-38', 
                'tech-color_wifi' => 'tech-color_wifi', 
                'text-color_capitalize' => 'text-color_capitalize', 
                'text-color_caps-all' => 'text-color_caps-all', 
                'text-color_list-numbers' => 'text-color_list-numbers', 
                'text-color_quote' => 'text-color_quote', 
                'ui-color-1_attach-87' => 'ui-color-1_attach-87', 
                'ui-color-1_calendar-grid-61' => 'ui-color-1_calendar-grid-61', 
                'ui-color-1_check' => 'ui-color-1_check', 
                'ui-color-1_dashboard-29' => 'ui-color-1_dashboard-29', 
                'ui-color-1_dashboard-30' => 'ui-color-1_dashboard-30', 
                'ui-color-1_edit-72' => 'ui-color-1_edit-72', 
                'ui-color-1_edit-76' => 'ui-color-1_edit-76', 
                'ui-color-1_email-83' => 'ui-color-1_email-83', 
                'ui-color-1_eye-17' => 'ui-color-1_eye-17', 
                'ui-color-1_eye-ban-18' => 'ui-color-1_eye-ban-18', 
                'ui-color-1_home-52' => 'ui-color-1_home-52', 
                'ui-color-1_home-minimal' => 'ui-color-1_home-minimal', 
                'ui-color-1_lock' => 'ui-color-1_lock', 
                'ui-color-1_lock-open' => 'ui-color-1_lock-open', 
                'ui-color-1_notification-70' => 'ui-color-1_notification-70', 
                'ui-color-1_pencil' => 'ui-color-1_pencil', 
                'ui-color-1_preferences' => 'ui-color-1_preferences', 
                'ui-color-1_preferences-rotate' => 'ui-color-1_preferences-rotate', 
                'ui-color-1_send' => 'ui-color-1_send', 
                'ui-color-1_settings' => 'ui-color-1_settings', 
                'ui-color-1_simple-add' => 'ui-color-1_simple-add', 
                'ui-color-1_simple-remove' => 'ui-color-1_simple-remove', 
                'ui-color-1_trash' => 'ui-color-1_trash', 
                'ui-color-1_ui-04' => 'ui-color-1_ui-04', 
                'ui-color-1_zoom' => 'ui-color-1_zoom', 
                'ui-color-1_zoom-in' => 'ui-color-1_zoom-in', 
                'ui-color-1_zoom-out' => 'ui-color-1_zoom-out', 
                'ui-color-2_archive' => 'ui-color-2_archive', 
                'ui-color-2_battery-half' => 'ui-color-2_battery-half', 
                'ui-color-2_battery-low' => 'ui-color-2_battery-low', 
                'ui-color-2_chat-content' => 'ui-color-2_chat-content', 
                'ui-color-2_favourite-28' => 'ui-color-2_favourite-28', 
                'ui-color-2_grid-45' => 'ui-color-2_grid-45', 
                'ui-color-2_grid-48' => 'ui-color-2_grid-48', 
                'ui-color-2_hourglass' => 'ui-color-2_hourglass', 
                'ui-color-2_lab' => 'ui-color-2_lab', 
                'ui-color-2_layers' => 'ui-color-2_layers', 
                'ui-color-2_like' => 'ui-color-2_like', 
                'ui-color-2_link-69' => 'ui-color-2_link-69', 
                'ui-color-2_paragraph' => 'ui-color-2_paragraph', 
                'ui-color-2_target' => 'ui-color-2_target', 
                'ui-color-2_tile-56' => 'ui-color-2_tile-56', 
                'ui-color-2_time' => 'ui-color-2_time', 
                'ui-color-2_time-alarm' => 'ui-color-2_time-alarm', 
                'ui-color-2_time-countdown' => 'ui-color-2_time-countdown', 
                'ui-color-2_webpage' => 'ui-color-2_webpage', 
                'ui-color-2_window-add' => 'ui-color-2_window-add', 
                'ui-color-2_window-delete' => 'ui-color-2_window-delete', 
                'users-color_badge-13' => 'users-color_badge-13', 
                'users-color_man-37' => 'users-color_man-37', 
                'users-color_man-45' => 'users-color_man-45', 
                'users-color_multiple-11' => 'users-color_multiple-11', 
                'users-color_parent' => 'users-color_parent', 
                'users-color_woman-24' => 'users-color_woman-24', 
                'users-color_woman-46' => 'users-color_woman-46', 
                'weather-color_celsius' => 'weather-color_celsius', 
                'weather-color_fahrenheit' => 'weather-color_fahrenheit', 
                'weather-color_wind' => 'weather-color_wind',
            );

            $outline_svg_icons = array(
                'arrows-1_circle-down-40' => 'arrows-1_circle-down-40', 
                'arrows-1_circle-right-09' => 'arrows-1_circle-right-09', 
                'arrows-1_cloud-download-93' => 'arrows-1_cloud-download-93', 
                'arrows-1_cloud-upload-94' => 'arrows-1_cloud-upload-94', 
                'arrows-1_direction-53' => 'arrows-1_direction-53', 
                'arrows-1_fullscreen-double-74' => 'arrows-1_fullscreen-double-74', 
                'arrows-1_loop-82' => 'arrows-1_loop-82', 
                'arrows-1_minimal-down' => 'arrows-1_minimal-down', 
                'arrows-1_minimal-left' => 'arrows-1_minimal-left', 
                'arrows-1_minimal-right' => 'arrows-1_minimal-right', 
                'arrows-1_minimal-up' => 'arrows-1_minimal-up', 
                'arrows-1_refresh-69' => 'arrows-1_refresh-69', 
                'arrows-1_share-91' => 'arrows-1_share-91', 
                'arrows-1_shuffle-98' => 'arrows-1_shuffle-98', 
                'arrows-2_file-download-89' => 'arrows-2_file-download-89', 
                'arrows-2_file-upload-88' => 'arrows-2_file-upload-88', 
                'arrows-2_lines' => 'arrows-2_lines', 
                'arrows-2_log-out' => 'arrows-2_log-out', 
                'business-outline_agenda' => 'business-outline_agenda', 
                'business-outline_award-48' => 'business-outline_award-48', 
                'business-outline_award-49' => 'business-outline_award-49', 
                'business-outline_badge' => 'business-outline_badge', 
                'business-outline_board-28' => 'business-outline_board-28', 
                'business-outline_board-29' => 'business-outline_board-29', 
                'business-outline_board-30' => 'business-outline_board-30', 
                'business-outline_briefcase-24' => 'business-outline_briefcase-24', 
                'business-outline_building' => 'business-outline_building', 
                'business-outline_bulb-63' => 'business-outline_bulb-63', 
                'business-outline_business-contact-86' => 'business-outline_business-contact-86', 
                'business-outline_business-contact-88' => 'business-outline_business-contact-88', 
                'business-outline_businessman-04' => 'business-outline_businessman-04', 
                'business-outline_calculator' => 'business-outline_calculator', 
                'business-outline_chart' => 'business-outline_chart', 
                'business-outline_chart-bar-32' => 'business-outline_chart-bar-32', 
                'business-outline_chart-pie-35' => 'business-outline_chart-pie-35', 
                'business-outline_chart-pie-36' => 'business-outline_chart-pie-36', 
                'business-outline_connect' => 'business-outline_connect', 
                'business-outline_contacts' => 'business-outline_contacts', 
                'business-outline_currency-dollar' => 'business-outline_currency-dollar', 
                'business-outline_currency-euro' => 'business-outline_currency-euro', 
                'business-outline_currency-pound' => 'business-outline_currency-pound', 
                'business-outline_currency-yen' => 'business-outline_currency-yen', 
                'business-outline_factory' => 'business-outline_factory', 
                'business-outline_globe' => 'business-outline_globe', 
                'business-outline_goal-64' => 'business-outline_goal-64', 
                'business-outline_gold' => 'business-outline_gold', 
                'business-outline_handout' => 'business-outline_handout', 
                'business-outline_handshake' => 'business-outline_handshake', 
                'business-outline_hierarchy-55' => 'business-outline_hierarchy-55', 
                'business-outline_laptop-71' => 'business-outline_laptop-71', 
                'business-outline_laptop-91' => 'business-outline_laptop-91', 
                'business-outline_money-12' => 'business-outline_money-12', 
                'business-outline_notes' => 'business-outline_notes', 
                'business-outline_pig' => 'business-outline_pig', 
                'business-outline_pin' => 'business-outline_pin', 
                'business-outline_plug' => 'business-outline_plug', 
                'business-outline_scale' => 'business-outline_scale', 
                'business-outline_sign' => 'business-outline_sign', 
                'business-outline_signature' => 'business-outline_signature', 
                'cards-outline_amazon' => 'cards-outline_amazon', 
                'cards-outline_amex' => 'cards-outline_amex', 
                'cards-outline_android' => 'cards-outline_android', 
                'cards-outline_apple' => 'cards-outline_apple', 
                'cards-outline_mastercard' => 'cards-outline_mastercard', 
                'cards-outline_paypal' => 'cards-outline_paypal', 
                'cards-outline_stripe' => 'cards-outline_stripe', 
                'cards-outline_visa' => 'cards-outline_visa', 
                'clothes-outline_bag-21' => 'clothes-outline_bag-21', 
                'clothes-outline_shirt-business' => 'clothes-outline_shirt-business', 
                'clothes-outline_tie-bow' => 'clothes-outline_tie-bow', 
                'design-outline_app' => 'design-outline_app', 
                'design-outline_artboard' => 'design-outline_artboard', 
                'design-outline_book-open' => 'design-outline_book-open', 
                'design-outline_brush' => 'design-outline_brush', 
                'design-outline_bullet-list' => 'design-outline_bullet-list', 
                'design-outline_code' => 'design-outline_code', 
                'design-outline_code-editor' => 'design-outline_code-editor', 
                'design-outline_command' => 'design-outline_command', 
                'design-outline_compass' => 'design-outline_compass', 
                'design-outline_copy' => 'design-outline_copy', 
                'design-outline_crop' => 'design-outline_crop', 
                'design-outline_design' => 'design-outline_design', 
                'design-outline_image' => 'design-outline_image', 
                'design-outline_measure-17' => 'design-outline_measure-17', 
                'design-outline_mobile-design' => 'design-outline_mobile-design', 
                'design-outline_mobile-dev' => 'design-outline_mobile-dev', 
                'design-outline_mouse-10' => 'design-outline_mouse-10', 
                'design-outline_note-code' => 'design-outline_note-code', 
                'design-outline_paint-16' => 'design-outline_paint-16', 
                'design-outline_paint-bucket-40' => 'design-outline_paint-bucket-40', 
                'design-outline_palette' => 'design-outline_palette', 
                'design-outline_pantone' => 'design-outline_pantone', 
                'design-outline_paper-design' => 'design-outline_paper-design', 
                'design-outline_paper-dev' => 'design-outline_paper-dev', 
                'design-outline_path-exclude' => 'design-outline_path-exclude', 
                'design-outline_pen-tool' => 'design-outline_pen-tool', 
                'design-outline_phone' => 'design-outline_phone', 
                'design-outline_photo-editor' => 'design-outline_photo-editor', 
                'design-outline_scissors-dashed' => 'design-outline_scissors-dashed', 
                'design-outline_tablet-mobile' => 'design-outline_tablet-mobile', 
                'design-outline_text' => 'design-outline_text', 
                'design-outline_vector' => 'design-outline_vector', 
                'design-outline_wand-99' => 'design-outline_wand-99', 
                'design-outline_webpage' => 'design-outline_webpage', 
                'design-outline_window-paragraph' => 'design-outline_window-paragraph', 
                'education-outline_abc' => 'education-outline_abc', 
                'education-outline_atom' => 'education-outline_atom', 
                'education-outline_award-55' => 'education-outline_award-55', 
                'education-outline_backpack-58' => 'education-outline_backpack-58', 
                'education-outline_board-51' => 'education-outline_board-51', 
                'education-outline_book-open' => 'education-outline_book-open', 
                'education-outline_grammar-check' => 'education-outline_grammar-check', 
                'education-outline_language' => 'education-outline_language', 
                'education-outline_microscope' => 'education-outline_microscope', 
                'education-outline_paper' => 'education-outline_paper', 
                'education-outline_pencil-47' => 'education-outline_pencil-47', 
                'education-outline_school' => 'education-outline_school', 
                'emoticons-outline_bomb' => 'emoticons-outline_bomb', 
                'emoticons-outline_cry-15' => 'emoticons-outline_cry-15', 
                'emoticons-outline_fist' => 'emoticons-outline_fist', 
                'emoticons-outline_like' => 'emoticons-outline_like', 
                'emoticons-outline_manga-62' => 'emoticons-outline_manga-62', 
                'emoticons-outline_sad' => 'emoticons-outline_sad', 
                'emoticons-outline_smile' => 'emoticons-outline_smile', 
                'emoticons-outline_speechless' => 'emoticons-outline_speechless', 
                'emoticons-outline_surprise' => 'emoticons-outline_surprise', 
                'envir-outline_recycling' => 'envir-outline_recycling', 
                'envir-outline_save-planet' => 'envir-outline_save-planet', 
                'files-2_ai-illustrator' => 'files-2_ai-illustrator', 
                'files-2_asp' => 'files-2_asp', 
                'files-2_css' => 'files-2_css', 
                'files-2_docx' => 'files-2_docx', 
                'files-2_gif' => 'files-2_gif', 
                'files-2_html' => 'files-2_html', 
                'files-2_jpg-jpeg' => 'files-2_jpg-jpeg', 
                'files-2_js-javascript-jquery' => 'files-2_js-javascript-jquery', 
                'files-3_pdf' => 'files-3_pdf', 
                'files-3_php' => 'files-3_php', 
                'files-3_png' => 'files-3_png', 
                'files-3_psd-photoshop' => 'files-3_psd-photoshop', 
                'files-3_sql' => 'files-3_sql', 
                'files-3_txt' => 'files-3_txt', 
                'files-3_xml' => 'files-3_xml', 
                'files-3_zip' => 'files-3_zip', 
                'files-outline_archive-3d-content' => 'files-outline_archive-3d-content', 
                'files-outline_paper' => 'files-outline_paper', 
                'files-outline_single-content-02' => 'files-outline_single-content-02', 
                'files-outline_single-copies' => 'files-outline_single-copies', 
                'files-outline_single-copy-04' => 'files-outline_single-copy-04', 
                'files-outline_single-paragraph' => 'files-outline_single-paragraph', 
                'files-outline_zip-55' => 'files-outline_zip-55', 
                'food-outline_beer-95' => 'food-outline_beer-95', 
                'food-outline_cocktail' => 'food-outline_cocktail', 
                'food-outline_cutlery-77' => 'food-outline_cutlery-77', 
                'food-outline_donut' => 'food-outline_donut', 
                'food-outline_moka' => 'food-outline_moka', 
                'food-outline_mug' => 'food-outline_mug', 
                'food-outline_pizza-slice' => 'food-outline_pizza-slice', 
                'food-outline_tea' => 'food-outline_tea', 
                'gestures-outline_double-tap' => 'gestures-outline_double-tap', 
                'gestures-outline_pinch' => 'gestures-outline_pinch', 
                'gestures-outline_scroll-horitontal' => 'gestures-outline_scroll-horitontal', 
                'gestures-outline_scroll-vertical' => 'gestures-outline_scroll-vertical', 
                'gestures-outline_stretch' => 'gestures-outline_stretch', 
                'gestures-outline_tap-02' => 'gestures-outline_tap-02', 
                'gestures-outline_touch-id' => 'gestures-outline_touch-id', 
                'health-outline_apple' => 'health-outline_apple', 
                'health-outline_brain' => 'health-outline_brain', 
                'health-outline_dna-27' => 'health-outline_dna-27', 
                'health-outline_sleep' => 'health-outline_sleep', 
                'health-outline_steps' => 'health-outline_steps', 
                'health-outline_wheelchair' => 'health-outline_wheelchair', 
                'holidays-outline_cockade' => 'holidays-outline_cockade', 
                'holidays-outline_gift' => 'holidays-outline_gift', 
                'holidays-outline_gift-exchange' => 'holidays-outline_gift-exchange', 
                'holidays-outline_message' => 'holidays-outline_message', 
                'location-outline_flag-complex' => 'location-outline_flag-complex', 
                'location-outline_map-gps' => 'location-outline_map-gps', 
                'location-outline_map-pin' => 'location-outline_map-pin', 
                'location-outline_worl-marker' => 'location-outline_worl-marker', 
                'location-outline_world' => 'location-outline_world', 
                'media-1_action-74' => 'media-1_action-74', 
                'media-1_album' => 'media-1_album', 
                'media-1_audio-92' => 'media-1_audio-92', 
                'media-1_camera-19' => 'media-1_camera-19', 
                'media-1_countdown-34' => 'media-1_countdown-34', 
                'media-1_flash-24' => 'media-1_flash-24', 
                'media-1_frame-12' => 'media-1_frame-12', 
                'media-1_image-01' => 'media-1_image-01', 
                'media-1_image-02' => 'media-1_image-02', 
                'media-1_layers' => 'media-1_layers', 
                'media-1_movie-62' => 'media-1_movie-62', 
                'media-1_player' => 'media-1_player', 
                'media-1_shake' => 'media-1_shake', 
                'media-1_speaker' => 'media-1_speaker', 
                'media-1_sport' => 'media-1_sport', 
                'media-1_touch' => 'media-1_touch', 
                'media-1_video-66' => 'media-1_video-66', 
                'media-2_headphones' => 'media-2_headphones', 
                'media-2_headphones-mic' => 'media-2_headphones-mic', 
                'media-2_note-03' => 'media-2_note-03', 
                'media-2_radio' => 'media-2_radio', 
                'media-2_sound-wave' => 'media-2_sound-wave', 
                'objects-outline_anchor' => 'objects-outline_anchor', 
                'objects-outline_bow' => 'objects-outline_bow', 
                'objects-outline_diamond' => 'objects-outline_diamond', 
                'objects-outline_dice' => 'objects-outline_dice', 
                'objects-outline_globe' => 'objects-outline_globe', 
                'objects-outline_key-26' => 'objects-outline_key-26', 
                'objects-outline_lamp' => 'objects-outline_lamp', 
                'objects-outline_planet' => 'objects-outline_planet', 
                'objects-outline_puzzle-09' => 'objects-outline_puzzle-09', 
                'objects-outline_puzzle-10' => 'objects-outline_puzzle-10', 
                'objects-outline_skull' => 'objects-outline_skull', 
                'objects-outline_spaceship' => 'objects-outline_spaceship', 
                'objects-outline_support-16' => 'objects-outline_support-16', 
                'objects-outline_support-17' => 'objects-outline_support-17', 
                'objects-outline_umbrella-13' => 'objects-outline_umbrella-13', 
                'shopping-outline_box-3d-50' => 'shopping-outline_box-3d-50', 
                'shopping-outline_cart' => 'shopping-outline_cart', 
                'shopping-outline_cart-add' => 'shopping-outline_cart-add', 
                'shopping-outline_cart-remove' => 'shopping-outline_cart-remove', 
                'shopping-outline_credit-card' => 'shopping-outline_credit-card', 
                'shopping-outline_credit-locked' => 'shopping-outline_credit-locked', 
                'shopping-outline_delivery-fast' => 'shopping-outline_delivery-fast', 
                'shopping-outline_delivery-time' => 'shopping-outline_delivery-time', 
                'shopping-outline_discount' => 'shopping-outline_discount', 
                'shopping-outline_gift' => 'shopping-outline_gift', 
                'shopping-outline_list' => 'shopping-outline_list', 
                'shopping-outline_newsletter' => 'shopping-outline_newsletter', 
                'shopping-outline_tag-content' => 'shopping-outline_tag-content', 
                'sport-outline_boxing' => 'sport-outline_boxing', 
                'sport-outline_crown' => 'sport-outline_crown', 
                'sport-outline_flag-finish' => 'sport-outline_flag-finish', 
                'sport-outline_podium-trophy' => 'sport-outline_podium-trophy', 
                'sport-outline_tactic' => 'sport-outline_tactic', 
                'sport-outline_user-run' => 'sport-outline_user-run', 
                'tech-outline_computer-old' => 'tech-outline_computer-old', 
                'tech-outline_desktop-screen' => 'tech-outline_desktop-screen', 
                'tech-outline_keyboard-mouse' => 'tech-outline_keyboard-mouse', 
                'tech-outline_laptop-front' => 'tech-outline_laptop-front', 
                'tech-outline_mobile' => 'tech-outline_mobile', 
                'tech-outline_player-19' => 'tech-outline_player-19', 
                'tech-outline_print' => 'tech-outline_print', 
                'tech-outline_tablet-button' => 'tech-outline_tablet-button', 
                'tech-outline_tv-old' => 'tech-outline_tv-old', 
                'tech-outline_watch' => 'tech-outline_watch', 
                'tech-outline_wifi' => 'tech-outline_wifi', 
                'text-outline_capitalize' => 'text-outline_capitalize', 
                'text-outline_caps-all' => 'text-outline_caps-all', 
                'text-outline_list-numbers' => 'text-outline_list-numbers', 
                'text-outline_quote' => 'text-outline_quote', 
                'transportation-outline_bike-sport' => 'transportation-outline_bike-sport', 
                'transportation-outline_light-traffic' => 'transportation-outline_light-traffic', 
                'travel-outline_world' => 'travel-outline_world', 
                'ui-1_attach-87' => 'ui-1_attach-87', 
                'ui-1_bell-54' => 'ui-1_bell-54', 
                'ui-1_calendar-grid-61' => 'ui-1_calendar-grid-61', 
                'ui-1_check-circle-07' => 'ui-1_check-circle-07', 
                'ui-1_dashboard-29' => 'ui-1_dashboard-29', 
                'ui-1_drop' => 'ui-1_drop', 
                'ui-1_email-85' => 'ui-1_email-85', 
                'ui-1_eye-17' => 'ui-1_eye-17', 
                'ui-1_eye-ban-18' => 'ui-1_eye-ban-18', 
                'ui-1_home-52' => 'ui-1_home-52', 
                'ui-1_lock' => 'ui-1_lock', 
                'ui-1_lock-open' => 'ui-1_lock-open', 
                'ui-1_notification-70' => 'ui-1_notification-70', 
                'ui-1_pencil' => 'ui-1_pencil', 
                'ui-1_preferences-circle' => 'ui-1_preferences-circle', 
                'ui-1_preferences-circle-rotate' => 'ui-1_preferences-circle-rotate', 
                'ui-1_send' => 'ui-1_send', 
                'ui-1_settings' => 'ui-1_settings', 
                'ui-1_settings-gear-65' => 'ui-1_settings-gear-65', 
                'ui-1_trash-simple' => 'ui-1_trash-simple', 
                'ui-1_ui-04' => 'ui-1_ui-04', 
                'ui-1_zoom-split' => 'ui-1_zoom-split', 
                'ui-1_zoom-split-in' => 'ui-1_zoom-split-in', 
                'ui-1_zoom-split-out' => 'ui-1_zoom-split-out', 
                'ui-2_alert-exclamation' => 'ui-2_alert-exclamation', 
                'ui-2_alert-question' => 'ui-2_alert-question', 
                'ui-2_alert-i' => 'ui-2_alert-i', 
                'ui-2_archive' => 'ui-2_archive', 
                'ui-2_chart-bar-53' => 'ui-2_chart-bar-53', 
                'ui-2_chat-round-content' => 'ui-2_chat-round-content', 
                'ui-2_disk' => 'ui-2_disk', 
                'ui-2_favourite-28' => 'ui-2_favourite-28', 
                'ui-2_favourite-31' => 'ui-2_favourite-31', 
                'ui-2_grid-48' => 'ui-2_grid-48', 
                'ui-2_grid-49' => 'ui-2_grid-49', 
                'ui-2_lab' => 'ui-2_lab', 
                'ui-2_layers' => 'ui-2_layers', 
                'ui-2_link-69' => 'ui-2_link-69', 
                'ui-2_menu-34' => 'ui-2_menu-34', 
                'ui-2_menu-35' => 'ui-2_menu-35', 
                'ui-2_paragraph' => 'ui-2_paragraph', 
                'ui-2_share-bold' => 'ui-2_share-bold', 
                'ui-2_tile-56' => 'ui-2_tile-56', 
                'ui-2_time' => 'ui-2_time', 
                'ui-2_time-countdown' => 'ui-2_time-countdown', 
                'users-outline_man-23' => 'users-outline_man-23', 
                'users-outline_multiple-11' => 'users-outline_multiple-11', 
                'users-outline_woman-25' => 'users-outline_woman-25',
            );
           
           $icons = array_merge($icons, $coloured_svg_icons);
           $icons = array_merge($icons, $outline_svg_icons);
           
           return $icons;
            
	  	}
		add_filter( 'spb_svg_icons_list', 'uplift_spb_svg_icons_list' );
	}
	
	
	/* HERO CONTENT SPB ADJUST
	================================================== */
	if ( ! function_exists( 'uplift_page_hero_content_check' ) ) {
	    function uplift_page_hero_content_check( $wrap_type ) {
	        global $post;
	        $page_design_style = uplift_get_post_meta( $post->ID, 'sf_page_design_style', true );
	        if ( $page_design_style == "hero-content-split" && $wrap_type == 'full-width-stretch' ) {
	            return 'full-width-contained';
	        } else {
	            return $wrap_type;
	        }
	    }
	    add_filter( 'spb_row_wrap_type', 'uplift_page_hero_content_check', 10 );
	}
	
	
	/* BUTTON TYPES
	================================================== */
	function uplift_shortcode_button_types() {
		$button_types = array(
			'standard' => __('Standard', 'uplift'),
			'bordered' => __('Bordered', 'uplift'),
		);
		
		return $button_types;
	}
	add_filter('uplift_shortcode_button_types', 'uplift_shortcode_button_types');
	
	
	/* BUTTON SIZES
	================================================== */
	function uplift_shortcode_button_sizes() {
		$button_sizes = array(
			'standard' => __('Standard', 'uplift'),
			'large'	=> __('Large', 'uplift'),
			'mega'	=> __('Mega', 'uplift'),
		);
		
		return $button_sizes;
	}
	add_filter('uplift_shortcode_button_sizes', 'uplift_shortcode_button_sizes');
	
	
	/* BUTTON COLOURS
	================================================== */
	function uplift_shortcode_button_colours($button_colours) {
	
		// remove	
		unset($button_colours['turquoise']);
		
		// add
		$button_colours['purple'] = __('Purple', 'uplift');
		$button_colours['midnight'] = __('Midnight', 'uplift');
	
		// return
		return $button_colours;
	}
	add_filter('uplift_shortcode_button_colours', 'uplift_shortcode_button_colours');
	

	/* ICON BOX TYPES
	================================================== */
	function uplift_spb_icon_box_types() {
		$icon_box_types = array(
    	    __( 'Standard Center', 'uplift' )              => "standard-center",
    	    __( 'Standard Center (Contained)', 'uplift' )  => "standard-center-contained",
			__( 'Standard Left', 'uplift' )                => "standard-left",
			__( 'Standard Left (Contained)', 'uplift' )    => "standard-left-contained",
			__( 'Vertical', 'uplift' )                 	=> "vertical",
			__( 'Vertical (Contained)', 'uplift' )     	=> "vertical-contained",
			__( 'Animated', 'uplift' )                 	=> "animated-alt",
    	);
    	
		return $icon_box_types;
	}
	add_filter('spb_icon_box_types', 'uplift_spb_icon_box_types');
	
	
	/* ICON BOX ICON TYPES
	================================================== */
	function uplift_spb_icon_box_icon_types() {
		$icon_box_icon_types = array(
	        '' => '',
	        __( "Icon", 'uplift' )  => "icon",
	        __( "Character", 'uplift' )  => "character",
	        __( "Image", 'uplift' )  => "image",
	        __( "SVG", 'uplift' )  => "svg",
	    );
		return $icon_box_icon_types;
	}
	add_filter('spb_icon_box_icon_types', 'uplift_spb_icon_box_icon_types');
    
    
    /* PRODUCT DISPLAY TYPES
    ================================================== */
    function uplift_spb_product_display_types() {
    	$product_display_type = array(
            __( 'Standard', 'uplift' )  => "standard",
            __( 'Preview Slider', 'uplift' )   => "preview-slider",
        );
    	return $product_display_type;
    }
    add_filter('spb_product_display_types', 'uplift_spb_product_display_types');
    
    
    /* PRODUCT DISPLAY TYPES
    ================================================== */
    function uplift_spb_promo_bar_types() {
    	$promo_bar_types = array(
            __( 'Text + Button', 'uplift' )                => 'promo-button',
            __( 'Text Only (Full Bar Link)', 'uplift' )    => 'promo-text',
            __( 'Custom Content', 'uplift' )               => 'promo-custom'
        );
    	return $promo_bar_types;
    }
    add_filter('spb_promo_bar_types', 'uplift_spb_promo_bar_types');
    
    
	/* PRODUCT DISPLAY TYPES
	================================================== */
	function uplift_spb_portfolio_pagination_types() {
		$pagination_types = array(
            __( "None", 'uplift' )             => "none",
            __( "Infinite scroll", 'uplift' )  => "infinite-scroll",
            __( "Load more (AJAX)", 'uplift' ) => "load-more",
            __( "Standard", 'uplift' )         => "standard",
        );
		return $pagination_types;
	}
	add_filter('spb_portfolio_pagination_types', 'uplift_spb_portfolio_pagination_types'); 
	
	
	/* BLOG DISPLAY TYPES
	================================================== */
	function uplift_spb_blog_display_types() {
		$blog_types = array(
            __( 'Standard', 'uplift' ) => "standard",
            __( 'Timeline', 'uplift' ) => "timeline",
            __( 'Mini', 'uplift' )     => "mini",
            __( 'Masonry', 'uplift' )  => "masonry",
        );
		return $blog_types;
	}
	add_filter('spb_blog_display_types', 'uplift_spb_blog_display_types'); 
	
	
	/* PAGE BUILDER CAROUSEL ARROWS
	================================================== */
	function uplift_spb_carousel_arrows_html() {
		$carousel_arrows = '<div class="carousel-arrows"><a href="#" class="carousel-prev"><i class="sf-icon-left-chevron"></i></a><a href="#" class="carousel-next"><i class="sf-icon-right-chevron"></i></a></div>';
		return $carousel_arrows;
	}
	add_filter('spb_carousel_arrows_html', 'uplift_spb_carousel_arrows_html');
	function uplift_spb_carousel_arrows_nowrap_html() {
		$carousel_arrows = '<a href="#" class="carousel-prev"><i class="sf-icon-left-chevron"></i></a><a href="#" class="carousel-next"><i class="sf-icon-right-chevron"></i></a>';
		return $carousel_arrows;
	}
	add_filter('spb_carousel_arrows_nowrap_html', 'uplift_spb_carousel_arrows_nowrap_html');

	
	/* PAGE BUILDER CLIENT IMG SCALE
	================================================== */
	function uplift_client_img_scale() {
		return 0.75;
	}
	add_filter('uplift_client_img_scale', 'uplift_client_img_scale');
	
	
	/* PAGE BUILDER PORT CAROUSEL ITEM CLASS
	================================================== */
	function uplift_portfolio_carousel_item_class() {
		return 'gallery-hover';
	}
	add_filter('spb_portfolio_carousel_item_class', 'uplift_portfolio_carousel_item_class');
		
	
	/* PAGE BUILDER ICON OVERRIDES
	================================================== */
	function uplift_testimonial_view_all_icon() {
		return '<i class="sf-icon-quickview"></i>';
	}
	add_filter('spb_testimonial_view_all_icon', 'uplift_testimonial_view_all_icon');
		
	
	/* PAGE BUILDER SVG ICONS
	================================================== */
	function uplift_spb_svg_icons_list( $svg_icon_output ) {
	
		$coloured_svg_icons = array(
            'arrows-color-1_cloud-download-95' => 'arrows-color-1_cloud-download-95', 
            'arrows-color-1_cloud-upload-96' => 'arrows-color-1_cloud-upload-96', 
            'arrows-color-2_file-download-87' => 'arrows-color-2_file-download-87', 
            'arrows-color-2_file-upload-86' => 'arrows-color-2_file-upload-86', 
            'arrows-color-2_lines' => 'arrows-color-2_lines', 
            'arrows-color-2_replay' => 'arrows-color-2_replay', 
            'arrows-color-3_cloud-refresh' => 'arrows-color-3_cloud-refresh', 
            'business-color_agenda' => 'business-color_agenda', 
            'business-color_award-48' => 'business-color_award-48', 
            'business-color_award-49' => 'business-color_award-49', 
            'business-color_badge' => 'business-color_badge', 
            'business-color_board-28' => 'business-color_board-28', 
            'business-color_board-29' => 'business-color_board-29', 
            'business-color_board-30' => 'business-color_board-30', 
            'business-color_briefcase-26' => 'business-color_briefcase-26', 
            'business-color_building' => 'business-color_building', 
            'business-color_bulb-63' => 'business-color_bulb-63', 
            'business-color_business-contact-85' => 'business-color_business-contact-85', 
            'business-color_business-contact-86' => 'business-color_business-contact-86', 
            'business-color_business-contact-87' => 'business-color_business-contact-87', 
            'business-color_business-contact-88' => 'business-color_business-contact-88', 
            'business-color_businessman-03' => 'business-color_businessman-03', 
            'business-color_calculator' => 'business-color_calculator', 
            'business-color_cheque' => 'business-color_cheque', 
            'business-color_connect' => 'business-color_connect', 
            'business-color_factory' => 'business-color_factory', 
            'business-color_globe' => 'business-color_globe', 
            'business-color_goal-64' => 'business-color_goal-64', 
            'business-color_gold' => 'business-color_gold', 
            'business-color_hammer' => 'business-color_hammer', 
            'business-color_handout' => 'business-color_handout', 
            'business-color_handshake' => 'business-color_handshake', 
            'business-color_hierarchy-55' => 'business-color_hierarchy-55', 
            'business-color_payment' => 'business-color_payment', 
            'business-color_pig' => 'business-color_pig', 
            'business-color_pin' => 'business-color_pin', 
            'business-color_progress' => 'business-color_progress', 
            'business-color_safe' => 'business-color_safe', 
            'business-color_signature' => 'business-color_signature', 
            'emoticons-color_bomb' => 'emoticons-color_bomb', 
            'emoticons-color_manga-62' => 'emoticons-color_manga-62', 
            'emoticons-color_sad' => 'emoticons-color_sad', 
            'emoticons-color_smile' => 'emoticons-color_smile', 
            'envir-color_recycling' => 'envir-color_recycling', 
            'envir-color_save-planet' => 'envir-color_save-planet', 
            'food-color_beer-95' => 'food-color_beer-95', 
            'food-color_carrot' => 'food-color_carrot', 
            'food-color_cocktail' => 'food-color_cocktail', 
            'food-color_cutlery-77' => 'food-color_cutlery-77', 
            'food-color_donut' => 'food-color_donut', 
            'food-color_fish' => 'food-color_fish', 
            'food-color_grape' => 'food-color_grape', 
            'food-color_moka' => 'food-color_moka', 
            'food-color_mug' => 'food-color_mug', 
            'food-color_pizza-slice' => 'food-color_pizza-slice', 
            'gestures-color_double-tap' => 'gestures-color_double-tap', 
            'gestures-color_pinch' => 'gestures-color_pinch', 
            'gestures-color_scroll-horitontal' => 'gestures-color_scroll-horitontal', 
            'gestures-color_scroll-vertical' => 'gestures-color_scroll-vertical', 
            'gestures-color_stretch' => 'gestures-color_stretch', 
            'gestures-color_touch-id' => 'gestures-color_touch-id', 
            'holidays-color_cockade' => 'holidays-color_cockade', 
            'holidays-color_gift' => 'holidays-color_gift', 
            'holidays-color_gift-exchange' => 'holidays-color_gift-exchange', 
            'holidays-color_message' => 'holidays-color_message', 
            'location-color_appointment' => 'location-color_appointment', 
            'location-color_flag-complex' => 'location-color_flag-complex', 
            'location-color_map-gps' => 'location-color_map-gps', 
            'location-color_map-pin' => 'location-color_map-pin', 
            'location-color_treasure-map-40' => 'location-color_treasure-map-40', 
            'location-color_world-pin' => 'location-color_world-pin', 
            'media-color-1_action-74' => 'media-color-1_action-74', 
            'media-color-1_album' => 'media-color-1_album', 
            'media-color-1_audio-91' => 'media-color-1_audio-91', 
            'media-color-1_camera-18' => 'media-color-1_camera-18', 
            'media-color-1_flash-24' => 'media-color-1_flash-24', 
            'media-color-1_frame-12' => 'media-color-1_frame-12', 
            'media-color-1_grid' => 'media-color-1_grid', 
            'media-color-1_image-01' => 'media-color-1_image-01', 
            'media-color-1_kid' => 'media-color-1_kid', 
            'media-color-1_layers' => 'media-color-1_layers', 
            'media-color-1_play-69' => 'media-color-1_play-69', 
            'media-color-1_polaroid-user' => 'media-color-1_polaroid-user', 
            'media-color-1_sd' => 'media-color-1_sd', 
            'media-color-1_shake' => 'media-color-1_shake', 
            'media-color-1_speaker' => 'media-color-1_speaker', 
            'media-color-1_sport' => 'media-color-1_sport', 
            'media-color-1_ticket-76' => 'media-color-1_ticket-76', 
            'media-color-1_touch' => 'media-color-1_touch', 
            'media-color-1_videocamera-71' => 'media-color-1_videocamera-71', 
            'media-color-2_guitar' => 'media-color-2_guitar', 
            'media-color-2_music-cloud' => 'media-color-2_music-cloud', 
            'media-color-2_note-03' => 'media-color-2_note-03', 
            'media-color-2_radio' => 'media-color-2_radio', 
            'media-color-2_remix' => 'media-color-2_remix', 
            'media-color-2_sound-wave' => 'media-color-2_sound-wave', 
            'nature-color_chicken' => 'nature-color_chicken', 
            'nature-color_forest' => 'nature-color_forest', 
            'nature-color_mountain' => 'nature-color_mountain', 
            'nature-color_tree-02' => 'nature-color_tree-02', 
            'objects-color_anchor' => 'objects-color_anchor', 
            'objects-color_battery' => 'objects-color_battery', 
            'objects-color_bow' => 'objects-color_bow', 
            'objects-color_cone' => 'objects-color_cone', 
            'objects-color_diamond' => 'objects-color_diamond', 
            'objects-color_globe' => 'objects-color_globe', 
            'objects-color_key-25' => 'objects-color_key-25', 
            'objects-color_key-26' => 'objects-color_key-26', 
            'objects-color_lamp' => 'objects-color_lamp', 
            'objects-color_leaf-38' => 'objects-color_leaf-38', 
            'objects-color_planet' => 'objects-color_planet', 
            'objects-color_puzzle-09' => 'objects-color_puzzle-09', 
            'objects-color_puzzle-10' => 'objects-color_puzzle-10', 
            'objects-color_spaceship' => 'objects-color_spaceship', 
            'objects-color_support-16' => 'objects-color_support-16', 
            'objects-color_support-17' => 'objects-color_support-17', 
            'objects-color_umbrella-13' => 'objects-color_umbrella-13', 
            'tech-color_computer-old' => 'tech-color_computer-old', 
            'tech-color_headphones' => 'tech-color_headphones', 
            'tech-color_keyboard-wifi' => 'tech-color_keyboard-wifi', 
            'tech-color_laptop-front' => 'tech-color_laptop-front', 
            'tech-color_mobile-button' => 'tech-color_mobile-button', 
            'tech-color_print' => 'tech-color_print', 
            'tech-color_tablet' => 'tech-color_tablet', 
            'tech-color_tv-old' => 'tech-color_tv-old', 
            'tech-color_watch' => 'tech-color_watch', 
            'tech-color_webcam-38' => 'tech-color_webcam-38', 
            'tech-color_wifi' => 'tech-color_wifi', 
            'text-color_capitalize' => 'text-color_capitalize', 
            'text-color_caps-all' => 'text-color_caps-all', 
            'text-color_list-numbers' => 'text-color_list-numbers', 
            'text-color_quote' => 'text-color_quote', 
            'ui-color-1_attach-87' => 'ui-color-1_attach-87', 
            'ui-color-1_calendar-grid-61' => 'ui-color-1_calendar-grid-61', 
            'ui-color-1_check' => 'ui-color-1_check', 
            'ui-color-1_dashboard-29' => 'ui-color-1_dashboard-29', 
            'ui-color-1_dashboard-30' => 'ui-color-1_dashboard-30', 
            'ui-color-1_edit-72' => 'ui-color-1_edit-72', 
            'ui-color-1_edit-76' => 'ui-color-1_edit-76', 
            'ui-color-1_email-83' => 'ui-color-1_email-83', 
            'ui-color-1_eye-17' => 'ui-color-1_eye-17', 
            'ui-color-1_eye-ban-18' => 'ui-color-1_eye-ban-18', 
            'ui-color-1_home-52' => 'ui-color-1_home-52', 
            'ui-color-1_home-minimal' => 'ui-color-1_home-minimal', 
            'ui-color-1_lock' => 'ui-color-1_lock', 
            'ui-color-1_lock-open' => 'ui-color-1_lock-open', 
            'ui-color-1_notification-70' => 'ui-color-1_notification-70', 
            'ui-color-1_pencil' => 'ui-color-1_pencil', 
            'ui-color-1_preferences' => 'ui-color-1_preferences', 
            'ui-color-1_preferences-rotate' => 'ui-color-1_preferences-rotate', 
            'ui-color-1_send' => 'ui-color-1_send', 
            'ui-color-1_settings' => 'ui-color-1_settings', 
            'ui-color-1_simple-add' => 'ui-color-1_simple-add', 
            'ui-color-1_simple-remove' => 'ui-color-1_simple-remove', 
            'ui-color-1_trash' => 'ui-color-1_trash', 
            'ui-color-1_ui-04' => 'ui-color-1_ui-04', 
            'ui-color-1_zoom' => 'ui-color-1_zoom', 
            'ui-color-1_zoom-in' => 'ui-color-1_zoom-in', 
            'ui-color-1_zoom-out' => 'ui-color-1_zoom-out', 
            'ui-color-2_archive' => 'ui-color-2_archive', 
            'ui-color-2_battery-half' => 'ui-color-2_battery-half', 
            'ui-color-2_battery-low' => 'ui-color-2_battery-low', 
            'ui-color-2_chat-content' => 'ui-color-2_chat-content', 
            'ui-color-2_favourite-28' => 'ui-color-2_favourite-28', 
            'ui-color-2_grid-45' => 'ui-color-2_grid-45', 
            'ui-color-2_grid-48' => 'ui-color-2_grid-48', 
            'ui-color-2_hourglass' => 'ui-color-2_hourglass', 
            'ui-color-2_lab' => 'ui-color-2_lab', 
            'ui-color-2_layers' => 'ui-color-2_layers', 
            'ui-color-2_like' => 'ui-color-2_like', 
            'ui-color-2_link-69' => 'ui-color-2_link-69', 
            'ui-color-2_paragraph' => 'ui-color-2_paragraph', 
            'ui-color-2_target' => 'ui-color-2_target', 
            'ui-color-2_tile-56' => 'ui-color-2_tile-56', 
            'ui-color-2_time' => 'ui-color-2_time', 
            'ui-color-2_time-alarm' => 'ui-color-2_time-alarm', 
            'ui-color-2_time-countdown' => 'ui-color-2_time-countdown', 
            'ui-color-2_webpage' => 'ui-color-2_webpage', 
            'ui-color-2_window-add' => 'ui-color-2_window-add', 
            'ui-color-2_window-delete' => 'ui-color-2_window-delete', 
            'users-color_badge-13' => 'users-color_badge-13', 
            'users-color_man-37' => 'users-color_man-37', 
            'users-color_man-45' => 'users-color_man-45', 
            'users-color_multiple-11' => 'users-color_multiple-11', 
            'users-color_parent' => 'users-color_parent', 
            'users-color_woman-24' => 'users-color_woman-24', 
            'users-color_woman-46' => 'users-color_woman-46', 
            'weather-color_celsius' => 'weather-color_celsius', 
            'weather-color_fahrenheit' => 'weather-color_fahrenheit', 
            'weather-color_wind' => 'weather-color_wind',
        );

        $outline_svg_icons = array(
            'arrows-1_circle-down-40' => 'arrows-1_circle-down-40', 
            'arrows-1_circle-right-09' => 'arrows-1_circle-right-09', 
            'arrows-1_cloud-download-93' => 'arrows-1_cloud-download-93', 
            'arrows-1_cloud-upload-94' => 'arrows-1_cloud-upload-94', 
            'arrows-1_direction-53' => 'arrows-1_direction-53', 
            'arrows-1_fullscreen-double-74' => 'arrows-1_fullscreen-double-74', 
            'arrows-1_loop-82' => 'arrows-1_loop-82', 
            'arrows-1_minimal-down' => 'arrows-1_minimal-down', 
            'arrows-1_minimal-left' => 'arrows-1_minimal-left', 
            'arrows-1_minimal-right' => 'arrows-1_minimal-right', 
            'arrows-1_minimal-up' => 'arrows-1_minimal-up', 
            'arrows-1_refresh-69' => 'arrows-1_refresh-69', 
            'arrows-1_share-91' => 'arrows-1_share-91', 
            'arrows-1_shuffle-98' => 'arrows-1_shuffle-98', 
            'arrows-2_file-download-89' => 'arrows-2_file-download-89', 
            'arrows-2_file-upload-88' => 'arrows-2_file-upload-88', 
            'arrows-2_lines' => 'arrows-2_lines', 
            'arrows-2_log-out' => 'arrows-2_log-out', 
            'business-outline_agenda' => 'business-outline_agenda', 
            'business-outline_award-48' => 'business-outline_award-48', 
            'business-outline_award-49' => 'business-outline_award-49', 
            'business-outline_badge' => 'business-outline_badge', 
            'business-outline_board-28' => 'business-outline_board-28', 
            'business-outline_board-29' => 'business-outline_board-29', 
            'business-outline_board-30' => 'business-outline_board-30', 
            'business-outline_briefcase-24' => 'business-outline_briefcase-24', 
            'business-outline_building' => 'business-outline_building', 
            'business-outline_bulb-63' => 'business-outline_bulb-63', 
            'business-outline_business-contact-86' => 'business-outline_business-contact-86', 
            'business-outline_business-contact-88' => 'business-outline_business-contact-88', 
            'business-outline_businessman-04' => 'business-outline_businessman-04', 
            'business-outline_calculator' => 'business-outline_calculator', 
            'business-outline_chart' => 'business-outline_chart', 
            'business-outline_chart-bar-32' => 'business-outline_chart-bar-32', 
            'business-outline_chart-pie-35' => 'business-outline_chart-pie-35', 
            'business-outline_chart-pie-36' => 'business-outline_chart-pie-36', 
            'business-outline_connect' => 'business-outline_connect', 
            'business-outline_contacts' => 'business-outline_contacts', 
            'business-outline_currency-dollar' => 'business-outline_currency-dollar', 
            'business-outline_currency-euro' => 'business-outline_currency-euro', 
            'business-outline_currency-pound' => 'business-outline_currency-pound', 
            'business-outline_currency-yen' => 'business-outline_currency-yen', 
            'business-outline_factory' => 'business-outline_factory', 
            'business-outline_globe' => 'business-outline_globe', 
            'business-outline_goal-64' => 'business-outline_goal-64', 
            'business-outline_gold' => 'business-outline_gold', 
            'business-outline_handout' => 'business-outline_handout', 
            'business-outline_handshake' => 'business-outline_handshake', 
            'business-outline_hierarchy-55' => 'business-outline_hierarchy-55', 
            'business-outline_laptop-71' => 'business-outline_laptop-71', 
            'business-outline_laptop-91' => 'business-outline_laptop-91', 
            'business-outline_money-12' => 'business-outline_money-12', 
            'business-outline_notes' => 'business-outline_notes', 
            'business-outline_pig' => 'business-outline_pig', 
            'business-outline_pin' => 'business-outline_pin', 
            'business-outline_plug' => 'business-outline_plug', 
            'business-outline_scale' => 'business-outline_scale', 
            'business-outline_sign' => 'business-outline_sign', 
            'business-outline_signature' => 'business-outline_signature', 
            'cards-outline_amazon' => 'cards-outline_amazon', 
            'cards-outline_amex' => 'cards-outline_amex', 
            'cards-outline_android' => 'cards-outline_android', 
            'cards-outline_apple' => 'cards-outline_apple', 
            'cards-outline_mastercard' => 'cards-outline_mastercard', 
            'cards-outline_paypal' => 'cards-outline_paypal', 
            'cards-outline_stripe' => 'cards-outline_stripe', 
            'cards-outline_visa' => 'cards-outline_visa', 
            'clothes-outline_bag-21' => 'clothes-outline_bag-21', 
            'clothes-outline_shirt-business' => 'clothes-outline_shirt-business', 
            'clothes-outline_tie-bow' => 'clothes-outline_tie-bow', 
            'design-outline_app' => 'design-outline_app', 
            'design-outline_artboard' => 'design-outline_artboard', 
            'design-outline_book-open' => 'design-outline_book-open', 
            'design-outline_brush' => 'design-outline_brush', 
            'design-outline_bullet-list' => 'design-outline_bullet-list', 
            'design-outline_code' => 'design-outline_code', 
            'design-outline_code-editor' => 'design-outline_code-editor', 
            'design-outline_command' => 'design-outline_command', 
            'design-outline_compass' => 'design-outline_compass', 
            'design-outline_copy' => 'design-outline_copy', 
            'design-outline_crop' => 'design-outline_crop', 
            'design-outline_design' => 'design-outline_design', 
            'design-outline_image' => 'design-outline_image', 
            'design-outline_measure-17' => 'design-outline_measure-17', 
            'design-outline_mobile-design' => 'design-outline_mobile-design', 
            'design-outline_mobile-dev' => 'design-outline_mobile-dev', 
            'design-outline_mouse-10' => 'design-outline_mouse-10', 
            'design-outline_note-code' => 'design-outline_note-code', 
            'design-outline_paint-16' => 'design-outline_paint-16', 
            'design-outline_paint-bucket-40' => 'design-outline_paint-bucket-40', 
            'design-outline_palette' => 'design-outline_palette', 
            'design-outline_pantone' => 'design-outline_pantone', 
            'design-outline_paper-design' => 'design-outline_paper-design', 
            'design-outline_paper-dev' => 'design-outline_paper-dev', 
            'design-outline_path-exclude' => 'design-outline_path-exclude', 
            'design-outline_pen-tool' => 'design-outline_pen-tool', 
            'design-outline_phone' => 'design-outline_phone', 
            'design-outline_photo-editor' => 'design-outline_photo-editor', 
            'design-outline_scissors-dashed' => 'design-outline_scissors-dashed', 
            'design-outline_tablet-mobile' => 'design-outline_tablet-mobile', 
            'design-outline_text' => 'design-outline_text', 
            'design-outline_vector' => 'design-outline_vector', 
            'design-outline_wand-99' => 'design-outline_wand-99', 
            'design-outline_webpage' => 'design-outline_webpage', 
            'design-outline_window-paragraph' => 'design-outline_window-paragraph', 
            'education-outline_abc' => 'education-outline_abc', 
            'education-outline_atom' => 'education-outline_atom', 
            'education-outline_award-55' => 'education-outline_award-55', 
            'education-outline_backpack-58' => 'education-outline_backpack-58', 
            'education-outline_board-51' => 'education-outline_board-51', 
            'education-outline_book-open' => 'education-outline_book-open', 
            'education-outline_grammar-check' => 'education-outline_grammar-check', 
            'education-outline_language' => 'education-outline_language', 
            'education-outline_microscope' => 'education-outline_microscope', 
            'education-outline_paper' => 'education-outline_paper', 
            'education-outline_pencil-47' => 'education-outline_pencil-47', 
            'education-outline_school' => 'education-outline_school', 
            'emoticons-outline_bomb' => 'emoticons-outline_bomb', 
            'emoticons-outline_cry-15' => 'emoticons-outline_cry-15', 
            'emoticons-outline_fist' => 'emoticons-outline_fist', 
            'emoticons-outline_like' => 'emoticons-outline_like', 
            'emoticons-outline_manga-62' => 'emoticons-outline_manga-62', 
            'emoticons-outline_sad' => 'emoticons-outline_sad', 
            'emoticons-outline_smile' => 'emoticons-outline_smile', 
            'emoticons-outline_speechless' => 'emoticons-outline_speechless', 
            'emoticons-outline_surprise' => 'emoticons-outline_surprise', 
            'envir-outline_recycling' => 'envir-outline_recycling', 
            'envir-outline_save-planet' => 'envir-outline_save-planet', 
            'files-2_ai-illustrator' => 'files-2_ai-illustrator', 
            'files-2_asp' => 'files-2_asp', 
            'files-2_css' => 'files-2_css', 
            'files-2_docx' => 'files-2_docx', 
            'files-2_gif' => 'files-2_gif', 
            'files-2_html' => 'files-2_html', 
            'files-2_jpg-jpeg' => 'files-2_jpg-jpeg', 
            'files-2_js-javascript-jquery' => 'files-2_js-javascript-jquery', 
            'files-3_pdf' => 'files-3_pdf', 
            'files-3_php' => 'files-3_php', 
            'files-3_png' => 'files-3_png', 
            'files-3_psd-photoshop' => 'files-3_psd-photoshop', 
            'files-3_sql' => 'files-3_sql', 
            'files-3_txt' => 'files-3_txt', 
            'files-3_xml' => 'files-3_xml', 
            'files-3_zip' => 'files-3_zip', 
            'files-outline_archive-3d-content' => 'files-outline_archive-3d-content', 
            'files-outline_paper' => 'files-outline_paper', 
            'files-outline_single-content-02' => 'files-outline_single-content-02', 
            'files-outline_single-copies' => 'files-outline_single-copies', 
            'files-outline_single-copy-04' => 'files-outline_single-copy-04', 
            'files-outline_single-paragraph' => 'files-outline_single-paragraph', 
            'files-outline_zip-55' => 'files-outline_zip-55', 
            'food-outline_beer-95' => 'food-outline_beer-95', 
            'food-outline_cocktail' => 'food-outline_cocktail', 
            'food-outline_cutlery-77' => 'food-outline_cutlery-77', 
            'food-outline_donut' => 'food-outline_donut', 
            'food-outline_moka' => 'food-outline_moka', 
            'food-outline_mug' => 'food-outline_mug', 
            'food-outline_pizza-slice' => 'food-outline_pizza-slice', 
            'food-outline_tea' => 'food-outline_tea', 
            'gestures-outline_double-tap' => 'gestures-outline_double-tap', 
            'gestures-outline_pinch' => 'gestures-outline_pinch', 
            'gestures-outline_scroll-horitontal' => 'gestures-outline_scroll-horitontal', 
            'gestures-outline_scroll-vertical' => 'gestures-outline_scroll-vertical', 
            'gestures-outline_stretch' => 'gestures-outline_stretch', 
            'gestures-outline_tap-02' => 'gestures-outline_tap-02', 
            'gestures-outline_touch-id' => 'gestures-outline_touch-id', 
            'health-outline_apple' => 'health-outline_apple', 
            'health-outline_brain' => 'health-outline_brain', 
            'health-outline_dna-27' => 'health-outline_dna-27', 
            'health-outline_sleep' => 'health-outline_sleep', 
            'health-outline_steps' => 'health-outline_steps', 
            'health-outline_wheelchair' => 'health-outline_wheelchair', 
            'holidays-outline_cockade' => 'holidays-outline_cockade', 
            'holidays-outline_gift' => 'holidays-outline_gift', 
            'holidays-outline_gift-exchange' => 'holidays-outline_gift-exchange', 
            'holidays-outline_message' => 'holidays-outline_message', 
            'location-outline_flag-complex' => 'location-outline_flag-complex', 
            'location-outline_map-gps' => 'location-outline_map-gps', 
            'location-outline_map-pin' => 'location-outline_map-pin', 
            'location-outline_worl-marker' => 'location-outline_worl-marker', 
            'location-outline_world' => 'location-outline_world', 
            'media-1_action-74' => 'media-1_action-74', 
            'media-1_album' => 'media-1_album', 
            'media-1_audio-92' => 'media-1_audio-92', 
            'media-1_camera-19' => 'media-1_camera-19', 
            'media-1_countdown-34' => 'media-1_countdown-34', 
            'media-1_flash-24' => 'media-1_flash-24', 
            'media-1_frame-12' => 'media-1_frame-12', 
            'media-1_image-01' => 'media-1_image-01', 
            'media-1_image-02' => 'media-1_image-02', 
            'media-1_layers' => 'media-1_layers', 
            'media-1_movie-62' => 'media-1_movie-62', 
            'media-1_player' => 'media-1_player', 
            'media-1_shake' => 'media-1_shake', 
            'media-1_speaker' => 'media-1_speaker', 
            'media-1_sport' => 'media-1_sport', 
            'media-1_touch' => 'media-1_touch', 
            'media-1_video-66' => 'media-1_video-66', 
            'media-2_headphones' => 'media-2_headphones', 
            'media-2_headphones-mic' => 'media-2_headphones-mic', 
            'media-2_note-03' => 'media-2_note-03', 
            'media-2_radio' => 'media-2_radio', 
            'media-2_sound-wave' => 'media-2_sound-wave', 
            'objects-outline_anchor' => 'objects-outline_anchor', 
            'objects-outline_bow' => 'objects-outline_bow', 
            'objects-outline_diamond' => 'objects-outline_diamond', 
            'objects-outline_dice' => 'objects-outline_dice', 
            'objects-outline_globe' => 'objects-outline_globe', 
            'objects-outline_key-26' => 'objects-outline_key-26', 
            'objects-outline_lamp' => 'objects-outline_lamp', 
            'objects-outline_planet' => 'objects-outline_planet', 
            'objects-outline_puzzle-09' => 'objects-outline_puzzle-09', 
            'objects-outline_puzzle-10' => 'objects-outline_puzzle-10', 
            'objects-outline_skull' => 'objects-outline_skull', 
            'objects-outline_spaceship' => 'objects-outline_spaceship', 
            'objects-outline_support-16' => 'objects-outline_support-16', 
            'objects-outline_support-17' => 'objects-outline_support-17', 
            'objects-outline_umbrella-13' => 'objects-outline_umbrella-13', 
            'shopping-outline_box-3d-50' => 'shopping-outline_box-3d-50', 
            'shopping-outline_cart' => 'shopping-outline_cart', 
            'shopping-outline_cart-add' => 'shopping-outline_cart-add', 
            'shopping-outline_cart-remove' => 'shopping-outline_cart-remove', 
            'shopping-outline_credit-card' => 'shopping-outline_credit-card', 
            'shopping-outline_credit-locked' => 'shopping-outline_credit-locked', 
            'shopping-outline_delivery-fast' => 'shopping-outline_delivery-fast', 
            'shopping-outline_delivery-time' => 'shopping-outline_delivery-time', 
            'shopping-outline_discount' => 'shopping-outline_discount', 
            'shopping-outline_gift' => 'shopping-outline_gift', 
            'shopping-outline_list' => 'shopping-outline_list', 
            'shopping-outline_newsletter' => 'shopping-outline_newsletter', 
            'shopping-outline_tag-content' => 'shopping-outline_tag-content', 
            'sport-outline_boxing' => 'sport-outline_boxing', 
            'sport-outline_crown' => 'sport-outline_crown', 
            'sport-outline_flag-finish' => 'sport-outline_flag-finish', 
            'sport-outline_podium-trophy' => 'sport-outline_podium-trophy', 
            'sport-outline_tactic' => 'sport-outline_tactic', 
            'sport-outline_user-run' => 'sport-outline_user-run', 
            'tech-outline_computer-old' => 'tech-outline_computer-old', 
            'tech-outline_desktop-screen' => 'tech-outline_desktop-screen', 
            'tech-outline_keyboard-mouse' => 'tech-outline_keyboard-mouse', 
            'tech-outline_laptop-front' => 'tech-outline_laptop-front', 
            'tech-outline_mobile' => 'tech-outline_mobile', 
            'tech-outline_player-19' => 'tech-outline_player-19', 
            'tech-outline_print' => 'tech-outline_print', 
            'tech-outline_tablet-button' => 'tech-outline_tablet-button', 
            'tech-outline_tv-old' => 'tech-outline_tv-old', 
            'tech-outline_watch' => 'tech-outline_watch', 
            'tech-outline_wifi' => 'tech-outline_wifi', 
            'text-outline_capitalize' => 'text-outline_capitalize', 
            'text-outline_caps-all' => 'text-outline_caps-all', 
            'text-outline_list-numbers' => 'text-outline_list-numbers', 
            'text-outline_quote' => 'text-outline_quote', 
            'transportation-outline_bike-sport' => 'transportation-outline_bike-sport', 
            'transportation-outline_light-traffic' => 'transportation-outline_light-traffic', 
            'travel-outline_world' => 'travel-outline_world', 
            'ui-1_attach-87' => 'ui-1_attach-87', 
            'ui-1_bell-54' => 'ui-1_bell-54', 
            'ui-1_calendar-grid-61' => 'ui-1_calendar-grid-61', 
            'ui-1_check-circle-07' => 'ui-1_check-circle-07', 
            'ui-1_dashboard-29' => 'ui-1_dashboard-29', 
            'ui-1_drop' => 'ui-1_drop', 
            'ui-1_email-85' => 'ui-1_email-85', 
            'ui-1_eye-17' => 'ui-1_eye-17', 
            'ui-1_eye-ban-18' => 'ui-1_eye-ban-18', 
            'ui-1_home-52' => 'ui-1_home-52', 
            'ui-1_lock' => 'ui-1_lock', 
            'ui-1_lock-open' => 'ui-1_lock-open', 
            'ui-1_notification-70' => 'ui-1_notification-70', 
            'ui-1_pencil' => 'ui-1_pencil', 
            'ui-1_preferences-circle' => 'ui-1_preferences-circle', 
            'ui-1_preferences-circle-rotate' => 'ui-1_preferences-circle-rotate', 
            'ui-1_send' => 'ui-1_send', 
            'ui-1_settings' => 'ui-1_settings', 
            'ui-1_settings-gear-65' => 'ui-1_settings-gear-65', 
            'ui-1_trash-simple' => 'ui-1_trash-simple', 
            'ui-1_ui-04' => 'ui-1_ui-04', 
            'ui-1_zoom-split' => 'ui-1_zoom-split', 
            'ui-1_zoom-split-in' => 'ui-1_zoom-split-in', 
            'ui-1_zoom-split-out' => 'ui-1_zoom-split-out', 
            'ui-2_alert-exclamation' => 'ui-2_alert-exclamation', 
            'ui-2_alert-question' => 'ui-2_alert-question', 
            'ui-2_alert-i' => 'ui-2_alert-i', 
            'ui-2_archive' => 'ui-2_archive', 
            'ui-2_chart-bar-53' => 'ui-2_chart-bar-53', 
            'ui-2_chat-round-content' => 'ui-2_chat-round-content', 
            'ui-2_disk' => 'ui-2_disk', 
            'ui-2_favourite-28' => 'ui-2_favourite-28', 
            'ui-2_favourite-31' => 'ui-2_favourite-31', 
            'ui-2_grid-48' => 'ui-2_grid-48', 
            'ui-2_grid-49' => 'ui-2_grid-49', 
            'ui-2_lab' => 'ui-2_lab', 
            'ui-2_layers' => 'ui-2_layers', 
            'ui-2_link-69' => 'ui-2_link-69', 
            'ui-2_menu-34' => 'ui-2_menu-34', 
            'ui-2_menu-35' => 'ui-2_menu-35', 
            'ui-2_paragraph' => 'ui-2_paragraph', 
            'ui-2_share-bold' => 'ui-2_share-bold', 
            'ui-2_tile-56' => 'ui-2_tile-56', 
            'ui-2_time' => 'ui-2_time', 
            'ui-2_time-countdown' => 'ui-2_time-countdown', 
            'users-outline_man-23' => 'users-outline_man-23', 
            'users-outline_multiple-11' => 'users-outline_multiple-11', 
            'users-outline_woman-25' => 'users-outline_woman-25',
        );
        $coloured_svg_icons = apply_filters( 'spb_coloured_svg_icons', $coloured_svg_icons );
        $outline_svg_icons = apply_filters( 'spb_outline_svg_icons', $outline_svg_icons );

        // Output
        foreach ( $coloured_svg_icons as $icon ) {
       		$svg_icon_output .= '<li class="svg-icon bg-image-icon" data-icon="'.$icon.'"><i class="svg-icon-picker-item '.$icon.'"></i></li>';
        }
        foreach ( $outline_svg_icons as $icon ) {
            $svg_icon_output .= '<li class="svg-icon bg-image-icon" data-icon="'.$icon.'"><i class="svg-icon-picker-item outline-svg '.$icon.'"></i></li>';
        }
        
        return $svg_icon_output;
	}
	add_filter( 'spb_svg_icons_list', 'uplift_spb_svg_icons_list' );
	
	
	/* PAGE BUILDER FONT ICONS
	================================================== */
	function uplift_spb_font_icons_list( $icon_list ) {
		
		// NUCLEO INTERFACE
		$nucleo_interface = array(
		    'e910' => 'sf-icon-audio-player', 
		    'e911' => 'sf-icon-video-player', 
		    'e95c' => 'sf-icon-fail', 
		    'e95d' => 'sf-icon-success', 
		    'e960' => 'sf-icon-video-player-fill', 
		    'e952' => 'sf-icon-settings', 
		    'e912' => 'sf-icon-lightbox', 
		    'e951' => 'sf-icon-portfolio', 
		    'e913' => 'sf-icon-external-link-big', 
		    'e914' => 'sf-icon-text-big', 
		    'e95a' => 'sf-icon-video-big', 
		    'e956' => 'sf-icon-down-arrow-big', 
		    'e955' => 'sf-icon-up-arrow-big', 
		    'e954' => 'sf-icon-left-arrow-big', 
		    'e915' => 'sf-icon-right-arrow-big', 
		    'e916' => 'sf-icon-flags-france', 
		    'e917' => 'sf-icon-flags-germany', 
		    'e918' => 'sf-icon-flags-greece', 
		    'e919' => 'sf-icon-flags-italy', 
		    'e91a' => 'sf-icon-flags-japan', 
		    'e91b' => 'sf-icon-flags-netherlands', 
		    'e91c' => 'icon-russia', 
		    'e94b' => 'sf-icon-flags-sweden', 
		    'e94c' => 'sf-icon-flags-portugal', 
		    'e94d' => 'sf-icon-flags-spain', 
		    'e94e' => 'sf-icon-flags-usa', 
		    'e94f' => 'sf-icon-flags-uk', 
		    'e953' => 'sf-icon-quote-big', 
		    'e962' => 'sf-icon-loader', 
		    'e964' => 'sf-icon-loader-gap', 
		    'e965' => 'sf-icon-dollar', 
		    'e966' => 'sf-icon-euro', 
		    'e967' => 'sf-icon-pound', 
		    'e968' => 'sf-icon-yen', 
		    'e961' => 'sf-icon-checkout', 
		    '10ffff' => 'sf-icon-variable', 
		    'e003' => 'sf-icon-preferences', 
		    'e90d' => 'sf-icon-quote', 
		    'e900' => 'sf-icon-download', 
		    'e901' => 'sf-icon-enlarge', 
		    'e902' => 'sf-icon-down-triangle', 
		    'e903' => 'sf-icon-up-triangle', 
		    'e904' => 'sf-icon-left-arrow', 
		    'e905' => 'sf-icon-right-arrow', 
		    'e906' => 'sf-icon-left-chevron', 
		    'e907' => 'sf-icon-right-chevron', 
		    'e908' => 'sf-icon-down-chevron', 
		    'e909' => 'sf-icon-up-chevron', 
		    'e90a' => 'sf-icon-read-more', 
		    'e90b' => 'sf-icon-share', 
		    'e0101' => 'sf-icon-node', 
		    'e90c' => 'sf-icon-project', 
		    'e004' => 'sf-icon-speech', 
		    'e90e' => 'sf-icon-archive', 
		    'e90f' => 'sf-icon-like', 
		    'e91d' => 'sf-icon-pause', 
		    'e91e' => 'sf-icon-play', 
		    'e91f' => 'sf-icon-image', 
		    'e920' => 'sf-icon-gallery', 
		    'e921' => 'sf-icon-volume', 
		    'e922' => 'sf-icon-audio', 
		    'e923' => 'sf-icon-cart', 
		    'e924' => 'sf-icon-categories', 
		    'e925' => 'sf-icon-tags', 
		    'e926' => 'sf-icon-dribbble', 
		    'e927' => 'sf-icon-fb', 
		    'e928' => 'sf-icon-instagram', 
		    'e929' => 'sf-icon-twitter', 
		    'e92a' => 'sf-icon-video', 
		    'e92b' => 'sf-icon-check', 
		    'e92c' => 'sf-icon-subject', 
		    'e92d' => 'sf-icon-reply', 
		    'e95f' => 'sf-icon-menu-chevron-right', 
		    'e92f' => 'sf-icon-quickview', 
		    'e005' => 'sf-icon-noview', 
		    'e930' => 'sf-icon-filter', 
		    'e931' => 'sf-icon-add-big', 
		    'e932' => 'sf-icon-remove-big', 
		    'e933' => 'sf-icon-trash', 
		    'e934' => 'sf-icon-supersearch', 
		    'e935' => 'sf-icon-search', 
		    'e936' => 'sf-icon-warning', 
		    'e937' => 'sf-icon-question', 
		    'e938' => 'sf-icon-info', 
		    'e939' => 'sf-icon-sort', 
		    'e93a' => 'sf-icon-comments', 
		    'e93b' => 'sf-icon-wishlist', 
		    'e93c' => 'sf-icon-star-fill', 
		    'e93d' => 'sf-icon-view-default', 
		    'e93e' => 'sf-icon-view-gallery', 
		    'e93f' => 'sf-icon-external-link', 
		    'e940' => 'sf-icon-menu', 
		    'e941' => 'sf-icon-text', 
		    'e942' => 'sf-icon-view-list', 
		    'e943' => 'sf-icon-add', 
		    'e944' => 'sf-icon-delete', 
		    'e945' => 'sf-icon-remove', 
		    'e946' => 'sf-icon-date', 
		    'e947' => 'sf-icon-star-stroke', 
		    'e948' => 'sf-icon-half-star', 
		    'e949' => 'sf-icon-account', 
		    'e94a' => 'sf-icon-name', 
		    'e950' => 'sf-icon-sticky-post', 
		    'e957' => 'sf-icon-phone', 
		    'e958' => 'sf-icon-down-arrow', 
		    'e959' => 'sf-icon-up-arrow', 
		    'e95b' => 'sf-icon-tick', 
		    'e95e' => 'sf-icon-menu-chevron', 
		    'e92e' => 'sf-icon-email',
		);
		
		// NUCLEO GENERAL
		$nucleo_general = array(
		    'e97d' => 'nucleo-icon-add', 
		    'e983' => 'nucleo-icon-alert-help', 
		    'e984' => 'nucleo-icon-alert-info', 
		    'e99a' => 'nucleo-icon-alert-square', 
		    'e982' => 'nucleo-icon-alert-warning', 
		    'e957' => 'nucleo-icon-anchor', 
		    'e922' => 'nucleo-icon-app', 
		    'e985' => 'nucleo-icon-archive', 
		    'e934' => 'nucleo-icon-archive-content', 
		    'e90f' => 'nucleo-icon-arrow-circle-right', 
		    'e907' => 'nucleo-icon-arrow-left', 
		    'e908' => 'nucleo-icon-arrow-right', 
		    'e90e' => 'nucleo-icon-arrow-square-right', 
		    'e909' => 'nucleo-icon-arrow-up', 
		    'e975' => 'nucleo-icon-attach', 
		    'e913' => 'nucleo-icon-award', 
		    'e914' => 'nucleo-icon-badge', 
		    'e95c' => 'nucleo-icon-bag', 
		    'e95d' => 'nucleo-icon-bag-add', 
		    'e95e' => 'nucleo-icon-bag-remove', 
		    'e917' => 'nucleo-icon-barchart', 
		    'e976' => 'nucleo-icon-bell', 
		    'e92f' => 'nucleo-icon-board', 
		    'e915' => 'nucleo-icon-briefcase', 
		    'e94c' => 'nucleo-icon-brightness', 
		    'e923' => 'nucleo-icon-brush', 
		    'e916' => 'nucleo-icon-bulb', 
		    'e94d' => 'nucleo-icon-camera', 
		    'e971' => 'nucleo-icon-capitalize', 
		    'e988' => 'nucleo-icon-chat-fill', 
		    'e987' => 'nucleo-icon-chat-stroke', 
		    'e979' => 'nucleo-icon-check', 
		    'e977' => 'nucleo-icon-check-small', 
		    'e978' => 'nucleo-icon-check-square', 
		    'e919' => 'nucleo-icon-cheque', 
		    'e90c' => 'nucleo-icon-chevron-down', 
		    'e90a' => 'nucleo-icon-chevron-left', 
		    'e90b' => 'nucleo-icon-chevron-right', 
		    'e90d' => 'nucleo-icon-chevron-up', 
		    'e999' => 'nucleo-icon-clock', 
		    'e900' => 'nucleo-icon-cloud-download', 
		    'e9a3' => 'nucleo-icon-cloud-fog', 
		    'e9a4' => 'nucleo-icon-cloud-hail', 
		    'e9a5' => 'nucleo-icon-cloud-light', 
		    'e901' => 'nucleo-icon-cloud-upload', 
		    'e939' => 'nucleo-icon-coffee', 
		    'e924' => 'nucleo-icon-command', 
		    'e94e' => 'nucleo-icon-countdown', 
		    'e95f' => 'nucleo-icon-credit-card', 
		    'e925' => 'nucleo-icon-crop', 
		    'e93a' => 'nucleo-icon-cutlery', 
		    'e960' => 'nucleo-icon-delivery', 
		    'e926' => 'nucleo-icon-design', 
		    'e965' => 'nucleo-icon-desktop', 
		    'e989' => 'nucleo-icon-disk', 
		    'e932' => 'nucleo-icon-dislike', 
		    'e91a' => 'nucleo-icon-dollar', 
		    'e902' => 'nucleo-icon-download', 
		    'e93b' => 'nucleo-icon-drag', 
		    'e97a' => 'nucleo-icon-edit-box', 
		    'e927' => 'nucleo-icon-eraser', 
		    'e91b' => 'nucleo-icon-euro', 
		    'e97b' => 'nucleo-icon-eye', 
		    'e937' => 'nucleo-icon-file', 
		    'e936' => 'nucleo-icon-file-blank', 
		    'e938' => 'nucleo-icon-files', 
		    'e97c' => 'nucleo-icon-filter', 
		    'e945' => 'nucleo-icon-flag', 
		    'e944' => 'nucleo-icon-flag-diagonal', 
		    'e963' => 'nucleo-icon-flag-finish', 
		    'e94f' => 'nucleo-icon-flash', 
		    'e935' => 'nucleo-icon-folder', 
		    'e950' => 'nucleo-icon-frame', 
		    'e903' => 'nucleo-icon-fullscreen', 
		    'e93c' => 'nucleo-icon-gestures', 
		    'e961' => 'nucleo-icon-gift', 
		    'e958' => 'nucleo-icon-globe', 
		    'e91f' => 'nucleo-icon-goal', 
		    'e949' => 'nucleo-icon-gps', 
		    'e98c' => 'nucleo-icon-grid', 
		    'e98d' => 'nucleo-icon-grid-small', 
		    'e991' => 'nucleo-icon-hamburger', 
		    'e966' => 'nucleo-icon-headphones', 
		    'e98a' => 'nucleo-icon-heart', 
		    'e941' => 'nucleo-icon-heartbeat', 
		    'e99b' => 'nucleo-icon-help-square', 
		    'e920' => 'nucleo-icon-hierarchy', 
		    'e951' => 'nucleo-icon-image', 
		    'e99c' => 'nucleo-icon-info-square', 
		    'e959' => 'nucleo-icon-key', 
		    'e98e' => 'nucleo-icon-lab', 
		    'e967' => 'nucleo-icon-laptop', 
		    'e952' => 'nucleo-icon-layers', 
		    'e933' => 'nucleo-icon-like', 
		    'e98f' => 'nucleo-icon-link', 
		    'e990' => 'nucleo-icon-link-broken', 
		    'e973' => 'nucleo-icon-list-bullet', 
		    'e946' => 'nucleo-icon-map', 
		    'e92e' => 'nucleo-icon-medal', 
		    'e992' => 'nucleo-icon-menu', 
		    'e94b' => 'nucleo-icon-mic', 
		    'e929' => 'nucleo-icon-mouse', 
		    'e969' => 'nucleo-icon-navigation', 
		    'e956' => 'nucleo-icon-note', 
		    'e92a' => 'nucleo-icon-paint', 
		    'e931' => 'nucleo-icon-paper', 
		    'e993' => 'nucleo-icon-paragraph', 
		    'e92b' => 'nucleo-icon-copy', 
		    'e92c' => 'nucleo-icon-pen', 
		    'e92d' => 'nucleo-icon-phone', 
		    'e918' => 'nucleo-icon-piechart', 
		    'e947' => 'nucleo-icon-pin', 
		    'e93d' => 'nucleo-icon-pinch', 
		    'e953' => 'nucleo-icon-player', 
		    'e921' => 'nucleo-icon-plug', 
		    'e91c' => 'nucleo-icon-pound', 
		    'e96b' => 'nucleo-icon-print', 
		    'e942' => 'nucleo-icon-pulse', 
		    'e974' => 'nucleo-icon-quote', 
		    'e911' => 'nucleo-icon-refresh', 
		    'e97e' => 'nucleo-icon-remove', 
		    'e93e' => 'nucleo-icon-rotate', 
		    'e994' => 'nucleo-icon-share', 
		    'e912' => 'nucleo-icon-share-diagnol', 
		    'e905' => 'nucleo-icon-share-right', 
		    'e904' => 'nucleo-icon-share-up', 
		    'e906' => 'nucleo-icon-shuffle', 
		    'e986' => 'nucleo-icon-signal', 
		    'e995' => 'nucleo-icon-small-add', 
		    'e996' => 'nucleo-icon-small-delete', 
		    'e997' => 'nucleo-icon-small-remove', 
		    'e95a' => 'nucleo-icon-spaceship', 
		    'e930' => 'nucleo-icon-speech', 
		    'e98b' => 'nucleo-icon-star', 
		    'e943' => 'nucleo-icon-steps', 
		    'e93f' => 'nucleo-icon-stretch', 
		    'e95b' => 'nucleo-icon-support', 
		    'e96c' => 'nucleo-icon-tablet', 
		    'e96d' => 'nucleo-icon-tablet-reader', 
		    'e962' => 'nucleo-icon-tag', 
		    'e940' => 'nucleo-icon-tap', 
		    'e9a1' => 'nucleo-icon-team', 
		    'e972' => 'nucleo-icon-text', 
		    'e998' => 'nucleo-icon-tile', 
		    'e97f' => 'nucleo-icon-trash', 
		    'e96e' => 'nucleo-icon-tv', 
		    'e910' => 'nucleo-icon-undo', 
		    'e9a2' => 'nucleo-icon-user', 
		    'e964' => 'nucleo-icon-user-run', 
		    'e99d' => 'nucleo-icon-users-add', 
		    'e99e' => 'nucleo-icon-users-badge', 
		    'e99f' => 'nucleo-icon-users-circle', 
		    'e9a0' => 'nucleo-icon-users-delete', 
		    'e954' => 'nucleo-icon-video', 
		    'e96f' => 'nucleo-icon-watch', 
		    'e970' => 'nucleo-icon-wifi', 
		    'e948' => 'nucleo-icon-world', 
		    'e91d' => 'nucleo-icon-yen', 
		    'e981' => 'nucleo-icon-zoom', 
		    'e980' => 'nucleo-icon-zoom-in', 
		);
		
		$icon_list .= uplift_icon_format_output( $nucleo_interface, "nucleo-interface", $format );
		$icon_list .= uplift_icon_format_output( $nucleo_general, "nucleo-general", $format );
		
		return $icon_list;
	}
	add_filter( 'spb_font_icons_list', 'uplift_spb_font_icons_list' );
	
	
	/* PAGE BUILDER TEMPLATES FILTER
	================================================== */
	function uplift_spb_templates($prebuilt_templates) {
		$prebuilt_templates = array();
		
		$prebuilt_templates["home-simple"] = array(
		"id" => "home-simple",
		"name" => "Main Demo - Home: Simple",
		"code" => '[spb_portfolio display_type="gallery" multi_size_ratio="1/1" fullwidth="yes" gutters="no" columns="4" show_title="yes" show_subtitle="yes" show_excerpt="yes" hover_show_excerpt="no" excerpt_length="20" item_count="4" category="All" order_by="none" order="DESC" portfolio_filter="no" pagination="none" button_enabled="yes" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_section spb_section_id="15528" width="1/1" el_position="first last"] [spb_blank_spacer height="50px" width="1/1" el_position="first last"] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="light" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="0px" bottom_margin="60px" fullwidth="yes" width="1/1" el_position="first last"] [spb_recent_posts title="Recent Articles" display_type="standard" carousel="yes" item_columns="3" item_count="4" category="All" offset="0" posts_order="DESC" excerpt_length="23" fullwidth="no" gutters="yes" button_enabled="no" pagination="yes" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [/spb_row] [spb_section spb_section_id="15472" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["home-moderna"] = array(
		"id" => "home-moderna",
		"name" => "Main Demo - Home: Moderna",
		"code" => '[spb_row element_name="Headline Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="80" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [spb_animated_headline element_name="agency anim headline" before_text="Welcome to uplift industries, we are a company the produces high quality" animated_strings="steel,copper,lead" after_text="pipes." animation_type="clip" textstyle="impact-text" textalign="left" textcolor="#303030" width="1/2" el_position="first"] [spb_blank_spacer height="1px" width="1/2" el_position="last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_button button_text="More about us" button_size="standard" button_colour="accent" button_type="bordered" rounded="yes" button_dropshadow="no" button_icon="nucleo-icon-chevron-right" button_link="/pages/about-us-classic/" button_target="_self" align="left" animation="none" animation_delay="0" width="1/2" el_position="first"] [spb_blank_spacer height="1px" width="1/2" el_position="last"] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [/spb_row] [spb_image image="15624" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="yes" overflow_mode="none" el_class="mb0 pb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_blank_spacer height="140px" width="1/1" el_position="first last"] [spb_section element_name="Icons: 3x2 vertical" spb_section_id="15469" width="1/1" el_position="first last"] [spb_blank_spacer height="140px" width="1/1" el_position="first last"] [spb_row element_name="Row" wrap_type="full-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" width="1/1" el_position="first last"] [spb_image image="15249" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" link_target="_self" lightbox="yes" intro_animation="none" animation_delay="200" width="1/2" el_position="first"] [spb_image image="15248" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" link_target="_self" lightbox="yes" intro_animation="none" animation_delay="200" width="1/2" el_position="last"] [spb_section spb_section_id="15534" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Headline Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="139px" width="1/1" el_position="first last"] [spb_recent_posts title="Recent Articles" display_type="standard" carousel="no" item_columns="3" item_count="3" category="All" offset="0" posts_order="DESC" excerpt_length="23" fullwidth="no" gutters="yes" button_enabled="yes" pagination="yes" width="1/1" el_position="first last"] [spb_blank_spacer height="115px" width="1/1" el_position="first last"] [/spb_row] [spb_section element_name="Promo Bar SPB" spb_section_id="15612" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["meet-the-team-creative"] = array(
		"id" => "meet-the-team-creative",
		"name" => "Main Demo - Meet The Team: Creative",
		"code" => '[spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_team display_type="gallery" carousel="no" item_columns="3" item_count="6" category="All" profile_link="no" ajax_overlay="yes" pagination="no" fullwidth="no" gutters="yes" order_by="none" order="DESC" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_section spb_section_id="15472" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["services-simple"] = array(
		"id" => "services-simple",
		"name" => "Main Demo - Services: Simple",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="60" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_animated_headline before_text="Were an award-winning creating company elegant digital solutions for" animated_strings="charities,agencies,governments" animation_type="slide" textstyle="h1" textalign="left" textcolor="#546e7a" width="1/1" el_position="first last"] [spb_divider type="thin" heading_text="Services We Offer" text="Go to top" top_margin="60px" bottom_margin="0px" fullwidth="no" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_icon_box title="Idea Generation" box_type="animated-alt" box_icon_type="svg" svg_icon="health-outline_brain" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#7eced5" text_color="#7eced5" bg_color="#ffffff" flip_bg_color="#7eced5" flip_text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/3" el_position="first"] [list extraclass=""] [list_item icon="sf-icon-menu-chevron-right"]Ideation[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Brainstorming[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Breakouts[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Meetings[/list_item] [/list] [/spb_icon_box] [spb_icon_box title="Colour Creation" box_type="animated-alt" box_icon_type="svg" svg_icon="design-outline_paint-bucket-40" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#78909c" text_color="#78909c" bg_color="#ffffff" flip_bg_color="#78909c" flip_text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/3"] [list extraclass=""] [list_item icon="sf-icon-menu-chevron-right"]Palette Creation[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Colour Invention[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Colour Mixing[/list_item] [/list] [/spb_icon_box] [spb_icon_box title="Data Analysis" box_type="animated-alt" box_icon_type="svg" svg_icon="business-outline_board-29" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#0097a7" text_color="#0097a7" bg_color="#ffffff" flip_bg_color="#0097a7" flip_text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/3" el_position="last"] [list extraclass=""] [list_item icon="sf-icon-menu-chevron-right"]Data Visualisation[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Data Mining[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Data Presentations[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Data Interpretation[/list_item] [/list] [/spb_icon_box] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box title="Human Resources" box_type="animated-alt" box_icon_type="svg" svg_icon="business-outline_badge" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#0277bd" text_color="#0277bd" bg_color="#ffffff" flip_bg_color="#0277bd" flip_text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/3" el_position="first"] [list extraclass=""] [list_item icon="sf-icon-menu-chevron-right"]HR Planning[/list_item] [list_item icon="sf-icon-menu-chevron-right"]HR Projects[/list_item] [list_item icon="sf-icon-menu-chevron-right"]HR Documentation[/list_item] [/list] [/spb_icon_box] [spb_icon_box title="Email Marketing" box_type="animated-alt" box_icon_type="svg" svg_icon="holidays-outline_message" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#303f9f" text_color="#303f9f" bg_color="#ffffff" flip_bg_color="#303f9f" flip_text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/3"] [list extraclass=""] [list_item icon="sf-icon-menu-chevron-right"]Subscriptions[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Email Creation[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Email Planning[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Analysis[/list_item] [/list] [/spb_icon_box] [spb_icon_box title="Applied Genetics" box_type="animated-alt" box_icon_type="svg" svg_icon="health-outline_dna-27" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#37474f" text_color="#37474f" bg_color="#ffffff" flip_bg_color="#37474f" flip_text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/3" el_position="last"] [list extraclass=""] [list_item icon="sf-icon-menu-chevron-right"]Gene Mapping[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Gene Regulation[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Gene Mutation[/list_item] [list_item icon="sf-icon-menu-chevron-right"]DNA Sequencing[/list_item] [/list] [/spb_icon_box] [/spb_row] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_section spb_section_id="15472" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["page-not-found"] = array(
		"id" => "page-not-found",
		"name" => "Main Demo - 404",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="window-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/4" el_position="first"] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="10" width="1/2" el_position="last"]  uplift-404-img  
		Our apologies
		
		It seems we couldnt find the page you are looking for. Please check to make sure youve typed the URL correctly.
		
		[uplift_button colour="white" type="icon" size="large" link="javascript: history.go(-1)" target="_self" icon="nucleo-icon-undo" dropshadow="yes" rounded="yes" extraclass="ml0"]Return[/uplift_button]
		
		[/spb_text_block] [/spb_row]');
		
		$prebuilt_templates["contact-simple"] = array(
		"id" => "contact-simple",
		"name" => "Main Demo - Contact: Simple",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="window-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" width="1/4" el_position="first"] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" simplified_controls="yes" custom_css="margin-top: px!important;margin-left: px!important;margin-right: px!important;margin-bottom: px!important;border-top: px default !important;border-left: px default !important;border-right: px default !important;border-bottom: px default !important;padding-top: 0px!important;padding-left: 0px!important;padding-right: 0px!important;padding-bottom: 0px!important;" border_styling_global="default" width="1/2"]
		Get in touch with us
		
		[contact-form-7 id="15387" title="Contact form 1"]   [/spb_text_block] [spb_blank_spacer height="1px" width="1/4" el_position="last"] [spb_blank_spacer height="1px" width="1/4" el_position="first"] [spb_divider type="thin" text="Go to top" top_margin="0px" bottom_margin="60px" fullwidth="no" width="1/2"] [spb_blank_spacer height="1px" width="1/4" el_position="last"] [spb_blank_spacer height="1px" width="1/4" el_position="first"] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" simplified_controls="yes" border_styling_global="default" width="1/2" el_position="last"] Visit us: No.1 Abbey Road, London, W1 ECH, UK Call: +44 (0) 800 123 4567   |   Email: info@uplift.com [social]   [/spb_text_block] [/spb_row]');
		
		$prebuilt_templates["our-process"] = array(
		"id" => "our-process",
		"name" => "Main Demo - Our Process",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" parallax_video_overlay="none" row_overlay_opacity="0" vertical_center="true" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" width="1/4" el_position="first"] [spb_text_block animation="none" animation_delay="0" padding_vertical="6" padding_horizontal="0" width="1/2" el_position="last"]
		Lorem ipsum dolor sit met, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed.
		
		[/spb_text_block] [/spb_row] [spb_icon_box_grid colour_style="dark" width="1/1" el_position="first last"] [spb_icon_box_grid_element title="1: Brainstorming and Ideation" target="" link="" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg health-outline_brain"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="2: Designing and Sketching" target="" link="" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg design-outline_crop"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="3: Development and Testing" target="" link="" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg design-outline_code"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="4: Iteration, iteration and iteration" target="" link="" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg files-outline_single-copies"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="5: Marketing and Launch" target="" link="" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg objects-outline_spaceship"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="6: Evaluate and Celebrate" target="" link="" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg food-outline_beer-95"][/spb_icon_box_grid_element] [/spb_icon_box_grid] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [spb_section spb_section_id="15472" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["about-personal"] = array(
		"id" => "about-personal",
		"name" => "Main Demo - About: Personal",
		"code" => '[spb_row element_name="Row" wrap_type="full-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_image image="15553" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="yes" overflow_mode="none" el_class="pl0 ml0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/2" el_position="first"] [spb_text_block animation="none" animation_delay="0" padding_vertical="8" padding_horizontal="17" width="1/2" el_position="last"]
		Hi, my name is Mike Munari. Im a developer based in London.
		
		Vestibule convallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque purus lorem eget elit. Sed vitae nunc in mets semper veilt arcu mattis hendrerit.
		
		[hr]
		
		[uplift_button colour="accent" type="icon" size="standard" link="#" target="_self" icon="nucleo-icon-cloud-download" dropshadow="no" rounded="yes" extraclass=""]Download CV[/uplift_button]
		
		[/spb_text_block] [/spb_row]');
		
		$prebuilt_templates["full-screen-page"] = array(
		"id" => "full-screen-page",
		"name" => "Main Demo - Full-Screen Page",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="image" row_bg_color="#111111" color_row_height="content-height" row_style="dark" bg_image="15458" bg_type="cover" parallax_image_height="window-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_mp4="http://swiftideasvideos.s3.amazonaws.com/uplift-warp-bkg-h264.mp4" bg_video_webm="http://swiftideasvideos.s3.amazonaws.com/uplift-warp-bkg.webmhd.webm" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="80" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" width="1/3" el_position="first"] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="4" width="1/3"]  uplift_logo_white@2x
		This is a full-screen page. It does exactly what it says on the tin.
		
		
		[uplift_button colour="white" type="sf-icon-stroke" size="standard" link="javascript: history.go(-1)" target="_self" icon="nucleo-icon-undo" dropshadow="no" rounded="yes" extraclass=""]Go back[/uplift_button]
		
		[/spb_text_block] [spb_blank_spacer height="1px" width="1/3" el_position="last"] [/spb_row]');
		
		$prebuilt_templates["full-width-page"] = array(
		"id" => "full-width-page",
		"name" => "Main Demo - Full-width Page",
		"code" => '[spb_image image="15251" image_size="full" frame="noframe" intro_animation="none" animation_delay="200" fullwidth="no" lightbox="no" link_target="_self" caption_pos="hover" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/1" el_position="first last"]
		Lorem ipsum dolor sit met, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		Class patent taciti sociosqu ad litro torquent per connubio nostra, per inceptos himenaeos. Curabitur a torto ut leo mattis cursus. Vestibule laoreet interdum pellentesque. Suspendisse vitae cursus urna. Lorem ipsum dolor sit met, consectetur adipiscing elit. Nulla veilt mets, ornare vitae maleducada in, fermentum ac turpis. Vestibule convallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque purus lorem eget elit. Sed vitae nunc in mets semper hendrerit. Curabitur mets felis, interduo quis sodales at, aliquam eu eros. Prone ac lacks urna, vel pulvinar ante. Integer poser, sapient ut iaculis molestie, justo quad ultrices orci.
		
		[/spb_text_block]');
		
		$prebuilt_templates["privacy-policy"] = array(
		"id" => "privacy-policy",
		"name" => "Main Demo - Privacy Policy",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="one" row_name="Information we collect" width="1/1" el_position="first last"] [spb_blank_spacer height="10px" width="1/1" el_position="first last"] [spb_text_block title="Information We Collect" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="4" width="1/1" el_position="first last"]
		Consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		[/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="30px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="two" row_name="How we use information" width="1/1" el_position="first last"] [spb_text_block title="How we use information" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="4" width="1/1" el_position="first last"]
		Consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		[/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="30px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="three" row_name="Transparency and choice" width="1/1" el_position="first last"] [spb_text_block title="Transparency and choice" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="4" width="1/1" el_position="first last"]
		Consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		[/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="30px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="four" row_name="Information sharing" width="1/1" el_position="first last"] [spb_text_block title="Information sharing" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="4" width="1/1" el_position="first last"]
		Consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		[/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="30px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="five" row_name="When this policy applies" width="1/1" el_position="first last"] [spb_text_block title="When this policy applies" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="4" width="1/1" el_position="first last"]
		Consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		[/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="30px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="six" row_name="Compliance and cooperation" width="1/1" el_position="first last"] [spb_text_block title="Compliance and cooperation" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="4" width="1/1" el_position="first last"]
		Consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		[/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="30px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="seven" row_name="Policy changes" width="1/1" el_position="first last"] [spb_text_block title="Policy changes" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="4" width="1/1" el_position="first last"]
		Consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		Vix vide fieriest tractates ut. Efficiantur necessitatibus eos ei, magna nemore labores ei pro. Ne sed oratio eigendi, accuaam detracto cu vim, mei oblique bonorum constituam te. Et nec maxime utroque. Sumo adolescent qui ea, no pro vitae dolores maluisset. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac, commode sed orci.
		
		[/spb_text_block] [/spb_row]');
		
		$prebuilt_templates["our-offices"] = array(
		"id" => "our-offices",
		"name" => "Main Demo - Our Offices",
		"code" => '[spb_blank_spacer height="90px" width="1/1" el_position="first last"] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" width="1/1" el_position="first last"] [spb_image image="15251" image_size="full" frame="noframe" intro_animation="none" animation_delay="800" fullwidth="no" lightbox="yes" link_target="_self" caption_pos="hover" remove_rounded="no" width="1/2" el_position="first"] [spb_text_block animation="none" animation_delay="200" padding_vertical="0" padding_horizontal="6" el_class="pb0" width="1/2" el_position="last"]
		Lorem ipsum dolor
		
		Lorem ipsum dolor sit amet isse potenti. Vesquam ante aliquet lacusemper elit. Cras neque nulla, convallis non commodo et, euismod nonsese. At vero eos et accus amus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non.
		
		Learn more
		
		[/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="30px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="200" padding_vertical="0" padding_horizontal="6" el_class="pb0" width="1/2" el_position="first"]
		Lorem ipsum dolor
		
		Lorem ipsum dolor sit amet isse potenti. Vesquam ante aliquet lacusemper elit. Cras neque nulla, convallis non commodo et, euismod nonsese. At vero eos et accus amus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non.
		
		Learn more
		
		[/spb_text_block] [spb_image image="15250" image_size="full" frame="noframe" intro_animation="none" animation_delay="800" fullwidth="no" lightbox="yes" link_target="_self" caption_pos="hover" remove_rounded="no" width="1/2" el_position="last"] [spb_divider type="thin" text="Go to top" top_margin="30px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" width="1/1" el_position="first last"] [spb_image image="15249" image_size="full" frame="noframe" intro_animation="none" animation_delay="800" fullwidth="no" lightbox="yes" link_target="_self" caption_pos="hover" remove_rounded="no" width="1/2" el_position="first"] [spb_text_block animation="none" animation_delay="200" padding_vertical="0" padding_horizontal="6" el_class="pb0" width="1/2" el_position="last"]
		Lorem ipsum dolor
		
		Lorem ipsum dolor sit amet isse potenti. Vesquam ante aliquet lacusemper elit. Cras neque nulla, convallis non commodo et, euismod nonsese. At vero eos et accus amus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non.
		
		Learn more
		
		[/spb_text_block] [/spb_row]');
		
		$prebuilt_templates["careers"] = array(
		"id" => "careers",
		"name" => "Main Demo - Careers",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" padding_vertical="2" padding_horizontal="0" width="1/1" el_position="first last"]
		4 Reasons to work at Uplift.
		[/spb_text_block] [spb_icon_box title="Competitive Salary" box_type="standard-center" box_icon_type="svg" icon="fa-money" svg_icon="business-outline_handout" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#00838f" text_color="#444444" animated_box_style="coloured" width="1/4" el_position="first"] Vestibule convallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod. [/spb_icon_box] [spb_icon_box title="Growth & Learning" box_type="standard-center" box_icon_type="svg" icon="fa-leaf" svg_icon="health-outline_brain" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#546e7a" text_color="#444444" animated_box_style="coloured" animated_box_rounded="yes" width="1/4"] Vestibule convallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod. [/spb_icon_box] [spb_icon_box title="Health Benefits" box_type="standard-center" box_icon_type="svg" icon="fa-heartbeat" svg_icon="media-2_sound-wave" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#00b8d4" text_color="#444444" animated_box_style="coloured" animated_box_rounded="yes" width="1/4"] Vestibule convallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod. [/spb_icon_box] [spb_icon_box title="Flexibility" box_type="standard-center" box_icon_type="svg" icon="fa-exchange" svg_icon="arrows-1_shuffle-98" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#00bfa5" text_color="#444444" animated_box_style="coloured" animated_box_rounded="yes" width="1/4" el_position="last"] Vestibule convallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod. [/spb_icon_box] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="0px" bottom_margin="30px" fullwidth="yes" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" padding_vertical="2" padding_horizontal="0" width="1/1" el_position="first last"]
		Current Job Openings
		[/spb_text_block] [spb_boxed_content type="whitestroke" box_link_target="_self" padding_vertical="10" padding_horizontal="10" width="1/3" el_position="first"]
		Design Lead
		
		Class patent taciti sociosqu ad litro torquent per connubio nostra, per inceptos hime naeos. Curabitur a torto ut leo mattis.
		
		[uplift_modal header="Design Lead Job" btn_colour="accent" btn_type="standard" btn_size="standard" btn_icon="ss-star" btn_text="Read more"]
		
		[dropcap4]L[/dropcap4]orem ipsum dolor sit met, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		[uplift_button colour="accent" type="standard" size="large" link="#" target="_self" icon="" dropshadow="no" rounded="no" extraclass=""]Apply for this opening[/uplift_button] [/uplift_modal] [/spb_boxed_content] [spb_boxed_content type="whitestroke" box_link_target="_self" padding_vertical="10" padding_horizontal="10" width="1/3"]
		Senior Digital Strategist
		
		Class patent taciti sociosqu ad litro torquent per connubio nostra, per inceptos hime naeos. Curabitur a torto ut leo mattis.
		
		[uplift_modal header="Design Lead Job" btn_colour="accent" btn_type="standard" btn_size="standard" btn_icon="ss-star" btn_text="Read more"]
		
		[dropcap4]L[/dropcap4]orem ipsum dolor sit met, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		[uplift_button colour="accent" type="standard" size="large" link="#" target="_self" icon="" dropshadow="no" rounded="no" extraclass=""]Apply for this opening[/uplift_button] [/uplift_modal] [/spb_boxed_content] [spb_boxed_content type="whitestroke" box_link_target="_self" padding_vertical="10" padding_horizontal="10" width="1/3" el_position="last"]
		Human Resources Manager
		
		Class patent taciti sociosqu ad litro torquent per connubio nostra, per inceptos hime naeos. Curabitur a torto ut leo mattis.
		
		[uplift_modal header="Design Lead Job" btn_colour="accent" btn_type="standard" btn_size="standard" btn_icon="ss-star" btn_text="Read more"]
		
		[dropcap4]L[/dropcap4]orem ipsum dolor sit met, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		[uplift_button colour="accent" type="standard" size="large" link="#" target="_self" icon="" dropshadow="no" rounded="no" extraclass=""]Apply for this opening[/uplift_button] [/uplift_modal] [/spb_boxed_content] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_boxed_content type="whitestroke" box_link_target="_self" padding_vertical="10" padding_horizontal="10" width="1/3" el_position="first"]
		Account Manager
		
		Class patent taciti sociosqu ad litro torquent per connubio nostra, per inceptos hime naeos. Curabitur a torto ut leo mattis.
		
		[uplift_modal header="Design Lead Job" btn_colour="accent" btn_type="standard" btn_size="standard" btn_icon="ss-star" btn_text="Read more"]
		
		[dropcap4]L[/dropcap4]orem ipsum dolor sit met, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		[uplift_button colour="accent" type="standard" size="large" link="#" target="_self" icon="" dropshadow="no" rounded="no" extraclass=""]Apply for this opening[/uplift_button] [/uplift_modal] [/spb_boxed_content] [spb_boxed_content type="whitestroke" box_link_target="_self" padding_vertical="10" padding_horizontal="10" width="1/3" el_position="last"]
		Junior Sales Assistant
		
		Class patent taciti sociosqu ad litro torquent per connubio nostra, per inceptos hime naeos. Curabitur a torto ut leo mattis.
		
		[uplift_modal header="Design Lead Job" btn_colour="accent" btn_type="standard" btn_size="standard" btn_icon="ss-star" btn_text="Read more"]
		
		[dropcap4]L[/dropcap4]orem ipsum dolor sit met, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum dissentiunt ad has.
		
		[uplift_button colour="accent" type="standard" size="large" link="#" target="_self" icon="" dropshadow="no" rounded="no" extraclass=""]Apply for this opening[/uplift_button] [/uplift_modal] [/spb_boxed_content] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [/spb_row] [spb_section spb_section_id="15236" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["services-creative"] = array(
		"id" => "services-creative",
		"name" => "Main Demo - Services: Creative",
		"code" => '[spb_row element_name="Row" wrap_type="full-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_responsive_vis="hidden-xs_hidden-sm" row_el_class="mt0 pt0" minimize_row="no" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_image image="14887" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="yes" overflow_mode="none" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/2" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 20%!important;padding-right: 20%!important;padding-bottom: 0%!important;" border_styling_global="default" width="1/2" el_position="last"]
		01
		
		Digital Marketing
		
		Class patent taciti sociosqu ad litro torquent per connubio nostra, per inceptos himenaeos. Curabitur a torto ut leo mattis cursus. Vestibule laoreet interdum pellentesque. Suspendisse vitae. [uplift_button colour="accent" type="bordered" size="standard" link="/portfolio/portfolio-two-column-gallery/" target="_self" icon="sf-icon-read-more" dropshadow="no" rounded="yes" extraclass=""]Case Studies[/uplift_button] [/spb_text_block] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 20%!important;padding-right: 20%!important;padding-bottom: 0%!important;" border_styling_global="default" width="1/2" el_position="first"]
		02
		
		Copywriting
		
		Class patent taciti sociosqu ad litro torquent per connubio nostra, per inceptos himenaeos. Curabitur a torto ut leo mattis cursus. Vestibule laoreet interdum pellentesque. Suspendisse vitae. [uplift_button colour="accent" type="bordered" size="standard" link="#" target="_self" icon="sf-icon-read-more" dropshadow="no" rounded="yes" extraclass=""]Case Studies[/uplift_button] [/spb_text_block] [spb_image image="14891" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="yes" overflow_mode="none" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/2" el_position="last"] [spb_image image="14892" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="yes" overflow_mode="none" el_class="mt0 pt0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/2" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 20%!important;padding-right: 20%!important;padding-bottom: 0%!important;" border_styling_global="default" width="1/2" el_position="last"]
		03
		
		Accounting
		
		Class patent taciti sociosqu ad litro torquent per connubio nostra, per inceptos himenaeos. Curabitur a torto ut leo mattis cursus. Vestibule laoreet interdum pellentesque. Suspendisse vitae. [uplift_button colour="accent" type="bordered" size="standard" link="#" target="_self" icon="sf-icon-read-more" dropshadow="no" rounded="yes" extraclass=""]Case Studies[/uplift_button] [/spb_text_block] [/spb_row] [spb_row element_name="Row" wrap_type="full-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_responsive_vis="hidden-lg_hidden-md" row_el_class="mt0 pt0" minimize_row="no" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_image image="14887" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="yes" overflow_mode="none" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 10%!important;padding-left: 10%!important;padding-right: 10%!important;padding-bottom: 10%!important;" border_styling_global="default" width="1/1" el_position="first last"]
		01
		
		Digital Marketing
		
		Class patent taciti sociosqu ad litro torquent per connubio nostra, per inceptos himenaeos. Curabitur a torto ut leo mattis cursus. Vestibule laoreet interdum pellentesque. Suspendisse vitae. [uplift_button colour="accent" type="bordered" size="standard" link="/portfolio/portfolio-two-column-gallery/" target="_self" icon="sf-icon-read-more" dropshadow="no" rounded="yes" extraclass=""]Case Studies[/uplift_button] [/spb_text_block] [spb_image image="14891" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="yes" overflow_mode="none" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 10%!important;padding-left: 10%!important;padding-right: 10%!important;padding-bottom: 10%!important;" border_styling_global="default" width="1/1" el_position="first last"]
		02
		
		Copywriting
		
		Class patent taciti sociosqu ad litro torquent per connubio nostra, per inceptos himenaeos. Curabitur a torto ut leo mattis cursus. Vestibule laoreet interdum pellentesque. Suspendisse vitae. [uplift_button colour="accent" type="bordered" size="standard" link="#" target="_self" icon="sf-icon-read-more" dropshadow="no" rounded="yes" extraclass=""]Case Studies[/uplift_button] [/spb_text_block] [spb_image image="14892" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="yes" overflow_mode="none" el_class="mt0 pt0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 10%!important;padding-left: 10%!important;padding-right: 10%!important;padding-bottom: 10%!important;" border_styling_global="default" width="1/1" el_position="first last"]
		03
		
		Accounting
		
		Class patent taciti sociosqu ad litro torquent per connubio nostra, per inceptos himenaeos. Curabitur a torto ut leo mattis cursus. Vestibule laoreet interdum pellentesque. Suspendisse vitae. [uplift_button colour="accent" type="bordered" size="standard" link="#" target="_self" icon="sf-icon-read-more" dropshadow="no" rounded="yes" extraclass=""]Case Studies[/uplift_button] [/spb_text_block] [/spb_row] [spb_section spb_section_id="15534" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["meet-the-team"] = array(
		"id" => "meet-the-team",
		"name" => "Main Demo - Meet the Team",
		"code" => '[spb_team display_type="standard-alt" carousel="no" item_columns="3" item_count="6" category="All" profile_link="yes" ajax_overlay="yes" pagination="no" fullwidth="no" gutters="yes" order_by="none" order="DESC" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["size-and-fit"] = array(
		"id" => "size-and-fit",
		"name" => "Main Demo - Size and Fit",
		"code" => '[spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/2" el_position="first last"]
		If you would like specific measurements for a product, please dont hesitate to ask us at help@uplift.com
		
		[/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="30px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [spb_text_block title="Menswear Size Guide" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/2" el_position="first"] [table type="standard_bordered"][trow][thcol][/thcol][thcol]Small[/thcol][thcol]Medium[/thcol][thcol]Large[/thcol][/trow][trow][tcol]Neck[/tcol][tcol]15"[/tcol][tcol]16"[/tcol][tcol]17"[/tcol][/trow][trow][tcol]Chest[/tcol][tcol]37"-38"[/tcol][tcol]39"-40"[/tcol][tcol]41"-42"[/tcol][/trow][trow][tcol]Waist[/tcol][tcol]30"[/tcol][tcol]32"[/tcol][tcol]34"[/tcol][/trow][/table] [/spb_text_block] [spb_text_block title="Womenswear Size Guide" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/2" el_position="last"] [table type="standard_bordered"][trow][thcol][/thcol][thcol]Small[/thcol][thcol]Medium[/thcol][thcol]Large[/thcol][/trow][trow][tcol]Bust[/tcol][tcol]15"[/tcol][tcol]16"[/tcol][tcol]17"[/tcol][/trow][trow][tcol]Waist[/tcol][tcol]37"-38"[/tcol][tcol]39"-40"[/tcol][tcol]41"-42"[/tcol][/trow][trow][tcol]Hips[/tcol][tcol]30"[/tcol][tcol]32"[/tcol][tcol]34"[/tcol][/trow][/table] [/spb_text_block] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_text_block title="Size Conversion Chart" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/1" el_position="first last"] [table type="standard_bordered"][trow][thcol][/thcol][thcol]XS[/thcol][thcol]S[/thcol][thcol]M[/thcol][thcol]L[/thcol][thcol]XL[/thcol][/trow][trow][tcol]Europe[/tcol][tcol]44[/tcol][tcol]46[/tcol][tcol]48[/tcol][tcol]50[/tcol][tcol]52[/tcol][/trow][trow][tcol]France[/tcol][tcol]44[/tcol][tcol]46[/tcol][tcol]48[/tcol][tcol]50[/tcol][tcol]52[/tcol][/trow][trow][tcol]Italy[/tcol][tcol]44[/tcol][tcol]46[/tcol][tcol]48[/tcol][tcol]50[/tcol][tcol]52[/tcol][/trow][trow][tcol]U.K.[/tcol][tcol]34[/tcol][tcol]36[/tcol][tcol]38[/tcol][tcol]40[/tcol][tcol]42[/tcol][/trow][trow][tcol]U.S.[/tcol][tcol]34[/tcol][tcol]36[/tcol][tcol]38[/tcol][tcol]40[/tcol][tcol]42[/tcol][/trow][/table] [/spb_text_block]');
		
		$prebuilt_templates["f-a-q-s"] = array(
		"id" => "f-a-q-s",
		"name" => "Main Demo - F.A.Q.'s",
		"code" => '[spb_faqs category="All" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["home-agency"] = array(
		"id" => "home-agency",
		"name" => "Main Demo - Home: Agency",
		"code" => '[spb_portfolio display_type="multi-size-masonry" multi_size_ratio="4/3" fullwidth="yes" gutters="yes" columns="2" show_title="yes" show_subtitle="yes" show_excerpt="no" hover_show_excerpt="no" excerpt_length="20" item_count="4" category="All" order_by="date" order="DESC" portfolio_filter="no" pagination="none" button_enabled="no" el_class="pb0 mb0" width="1/1" el_position="first last"] [spb_promo_bar display_type="promo-text" promo_bar_text="See more of our work" promo_bar_text_size="impact-text" btn_text="Button Text" btn_color="accent" btn_type="standard" href="/portfolio/portfolio-three-column-gallery/" target="_self" bg_color="#61aab0" text_color="#ffffff" page_align="no" fullwidth="yes" width="1/1" el_position="first last"] Enter your text here [/spb_promo_bar] [spb_row element_name="Services Row" wrap_type="full-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="2" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" width="1/3" el_position="first"] [spb_text_block animation="none" animation_delay="0" padding_vertical="4" padding_horizontal="0" simplified_controls="yes" custom_css="margin-top: px!important;margin-left: px!important;margin-right: px!important;margin-bottom: px!important;border-top: px default !important;border-left: px default !important;border-right: px default !important;border-bottom: px default !important;padding-top: 0px!important;padding-left: 0px!important;padding-right: 0px!important;padding-bottom: 0px!important;" border_styling_global="default" width="1/3"]
		What We Do
		
		Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam.
		
		More about our services
		
		[/spb_text_block] [spb_blank_spacer height="1px" width="1/3" el_position="last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box title="Digital Planning" box_type="animated-alt" box_icon_type="svg" svg_icon="health-outline_brain" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#ffffff" text_color="#ffffff" bg_color="#7eced5" flip_bg_color="#ffffff" flip_text_color="#7eced5" animated_box_style="coloured" animated_box_rounded="yes" width="1/4" el_position="first"] [list extraclass=""] [list_item icon="sf-icon-menu-chevron-right"]Ideation[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Brainstorming[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Breakouts[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Meetings[/list_item] [/list] [/spb_icon_box] [spb_icon_box title="Interaction Design" box_type="animated-alt" box_icon_type="svg" svg_icon="design-outline_webpage" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#ffffff" text_color="#ffffff" bg_color="#78909c" flip_bg_color="#ffffff" flip_text_color="#78909c" animated_box_style="coloured" animated_box_rounded="yes" width="1/4"] [list extraclass=""] [list_item icon="sf-icon-menu-chevron-right"]Palette Creation[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Colour Invention[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Colour Mixing[/list_item] [/list] [/spb_icon_box] [spb_icon_box title="Mobile Gaming" box_type="animated-alt" box_icon_type="svg" svg_icon="sport-outline_podium-trophy" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#ffffff" text_color="#ffffff" bg_color="#37474f" flip_bg_color="#ffffff" flip_text_color="#37474f" animated_box_style="coloured" animated_box_rounded="yes" width="1/4"] [list extraclass=""] [list_item icon="sf-icon-menu-chevron-right"]Gene Mapping[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Gene Regulation[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Gene Mutation[/list_item] [list_item icon="sf-icon-menu-chevron-right"]DNA Sequencing[/list_item] [/list] [/spb_icon_box] [spb_icon_box title="Social Marketing" box_type="animated-alt" box_icon_type="svg" svg_icon="envir-outline_save-planet" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#ffffff" text_color="#ffffff" bg_color="#0277bd" flip_bg_color="#ffffff" flip_text_color="#0277bd" animated_box_style="coloured" animated_box_rounded="yes" width="1/4" el_position="last"] [list extraclass=""] [list_item icon="sf-icon-menu-chevron-right"]HR Planning[/list_item] [list_item icon="sf-icon-menu-chevron-right"]HR Projects[/list_item] [list_item icon="sf-icon-menu-chevron-right"]HR Documentation[/list_item] [/list] [/spb_icon_box] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box title="Testing & Prototyping" box_type="animated-alt" box_icon_type="svg" svg_icon="design-outline_code-editor" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#ffffff" text_color="#ffffff" bg_color="#00acc1" flip_bg_color="#ffffff" flip_text_color="#00acc1" animated_box_style="coloured" animated_box_rounded="yes" width="1/4" el_position="first"] [list extraclass=""] [list_item icon="sf-icon-menu-chevron-right"]Testing[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Prototyping[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Planning[/list_item] [/list] [/spb_icon_box] [spb_icon_box title="Search Engine Marketing" box_type="animated-alt" box_icon_type="svg" svg_icon="business-outline_connect" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#ffffff" text_color="#ffffff" bg_color="#61aab0" flip_bg_color="#ffffff" flip_text_color="#61aab0" animated_box_style="coloured" animated_box_rounded="yes" width="1/4"] [list extraclass=""] [list_item icon="sf-icon-menu-chevron-right"]S.E.O. Optimising[/list_item] [list_item icon="sf-icon-menu-chevron-right"]S.E.M. Optimising[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Media Buying[/list_item] [/list] [/spb_icon_box] [spb_icon_box title="Email Marketing" box_type="animated-alt" box_icon_type="svg" svg_icon="holidays-outline_message" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#ffffff" text_color="#ffffff" bg_color="#5c6bc0" flip_bg_color="#ffffff" flip_text_color="#5c6bc0" animated_box_style="coloured" animated_box_rounded="yes" width="1/4"] [list extraclass=""] [list_item icon="sf-icon-menu-chevron-right"]Email Design[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Mailout Planning[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Visualisation[/list_item] [/list] [/spb_icon_box] [spb_icon_box title="User Research" box_type="animated-alt" box_icon_type="svg" svg_icon="ui-2_layers" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#ffffff" text_color="#ffffff" bg_color="#455a64" flip_bg_color="#ffffff" flip_text_color="#455a64" animated_box_style="coloured" animated_box_rounded="yes" width="1/4" el_position="last"] [list extraclass=""] [list_item icon="sf-icon-menu-chevron-right"]Research Planning[/list_item] [list_item icon="sf-icon-menu-chevron-right"]User Testing[/list_item] [list_item icon="sf-icon-menu-chevron-right"]Documentation[/list_item] [/list] [/spb_icon_box] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [/spb_row] [spb_swift_slider fullscreen="false" maxheight="600" slidecount="3" category="blog" transition="slide" loop="true" nav="true" pagination="true" continue="false" fullwidth="yes" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["home-start-up"] = array(
		"id" => "home-start-up",
		"name" => "Main Demo - Home: Start-up",
		"code" => '[spb_row element_name="Intro Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" bg_image="14320" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_mp4="http://swiftideasvideos.s3.amazonaws.com/agency_work.mp4" bg_video_webm="http://swiftideasvideos.s3.amazonaws.com/agency_work.webmhd.webm" bg_video_loop="yes" parallax_video_height="content-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="90" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="Intro" row_name="Intro" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="140px" responsive_vis="hidden-xs_hidden-sm" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 2%!important;padding-left: 20%!important;padding-right: 20%!important;padding-bottom: 2%!important;" border_styling_global="default" width="1/1" el_position="first last"]
		Do more, faster and with less effort... welcome to uplift
		
		[uplift_button colour="accent" type="standard" size="standard" link="/home/" target="_self" icon="nucleo-icon-eye" dropshadow="no" rounded="no" extraclass=""]Live Preview[/uplift_button] [uplift_button colour="accent" type="bordered" size="standard" link="/home/" target="_self" icon="sf-icon-reply" dropshadow="no" rounded="no" extraclass=""]Create account[/uplift_button]
		
		[/spb_text_block] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_image image="15726" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="3 Icon Boxes Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="window-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="features" row_name="Features" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="40px" width="1/1" el_position="first last"] [spb_icon_box title="Amazing Features" box_type="standard-center" box_icon_type="svg" svg_icon="education-outline_pencil-47" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#7eced5" text_color="#333333" animated_box_style="coloured" animated_box_rounded="yes" width="1/3" el_position="first"] Vestibule convallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque purus. [/spb_icon_box] [spb_icon_box title="Stunning Design" box_type="standard-center" box_icon_type="svg" svg_icon="ui-1_settings-gear-65" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#78909c" text_color="#333333" animated_box_style="coloured" animated_box_rounded="yes" width="1/3"] Vestibule convallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque purus. [/spb_icon_box] [spb_icon_box title="Performance in its DNA" box_type="standard-center" box_icon_type="svg" svg_icon="health-outline_dna-27" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#546e7a" text_color="#333333" animated_box_style="coloured" animated_box_rounded="yes" width="1/3" el_position="last"] Vestibule convallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque purus. [/spb_icon_box] [spb_blank_spacer height="40px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="full-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_gallery gallery_id="15080" display_type="slider" columns="5" fullwidth="no" gutters="yes" image_size="full" slider_transition="slide" show_thumbs="no" autoplay="no" show_captions="no" enable_lightbox="no" el_class="pb0 mb0 pt0 mt0" width="1/2" el_position="first"] [spb_image image="15251" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" link_target="_self" lightbox="yes" intro_animation="none" animation_delay="200" width="1/2" el_position="last"] [/spb_row] [spb_row element_name="3 ways Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="interaction" row_name="Interaction" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_icon_box_grid columns="3" colour_style="dark" width="3/4" el_position="first"] [spb_icon_box_grid_element title="Pinch Touch" target="" link="#" icon="svg-icon-picker-item svg-icon-picker-item gestures-color_pinch"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Swipe Touch" target="" link="#" icon="svg-icon-picker-item svg-icon-picker-item gestures-color_scroll-horitontal"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Drag Touch" target="" link="#" icon="svg-icon-picker-item svg-icon-picker-item gestures-color_scroll-vertical"][/spb_icon_box_grid_element] [/spb_icon_box_grid] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 4%!important;padding-right: 4%!important;padding-bottom: 0%!important;" border_styling_global="default" width="1/4" el_position="last"]
		3 types of interaction.
		
		Lorem ipsum dolor sit met, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet. [uplift_button colour="accent" type="bordered" size="standard" link="/pages/about-us-classic/" target="_self" icon="" dropshadow="no" rounded="no" extraclass=""]Find out more[/uplift_button] [/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="60px" bottom_margin="0px" fullwidth="yes" width="1/1" el_position="first last"] [/spb_row] [spb_section element_name="Fun Facts Counters" spb_section_id="15667" width="1/1" el_position="first last"] [spb_row element_name="Examples Portfolio" wrap_type="full-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="examples" row_name="Examples" minimize_row="no" width="1/1" el_position="first last"] [spb_portfolio display_type="multi-size-masonry" multi_size_ratio="4/3" fullwidth="yes" gutters="no" columns="5" show_title="yes" show_subtitle="yes" show_excerpt="yes" hover_show_excerpt="no" excerpt_length="20" item_count="4" category="All" order_by="date" order="DESC" portfolio_filter="no" pagination="none" button_enabled="yes" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="FAQs Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#455a64" color_row_height="content-height" row_style="light" bg_image="14055" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="90" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="faqs" row_name="F.A.Q.s" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" border_styling_global="default" width="1/1" el_position="first last"]
		Frequently Asked Questions
		
		[/spb_text_block] [spb_icon_box title="How do I flag an issue?" box_type="standard-left" box_icon_type="svg" svg_icon="location-outline_flag-complex" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#78909c" text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/4" el_position="first"] Vestibule ante ipsum primis in fauci i bus luctus et ultrice posuere cubilia Curae; Inte ger in enim dui. [/spb_icon_box] [spb_icon_box title="Wheres my free shirt?" box_type="standard-left" box_icon_type="svg" svg_icon="business-outline_businessman-04" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#78909c" text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/4"] Vestibule ante ipsum primis in fauci i bus luctus et ultrice posuere cubilia Curae; Inte ger in enim dui. [/spb_icon_box] [spb_icon_box title="Where do I sign up?" box_type="standard-left" box_icon_type="svg" svg_icon="business-outline_sign" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#78909c" text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/4"] Vestibule ante ipsum primis in fauci i bus luctus et ultrice posuere cubilia Curae; Inte ger in enim dui. [/spb_icon_box] [spb_icon_box title="Can I Subscribe?" box_type="standard-left" box_icon_type="svg" svg_icon="ui-1_email-85" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#78909c" text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/4" el_position="last"] Vestibule ante ipsum primis in fauci i bus luctus et ultrice posuere cubilia Curae; Inte ger in enim dui. [/spb_icon_box] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box title="Can I upgrade later?" box_type="standard-left" box_icon_type="svg" svg_icon="arrows-1_loop-82" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#78909c" text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/4" el_position="first"] Vestibule ante ipsum primis in fauci i bus luctus et ultrice posuere cubilia Curae; Inte ger in enim dui. [/spb_icon_box] [spb_icon_box title="Is the agreement binding?" box_type="standard-left" box_icon_type="svg" svg_icon="education-outline_paper" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#78909c" text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/4"] Vestibule ante ipsum primis in fauci i bus luctus et ultrice posuere cubilia Curae; Inte ger in enim dui. [/spb_icon_box] [spb_icon_box title="How long does it last?" box_type="standard-left" box_icon_type="svg" svg_icon="health-outline_sleep" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#78909c" text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/4"] Vestibule ante ipsum primis in fauci i bus luctus et ultrice posuere cubilia Curae; Inte ger in enim dui. [/spb_icon_box] [spb_icon_box title="How can I get refunded?" box_type="standard-left" box_icon_type="svg" svg_icon="shopping-outline_credit-locked" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#78909c" text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/4" el_position="last"] Vestibule ante ipsum primis in fauci i bus luctus et ultrice posuere cubilia Curae; Inte ger in enim dui. [/spb_icon_box] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Testimonials Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="reviews" row_name="Reviews" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" border_styling_global="default" width="1/1" el_position="first last"]
		What Customers Say
		
		[/spb_text_block] [spb_section element_name="Testimonials Grid" spb_section_id="15613" width="1/1" el_position="first last"] [spb_divider type="thin" heading_text="As used by these great people" text="Go to top" top_margin="30px" bottom_margin="90px" fullwidth="no" width="1/1" el_position="first last"] [spb_clients title="Companies using uplift" item_count="8" item_columns="4" category="All" carousel="no" pagination="no" el_class="pt0 mt0" width="2/3" el_position="first"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" width="1/3" el_position="last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" border_styling_global="default" width="1/1" el_position="first last"]
		Usage by industry
		
		[/spb_text_block] [spb_progress_bar percentage="100" text="Healthcare" value="30k+ Users" colour="#7eced5" width="1/1" el_position="first last"] [spb_progress_bar percentage="80" text="Publishing" value="18k+ Users" colour="#61aab0" width="1/1" el_position="first last"] [spb_progress_bar percentage="70" text="Catering" value="14k+ Users" colour="#546e7a" width="1/1" el_position="first last"] [spb_progress_bar percentage="90" text="Design" value="23k+ Users" colour="#90a4ae" width="1/1" el_position="first last"] [/spb_column] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Team Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#d1eff2" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="team" row_name="Our Team" minimize_row="yes" width="1/1" el_position="first last"] [spb_blank_spacer height="80px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" border_styling_global="default" width="1/1" el_position="first last"]
		Our team is here to help
		
		[/spb_text_block] [spb_blank_spacer height="40px" width="1/1" el_position="first last"] [spb_team display_type="gallery" carousel="no" item_columns="5" item_count="5" category="All" profile_link="no" ajax_overlay="yes" pagination="no" fullwidth="yes" gutters="no" order_by="none" order="DESC" el_class="pb0 mb0" width="1/1" el_position="first last"] [/spb_row] [spb_section element_name="Sign Up!" spb_section_id="15637" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["home-apptastic"] = array(
		"id" => "home-apptastic",
		"name" => "Main Demo - Home: Apptastic",
		"code" => '[spb_row element_name="Intro: Desktop" wrap_type="content-width" row_bg_type="image" row_bg_color="#61aab0" color_row_height="content-height" bg_image="14894" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="90" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_responsive_vis="hidden-xs_hidden-sm" row_el_class="no-shadow" minimize_row="no" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="160px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 25%!important;padding-left: 0%!important;padding-right: 20%!important;padding-bottom: 0%!important;" border_styling_global="default" width="1/2" el_position="first"]
		This is the uplift app, it will transform your life for the better.
		
		app-badge-appleapp-badge-google [/spb_text_block] [spb_image image="15681" image_size="full" image_width="550" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="mb0 pb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/2" el_position="last"] [/spb_row] [spb_row element_name="Intro: Tablet/Mobile" wrap_type="content-width" row_bg_type="image" row_bg_color="#61aab0" color_row_height="content-height" bg_image="14894" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="90" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_responsive_vis="hidden-lg_hidden-md" row_el_class="no-shadow" minimize_row="no" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 10%!important;padding-left: 5%!important;padding-right: 0%!important;padding-bottom: 0%!important;" border_styling_global="default" width="1/1" el_position="first last"]
		This is the uplift app, it will transform your life for the better.
		
		app-badge-apple  app-badge-google [/spb_text_block] [spb_image image="15681" image_size="full" image_width="550" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="mb0 pb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="window-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_icon_box title="Amazing Features" box_type="standard-center" box_icon_type="svg" svg_icon="location-color_treasure-map-40" animate_svg="no" target="_self" animation="none" animation_delay="0" animated_box_style="coloured" animated_box_rounded="yes" width="1/4" el_position="first"] Vestibule corv allis pulv inar tellus eget ultr icies. Sed sollici tudin, sem vitae elemen tum. [/spb_icon_box] [spb_icon_box title="Stunning Design" box_type="standard-center" box_icon_type="svg" svg_icon="objects-color_diamond" animate_svg="no" target="_self" animation="none" animation_delay="0" text_color="76b5b5" animated_box_style="coloured" animated_box_rounded="yes" width="1/4"] Vestibule corv allis pulv inar tellus eget ultr icies. Sed sollici tudin, sem vitae elemen tum. [/spb_icon_box] [spb_icon_box title="Unlimited Users" box_type="standard-center" box_icon_type="svg" svg_icon="users-color_badge-13" animate_svg="no" target="_self" animation="none" animation_delay="0" text_color="76b5b5" animated_box_style="coloured" animated_box_rounded="yes" width="1/4"] Vestibule corv allis pulv inar tellus eget ultr icies. Sed sollici tudin, sem vitae elemen tum. [/spb_icon_box] [spb_icon_box title="Wireless Syncing" box_type="standard-center" box_icon_type="svg" svg_icon="media-color-2_radio" animate_svg="no" target="_self" animation="none" animation_delay="0" text_color="76b5b5" animated_box_style="coloured" animated_box_rounded="yes" width="1/4" el_position="last"] Vestibule corv allis pulv inar tellus eget ultr icies. Sed sollici tudin, sem vitae elemen tum. [/spb_icon_box] [spb_divider type="thin" text="Go to top" top_margin="60px" bottom_margin="0px" fullwidth="yes" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" bg_image="14894" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="100px" width="1/1" el_position="first last"] [spb_image image="15679" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="mb0 pb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="400" width="1/2" el_position="first"] [spb_column col_animation="none" col_animation_delay="400" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="8" width="1/2" el_position="last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" border_styling_global="default" width="1/1" el_position="first last"]
		Amazing features
		
		Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque purus. [/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="10px" bottom_margin="10px" fullwidth="no" width="1/1" el_position="first last"] [spb_icon_box title="Touch control" box_type="standard-left" box_icon_type="svg" svg_icon="media-color-1_shake" animate_svg="no" target="_self" animation="none" animation_delay="0" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="first"] Lorem ipsum dolor sit amet, consectetur adipiscing elit. [/spb_icon_box] [spb_icon_box title="iWatch Support" box_type="standard-left" box_icon_type="svg" svg_icon="tech-color_watch" animate_svg="no" target="_self" animation="none" animation_delay="0" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="last"] Lorem ipsum dolor sit amet, consectetur adipiscing elit. [/spb_icon_box] [/spb_column] [spb_blank_spacer height="100px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_image="14894" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="0px" bottom_margin="60px" fullwidth="yes" width="1/1" el_position="first last"] [spb_column col_animation="none" col_animation_delay="400" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="4" width="1/2" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" border_styling_global="default" width="1/1" el_position="first last"]
		Stunning design
		
		Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed. Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Vivamus pellentesque orci sit met odio dictum eget kommod nulla consequent. Prooien iaculis trirtique nis ut eleifend. Mecenas locus purus, malesuada eu scelerisque ac. [/spb_text_block] [spb_blank_spacer height="20px" width="1/1" el_position="first last"] [spb_button button_text="See the iWatch demo" button_size="standard" button_colour="black" button_type="standard" rounded="yes" button_dropshadow="no" button_icon="nucleo-icon-watch" button_link="/portfolio/portfolio-multi-size-masonry-full-width/" button_target="_self" align="left" animation="none" animation_delay="0" width="1/1" el_position="first last"] [/spb_column] [spb_image image="15683" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="mb0 pb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="400" width="1/2" el_position="last"] [spb_blank_spacer height="70px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#222222" color_row_height="content-height" row_style="light" bg_image="14894" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="140px" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" width="1/4" el_position="first"] [spb_text_block element_name="stunning design" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" border_styling_global="default" width="1/2"]
		Stunning Design
		
		Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in sceleri.
		
		[/spb_text_block] [spb_blank_spacer height="1px" width="1/4" el_position="last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" width="1/4" el_position="first"] [spb_icon_box title="Pixel Perfect" box_type="standard-center" box_icon_type="svg" svg_icon="design-outline_vector" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#ffffff" text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/1" el_position="first last"] Lorem ipsum dolor sit amet, consectetur adipiscing elit. [/spb_icon_box] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box title="Packs A Punch" box_type="standard-center" box_icon_type="svg" svg_icon="emoticons-outline_fist" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#ffffff" text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/1" el_position="first last"] Lorem ipsum dolor sit amet, consectetur adipiscing elit. [/spb_icon_box] [/spb_column] [spb_image image="15685" image_size="full" image_width="550" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="mb0 pb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/2"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" width="1/4" el_position="last"] [spb_icon_box title="Attention To Detail" box_type="standard-center" box_icon_type="svg" svg_icon="ui-1_zoom-split" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#ffffff" text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/1" el_position="first last"] Lorem ipsum dolor sit amet, consectetur adipiscing elit. [/spb_icon_box] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box title="Unlimited Colours" box_type="standard-center" box_icon_type="svg" svg_icon="design-outline_palette" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#ffffff" text_color="#ffffff" animated_box_style="coloured" animated_box_rounded="yes" width="1/1" el_position="first last"] Lorem ipsum dolor sit amet, consectetur adipiscing elit. [/spb_icon_box] [/spb_column] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_button button_text="What people are saying" button_size="standard" button_colour="white" button_type="standard" rounded="yes" button_dropshadow="no" button_icon="sf-icon-quote" button_link="/pages/about-us/" button_target="_self" align="center" animation="none" animation_delay="0" width="1/1" el_position="first last"] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Download App Row" wrap_type="content-width" row_bg_type="video" row_bg_color="#252525" color_row_height="content-height" bg_image="14320" bg_type="cover" parallax_image_height="window-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_mp4="http://swiftideasvideos.s3.amazonaws.com/agency_work.mp4" bg_video_webm="http://swiftideasvideos.s3.amazonaws.com/agency_work.webmhd.webm" bg_video_loop="yes" parallax_video_height="content-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="90" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" simplified_controls="yes" custom_css="margin-top: px!important;margin-left: px!important;margin-right: px!important;margin-bottom: px!important;border-top: px default !important;border-left: px default !important;border-right: px default !important;border-bottom: px default !important;padding-top: 0px!important;padding-left: 0px!important;padding-right: 0px!important;padding-bottom: 0px!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" responsive_vis="hidden-xs_hidden-sm" width="1/4" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" custom_css="margin-top: px!important;margin-left: px!important;margin-right: px!important;margin-bottom: px!important;border-top: px default !important;border-left: px default !important;border-right: px default !important;border-bottom: px default !important;padding-top: 120px!important;padding-left: 50px!important;padding-right: 50px!important;padding-bottom: 120px!important;" border_styling_global="default" width="1/2" el_position="last"]
		Download the uplift app, it will transform your life for the better
		
		app-badge-apple    app-badge-google
		[/spb_text_block] [/spb_row] [spb_row element_name="Pricing Plans" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="window-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="0px" bottom_margin="91px" fullwidth="yes" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" width="1/4" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" border_styling_global="default" width="1/2"]
		Choose a plan
		
		Vestibule convallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque purus.
		
		[/spb_text_block] [spb_blank_spacer height="1px" width="1/4" el_position="last"] [spb_pricing_table columns="3" width="1/1" el_position="first last"] [spb_pricing_column name="Free" highlight_column="no" price="$0" period="/mo" btn_text="Sign up" href="http://uplift.swiftideas.com/purchase" target="_self" el_class="" ][spb_pricing_column_feature feature_name="1 User License" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="1 Email Account" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="Feature Name" el_class=""] [/spb_pricing_column_feature][/spb_pricing_column][spb_pricing_column name="STARTER" highlight_column="yes" price="$99" period="/mo" btn_text="Purchase Plan" href="http://uplift.swiftideas.com/purchase" target="_self" el_class="" ][spb_pricing_column_feature feature_name="1 User License" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="3 Email Accounts" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="5 Domain Names" el_class=""] [/spb_pricing_column_feature][/spb_pricing_column][spb_pricing_column name="Pro" highlight_column="no" price="$199" period="/mo" btn_text="Purchase Plan" href="http://uplift.swiftideas.com/purchase" target="_self" el_class="" ][spb_pricing_column_feature feature_name="5 User Licenses" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="10 Email Accounts" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="10 Domain Names" el_class=""] [/spb_pricing_column_feature][/spb_pricing_column] [/spb_pricing_table] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" row_style="dark" bg_image="15621" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="60" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="0px" bottom_margin="60px" fullwidth="yes" width="1/1" el_position="first last"] [spb_animated_headline before_text="Customers say uplift is" animated_strings="quick,simple,stunning" animation_type="letters_rotate-2" textstyle="impact-text" textalign="center" textcolor="#333333" width="1/1" el_position="first last"] [spb_blank_spacer height="45px" width="1/1" el_position="first last"] [spb_section spb_section_id="15611" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [/spb_row] [spb_section spb_section_id="15534" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["home-shop"] = array(
		"id" => "home-shop",
		"name" => "Main Demo - Home: Shop",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_image_banner image="15603" image_size="full" content_pos="left" content_textalign="left" animation="none" animation_delay="200" image_link="/shop/?sidebar=left-sidebar" link_target="_self" width="1/3" el_position="first"]
		S/S 16 Lookbook
		
		[/spb_image_banner] [spb_image_banner image="15600" image_size="full" content_pos="center" content_textalign="left" animation="none" animation_delay="200" image_link="/product-category/sunglasses/" link_target="_self" width="1/3"]
		Sunglasses Giveaway
		
		[/spb_image_banner] [spb_image_banner image="15601" image_size="full" content_pos="center" content_textalign="left" animation="none" animation_delay="200" image_link="/pages/about-us/" link_target="_self" width="1/3" el_position="last"]
		Find Out About Us
		
		[/spb_image_banner] [spb_divider type="thin" text="Go to top" top_margin="30px" bottom_margin="49px" fullwidth="no" width="1/1" el_position="first last"] [/spb_row] [spb_products title="Featured Products" asset_type="latest-products" category="0" display_type="standard" multi_masonry="yes" carousel="no" fullwidth="no" columns="4" item_count="4" order="DESC" button_enabled="yes" width="1/1" el_position="first last"] [spb_blank_spacer height="20px" width="1/1" el_position="first last"] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="image" row_bg_color="#222222" color_row_height="content-height" bg_image="15597" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="80" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_icon_box_grid columns="3" colour_style="light" width="1/1" el_position="first last"] [spb_icon_box_grid_element title="Fast & Free International Delivery" target="" link="/pages/about-us-classic/" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg shopping-outline_delivery-time"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Secure Checkout And Transactions" target="" link="/pages/about-us-classic/" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg shopping-outline_credit-locked"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Free One-Day No Quibble Returns" target="" link="/pages/about-us-classic/" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg ui-1_send"][/spb_icon_box_grid_element] [/spb_icon_box_grid] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [/spb_row] [spb_supersearch fullwidth="yes" width="1/1" el_position="first last"] [spb_blank_spacer height="50px" width="1/1" el_position="first last"] [spb_products title="Latest Arrivals" asset_type="selected-products" category="0" products="15128,15143,15111, 15115" display_type="standard" multi_masonry="no" carousel="yes" fullwidth="no" columns="3" item_count="4" order="ASC" button_enabled="no" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="10px" bottom_margin="49px" fullwidth="no" width="1/1" el_position="first last"] [spb_recent_posts title="Recent Articles" display_type="standard-row" carousel="no" item_columns="2" item_count="2" category="All" offset="0" posts_order="DESC" excerpt_length="14" fullwidth="no" gutters="yes" button_enabled="no" pagination="yes" width="1/2" el_position="first"] [spb_products_mini title="Top Rated Items" asset_type="top-rated" item_count="4" width="1/4"] [spb_products_mini title="Best Selling Items" asset_type="best-sellers" item_count="4" width="1/4" el_position="last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" row_style="dark" bg_image="15621" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="60" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="0px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [spb_animated_headline before_text="Our customers say were" animated_strings="quick,easy,safe" animation_type="letters_rotate-2" textstyle="impact-text" textalign="center" textcolor="#7eced5" width="1/1" el_position="first last"] [spb_blank_spacer height="45px" width="1/1" el_position="first last"] [spb_section spb_section_id="15611" width="1/1" el_position="first last"] [spb_blank_spacer height="45px" width="1/1" el_position="first last"] [spb_button button_text="More testimonials" button_size="standard" button_colour="accent" button_type="bordered" rounded="yes" button_dropshadow="no" button_icon="sf-icon-read-more" button_link="/pages/about-us-classic/" button_target="_self" align="center" animation="none" animation_delay="0" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [/spb_row]');
		
		$prebuilt_templates["home-magazine"] = array(
		"id" => "home-magazine",
		"name" => "Main Demo - Home: Magazine",
		"code" => '[spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" width="2/3" el_position="first"] [spb_swift_slider fullscreen="false" maxheight="504" slidecount="3" category="blog" transition="slide" loop="true" nav="true" pagination="true" continue="false" fullwidth="no" width="1/1" el_position="first last"] [spb_blank_spacer element_name="30px Spacer" height="30px" width="1/1" el_position="first last"] [spb_blog blog_type="masonry" gutters="yes" columns="2" fullwidth="no" item_count="8" category="All" offset="0" order_by="date" order="DESC" show_title="yes" show_excerpt="yes" show_details="yes" excerpt_length="19" content_output="excerpt" show_read_more="yes" social_integration="no" blog_filter="no" pagination="infinite-scroll" width="1/1" el_position="first last"] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" width="1/3" el_position="last"] [spb_recent_posts display_type="list" carousel="no" item_columns="1" item_count="4" category="All" offset="0" posts_order="DESC" excerpt_length="6" fullwidth="no" gutters="yes" button_enabled="no" pagination="yes" el_class="mb0 pb0" width="1/1" el_position="first last"] [spb_divider type="thin" heading_text="Follow Us" text="Go to top" top_margin="0px" bottom_margin="30px" fullwidth="no" width="1/1" el_position="first last"] [spb_image image="15584" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="no" fullwidth="no" overflow_mode="none" image_link="http://uplift.swiftideas.com/purchase" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" el_class="mb0 pb0" simplified_controls="yes" custom_css_percentage="yes" border_styling_global="default" width="1/1" el_position="first last"]
		[social size="large"]
		[/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="0px" bottom_margin="30px" fullwidth="no" width="1/1" el_position="first last"] [spb_widget_area sidebar_id="sidebar-6" width="1/1" el_position="first last"] [/spb_column]');
		
		$prebuilt_templates["home-bold-move"] = array(
		"id" => "home-bold-move",
		"name" => "Main Demo - Home: Bold Move",
		"code" => '[spb_blank_spacer height="120px" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" width="1/6" el_position="first"] [spb_animated_headline before_text="Were an award-winning company creating solutions for" animated_strings="charities,agencies,churches" animation_type="slide" textstyle="impact-text" textalign="center" textcolor="#7eced5" width="2/3" el_position="last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_button button_text="More about us" button_size="standard" button_colour="accent" button_type="bordered" rounded="no" button_dropshadow="no" button_icon="nucleo-icon-users-circle" button_link="/pages/about-us-classic/" button_target="_self" align="center" animation="none" animation_delay="0" width="1/1" el_position="first last"] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [spb_portfolio display_type="gallery" multi_size_ratio="1/1" fullwidth="no" gutters="yes" columns="3" show_title="yes" show_subtitle="yes" show_excerpt="no" hover_show_excerpt="no" excerpt_length="20" item_count="6" category="All" order_by="date" order="DESC" portfolio_filter="no" pagination="none" button_enabled="no" el_class="pb0 mb0" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_button button_text="See more work" button_size="standard" button_colour="accent" button_type="standard" rounded="no" button_dropshadow="no" button_icon="nucleo-icon-eye" button_link="/portfolio/portfolio-multi-size-masonry-alt/" button_target="_self" align="center" animation="none" animation_delay="0" width="1/1" el_position="first last"] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="10" simplified_controls="yes" border_styling_global="default" width="1/1" el_position="first last"]
		Our Capabilities
		
		[hr]
		
		[/spb_text_block] [spb_section element_name="icon grid" spb_section_id="15256" width="1/1" el_position="first last"] [spb_blank_spacer height="140px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="10" simplified_controls="yes" custom_css="margin-top: px!important;margin-left: px!important;margin-right: px!important;margin-bottom: px!important;border-top: px default !important;border-left: px default !important;border-right: px default !important;border-bottom: px default !important;padding-top: 0px!important;padding-left: 0px!important;padding-right: 0px!important;padding-bottom: 0px!important;" border_styling_global="default" width="1/1" el_position="first last"]
		Our Articles
		
		[hr]
		
		[/spb_text_block] [spb_recent_posts display_type="standard" carousel="no" item_columns="3" item_count="3" category="All" offset="0" posts_order="DESC" excerpt_length="23" fullwidth="no" gutters="yes" button_enabled="no" pagination="yes" width="1/1" el_position="first last"] [spb_blank_spacer height="35px" width="1/1" el_position="first last"] [spb_button button_text="More articles" button_size="standard" button_colour="accent" button_type="standard" rounded="no" button_dropshadow="no" button_icon="sf-icon-text" button_link="/blog/blog-timeline-full-width/" button_target="_self" align="center" animation="none" animation_delay="0" width="1/1" el_position="first last"] [spb_blank_spacer height="110px" width="1/1" el_position="first last"] [spb_section spb_section_id="15534" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["home-classic"] = array(
		"id" => "home-classic",
		"name" => "Main Demo - Home: Classic",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="fff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_section spb_section_id="15469" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" row_style="dark" bg_image="15201" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_mp4="http://swiftideasvideos.s3.amazonaws.com/ronin.mp4" bg_video_webm="http://swiftideasvideos.s3.amazonaws.com/ronin.webm" bg_video_loop="yes" parallax_video_height="content-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="80" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="0px" bottom_margin="60px" fullwidth="yes" width="1/1" el_position="first last"] [spb_section spb_section_id="15471" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="60px" bottom_margin="0px" fullwidth="yes" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" row_style="dark" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_section element_name="Counters x4" spb_section_id="15667" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="0px" bottom_margin="90px" fullwidth="no" width="1/1" el_position="first last"] [spb_tabs tabs_type="standard" center_tabs="no" width="1/3" el_position="first"] [spb_tab title="ABOUT US" icon="nucleo-icon-eye" id="ABOUTUS"] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/1" el_position="first last"] Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam viverra euismod odio, gravida pellentesque urna varius vitae. Sed dui lorem, adipiscing in adipiscing et, interdum nec metus. Mauris ultricies, justo eu convallis placerat, felis enim ornare nisi, vitae mattis nulla ante id dui.
		Learn more
		
		[/spb_text_block] [/spb_tab] [spb_tab title="HOW WE WORK" icon="nucleo-icon-laptop" id="HOWWEWORK"] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/1" el_position="first last"] Mauris ultricies, justo eu convallis placerat, felis enim ornare nisi, vitae mattis nulla ante id dui. Ut lectus purus, commodo et tincidunt vel, interdum sed lectus. Vestibulum adipiscing tempor nisi id elementu sadips ipsums dolores uns fugiats gravida nam elit vols nulla dolores amet. [/spb_text_block] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [/spb_tab] [/spb_tabs] [spb_accordion active_section="0" width="1/3"] [spb_accordion_tab title="OUR PROCESS" accordion_id="our-process" icon="nucleo-icon-brush"] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/1" el_position="first last"] Etiam venenatis tristique sapien eu fringilla. Ut tincidunt egestas rhoncus. Praesent elementum tempus vehicula. Quisque sed dui sed dui pellentesque dapibus ac sed ipsum. Nullam fringilla dignissim sem, quis sagittis elit condimentum sed. [/spb_text_block] [/spb_accordion_tab] [spb_accordion_tab title="OUR SERVICES" accordion_id="our-services" icon="nucleo-icon-laptop"] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/1" el_position="first last"] Nulla fringilla adipiscing libero id bibendum. Nam porttitor bibendum leo non scelerisque. Sed fringilla consectetur massa, ut pretium ipsum laoreet ac. Fusce eu erat vitae massa pharetra tempor. Nulla hendrerit diam non quam imperdiet ut interdum dui scelerisque. Praesent eu libero sit amet ligula luctus congue id quis diam. Aliquam sodales ligula non mi sodales hendrerit. Mauris vitae erat ut magna rutrum malesuada sed vitae ante. Donec ornare, erat sit amet faucibus placerat, quam magna auctor ipsum, sed euismod ligula lacus ac magna. Maecenas imperdiet risus vitae massa cursus sit amet bibendum nibh adipiscing. Etiam at lacus eget nunc convallis vestibulum iaculis vitae metus. [/spb_text_block] [/spb_accordion_tab] [spb_accordion_tab title="CASE STUDIES" accordion_id="case-studies" icon="nucleo-icon-piechart"] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/1" el_position="first last"] Pellentesque tellus lacus, pharetra dignissim laoreet in, fringilla nec nisl. Mauris venenatis sapien et arcu consequat venenatis. Phasellus non enim sapien. Aliquam elementum ornare felis, ut tempus magna sagittis eu. Quisque magna odio, suscipit sed eleifend sit amet, pellentesque suscipit enim. Phasellus enim turpis, pharetra nec laoreet id, pellentesque nec metus. Maecenas vestibulum orci et elit adipiscing vitae lacinia arcu malesuada. Donec in augue in massa ullamcorper mattis. Aliquam fringilla placerat neque, non gravida diam sagittis ut. Mauris malesuada urna eget nisi adipiscing mattis. Nunc eleifend tristique interdum. [/spb_text_block] [/spb_accordion_tab] [/spb_accordion] [spb_testimonial_carousel title="What people are saying" item_count="6" order="date" category="All" page_link="no" showcase="no" width="1/3" el_position="last"] [spb_blank_spacer height="59px" width="1/1" el_position="first last"] [/spb_row] [spb_section element_name="Animated Promo Bar" spb_section_id="15664" width="1/1" el_position="first last"] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" row_style="dark" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [spb_recent_posts title="News & Thoughts" display_type="standard" carousel="yes" item_columns="3" item_count="4" category="All" offset="0" posts_order="DESC" excerpt_length="24" fullwidth="no" gutters="yes" button_enabled="no" pagination="yes" width="1/1" el_position="first last"] [spb_blank_spacer height="59px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" row_style="dark" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="0px" bottom_margin="90px" fullwidth="yes" width="1/1" el_position="first last"] [spb_text_block title="One vision, one goal" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="4" width="1/3" el_position="first"] Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam viverra euismod odio, gravida pellentesque urna varius vitae. Sed dui lorem, adipiscing in patent taciti sociosqu ad litro torquent per connubio nostra, per inceptos vestibule laoreet interdum pellentesque. Adipiscing et, interdum nec metus. Mauris ultricies, justo eu convallis placerat, felis enim ornare nisi, vitae mattis nulla ante id dui.
		More about the team
		
		[/spb_text_block] [spb_team title="Meet our team" display_type="standard-alt" carousel="yes" item_columns="3" item_count="4" category="All" profile_link="no" ajax_overlay="yes" pagination="no" fullwidth="no" gutters="yes" order_by="none" order="ASC" width="2/3" el_position="last"] [spb_divider type="thin" text="Go to top" top_margin="60px" bottom_margin="0px" fullwidth="yes" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="full-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_section spb_section_id="15399" width="1/1" el_position="first last"] [/spb_row] [spb_section element_name="Animated Promo Bar" spb_section_id="15472" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["about-me"] = array(
		"id" => "about-me",
		"name" => "Main Demo - About Me",
		"code" => '[spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_text_block title="Hello, my name is John" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/2" el_position="first"]
		Lorem ipsum dolor sit amet isse potenti. Vesquam ante aliquet lacusemper elit. Cras neque nulla, convallis non commodo et, euismod nonsese. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum.
		
		Vesquam ante aliquet lacusemper elit. Cras neque nulla, convallis non commodo et, euismod nonsese. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditi praesentium.
		
		[/spb_text_block] [spb_text_block title="My Skills" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="4" width="1/2" el_position="last"] [progress_bar percentage="100" name="Illustrator" value="100" type="" colour="#00acc1"] [progress_bar percentage="80" name="Photoshop" value="80" type="" colour="#0097a7"] [progress_bar percentage="70" name="After Effects" value="70" type="" colour="#00838f"] [progress_bar percentage="100" name="Aperture" value="100" type="" colour="#00897b"] [progress_bar percentage="100" name="InDesign" value="100" type="" colour="#546e7a"] [/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="30px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [spb_accordion widget_title="My Experience" width="1/2" el_position="first"] [spb_accordion_tab title="CREATIVE DIRECTOR" accordion_id="creative-director" icon=""] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/1" el_position="first last"] Vesquam ante aliquet lacusemper elit. Cras neque nulla, convallis non commodo et, euismod nonsese. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum. [/spb_text_block] [/spb_accordion_tab] [spb_accordion_tab title="ART DIRECTOR" accordion_id="art-director" icon=""] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/1" el_position="first last"] Lorem ipsum dolor sit amet isse potenti. Vesquam ante aliquet lacusemper elit. Cras neque nulla, convallis non commodo et, euismod nonsese. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum. [/spb_text_block] [/spb_accordion_tab] [spb_accordion_tab title="LEAD DESIGNER" accordion_id="designer" icon=""] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/1" el_position="first last"] Lorem ipsum dolor sit amet isse potenti. Vesquam ante aliquet lacusemper elit. Cras neque nulla, convallis non commodo et, euismod nonsese. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum. [/spb_text_block] [/spb_accordion_tab] [spb_accordion_tab title="DESIGNER" accordion_id="designer-1" icon=""] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/1" el_position="first last"] Lorem ipsum dolor sit amet isse potenti. Vesquam ante aliquet lacusemper elit. Cras neque nulla, convallis non commodo et, euismod nonsese. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum. [/spb_text_block] [/spb_accordion_tab] [spb_accordion_tab title="INTERNSHIP" accordion_id="internship" icon=""] [/spb_accordion_tab] [/spb_accordion] [spb_clients title="Selected Clients" item_count="6" item_columns="3" category="All" carousel="no" pagination="no" width="1/2" el_position="last"] [spb_blank_spacer height="40px" width="1/1" el_position="first last"] [spb_section spb_section_id="15236" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["maintenance-mode"] = array(
		"id" => "maintenance-mode",
		"name" => "Main Demo - Maintenance Mode",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="window-height" bg_type="cover" parallax_image_height="window-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" width="1/4" el_position="first"] [spb_text_block animation="fadeInUp" animation_delay="400" padding_vertical="0" padding_horizontal="4" width="1/2"]  uplift_logo_admin
		Our site is currently undergoing scheduled maintenance. Well be back shortly...
		In the meantime, drop us a line help@uplift.com
		
		[/spb_text_block] [spb_blank_spacer height="1px" width="1/4" el_position="last"] [/spb_row]');
		
		$prebuilt_templates["coming-soon"] = array(
		"id" => "coming-soon",
		"name" => "Main Demo - Coming Soon",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="window-height" bg_type="cover" parallax_image_height="window-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" width="1/4" el_position="first"] [spb_text_block animation="fadeInUp" animation_delay="400" padding_vertical="0" padding_horizontal="4" width="1/2"]  uplift_logo_admin
		Our new site is coming soon.
		[hr]
		[uplift_countdown year="2017" month="1" day="1" fontsize="small" displaytext=""]
		
		[hr]
		
		In the meantime, drop us a line help@uplift.com
		
		[/spb_text_block] [spb_blank_spacer height="1px" width="1/4" el_position="last"] [/spb_row]');
		
		$prebuilt_templates["pricing"] = array(
		"id" => "pricing",
		"name" => "Main Demo - Pricing",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" parallax_video_overlay="none" row_overlay_opacity="0" vertical_center="true" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_pricing_table columns="3" width="1/1" el_position="first last"] [spb_pricing_column name="Starter Package" highlight_column="no" price="$200" period="/MO" btn_text="Purchase Plan" href="#" target="_self" el_class="" ][spb_pricing_column_feature feature_name="50GB Storage Space" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="1 User License" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="3 Email Accounts" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="5 Domain Names" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="Unlimited Bandwidth" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="24/7 Support" el_class=""] [/spb_pricing_column_feature][/spb_pricing_column][spb_pricing_column name="Team Package" highlight_column="yes" price="$300" period="/MO" btn_text="Purchase Plan" href="#" target="_self" el_class="" ][spb_pricing_column_feature feature_name="100GB Storage Space" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="5 User Licenses" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="10 Email Accounts" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="10 Domain Names" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="Unlimited Bandwidth" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="24/7 Support" el_class=""] [/spb_pricing_column_feature][/spb_pricing_column][spb_pricing_column name="Premium Package" highlight_column="no" price="$400" period="/MO" btn_text="Purchase Plan" href="#" target="_self" el_class="" ][spb_pricing_column_feature feature_name="200GB Storage Space" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="10 User Licenses" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="Unlimited Email Accounts" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="Unlimited Domain Names" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="Unlimited Bandwidth" el_class=""] [/spb_pricing_column_feature][spb_pricing_column_feature feature_name="24/7 Support" el_class=""] [/spb_pricing_column_feature][/spb_pricing_column] [/spb_pricing_table] [/spb_row] [spb_divider type="thin" text="Go to top" top_margin="30px" bottom_margin="0px" fullwidth="no" width="1/1" el_position="first last"] [spb_row element_name="FAQs Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="yes" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" padding_vertical="2" padding_horizontal="0" width="1/1" el_position="first last"]
		Frequently asked questions
		[/spb_text_block] [spb_icon_box title="Am I going to be tied into a contract?" box_type="vertical" box_icon_type="svg" svg_icon="business-color_cheque" animate_svg="no" target="_self" animation="none" animation_delay="0" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="first"]
		Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed.
		
		[/spb_icon_box] [spb_icon_box title="How can I claim my free hat?" box_type="vertical" box_icon_type="svg" svg_icon="media-color-1_kid" animate_svg="no" target="_self" animation="none" animation_delay="0" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="last"]
		Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed.
		
		[/spb_icon_box] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box title="Where do I sign up?" box_type="vertical" box_icon_type="svg" svg_icon="ui-color-2_favourite-28" animate_svg="no" target="_self" animation="none" animation_delay="0" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="first"]
		Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed.
		
		[/spb_icon_box] [spb_icon_box title="Can I upgrade later?" box_type="vertical" box_icon_type="svg" svg_icon="arrows-color-2_file-upload-86" animate_svg="no" target="_self" animation="none" animation_delay="0" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="last"]
		Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed.
		
		[/spb_icon_box] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box title="How long does it last?" box_type="vertical" box_icon_type="svg" svg_icon="ui-color-2_hourglass" animate_svg="no" target="_self" animation="none" animation_delay="0" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="first"]
		Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed.
		
		[/spb_icon_box] [spb_icon_box title="Do I have to pay now?" box_type="vertical" box_icon_type="svg" svg_icon="business-color_payment" animate_svg="no" target="_self" animation="none" animation_delay="0" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="last"]
		Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed.
		
		[/spb_icon_box] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box title="How do I cancel my agreement?" box_type="vertical" box_icon_type="svg" svg_icon="business-color_award-49" animate_svg="no" target="_self" animation="none" animation_delay="0" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="first"]
		Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed.
		
		[/spb_icon_box] [spb_icon_box title="Can I sign up others?" box_type="vertical" box_icon_type="svg" svg_icon="users-color_parent" animate_svg="no" target="_self" animation="none" animation_delay="0" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="last"]
		Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed.
		
		[/spb_icon_box] [/spb_row] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_section spb_section_id="15472" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["contact-alt"] = array(
		"id" => "contact-alt",
		"name" => "Main Demo - Contact: Modern",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" padding_vertical="20" padding_horizontal="0" width="1/3" el_position="first"]
		Project Enquiries
		Call: +44 (0) 800 123 4568 Email: projects@uplift.com
		
		[/spb_text_block] [spb_text_block animation="none" animation_delay="0" padding_vertical="20" padding_horizontal="0" width="1/3"]
		General Enquiries
		Call: +44 (0) 800 123 4567 Email: info@uplift.com
		
		[/spb_text_block] [spb_text_block animation="none" animation_delay="0" padding_vertical="20" padding_horizontal="0" width="1/3" el_position="last"]
		Stay Social
		[social size="large"]
		[/spb_text_block] [/spb_row] [spb_gmaps size="600" type="roadmap" zoom="14" map_controls="yes" advanced_styling="yes" style_array="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" saturation="color" fullscreen="yes" width="1/1" el_position="first last"] [spb_map_pin pin_title="Our Office" address="New York" pin_latitude="40.7127837" pin_longitude="-74.00594130000002" pin_image="15385" pin_button_text="Our Office" width="1/1" el_position="first last"]
		No.1 Abbey Road, London, W1 ECH UK
		
		Call: +44 (0) 800 123 4567 Email: info@swiftideas.net
		
		[/spb_map_pin] [/spb_gmaps]');
		
		
		$prebuilt_templates["about-us-classic"] = array(
		"id" => "about-us-classic",
		"name" => "Main Demo - About Us: Classic",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" width="1/1" el_position="first last"] [spb_image image="14052" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="no" fullwidth="no" link_target="_self" lightbox="yes" intro_animation="none" animation_delay="800" width="1/2" el_position="first"] [spb_text_block animation="none" animation_delay="200" padding_vertical="0" padding_horizontal="6" el_class="pb0" width="1/2" el_position="last"]
		Hello, we are Uplift... and we make nice things.
		
		Lorem ipsum dolor sit amet isse potenti. Vesquam ante aliquet lacusemper elit. Cras neque nulla, convallis non commodo et, euismod nonsese. At vero eos et accus amus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non.
		
		Learn more
		
		[/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="30px" bottom_margin="30px" fullwidth="no" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box title="File Management" box_type="vertical" box_icon_type="svg" svg_icon="arrows-color-2_file-upload-86" animate_svg="yes" target="_self" animation="none" animation_delay="0" text_color="#444444" bg_color="#ffffff" animated_box_style="stroke" animated_box_rounded="yes" width="1/3" el_position="first"] Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque purus. [/spb_icon_box] [spb_icon_box title="Presentations" box_type="vertical" box_icon_type="svg" svg_icon="business-color_board-29" animate_svg="yes" target="_self" animation="none" animation_delay="0" text_color="#444444" bg_color="#ffffff" animated_box_style="stroke" animated_box_rounded="yes" width="1/3"] Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque purus. [/spb_icon_box] [spb_icon_box title="Human Resources" box_type="vertical" box_icon_type="svg" svg_icon="business-color_business-contact-85" animate_svg="yes" target="_self" animation="none" animation_delay="0" text_color="#444444" bg_color="#ffffff" animated_box_style="stroke" animated_box_rounded="yes" width="1/3" el_position="last"] Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque purus. [/spb_icon_box] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box title="Marketing & Strategy" box_type="vertical" box_icon_type="svg" svg_icon="business-color_goal-64" animate_svg="yes" target="_self" animation="none" animation_delay="0" text_color="#444444" bg_color="#ffffff" animated_box_style="stroke" animated_box_rounded="yes" width="1/3" el_position="first"] Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque purus. [/spb_icon_box] [spb_icon_box title="Future Planning" box_type="vertical" box_icon_type="svg" svg_icon="location-color_map-pin" animate_svg="yes" target="_self" animation="none" animation_delay="0" text_color="#444444" bg_color="#ffffff" animated_box_style="stroke" animated_box_rounded="yes" width="1/3"] Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque purus. [/spb_icon_box] [spb_icon_box title="Copywriting" box_type="vertical" box_icon_type="svg" svg_icon="business-color_award-49" animate_svg="yes" target="_self" animation="none" animation_delay="0" text_color="#444444" bg_color="#ffffff" animated_box_style="stroke" animated_box_rounded="yes" width="1/3" el_position="last"] Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque purus. [/spb_icon_box] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="0px" bottom_margin="60px" fullwidth="yes" width="1/1" el_position="first last"] [spb_counter subject="Employees" from="0" to="45" speed="2000" refresh="25" commas="true" textstyle="h6" textcolor="#7eced5" icon="nucleo-icon-team" width="1/4" el_position="first"] [spb_counter subject="Page Views" from="0" to="500" speed="2000" refresh="25" suffix="k" commas="true" textstyle="h6" textcolor="#61aab0" icon="nucleo-icon-eye" width="1/4"] [spb_counter subject="Monthly revenue" from="0" to="90" speed="2000" refresh="25" prefix="$" suffix="k" commas="true" textstyle="h6" textcolor="#90a4ae" icon="fa-credit-card-alt" width="1/4"] [spb_counter subject="Offices Globally" from="0" to="12" speed="2000" refresh="25" commas="true" textstyle="h6" textcolor="#78909c" icon="fa-globe" width="1/4" el_position="last"] [spb_divider type="thin" text="Go to top" top_margin="50px" bottom_margin="0px" fullwidth="yes" width="1/1" el_position="first last"] [/spb_row] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_team title="Our Leadership Team" display_type="standard" carousel="yes" item_columns="3" item_count="6" category="All" profile_link="yes" ajax_overlay="yes" pagination="no" fullwidth="no" gutters="yes" order_by="none" order="DESC" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="40px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [spb_blog_grid title="Follow us @uplift" item_count="2" twitter_username="swiftideas" instagram_id="1193751843" instagram_token="1193751843.5b9e1e6.c8c5c0a5df0e4d5687e389f24adb8643" fullwidth="no" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_section spb_section_id="15472" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["about-us"] = array(
		"id" => "about-us",
		"name" => "Main Demo - About Us Extended",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="image" row_bg_color="#37474f" color_row_height="content-height" bg_image="14052" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_mp4="http://swiftideasvideos.s3.amazonaws.com/agency_work.mp4" bg_video_webm="http://swiftideasvideos.s3.amazonaws.com/agency_work.webmhd.webm" bg_video_loop="yes" parallax_video_height="content-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="80" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="fadeIn" row_animation_delay="200" width="1/1" el_position="first last"] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="600" padding_vertical="20" padding_horizontal="0" el_class="pb0" width="1/1" el_position="first last"]
		Hello, we are Uplift & we make nice things.
		
		[/spb_text_block] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" width="1/6" el_position="first"] [spb_text_block animation="none" animation_delay="200" padding_vertical="12" padding_horizontal="0" el_class="pb0" width="2/3"]
		Welcome to uplift,
		
		Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Maecenas ultrices viverra ligula, vel lobortis ante pulvinar sed deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum.
		
		Learn more
		
		[/spb_text_block] [spb_blank_spacer height="1px" width="1/6" el_position="last"] [spb_blank_spacer height="1px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="full-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" width="1/1" el_position="first last"] [spb_image image="15251" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" link_target="_self" lightbox="yes" intro_animation="none" animation_delay="200" width="1/2" el_position="first"] [spb_image image="15249" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" link_target="_self" lightbox="yes" intro_animation="none" animation_delay="200" width="1/2" el_position="last"] [spb_image image="15250" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" link_target="_self" lightbox="yes" intro_animation="none" animation_delay="200" width="1/2" el_position="first"] [spb_image image="15248" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" link_target="_self" lightbox="yes" intro_animation="none" animation_delay="200" width="1/2" el_position="last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="200" padding_vertical="4" padding_horizontal="0" el_class="pb0" width="1/1" el_position="first last"]
		What We Do
		
		[/spb_text_block] [spb_section spb_section_id="15257" width="1/1" el_position="first last"] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [/spb_row] [spb_divider type="thin" text="Go to top" top_margin="0px" bottom_margin="10px" fullwidth="no" width="1/1" el_position="first last"] [spb_row element_name="Core Values Row" wrap_type="full-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="80" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer element_name="Core Values Row" height="1px" width="1/4" el_position="first"] [spb_text_block element_name="Core Values Row" animation="none" animation_delay="200" padding_vertical="6" padding_horizontal="0" el_class="pb0" width="1/2"]
		Our Core Values
		
		[/spb_text_block] [spb_blank_spacer element_name="Core Values Row" height="1px" width="1/4" el_position="last"] [spb_blank_spacer element_name="Core Values Row" height="30px" width="1/1" el_position="first last"] [spb_section element_name="Core Values Row" spb_section_id="15399" el_class="pb0 mb0" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Video Row" wrap_type="content-width" row_bg_type="video" row_bg_color="#406b6f" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_mp4="http://swiftideasvideos.s3.amazonaws.com/agency_work.mp4" bg_video_webm="http://swiftideasvideos.s3.amazonaws.com/agency_work.webmhd.webm" bg_video_loop="yes" parallax_video_height="content-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="60" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="200" padding_vertical="20" padding_horizontal="0" el_class="pb0" width="1/1" el_position="first last"]
		A Day In The Life
		
		[uplift_fullscreenvideo type="icon-button" btntext="" imageurl="#" videourl="" extraclass=""]
		
		[/spb_text_block] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_clients item_count="5" item_columns="5" category="All" carousel="no" pagination="no" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="team" width="1/1" el_position="first last"] [spb_blank_spacer height="10px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="200" padding_vertical="6" padding_horizontal="0" el_class="pb0" width="1/1" el_position="first last"]
		Meet the Team
		
		[/spb_text_block] [spb_team display_type="standard-alt" carousel="no" item_columns="3" item_count="6" category="All" profile_link="no" ajax_overlay="no" pagination="no" fullwidth="no" gutters="yes" order_by="none" order="DESC" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#263238" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" vertical_center="true" inner_column_height="col-natural" row_animation="none" row_animation_delay="0" row_id="team" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_blog_grid item_count="1" instagram_id="1193751843" instagram_token="1193751843.5b9e1e6.c8c5c0a5df0e4d5687e389f24adb8643" fullwidth="yes" width="1/1" el_position="first last"] [/spb_row] [spb_section spb_section_id="15534" width="1/1" el_position="first last"]');
		
		$prebuilt_templates["pages"] = array(
		"id" => "pages",
		"name" => "Main Demo - Pages",
		"code" => '');
		
		$prebuilt_templates["home"] = array(
		"id" => "home",
		"name" => "Main Demo - Home",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_icon_box_grid columns="3" colour_style="dark" width="1/1" el_position="first last"] [spb_icon_box_grid_element title="Simple, Easy-To-Use and Intuitive" target="" link="#" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg emoticons-outline_like"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Engineered for Accelerated Performance" target="" link="" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg sport-outline_user-run"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Extensive Options Providing Flexibility" target="" link="" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg ui-1_preferences-circle"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Fully Responsive and Device Agnostic" target="" link="" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg design-outline_tablet-mobile"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Beautiful and Intelligent Design" target="" link="" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg health-outline_brain"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Professional Support and Maintenance" target="" link="" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg objects-outline_support-17"][/spb_icon_box_grid_element] [/spb_icon_box_grid] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="image" row_bg_color="#222222" color_row_height="content-height" row_style="light" bg_image="14826" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="90" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_portfolio_showcase title="Selected Projects" category="All" item_count="12" pagination="yes" width="1/1" el_position="first last"] [spb_blank_spacer height="40px" width="1/1" el_position="first last"] [/spb_row] [spb_section spb_section_id="15472" width="1/1" el_position="first last"] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_image="15251" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 5%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 20%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_section spb_section_id="15469" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="60px" bottom_margin="30px" fullwidth="no" width="1/1" el_position="first last"] [/spb_row] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="no" custom_css="margin-top: -260px!important;margin-left: 0px!important;margin-right: 0px!important;margin-bottom: 0px!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0px!important;padding-left: 15px!important;padding-right: 15px!important;padding-bottom: 0px!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_team title="Meet our team" display_type="standard-alt" carousel="yes" item_columns="3" item_count="4" category="All" profile_link="no" ajax_overlay="yes" pagination="no" fullwidth="no" gutters="yes" order_by="date" order="DESC" width="1/1" el_position="first last"] [/spb_column] [spb_row element_name="Row" wrap_type="content-width" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" parallax_video_overlay="none" row_overlay_opacity="0" vertical_center="true" width="1/1" el_position="first last"] [spb_divider type="heading" heading_text="What people are saying" text="Go to top" top_margin="20px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [spb_section spb_section_id="15611" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [/spb_row]');
		
		$prebuilt_templates["contact"] = array(
		"id" => "contact",
		"name" => "Main Demo - Contact: Classic",
		"code" => '[spb_gmaps size="500" type="roadmap" zoom="14" 
		map_controls="yes" advanced_styling="yes" style_array="JTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJhbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmxhYmVscy50ZXh0LmZpbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2F0dXJhdGlvbiUyMiUzQSUyMDM2JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29sb3IlMjIlM0ElMjAlMjIlMjMzMzMzMzMlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsaWdodG5lc3MlMjIlM0ElMjA0MCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMmFsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIybGFiZWxzLnRleHQuc3Ryb2tlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb2xvciUyMiUzQSUyMCUyMiUyM2ZmZmZmZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxpZ2h0bmVzcyUyMiUzQSUyMDE2JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJhbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmxhYmVscy5pY29uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMmFkbWluaXN0cmF0aXZlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJnZW9tZXRyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0eWxlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2aXNpYmlsaXR5JTIyJTNBJTIwJTIyb2ZmJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJhZG1pbmlzdHJhdGl2ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIyZ2VvbWV0cnkuZmlsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0eWxlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb2xvciUyMiUzQSUyMCUyMiUyM2ZmZmZmZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxpZ2h0bmVzcyUyMiUzQSUyMDIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIyYWRtaW5pc3RyYXRpdmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmdlb21ldHJ5LnN0cm9rZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0eWxlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb2xvciUyMiUzQSUyMCUyMiUyM2ZlZmVmZSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxpZ2h0bmVzcyUyMiUzQSUyMDE3JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2VpZ2h0JTIyJTNBJTIwMS4yJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIyYWRtaW5pc3RyYXRpdmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmxhYmVscyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0eWxlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2aXNpYmlsaXR5JTIyJTNBJTIwJTIyb2ZmJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJsYW5kc2NhcGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmdlb21ldHJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbG9yJTIyJTNBJTIwJTIyJTIzZjdmN2Y3JTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGlnaHRuZXNzJTIyJTNBJTIwMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMmxhbmRzY2FwZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIybGFiZWxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMmxhbmRzY2FwZS5tYW5fbWFkZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIybGFiZWxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMmxhbmRzY2FwZS5uYXR1cmFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJsYWJlbHMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIycG9pJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJnZW9tZXRyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0eWxlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb2xvciUyMiUzQSUyMCUyMiUyM2Y3ZjdmNyUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxpZ2h0bmVzcyUyMiUzQSUyMDIxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJwb2klMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmxhYmVscyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0eWxlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2aXNpYmlsaXR5JTIyJTNBJTIwJTIyb2ZmJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJwb2kucGFyayUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIyZ2VvbWV0cnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29sb3IlMjIlM0ElMjAlMjIlMjNkZWRlZGUlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsaWdodG5lc3MlMjIlM0ElMjAyMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMnBvaS5wYXJrJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJsYWJlbHMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIycm9hZC5oaWdod2F5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJnZW9tZXRyeS5maWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbG9yJTIyJTNBJTIwJTIyJTIzZWNlZmYxJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGlnaHRuZXNzJTIyJTNBJTIwMTclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2aXNpYmlsaXR5JTIyJTNBJTIwJTIyb2ZmJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJyb2FkLmhpZ2h3YXklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmdlb21ldHJ5LnN0cm9rZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0eWxlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb2xvciUyMiUzQSUyMCUyMiUyM2ZmZmZmZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxpZ2h0bmVzcyUyMiUzQSUyMDI5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2VpZ2h0JTIyJTNBJTIwMC4yJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIycm9hZC5oaWdod2F5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJsYWJlbHMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIycm9hZC5hcnRlcmlhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIyZ2VvbWV0cnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29sb3IlMjIlM0ElMjAlMjIlMjNlY2VmZjElMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsaWdodG5lc3MlMjIlM0ElMjAxOCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIycm9hZC5hcnRlcmlhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIybGFiZWxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMnJvYWQuYXJ0ZXJpYWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmxhYmVscy50ZXh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh1ZSUyMiUzQSUyMCUyMiUyM2ZmMDAwMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIycm9hZC5sb2NhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIyZ2VvbWV0cnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29sb3IlMjIlM0ElMjAlMjIlMjNlY2VmZjElMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsaWdodG5lc3MlMjIlM0ElMjAxNiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIycm9hZC5sb2NhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIybGFiZWxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMnRyYW5zaXQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmdlb21ldHJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbG9yJTIyJTNBJTIwJTIyJTIzZjJmMmYyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGlnaHRuZXNzJTIyJTNBJTIwMTklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2aXNpYmlsaXR5JTIyJTNBJTIwJTIyb2ZmJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJ0cmFuc2l0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJsYWJlbHMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIydHJhbnNpdC5zdGF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJsYWJlbHMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIyd2F0ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmdlb21ldHJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbG9yJTIyJTNBJTIwJTIyJTIzMjZjNmRhJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGlnaHRuZXNzJTIyJTNBJTIwMTclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3ZWlnaHQlMjIlM0ElMjAlMjIxJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJ3YXRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIybGFiZWxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElNUQ=" saturation="color" fullscreen="yes" width="1/1" el_position="first last"] [spb_map_pin pin_title="Our Office" address="New York" pin_latitude="40.7127837" pin_longitude="-74.00594130000002" pin_image="15385" pin_button_text="Our Office" width="1/1" el_position="first last"]
		No.1 Abbey Road, London, W1 ECH UK
		
		Call: +44 (0) 800 123 4567 Email: info@swiftideas.net
		
		[/spb_map_pin] [/spb_gmaps] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/2" el_position="first"] [contact-form-7 id="15387" title="Contact form 1"] [/spb_text_block] [spb_column width="1/4"] [spb_text_block title="Information" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/1" el_position="first last"] Lorem ipsum dolor sit amet isse potenti. Vesquam ante aliquet lacusemper elit. Cras neque nulla. [/spb_text_block] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_text_block title="Follow us @uplift" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/1" el_position="first last"] [social] [/spb_text_block] [/spb_column] [spb_column width="1/4" el_position="last"] [spb_text_block title="Our Address" animation="none" animation_delay="0" padding_vertical="0" padding_horizontal="0" width="1/1" el_position="first last"] No.1 Abbey Road, London, W1 ECH UK Call: +44 (0) 800 123 4567 Email: info@swiftideas.net [/spb_text_block] [/spb_column]');
		
		$prebuilt_templates["services-classic"] = array(
		"id" => "services-classic",
		"name" => "Main Demo - Services: Classic",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" width="1/1" el_position="first last"] [spb_blank_spacer height="25px" width="1/1" el_position="first last"] [spb_column width="1/3" el_position="first"] [spb_animated_headline before_text="Were an award-winning company elegant creating solutions for" animated_strings="charities,agencies,governments" animation_type="slide" textstyle="h1" textalign="left" textcolor="#7eced5" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" border_styling_global="default" width="1/1" el_position="first last"]
		Lorem ipsum dolor sit met, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim. Mecenas ultraces viverra ligula, vel lobortis ante decore tamquam pulvinar sed iaculis trirtique nis.
		
		See our case studies
		
		[/spb_text_block] [/spb_column] [spb_gallery gallery_id="15080" display_type="slider" columns="5" fullwidth="no" gutters="yes" image_size="full" slider_transition="slide" show_thumbs="no" autoplay="no" show_captions="no" enable_lightbox="no" width="2/3" el_position="last"] [spb_blank_spacer height="35px" width="1/1" el_position="first last"] [/spb_row] [spb_divider type="heading" heading_text="Services we offer" text="Go to top" top_margin="0px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [spb_section spb_section_id="15257" width="1/1" el_position="first last"] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [spb_section spb_section_id="15534" width="1/1" el_position="first last"]');

		$prebuilt_templates["startup-home"] = array(
		"id" => "startup-home",
		"name" => "Startup Demo - Home",
		"code" => '[spb_row element_name="Intro: Desktop/Tablet" wrap_type="content-width" row_bg_type="video" row_bg_color="#1a237e" color_row_height="window-height" bg_image="14320" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_mp4="http://swiftideasvideos.s3.amazonaws.com/agency_work.mp4" bg_video_webm="http://swiftideasvideos.s3.amazonaws.com/agency_work.webmhd.webm" bg_video_loop="yes" parallax_video_height="content-height" row_header_style="light" row_top_style="none" row_bottom_style="slant-ltr" parallax_video_overlay="color" row_overlay_opacity="80" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_responsive_vis="hidden-xs" row_id="intro" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;" border_styling_global="default" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 20%;padding-left: 14%;padding-right: 14%;padding-bottom: 20%;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]
<p class="impact-text-large" style="text-align: center;"><span style="color: #ffffff;">Introducing Uplift, build better, faster and with less effort.</span></p>
<p style="text-align: center;">[uplift_button colour="accent" type="bordered" size="standard" link="#overview" target="_self" icon="nucleo-icon-chevron-down" dropshadow="no" rounded="yes" extraclass=""]Take the tour[/uplift_button]</p>
[/spb_text_block] [/spb_row] [spb_row element_name="Intro: Mobile" wrap_type="content-width" row_bg_type="image" row_bg_color="#1a237e" color_row_height="window-height" bg_image="14320" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_mp4="http://swiftideasvideos.s3.amazonaws.com/agency_work.mp4" bg_video_webm="http://swiftideasvideos.s3.amazonaws.com/agency_work.webmhd.webm" bg_video_loop="yes" parallax_video_height="content-height" row_header_style="light" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="80" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_responsive_vis="hidden-lg_hidden-md_hidden-sm" row_id="intro" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_styling_global="default" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 14%;padding-left: 2%;padding-right: 2%;padding-bottom: 4%;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]
<p class="impact-text-large" style="text-align: center;"><span style="color: #ffffff;">Introducing Uplift, build better, faster and with less effort.</span></p>
<p style="text-align: center;">[uplift_button colour="accent" type="bordered" size="standard" link="#overview" target="_self" icon="nucleo-icon-chevron-down" dropshadow="no" rounded="yes" extraclass=""]Take the tour[/uplift_button]</p>
[/spb_text_block] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

[uplift_fullscreenvideo type="image-button" btntext="" imageurl="http://uplift.swiftideas.com/startup-demo/wp-content/uploads/sites/9/2016/01/browser-6.png" imageheight="542" imagewidth="1140" videourl="https://vimeo.com/36176127" extraclass=""]

[/spb_text_block] [/spb_row] [spb_row element_name="Video overlay: Desktop/Tablet" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_responsive_vis="hidden-xs" minimize_row="no" simplified_controls="no" custom_css="margin-top: -330px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_styling_global="default" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

[uplift_fullscreenvideo type="image-button" btntext="" imageurl="http://uplift.swiftideas.com/startup-demo/wp-content/uploads/sites/9/2016/01/browser-6.png" imageheight="542" imagewidth="1140" videourl="https://vimeo.com/36176127" extraclass=""]

[/spb_text_block] [/spb_row] [spb_row element_name="Overview" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="overview" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 3%;padding-left: 0%;padding-right: 0%;padding-bottom: 7%;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" responsive_vis="hidden-xs_hidden-sm" width="1/4" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 6%;padding-left: 2%;padding-right: 2%;padding-bottom: 6%;" border_size="0" border_styling_global="default" width="1/2" el_position="last"]
<h5 style="text-align: center;">OVERVIEW</h5>
<p class="impact-text" style="text-align: center;">Loaded with cutting-edge features and extraordinary attention to detail.</p>
<p style="text-align: center;">lass patent taciti sociosqu ad litro torquent per connubio nostra, per inceptos himenaeos. Curabitur a torto ut leo mattis cursus. Vestibule laoreet interdum pellentesque.</p>
[/spb_text_block] [spb_icon_box title="Gesture Library" box_type="standard-center" box_icon_type="svg" svg_icon="media-1_shake" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#5c6bc0" icon_bg_color="#ffffff" text_color="#5c6bc0" animated_box_style="coloured" animated_box_rounded="yes" width="1/3" el_position="first"]

<span style="color: #333333;">Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt.</span>

[/spb_icon_box] [spb_icon_box title="Responsive Testing" box_type="standard-center" box_icon_type="svg" svg_icon="design-outline_tablet-mobile" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#64b5f6" text_color="#64b5f6" animated_box_style="coloured" animated_box_rounded="yes" width="1/3"]

<span style="color: #333333;">Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt.</span>

[/spb_icon_box] [spb_icon_box title="Code Repository" box_type="standard-center" box_icon_type="svg" svg_icon="design-outline_paper-dev" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#9575cd" text_color="#9575cd" animated_box_style="coloured" animated_box_rounded="yes" width="1/3" el_position="last"]

<span style="color: #333333;">Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt.</span>

[/spb_icon_box] [spb_blank_spacer height="30px" responsive_vis="hidden-xs" width="1/1" el_position="first last"] [spb_icon_box title="Uplift Labs" box_type="standard-center" box_icon_type="svg" svg_icon="ui-2_lab" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#ba68c8" icon_bg_color="#ffffff" text_color="#ba68c8" animated_box_style="coloured" animated_box_rounded="yes" width="1/3" el_position="first"]

<span style="color: #333333;">Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt.</span>

[/spb_icon_box] [spb_icon_box title="Easy Editing" box_type="standard-center" box_icon_type="svg" svg_icon="design-outline_artboard" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#f06292" icon_bg_color="#ffffff" text_color="#f06292" animated_box_style="coloured" animated_box_rounded="yes" width="1/3"]

<span style="color: #333333;">Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt.</span>

[/spb_icon_box] [spb_icon_box title="Unlimited Layouts" box_type="standard-center" box_icon_type="svg" svg_icon="design-outline_window-paragraph" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#ff8a80" icon_bg_color="#ffffff" text_color="#ff8a80" animated_box_style="coloured" animated_box_rounded="yes" width="1/3" el_position="last"]

<span style="color: #333333;">Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt.</span>

[/spb_icon_box] [/spb_row] [spb_row element_name="Explore" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="explore" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 4%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" responsive_vis="hidden-xs_hidden-sm" width="1/4" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 6%;padding-left: 2%;padding-right: 2%;padding-bottom: 10%;" border_size="0" border_styling_global="default" width="1/2" el_position="last"]
<h5 style="text-align: center;">EXPLORE</h5>
<p class="impact-text" style="text-align: center;">Create something special, see whats possible with uplift.</p>
[/spb_text_block] [spb_portfolio_carousel title="Showcase Gallery" item_count="5" item_columns="4" fullwidth="yes" gutters="no" category="All" el_class="pb0 mb0" width="1/1" el_position="first last"] [/spb_row] [spb_promo_bar display_type="promo-button" promo_bar_text="You will love creating with Uplift" promo_bar_text_size="impact-text" btn_text="Get started today" btn_color="accent" btn_type="rounded_bordered" href="http://uplift.swiftideas.com/purchase" target="_self" bg_color="#e8eaf6" text_color="#5c6bc0" page_align="yes" fullwidth="yes" width="1/1" el_position="first last"]

Enter your text here

[/spb_promo_bar] [spb_row element_name="Reviews" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="reviews" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 2%;padding-left: 0%;padding-right: 0%;padding-bottom: 7%;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" responsive_vis="hidden-xs_hidden-sm" width="1/4" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 12%;padding-left: 2%;padding-right: 2%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/2" el_position="last"]
<h5 style="text-align: center;">REVIEWS</h5>
<p class="impact-text" style="text-align: center;">What people are saying</p>
[/spb_text_block] [spb_blank_spacer height="60px" responsive_vis="hidden-xs" width="1/1" el_position="first last"] [spb_section element_name="Testimonials" spb_section_id="15611" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Review Call out: Desktop" wrap_type="full-width" row_bg_type="color" row_bg_color="#5c6bc0" color_row_height="content-height" bg_image="15624" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_responsive_vis="hidden-xs_hidden-sm" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_styling_global="default" width="1/1" el_position="first last"] [spb_image image="15559" image_size="large" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/2" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 14%;padding-right: 14%;padding-bottom: 0%;background-color:#5c6bc0;" border_size="0" border_styling_global="default" back_color_global="#5c6bc0" width="1/2" el_position="last"]
<h3><span style="color: #ffffff;">"With Uplift I can build my websites just the way I want them to be. The many options that Uplift provides are magnificent. If you want a good working website with great features then Uplift is a must have. I am a happy customer."</span></h3>
<span style="color: #ffffff;">Happy Customer</span>

[/spb_text_block] [/spb_row] [spb_row element_name="Review Call out: Tablet/Mobile" wrap_type="full-width" row_bg_type="color" row_bg_color="#5c6bc0" color_row_height="content-height" bg_image="15624" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_responsive_vis="hidden-lg_hidden-md" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;" border_styling_global="default" width="1/1" el_position="first last"] [spb_image image="15559" image_size="large" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 6%;padding-left: 6%;padding-right: 6%;padding-bottom: 10%;background-color:#5c6bc0;" border_size="0" border_styling_global="default" back_color_global="#5c6bc0" width="1/1" el_position="first last"]
<h3><span style="color: #ffffff;">"With Uplift I can build my websites just the way I want them to be. The many options that Uplift provides are magnificent. If you want a good working website with great features then Uplift is a must have. I am a happy customer."</span></h3>
<span style="color: #ffffff;">Happy Customer</span>

[/spb_text_block] [/spb_row] [spb_row element_name="News" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="news" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 4%;padding-left: 0%;padding-right: 0%;padding-bottom: 4%;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" width="1/4" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 6%;padding-left: 2%;padding-right: 2%;padding-bottom: 6%;" border_size="0" border_styling_global="default" width="1/2" el_position="last"]
<h5 style="text-align: center;">NEWS</h5>
<p class="impact-text" style="text-align: center;">Recent press &amp; articles.</p>
[/spb_text_block] [spb_blog blog_type="masonry" gutters="yes" columns="3" fullwidth="no" item_count="3" category="All" offset="0" order_by="date" order="DESC" show_title="yes" show_excerpt="yes" show_details="yes" excerpt_length="14" content_output="excerpt" show_read_more="yes" social_integration="no" blog_filter="no" pagination="none" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" responsive_vis="hidden-xs" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Contact" wrap_type="full-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="contact" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_styling_global="default" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 6%;padding-left: 14%;padding-right: 14%;padding-bottom: 6%;background-color:#ffffff;" border_size="0" border_styling_global="default" back_color_global="#ffffff" width="1/3" el_position="first"]
<h5>CONTACT</h5><p class="impact-text">Get in touch</p> [contact-form-7 id="15387" title="Contact form 1"][/spb_text_block][spb_gmaps size="650" type="roadmap" zoom="13" map_controls="no" advanced_styling="yes" saturation="color" fullscreen="yes" width="2/3" el_position="last"] [spb_map_pin pin_title="First Pin" address="New York" pin_image="16241" width="1/1" el_position="first last"] This is a map pin. Click the edit button to change it. [/spb_map_pin] [/spb_gmaps] [/spb_row] [spb_section spb_section_id="15637" width="1/1" el_position="first last"]');

	$prebuilt_templates["agency-about"] = array(
	"id" => "agency-about",
	"name" => "Agency Demo - About",
	"code" => '[spb_row row_responsive_vis="hidden-xs_hidden-sm" element_name="Desktop" wrap_type="full-width" row_bg_type="image" color_row_height="content-height" bg_image="16276" bg_type="cover" parallax_image_height="window-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-window-height" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" simplified_controls="yes" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_styling_global="default" width="1/1" el_position="first last"] [spb_column col_animation="none" col_animation_delay="0" col_bg_color="#f7f7f7" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 4%;padding-right: 4%;padding-bottom: 0%;" border_styling_global="default" width="1/2" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;background-color:#f7f7f7;" border_size="0" border_styling_global="default" back_color_global="#f7f7f7" width="1/1" el_position="first last"]
<p class="impact-text" style="text-align: center;">Hi, my name is Mike Jones. Im a designer and photographer based in London.</p>

<h5 style="text-align: center;">Vestibule convallis pulvinar tellus eget ultricies. Sed sollic itudin, sem vitae eleme ntum euis mod, veilt arcu mattis diam, in sceler isque purus lorem eget elit. Sed vitae nunc in mets semper veilt arcu mattis hendrerit.</h5>
[/spb_text_block] [spb_divider type="heading" heading_text="Selected Clients" text="Go to top" top_margin="30px" bottom_margin="30px" fullwidth="no" width="1/1" el_position="first last"] [spb_clients item_count="6" item_columns="3" category="All" carousel="no" pagination="no" width="1/1" el_position="first last"] [spb_divider type="heading" heading_text="Follow Me" text="Go to top" top_margin="60px" bottom_margin="0px" fullwidth="no" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;background-color:#f7f7f7;" border_size="0" border_styling_global="default" back_color_global="#f7f7f7" width="1/1" el_position="first last"]
<div style="text-align: center;">[social size="large"]</div>
[/spb_text_block] [/spb_column] [/spb_row] [spb_row row_responsive_vis="hidden-lg_hidden-md" element_name="Tablet / Mobile" wrap_type="content-width" row_bg_type="color" row_bg_color="#f7f7f7" color_row_height="content-height" bg_image="16276" bg_type="cover" parallax_image_height="window-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" simplified_controls="yes" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_styling_global="default" width="1/1" el_position="first last"] [spb_image image="16276" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" link_target="_self" lightbox="yes" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;background-color:#f7f7f7;" border_size="0" border_styling_global="default" back_color_global="#f7f7f7" width="1/1" el_position="first last"]
<p class="impact-text" style="text-align: center;">Hi, my name is Mike Jones. Im a designer and photographer based in London.</p>

<h5 style="text-align: center;">Vestibule convallis pulvinar tellus eget ultricies. Sed sollic itudin, sem vitae eleme ntum euis mod, veilt arcu mattis diam, in sceler isque purus lorem eget elit. Sed vitae nunc in mets semper veilt arcu mattis hendrerit.</h5>
[/spb_text_block] [spb_divider type="heading" heading_text="Selected Clients" text="Go to top" top_margin="30px" bottom_margin="30px" fullwidth="no" width="1/1" el_position="first last"] [spb_clients item_count="6" item_columns="3" category="All" carousel="no" pagination="no" width="1/1" el_position="first last"] [spb_divider type="heading" heading_text="Follow Me" text="Go to top" top_margin="60px" bottom_margin="0px" fullwidth="no" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;background-color:#f7f7f7;" border_size="0" border_styling_global="default" back_color_global="#f7f7f7" width="1/1" el_position="first last"]
<div style="text-align: center;">[social size="large"]</div>
[/spb_text_block] [/spb_row]');

		$prebuilt_templates["agency-contact"] = array(
		"id" => "agency-contact",
		"name" => "Agency Demo - Contact",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="image" row_bg_color="#222222" color_row_height="window-height" bg_image="16271" bg_type="cover" parallax_image_height="window-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" simplified_controls="yes" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" responsive_vis="hidden-xs" width="1/3" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 55px;padding-left: 40px;padding-right: 40px;padding-bottom: 7px;background-color:#ffffff;" border_size="0" border_styling_global="default" back_color_global="#ffffff" width="1/3" el_position="last"]

[contact-form-7 id="15387" title="Contact form 1"]

[/spb_text_block] [/spb_row]');

		$prebuilt_templates["agency-news"] = array(
		"id" => "agency-news",
		"name" => "Agency Demo - News & Stuff",
		"code" => '[spb_blank_spacer height="50px" width="1/1" el_position="first last"] [spb_blog blog_type="timeline" gutters="yes" columns="4" fullwidth="no" item_count="4" category="All" offset="0" order_by="date" order="DESC" show_title="yes" show_excerpt="yes" show_details="yes" excerpt_length="27" content_output="excerpt" show_read_more="yes" social_integration="no" blog_filter="no" pagination="infinite-scroll" width="1/1" el_position="first last"]');

		$prebuilt_templates["agency-photography"] = array(
		"id" => "agency-photography",
		"name" => "Agency Demo - Photography",
		"code" => '[spb_row element_name="Row" wrap_type="full-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" simplified_controls="yes" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_styling_global="default" width="1/1" el_position="first last"] [spb_gallery gallery_id="15080" display_type="masonry" columns="2" fullwidth="no" gutters="no" image_size="full" slider_transition="slide" show_thumbs="yes" autoplay="yes" show_captions="no" enable_lightbox="yes" el_class="mb0" width="1/1" el_position="first last"] [/spb_row]');

		$prebuilt_templates["agency-work"] = array(
		"id" => "agency-work",
		"name" => "Agency Demo - Work",
		"code" => '[spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_portfolio display_type="multi-size-masonry" multi_size_ratio="1/1" fullwidth="yes" gutters="yes" columns="2" show_title="yes" show_subtitle="yes" show_excerpt="yes" hover_show_excerpt="no" excerpt_length="20" item_count="12" category="All" order_by="date" order="DESC" portfolio_filter="no" pagination="none" button_enabled="yes" width="1/1" el_position="first last"]');

		$prebuilt_templates["goodsdemo-home"] = array(
		"id" => "goodsdemo-home",
		"name" => "Goods Demo - Home",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_responsive_vis="hidden-xs" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_image_banner image="16051" image_size="full" content_pos="center" content_textalign="center" animation="none" animation_delay="200" image_link="/goods-demo/products/" link_target="_self" width="1/3" el_position="first"]

Shop
Chairs
[/spb_image_banner] [spb_image_banner image="16048" image_size="full" content_pos="center" content_textalign="center" animation="none" animation_delay="200" image_link="/goods-demo/products/" link_target="_self" width="1/3"]

Shop
Stools
[/spb_image_banner] [spb_image_banner image="16049" image_size="full" content_pos="center" content_textalign="center" animation="none" animation_delay="200" image_link="/goods-demo/products/" link_target="_self" width="1/3" el_position="last"]

Shop
Tables
[/spb_image_banner] [/spb_row] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_divider type="heading" heading_text="Latest Arrivals" text="Go to top" top_margin="0px" bottom_margin="30px" fullwidth="no" width="1/1" el_position="first last"] [spb_products asset_type="latest-products" category="chairs,stools,tables" display_type="standard" display_layout="standard" multi_masonry="no" carousel="no" fullwidth="no" columns="3" item_count="3" order_by="date" order="DESC" button_enabled="no" width="1/1" el_position="first last"] [spb_blank_spacer height="20px" width="1/1" el_position="first last"] [spb_button button_text="Shop All Products" button_size="large" button_colour="accent" button_type="standard" rounded="yes" button_dropshadow="no" button_link="/goods-demo/products/" button_target="_self" align="center" animation="none" animation_delay="0" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="image" row_bg_color="#222222" color_row_height="content-height" bg_image="133" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="80" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" simplified_controls="yes" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_styling_global="default" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 8%;padding-left: 12%;padding-right: 12%;padding-bottom: 2%;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Reasons to shop with us
[/spb_text_block] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_icon_box_grid columns="3" colour_style="light" width="1/1" el_position="first last"]

[spb_icon_box_grid_element title="Fast & Free
International Delivery" target="" link="/goods-demo/products/" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg shopping-outline_delivery-time"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Secure Checkout
And Transactions" target="" link="/goods-demo/products/" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg shopping-outline_credit-locked"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Free One-Day
No Quibble Returns" target="" link="/goods-demo/products/" icon="svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item svg-icon-picker-item outline-svg ui-1_send"][/spb_icon_box_grid_element]

[/spb_icon_box_grid] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [/spb_row] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [spb_products title="Featured Products" asset_type="featured-products" category="chairs,stools,tables" display_type="standard" display_layout="standard" multi_masonry="yes" carousel="no" fullwidth="no" columns="4" item_count="4" order="DESC" button_enabled="yes" width="1/1" el_position="first last"] [spb_divider type="heading" heading_text="Recent Journal Articles" text="Go to top" top_margin="50px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [spb_recent_posts display_type="standard" carousel="no" item_columns="3" item_count="3" category="All" offset="0" posts_order="DESC" excerpt_length="24" fullwidth="no" gutters="yes" button_enabled="no" pagination="yes" width="1/1" el_position="first last"] [spb_blank_spacer height="50px" width="1/1" el_position="first last"] [spb_button button_text="More Journal Articles" button_size="large" button_colour="accent" button_type="standard" rounded="yes" button_dropshadow="no" button_link="/goods-demo/the-journal/" button_target="_self" align="center" animation="none" animation_delay="0" width="1/1" el_position="first last"]');


	$prebuilt_templates["cafe-about"] = array(
		"id" => "cafe-about",
		"name" => "Cafe Demo - About",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="200" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="6" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 6%;padding-bottom: 0%;" border_size="0" border_styling_global="default" el_class="pb0" width="1/2" el_position="first"]
<h3>Hello, <em>we are</em> Uplift...
and we cook nice things.</h3>
Lorem ipsum dolor sit amet isse potenti. Vesquam ante aliquet lacu semper elit. Cras neque nulla, convallis non commodo et, euismod nonsese.At vero eos et accus amus et iusto odio dignis simos ducimus qui blanditiis praese ntium volu ptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non. At vero eos et accus amus et iusto odio dignis simos ducimus qui blanditiis praese ntium volu ptatum deleniti atque corrupti quos dolores et quas molestias excepturi.

[/spb_text_block] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 8%;padding-right: 0%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/2" el_position="last"]

[uplift_fullscreenvideo type="image-button" btntext="" imageurl="http://uplift.swiftideas.com/cafe-demo/wp-content/uploads/sites/4/2016/01/food-med.jpg" videourl="https://vimeo.com/36176127" extraclass=""]

[/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="60px" bottom_margin="30px" fullwidth="no" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box title="Fine Dining" box_type="vertical" box_icon_type="svg" svg_icon="food-outline_cutlery-77" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#f5825e" text_color="#444444" bg_color="#ffffff" animated_box_style="stroke" animated_box_rounded="yes" width="1/3" el_position="first"]
<h5>Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque.</h5>
[/spb_icon_box] [spb_icon_box title="Artisan Coffee" box_type="vertical" box_icon_type="svg" svg_icon="food-outline_moka" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#f5825e" text_color="#444444" bg_color="#ffffff" animated_box_style="stroke" animated_box_rounded="yes" width="1/3"]
<h5>Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque.</h5>
[/spb_icon_box] [spb_icon_box title="Huge Tea Selection" box_type="vertical" box_icon_type="svg" svg_icon="food-outline_tea" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#f5825e" text_color="#444444" bg_color="#ffffff" animated_box_style="stroke" animated_box_rounded="yes" width="1/3" el_position="last"]
<h5>Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque.</h5>
[/spb_icon_box] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box title="Baked Goods" box_type="vertical" box_icon_type="svg" svg_icon="food-outline_donut" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#f5825e" text_color="#444444" bg_color="#ffffff" animated_box_style="stroke" animated_box_rounded="yes" width="1/3" el_position="first"]
<h5>Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque.</h5>
[/spb_icon_box] [spb_icon_box title="Craft Brewery" box_type="vertical" box_icon_type="svg" svg_icon="food-outline_beer-95" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#f5825e" text_color="#444444" bg_color="#ffffff" animated_box_style="stroke" animated_box_rounded="yes" width="1/3"]
<h5>Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque.</h5>
[/spb_icon_box] [spb_icon_box title="Ethically Sourced" box_type="vertical" box_icon_type="svg" svg_icon="envir-outline_recycling" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#f5825e" text_color="#444444" bg_color="#ffffff" animated_box_style="stroke" animated_box_rounded="yes" width="1/3" el_position="last"]
<h5>Vestibule corvallis pulvinar tellus eget ultricies. Sed sollicitudin, sem vitae elementum euismod, veilt arcu mattis diam, in scelerisque.</h5>
[/spb_icon_box] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" simplified_controls="yes" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_styling_global="default" width="1/1" el_position="first last"] [spb_image image="16244" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="no" fullwidth="no" overflow_mode="none" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_image image="16231" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="no" fullwidth="no" overflow_mode="none" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/2" el_position="first"] [spb_image image="16238" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="no" fullwidth="no" overflow_mode="none" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/2" el_position="last"] [/spb_row]');

	$prebuilt_templates["cafe-getintouch"] = array(
		"id" => "cafe-getintouch",
		"name" => "Cafe Demo - Get in Touch",
		"code" => '[spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 6%;padding-left: 0%;padding-right: 0%;padding-bottom: 6%;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"] [spb_text_block title="Jobs at Uplift" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 6%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/2" el_position="first"]

<strong>Full / Part Time Barista
</strong>Ut sum noluisse insolens appellantur, discere epicurei nominati id duo. Id eventi vidisse omnesque qui. Sale decore tamquam eso ne, in pri amet pertinax, vel option nominavi id. Ferri elitra semper ius ad, ea pro dique vivendo repudiandae, delenit asseveri ex ius. Per aliquip liberasse accomodare an, et vim clima deleniti, phaedrum.

Call: +44 (0) 208 19379
Email: <a href="mailto:info@upliftcafe.com">jobs@upliftcafe.com</a>
<div></div>
[/spb_text_block] [spb_text_block title="Opening Hours:" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/4"]

<strong>Mon-Tue-Wed</strong> 07.00-19.00
<strong>Thu-Fri</strong> 07.00-20.00
<strong>Saturday</strong> 08.00-20.00
<strong>Sunday</strong> 08.00-19.00
Our kitchen is open until 6pm

Join us for a drink - it is happy hour from 17.30 till closing time every day!

[/spb_text_block] [spb_text_block title="Visit Us" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/4" el_position="last"]

Uplift Cafe,
290 Fake Street,
London, W1C E78

Call: +44 (0) 208 19378
Email: <a href="mailto:info@upliftcafe.com">info@upliftcafe.com</a>
<div>[uplift_button colour="black" type="standard" size="standard" link="http://uplift.swiftideas.com/purchase" target="_self" icon="" dropshadow="no" rounded="no" extraclass=""]Make a booking[/uplift_button]</div>
<div></div>
[/spb_text_block] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_gmaps size="600" type="roadmap" zoom="14" map_controls="no" advanced_styling="yes" style_array="JTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJhbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmxhYmVscy50ZXh0LmZpbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2F0dXJhdGlvbiUyMiUzQSUyMDM2JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29sb3IlMjIlM0ElMjAlMjIlMjMzMzMzMzMlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsaWdodG5lc3MlMjIlM0ElMjA0MCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMmFsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIybGFiZWxzLnRleHQuc3Ryb2tlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb2xvciUyMiUzQSUyMCUyMiUyM2ZmZmZmZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxpZ2h0bmVzcyUyMiUzQSUyMDE2JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJhbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmxhYmVscy5pY29uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMmFkbWluaXN0cmF0aXZlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJnZW9tZXRyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0eWxlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2aXNpYmlsaXR5JTIyJTNBJTIwJTIyb2ZmJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJhZG1pbmlzdHJhdGl2ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIyZ2VvbWV0cnkuZmlsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0eWxlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb2xvciUyMiUzQSUyMCUyMiUyM2ZmZmZmZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxpZ2h0bmVzcyUyMiUzQSUyMDIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIyYWRtaW5pc3RyYXRpdmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmdlb21ldHJ5LnN0cm9rZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0eWxlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb2xvciUyMiUzQSUyMCUyMiUyM2ZlZmVmZSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxpZ2h0bmVzcyUyMiUzQSUyMDE3JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2VpZ2h0JTIyJTNBJTIwMS4yJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIyYWRtaW5pc3RyYXRpdmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmxhYmVscyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0eWxlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2aXNpYmlsaXR5JTIyJTNBJTIwJTIyb2ZmJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJsYW5kc2NhcGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmdlb21ldHJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbG9yJTIyJTNBJTIwJTIyJTIzZjdmN2Y3JTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGlnaHRuZXNzJTIyJTNBJTIwMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMmxhbmRzY2FwZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIybGFiZWxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMmxhbmRzY2FwZS5tYW5fbWFkZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIybGFiZWxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMmxhbmRzY2FwZS5uYXR1cmFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJsYWJlbHMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIycG9pJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJnZW9tZXRyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0eWxlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb2xvciUyMiUzQSUyMCUyMiUyM2Y3ZjdmNyUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxpZ2h0bmVzcyUyMiUzQSUyMDIxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJwb2klMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmxhYmVscyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0eWxlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2aXNpYmlsaXR5JTIyJTNBJTIwJTIyb2ZmJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJwb2kucGFyayUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIyZ2VvbWV0cnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29sb3IlMjIlM0ElMjAlMjIlMjNkZWRlZGUlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsaWdodG5lc3MlMjIlM0ElMjAyMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMnBvaS5wYXJrJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJsYWJlbHMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIycm9hZC5oaWdod2F5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJnZW9tZXRyeS5maWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbG9yJTIyJTNBJTIwJTIyJTIzZWNlZmYxJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGlnaHRuZXNzJTIyJTNBJTIwMTclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2aXNpYmlsaXR5JTIyJTNBJTIwJTIyb2ZmJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJyb2FkLmhpZ2h3YXklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmdlb21ldHJ5LnN0cm9rZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0eWxlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb2xvciUyMiUzQSUyMCUyMiUyM2ZmZmZmZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxpZ2h0bmVzcyUyMiUzQSUyMDI5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2VpZ2h0JTIyJTNBJTIwMC4yJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIycm9hZC5oaWdod2F5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJsYWJlbHMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIycm9hZC5hcnRlcmlhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIyZ2VvbWV0cnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29sb3IlMjIlM0ElMjAlMjIlMjNlY2VmZjElMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsaWdodG5lc3MlMjIlM0ElMjAxOCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIycm9hZC5hcnRlcmlhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIybGFiZWxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMnJvYWQuYXJ0ZXJpYWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmxhYmVscy50ZXh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh1ZSUyMiUzQSUyMCUyMiUyM2ZmMDAwMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIycm9hZC5sb2NhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIyZ2VvbWV0cnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29sb3IlMjIlM0ElMjAlMjIlMjNlY2VmZjElMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsaWdodG5lc3MlMjIlM0ElMjAxNiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIycm9hZC5sb2NhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIybGFiZWxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMCUyMnRyYW5zaXQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmdlb21ldHJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbG9yJTIyJTNBJTIwJTIyJTIzZjJmMmYyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGlnaHRuZXNzJTIyJTNBJTIwMTklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2aXNpYmlsaXR5JTIyJTNBJTIwJTIyb2ZmJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJ0cmFuc2l0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJsYWJlbHMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIydHJhbnNpdC5zdGF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWxlbWVudFR5cGUlMjIlM0ElMjAlMjJsYWJlbHMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdHlsZXJzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmlzaWJpbGl0eSUyMiUzQSUyMCUyMm9mZiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZlYXR1cmVUeXBlJTIyJTNBJTIwJTIyd2F0ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbGVtZW50VHlwZSUyMiUzQSUyMCUyMmdlb21ldHJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbG9yJTIyJTNBJTIwJTIyJTIzMzAzMDMwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGlnaHRuZXNzJTIyJTNBJTIwMTclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3ZWlnaHQlMjIlM0ElMjAlMjIxJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjAlMjJ3YXRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVsZW1lbnRUeXBlJTIyJTNBJTIwJTIybGFiZWxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3R5bGVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpc2liaWxpdHklMjIlM0ElMjAlMjJvZmYlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElNUQ=" saturation="color" fullscreen="no" width="1/1" el_position="first last"] [spb_map_pin pin_title="Our Office" address="New York" pin_latitude="40.7127837" pin_longitude="-74.00594130000002" pin_image="16252" pin_button_text="Our Office" width="1/1" el_position="first last"]
<h6>No.1 Abbey Road, London, W1 ECH UK</h6>
<h6>Call: +44 (0) 800 123 4567 Email: info@swiftideas.net</h6>
[/spb_map_pin] [/spb_gmaps] [/spb_row]');





	$prebuilt_templates["cafe-home"] = array(
		"id" => "cafe-home",
		"name" => "Cafe Demo - Home",
		"code" => '[spb_row row_responsive_vis="hidden-xs" element_name="Row" wrap_type="content-width" row_bg_type="image" row_bg_color="#222222" color_row_height="content-height" row_style="light" bg_image="16224" bg_type="cover" parallax_image_height="window-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="light" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="70" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 10%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer responsive_vis="hidden-xs" height="1px" width="1/6" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 16%;padding-left: 10%;padding-right: 10%;padding-bottom: 20%;" border_size="0" border_styling_global="default" width="2/3" el_position="last"]
<p class="impact-text-large" style="text-align: center;"><span style="color: #ffffff;">Welcome to the Uplift Cafe</span></p>
<p class="impact-text" style="text-align: center;"><span style="color: #ffffff;">bringing you the best in local organic &amp; responsibly sourced goodness, since 1982.</span></p>
<p style="text-align: center;"><a class="read-more" href="/cafe-demo/about-the-cafe/">More about us</a></p>
[/spb_text_block] [spb_icon_box_grid columns="3" colour_style="light" width="1/1" el_position="first last"]

[spb_icon_box_grid_element title="Incredible Drinks" target="" link="/cafe-demo/food-and-drinks/" icon="svg-icon-picker-item outline-svg food-outline_cocktail"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Local Organic Food" target="" link="/cafe-demo/food-and-drinks/" icon="svg-icon-picker-item outline-svg food-outline_pizza-slice"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Sustainably Sourced" target="" link="/cafe-demo/about-the-cafe/" icon="svg-icon-picker-item outline-svg envir-outline_save-planet"][/spb_icon_box_grid_element]

[/spb_icon_box_grid] [/spb_row] [spb_row row_responsive_vis="hidden-lg_hidden-md_hidden-sm" element_name="Row" wrap_type="content-width" row_bg_type="image" row_bg_color="#222222" color_row_height="content-height" row_style="light" bg_image="16224" bg_type="cover" parallax_image_height="window-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="light" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="70" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 10%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;" border_styling_global="default" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 16%;padding-left: 7%;padding-right: 7%;padding-bottom: 20%;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]
<p class="impact-text-large" style="text-align: center;"><span style="color: #ffffff;">Welcome to the Uplift Cafe</span></p>

<h3 style="text-align: center;"><span style="color: #ffffff;">bringing you the best in local organic &amp; responsibly sourced goodness, since 1982.</span></h3>
<p style="text-align: center;"><a class="read-more" href="/cafe-demo/about-the-cafe/">More about us</a></p>
[/spb_text_block] [spb_icon_box_grid columns="3" colour_style="light" width="1/1" el_position="first last"]

[spb_icon_box_grid_element title="Incredible Drinks" target="" link="/cafe-demo/food-and-drinks/" icon="svg-icon-picker-item outline-svg food-outline_cocktail"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Local Organic Food" target="" link="/cafe-demo/food-and-drinks/" icon="svg-icon-picker-item outline-svg food-outline_pizza-slice"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Sustainably Sourced" target="" link="/cafe-demo/about-the-cafe/" icon="svg-icon-picker-item outline-svg envir-outline_save-planet"][/spb_icon_box_grid_element]

[/spb_icon_box_grid] [/spb_row] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="color" row_bg_color="#ffffff" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="dark" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="no" simplified_controls="no" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_text_block title="Welcome" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_size="0" border_styling_global="default" width="1/3" el_position="first"]

<span style="line-height: 1.5;">Doce erat magna, aliquot vitae semper vitae, accusant vel nis. Viva mus pellen tesque orcisit met odio dictum eget kommod nulla cons equent. Prooien iaculis trirtique nis ut eleifend. Ut sum noluisse insolens appel lantur, discere eget kommod nulla cons equent. </span>

[uplift_button colour="black" type="standard" size="standard" link="http://uplift.swiftideas.com/purchase" target="_self" icon="sf-icon-reply" dropshadow="no" rounded="no" extraclass=""]Make a booking[/uplift_button]

[/spb_text_block] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 4%;padding-right: 4%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/3"]
<p class="impact-text" style="text-align: center;"><span style="color: #f5825e;">Get 10% off your first order when you subscribe</span></p>
<p style="text-align: center;">[hr]</p>
<p style="text-align: center;">[contact-form-7 id="15636" title="Sign up"]</p>
[/spb_text_block] [spb_text_block title="Opening Hours" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_size="0" border_styling_global="default" width="1/3" el_position="last"]

<strong>Monday-Tuesday-Wednesday</strong> 07.00-19.00
<strong>Thursday-Friday</strong> 07.00-20.00
<strong>Saturday</strong> 08.00-20.00
<strong>Sunday</strong> 08.00-19.00
Our kitchen is open until 6pm

Join us for a drink - it is happy hour from 17.30 till closing time every day!

[/spb_text_block] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_gallery title="Gallery" gallery_id="15080" display_type="slider" columns="5" fullwidth="no" gutters="yes" image_size="full" slider_transition="slide" show_thumbs="no" autoplay="yes" show_captions="no" enable_lightbox="no" width="1/1" el_position="first last"] [/spb_row] [spb_blank_spacer height="38px" width="1/1" el_position="first last"] [spb_blog_grid title="Follow us @uplift" item_count="2" twitter_username="swiftideas" instagram_id="1193751843" instagram_token="1193751843.5b9e1e6.c8c5c0a5df0e4d5687e389f24adb8643" fullwidth="no" width="1/1" el_position="first last"]');

	$prebuilt_templates["cafe-news"] = array(
		"id" => "cafe-news",
		"name" => "Cafe Demo - News & Events",
		"code" => '[spb_blog blog_type="masonry" gutters="yes" columns="3" fullwidth="no" item_count="12" category="All" offset="0" order_by="date" order="DESC" show_title="yes" show_excerpt="yes" show_details="yes" excerpt_length="17" content_output="excerpt" show_read_more="yes" social_integration="yes" twitter_username="swiftideas" instagram_id="1193751843" instagram_token="1193751843.5b9e1e6.c8c5c0a5df0e4d5687e389f24adb8643" blog_filter="no" pagination="none" width="1/1" el_position="first last"]');

$prebuilt_templates["cafe-menu"] = array(
		"id" => "cafe-menu", 
		"name" => "Cafe Demo - What's on the Menu",
		"code" => '[spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_text_block title="Starters" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 4%;padding-right: 4%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/3" el_position="first"]

[table type="standard_minimal"][trow][thcol][/thcol][thcol][/thcol][/trow][trow][tcol]<strong><span class="s1">Potted Shrimps</span></strong>[/tcol][tcol]$12[/tcol][/trow][trow][tcol]<strong><span class="s1">Goats Cheese Salad</span></strong>[/tcol][tcol]$18[/tcol][/trow][trow][tcol]<strong><span class="s1">Avocado Halloumi Wrap</span></strong>[/tcol][tcol]$8[/tcol][/trow][trow][tcol]<strong>Welsh Rarebit</strong>[/tcol][tcol]$24[/tcol][/trow][trow][tcol]<strong><span class="s1">Miso Soup</span></strong>[/tcol][tcol]$16[/tcol][/trow][trow][tcol]<b>Fried Calamari</b>[/tcol][tcol]$14[/tcol][/trow][/table]

[/spb_text_block] [spb_text_block title="Mains" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 4%;padding-right: 4%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/3"]

[table type="standard_minimal"][trow][thcol][/thcol][thcol][/thcol][/trow][trow][tcol]<strong><span class="s1">Club Sandwich</span></strong>[/tcol][tcol]$12[/tcol][/trow][trow][tcol]<b>Wild Mushroom Risotto</b>[/tcol][tcol]$18[/tcol][/trow][trow][tcol]<strong><span class="s1">Chicken Katsu Curry</span></strong>[/tcol][tcol]$8[/tcol][/trow][trow][tcol]<strong>Fish and Chips</strong>[/tcol][tcol]$24[/tcol][/trow][trow][tcol]<strong><span class="s1">Grilled Tuna</span></strong>[/tcol][tcol]$16[/tcol][/trow][trow][tcol]<b>Hanger Steak</b>[/tcol][tcol]$14[/tcol][/trow][/table]

[/spb_text_block] [spb_text_block title="Desserts" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 4%;padding-right: 4%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/3" el_position="last"]

[table type="standard_minimal"][trow][thcol][/thcol][thcol][/thcol][/trow][trow][tcol]<strong><span class="s1">Carrot Cake</span></strong>[/tcol][tcol]$12[/tcol][/trow][trow][tcol]<strong><span class="s1">Macaroon Selection</span></strong>[/tcol][tcol]$18[/tcol][/trow][trow][tcol]<strong><span class="s1">Date &amp; Walnut Cake</span></strong>[/tcol][tcol]$8[/tcol][/trow][trow][tcol]<strong>Ice Cream</strong>[/tcol][tcol]$24[/tcol][/trow][trow][tcol]<strong><span class="s1">Afogato</span></strong>[/tcol][tcol]$16[/tcol][/trow][/table]

[/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="60px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [spb_text_block title="White Wine" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 4%;padding-right: 4%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/2" el_position="first"]

[table type="standard_minimal"][trow][thcol][/thcol][thcol]125ml[/thcol][thcol]250ml[/thcol][thcol]Bottle[/thcol][/trow][trow][tcol]<span class="s1"><b>Wine</b></span>[/tcol][tcol]$20[/tcol][tcol]$40[/tcol][tcol]$120[/tcol][/trow][trow][tcol]<strong>Cloudy Bay Sauvignon</strong>[/tcol][tcol]$22[/tcol][tcol]$48[/tcol][tcol]$145[/tcol][/trow][trow][tcol]<strong>Chablis 1er Cru</strong>[/tcol][tcol]$32[/tcol][tcol]$66[/tcol][tcol]$180[/tcol][/trow][/table]

[/spb_text_block] [spb_text_block title="Red Wine" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 4%;padding-right: 4%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/2" el_position="last"]

[table type="standard_minimal"][trow][thcol][/thcol][thcol]125ml[/thcol][thcol]250ml[/thcol][thcol]Bottle[/thcol][/trow][trow][tcol]<strong><span class="s1">Red Wine 1</span></strong>[/tcol][tcol]$20[/tcol][tcol]$40[/tcol][tcol]$120[/tcol][/trow][trow][tcol]<strong><span class="s1">Chateau Margaux</span></strong>[/tcol][tcol]$22[/tcol][tcol]$48[/tcol][tcol]$145[/tcol][/trow][trow][tcol]<strong>Penfolds Grange</strong>[/tcol][tcol]$32[/tcol][tcol]$66[/tcol][tcol]$180[/tcol][/trow][/table]

[/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="60px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [spb_text_block title="Cocktails" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 4%;padding-right: 4%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/3" el_position="first"]

[table type="standard_minimal"][trow][thcol][/thcol][thcol][/thcol][/trow][trow][tcol]<strong><span class="s1">Pink Gin Fizz</span></strong>[/tcol][tcol]$12[/tcol][/trow][trow][tcol]<strong><span class="s1">Dirty Martini</span></strong>[/tcol][tcol]$18[/tcol][/trow][trow][tcol]<strong><span class="s1">Old Fashioned</span></strong>[/tcol][tcol]$8[/tcol][/trow][trow][tcol]<strong>Mint Julep</strong>[/tcol][tcol]$24[/tcol][/trow][trow][tcol]<strong><span class="s1">Bloody Mary</span></strong>[/tcol][tcol]$16[/tcol][/trow][trow][tcol]<b>Manhattan</b>[/tcol][tcol]$14[/tcol][/trow][/table]

[/spb_text_block] [spb_text_block title="Coffee &amp; Tea" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 4%;padding-right: 4%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/3"]

[table type="standard_minimal"][trow][thcol][/thcol][thcol][/thcol][/trow][trow][tcol]<strong><span class="s1">Filter Coffee</span></strong>[/tcol][tcol]$4.50[/tcol][/trow][trow][tcol]<b>Cappuccino</b>[/tcol][tcol]$6[/tcol][/trow][trow][tcol]<strong><span class="s1">Flat White</span></strong>[/tcol][tcol]$6[/tcol][/trow][trow][tcol]<strong>Espresso</strong>[/tcol][tcol]$4[/tcol][/trow][trow][tcol]<strong><span class="s1">Pot of Tea</span></strong>[/tcol][tcol]$16[/tcol][/trow][trow][tcol]<b>Earl Grey</b>[/tcol][tcol]$4[/tcol][/trow][/table]

[/spb_text_block] [spb_text_block title="Craft Beers" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 4%;padding-right: 4%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/3" el_position="last"]

[table type="standard_minimal"][trow][thcol][/thcol][thcol][/thcol][/trow][trow][tcol]<strong><span class="s1">Brooklyn Lager</span></strong>[/tcol][tcol]$20[/tcol][/trow][trow][tcol]<strong><span class="s1">Brewdog Punk IPA</span></strong>[/tcol][tcol]$18[/tcol][/trow][trow][tcol]<strong><span class="s1">Camden Pale Ale</span></strong>[/tcol][tcol]$25[/tcol][/trow][trow][tcol]<strong>Anchor Steam</strong>[/tcol][tcol]$24[/tcol][/trow][trow][tcol]<strong><span class="s1">Meantime Pale Ale</span></strong>[/tcol][tcol]$22[/tcol][/trow][trow][tcol]<b>Gamma Ray IPA</b>[/tcol][tcol]$23[/tcol][/trow][/table]

[/spb_text_block] [spb_divider type="thin" text="Go to top" top_margin="60px" bottom_margin="60px" fullwidth="no" width="1/1" el_position="first last"] [spb_blank_spacer responsive_vis="hidden-xs_hidden-sm" height="1px" width="1/4" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_size="0" border_styling_global="default" width="1/2" el_position="last"]
<h3 style="text-align: center;">If you have specific dietary requirements, please dont hesitate to ask us for help at <a href="#">help@uplift.com</a></h3>
[/spb_text_block]');



	$prebuilt_templates["goodsdemo-products"] = array(
		"id" => "goodsdemo-products",
		"name" => "Goods Demo - Products",
		"code" => '[spb_products asset_type="latest-products" category="Chairs" products="0" display_type="standard" display_layout="standard" multi_masonry="no" carousel="no" fullwidth="no" columns="4" item_count="12" order="DESC" button_enabled="no" width="1/1" el_position="first last"]');

	$prebuilt_templates["goodsdemo-journal"] = array(
		"id" => "goodsdemo-journal",
		"name" => "Goods Demo - The Journal",
		"code" => '[spb_recent_posts display_type="standard" carousel="no" item_columns="3" item_count="3" category="All" offset="0" posts_order="DESC" excerpt_length="32" fullwidth="no" gutters="yes" button_enabled="no" pagination="yes" width="1/1" el_position="first last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_recent_posts display_type="standard" carousel="no" item_columns="3" item_count="3" category="All" offset="3" posts_order="DESC" excerpt_length="32" fullwidth="no" gutters="yes" button_enabled="no" pagination="yes" width="1/1" el_position="first last"]');






	$prebuilt_templates["goodsdemo-about"] = array(
		"id" => "goodsdemo-about",
		"name" => "Goods Demo - About",
		"code" => '[spb_image image="128" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="no" fullwidth="no" overflow_mode="none" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/2" el_position="first"] [spb_column width="1/2" el_position="last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Lorem ipsum dolor sit amet isse potenti. Vesquam ante aliquet lacusemper elit. Cras neque nulla, convallis non.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum.

[/spb_text_block] [/spb_column] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_row element_name="Row" wrap_type="content-width" row_bg_type="image" row_bg_color="#222222" color_row_height="content-height" bg_image="17" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="80" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_el_class="no-shadow" minimize_row="no" simplified_controls="yes" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_styling_global="default" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 10%;padding-left: 14%;padding-right: 14%;padding-bottom: 10%;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

"Lorem ipsum dolor sit met, consectetur adipiscing elit. Integer imperdiet iaculis ipsum aliquet ultricies. Sed a tincidunt enim."
[/spb_text_block] [/spb_row] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 6%;padding-left: 0%;padding-right: 0%;padding-bottom: 2%;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Follow us @upliftgoods

[/spb_text_block] [spb_blog_grid item_count="1" instagram_id="1193751843" instagram_token="1193751843.5b9e1e6.c8c5c0a5df0e4d5687e389f24adb8643" fullwidth="no" width="1/1" el_position="first last"]');

	$prebuilt_templates["goodsdemo-contact"] = array(
		"id" => "goodsdemo-contact",
		"name" => "Goods Demo - Contact",
		"code" => '
		[spb_gmaps size="400" type="roadmap" zoom="14" map_controls="yes" advanced_styling="yes" style_array="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" saturation="color" fullscreen="yes" width="1/1" el_position="first last"] [spb_map_pin address="New York" pin_image="16042" width="1/1" el_position="first last"] This is a map pin. Click the edit button to change it. [/spb_map_pin] [/spb_gmaps] [spb_blank_spacer height="50px" width="1/1" el_position="first last"] [spb_text_block title="Drop us a line" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_size="0" border_styling_global="default" width="1/2" el_position="first"]
		[contact-form-7 id="15387" title="Contact form 1"]

[/spb_text_block] [spb_text_block title="Information" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_size="0" border_styling_global="default" width="1/4"]

Lorem ipsum dolor sit amet isse potenti. Vesquam ante aliquet lacusemper elit. Cras neque nulla, convallis non commodo et, euismod nonsese. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium.

[social]

[/spb_text_block] [spb_text_block title="Our address" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" border_size="0" border_styling_global="default" width="1/4" el_position="last"]

No.1 Abbey Road,
London,
W1 ECH
UK

Call: +44 (0) 800 123 4567
Email: info@swiftideas.net

[/spb_text_block]');



	$prebuilt_templates["landing-home"] = array(
	"id" => "landing-home",
	"name" => "Landing Demo - Home",
	"code" => '[spb_row element_name="Intro: Hero" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" row_style="dark" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="dark" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_responsive_vis="hidden-xs_hidden-sm" row_id="hero" row_name="hero" minimize_row="yes" simplified_controls="no" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 11%;padding-left: 0%;padding-right: 0%;padding-bottom: 9%;" border_styling_global="default" width="1/1" el_position="first last"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="no" border_styling_global="default" width="1/3" el_position="first"] [spb_animated_headline before_text="Introducing uplift. Building your site has never been" animated_strings="better,faster,easier,nicer" animation_type="clip" textstyle="impact-text" textalign="left" textcolor="#546e7a" width="1/1" el_position="first last"] [spb_blank_spacer height="40px" width="1/1" el_position="first last"] [spb_button button_text="View main demo" button_size="standard" button_colour="accent" button_type="standard" rounded="yes" button_dropshadow="no" button_icon="sf-icon-quickview" button_link="http://uplift.swiftideas.com/home/" button_target="_self" align="left" animation="none" animation_delay="0" width="1/1" el_position="first last"] [/spb_column] [spb_image image="129" image_size="full" image_width="750" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="2/3" el_position="last"] [/spb_row] [spb_row element_name="Intro: Icon Grid x 4" wrap_type="full-width" row_bg_type="color" color_row_height="content-height" row_style="dark" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="dark" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_responsive_vis="hidden-xs_hidden-sm" minimize_row="no" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_divider type="thin" text="Go to top" top_margin="0px" bottom_margin="0px" fullwidth="yes" width="1/1" el_position="first last"] [spb_icon_box_grid columns="4" colour_style="dark" el_class="pb0 mb0" width="1/1" el_position="first last"]

[spb_icon_box_grid_element title="Easy to use,
flexible & powerful" target="" link="#main1" icon="svg-icon-picker-item outline-svg design-outline_wand-99"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Fully Responsive
with fluid grid" target="" link="#main2" icon="svg-icon-picker-item outline-svg design-outline_tablet-mobile"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="A Page Builder
thats fast & simple" target="" link="#main3" icon="svg-icon-picker-item outline-svg business-outline_calculator"][/spb_icon_box_grid_element][spb_icon_box_grid_element title="Cutting edge features
& attention to detail" target="" link="#features" icon="svg-icon-picker-item outline-svg ui-1_zoom-split"][/spb_icon_box_grid_element]

[/spb_icon_box_grid] [/spb_row] [spb_row element_name="Main 1: Better, faster, less effort" wrap_type="full-width" row_bg_type="color" row_bg_color="#eceff1" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="dark" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="main1" minimize_row="yes" simplified_controls="no" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [spb_image image="121" image_size="full" image_width="1061" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="left" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/2" el_position="first"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="18" simplified_controls="no" border_styling_global="default" width="1/2" el_position="last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 0%;padding-bottom: 4%;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

A new theme thats as easy to use as it is flexible & powerful.
Welcome to uplift, our most accomplished theme yet. It has been intelligently engineered with performance in mind, coupled with our legendary attention to detail. The result isa true multi-purpose theme that is [highlight]suitable for all levels of experience.[/highlight] But dont take our word for it...

[/spb_text_block] [spb_button button_text="What people are saying" button_size="large" button_colour="accent" button_type="standard" rounded="yes" button_dropshadow="no" button_icon="sf-icon-quote" button_link="#reviews" button_target="_self" align="left" animation="none" animation_delay="0" width="1/1" el_position="first last"] [/spb_column] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Main 2: Mobile" wrap_type="full-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="main2" minimize_row="yes" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="18" simplified_controls="yes" border_styling_global="default" width="1/2" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 0%;padding-bottom: 4%;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

More than Responsive.
Built using the sleek, intuitive, and powerful Bootstrap framework, [highlight]Uplift will look great on any device.[/highlight] It also comes with the ability to control which devices certain elements are seen on and includes a Responsive Visibility Shortcode for extra control.

[/spb_text_block] [spb_button button_text="Responsive Visibility" button_size="large" button_colour="accent" button_type="standard" rounded="yes" button_dropshadow="no" button_icon="nucleo-icon-stretch" button_link="http://uplift.swiftideas.com/elements/responsive-visibility/" button_target="_self" align="left" animation="none" animation_delay="0" width="1/1" el_position="first last"] [/spb_column] [spb_image image="126" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="right" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/2" el_position="last"] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_image image="128" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="left" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/2" el_position="first"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="no" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 10%!important;padding-right: 10%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/2" el_position="last"] [spb_icon_box title="4 Mobile Header Layouts" box_type="vertical" box_icon_type="svg" svg_icon="design-outline_mobile-dev" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#7eced5" animated_box_style="coloured" animated_box_rounded="yes" width="1/1" el_position="first last"]

Choose from  Left Logo, Right Logo, Centred Logo (menu left, cart right) or Centred Logo (cart right, menu left.)

[/spb_icon_box] [spb_icon_box title="2 Mobile Menu Types" box_type="vertical" box_icon_type="svg" svg_icon="files-outline_single-copy-04" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#7eced5" animated_box_style="coloured" animated_box_rounded="yes" width="1/1" el_position="first last"]

Choose from Slideout or Overlay. Both can accomodate search box, translate, cart and account options.

[/spb_icon_box] [spb_icon_box title="Gesture Compatible" box_type="vertical" box_icon_type="svg" svg_icon="gestures-outline_scroll-horitontal" animate_svg="no" target="_self" animation="none" animation_delay="0" icon_color="#7eced5" animated_box_style="coloured" animated_box_rounded="yes" width="1/1" el_position="first last"]

Uplift can be used intuitively on mobile devices, so users can swipe their way through your content.

[/spb_icon_box] [/spb_column] [spb_blank_spacer height="140px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Main 3: Pagebuilder" wrap_type="full-width" row_bg_type="color" row_bg_color="#eceff1" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="main3" minimize_row="yes" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [spb_column col_animation="none" col_animation_delay="600" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="20" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/2" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Building the easy way.
[highlight]No coding or design knowledge required![/highlight] Our newly improved Page Builder will save you time and its now even easier to use. It comes loaded with 54 useful elements and the following:

[/spb_text_block] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 2%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

[one_half] [list extraclass=""] [list_item icon="nucleo-icon-check"]Frequently Used Elements[/list_item] [list_item icon="nucleo-icon-check"]History & Undo functionality[/list_item] [list_item icon="nucleo-icon-check"]Simple &  Intuitive to use[/list_item] [/list] [/one_half] [one_half_last] [list extraclass=""] [list_item icon="nucleo-icon-check"] 42 Pre-built pages[/list_item] [list_item icon="nucleo-icon-check"]Save your elements & pages[/list_item] [list_item icon="nucleo-icon-check"]Visual Composer included[/list_item] [/list] [/one_half_last]

[/spb_text_block] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 0%;padding-bottom: 2%;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

[uplift_button colour="accent" type="standard" size="large" link="http://pagebuilder.swiftideas.com/" target="_blank" icon="sf-icon-reply" dropshadow="no" rounded="yes" extraclass=""]Take A Test Drive[/uplift_button] [uplift_button colour="accent" type="bordered" size="large" link="#demos" target="_self" icon="sf-icon-quickview" dropshadow="no" rounded="yes" extraclass=""]See What We Built[/uplift_button]

[/spb_text_block] [/spb_column] [spb_image image="127" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="right" link_target="_self" lightbox="no" intro_animation="none" animation_delay="600" width="1/2" el_position="last"] [spb_blank_spacer height="140px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Demos" wrap_type="content-width" row_bg_type="color" row_bg_color="#455a64" color_row_height="content-height" row_style="light" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="light" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="demos" minimize_row="yes" simplified_controls="no" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 4%;padding-left: 0%;padding-right: 0%;padding-bottom: 4%;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Stunning Demos
Included free and easy to setup with our one-click demo install

[/spb_text_block] [spb_portfolio display_type="multi-size-masonry" multi_size_ratio="4/3" fullwidth="no" gutters="yes" columns="3" show_title="yes" show_subtitle="yes" show_excerpt="yes" hover_show_excerpt="no" excerpt_length="20" item_count="9" category="All" order_by="none" order="DESC" portfolio_filter="no" pagination="none" button_enabled="yes" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

More coming soon!

[/spb_text_block] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [spb_promo_bar display_type="promo-button" promo_bar_text="Crank your power to the max" promo_bar_text_size="standard" btn_text="Purchase Uplift" btn_color="accent" btn_type="rounded" href="http://uplift.swiftideas.com/purchase" target="_self" bg_color="#37474f" text_color="#7dced4" page_align="no" fullwidth="yes" width="1/1" el_position="first last"]

Enter your text here

[/spb_promo_bar] [/spb_row] [spb_row element_name="Features 1: Pagebuilder, Page Headers, Performance" wrap_type="content-width" row_bg_type="color" row_bg_color="#eceff1" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="dark" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="features" minimize_row="yes" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 9%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 4%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Features and Details
[/spb_text_block] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="first"] [spb_image element_name="pb img" image="107" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="pb" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Pagebuilder with 54 elements

Uplift makes it easy to create beautiful pages with our new improved Pagebuilder. Its super easy to use and comes with a host of useful features.

[uplift_button colour="accent" type="bordered" size="standard" link="#main3" target="_self" icon="sf-icon-up-chevron" dropshadow="no" rounded="yes" extraclass=""]Find out more[/uplift_button]

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3"] [spb_image element_name="page headers img" image="84" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="page headers" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

3 Page Header Styles

For added flexibility Uplift comes with 3 different types of page header: Standard, Hero and our new innovative App-style page header.

[uplift_button colour="accent" type="standard" size="standard" link="http://uplift.swiftideas.com/pages/our-offices/" target="_self" icon="nucleo-icon-link" dropshadow="no" rounded="yes" extraclass=""]See example[/uplift_button]

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="last"] [spb_image element_name="performance img" image="106" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="performance" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Accelerated Performance

Uplift is SEO optimised and built with clean, semantic HTML5 code. It performs with optional speed with sacrificing style and features.

[uplift_button colour="accent" type="standard" size="standard" link="#" target="_self" icon="nucleo-icon-file" dropshadow="no" rounded="yes" extraclass=""]See report[/uplift_button]

[/spb_text_block] [/spb_column] [/spb_row] [spb_row element_name="Features 2: Shop: Headers, Pages" wrap_type="content-width" row_bg_type="color" row_bg_color="#eceff1" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="dark" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="features2" minimize_row="yes" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="50px" responsive_vis="hidden-xs_hidden-sm" width="1/1" el_position="first last"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="first"] [spb_image element_name="Shop img" image="82" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="Shop" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

3 Shop Styles + 3 Product Posts

Selling has never been easier or looked as good! Choose from Standard, Multi-Masonry or Thumb Slider shop styles. And Standard, Full-screen or Extended product posts.

[uplift_button colour="accent" type="standard" size="standard" link="http://uplift.swiftideas.com/shop/" target="_self" icon="nucleo-icon-link" dropshadow="no" rounded="yes" extraclass=""]See example[/uplift_button]

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3"] [spb_image element_name="Headers img" image="98" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="Headers" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 2%;padding-right: 2%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

10+ Header Types

Go full-width or site-width, go transparent (light or dark), go vertical. Have a top bar or sticky option, sticky resizing, sticky show/hide. Customise further with our drag-n-drop configurator.

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="last"] [spb_image element_name="pre-built pages img" image="80" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="pre-built pages" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

42+ Pre-built Pages

Uplift comes loaded with 42 impressive pre-built pages designed for a wide range of uses. It also includes 20+ stunning standard pages, beautifully crafted and ready to use.

[uplift_button colour="accent" type="standard" size="standard" link="http://uplift.swiftideas.com/pages/about-us/" target="_self" icon="nucleo-icon-link" dropshadow="no" rounded="yes" extraclass=""]See example[/uplift_button]

[/spb_text_block] [/spb_column] [/spb_row] [spb_row element_name="Features 3: Push navs, Team AJAX, Nucleo" wrap_type="content-width" row_bg_type="color" row_bg_color="#eceff1" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="dark" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="features3" minimize_row="yes" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="50px" responsive_vis="hidden-xs_hidden-sm" width="1/1" el_position="first last"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="first"] [spb_image element_name="Push Navs img" image="78" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="push nav" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

6 Types of Creative Navigation

3 types of Push navigation (full-page, 1/4 and mini.) Also includes 2 Slideout Menus & the Overlay menu.

[uplift_button colour="accent" type="standard" size="standard" link="http://uplift.swiftideas.com/" target="_self" icon="nucleo-icon-link" dropshadow="no" rounded="yes" extraclass=""]See example[/uplift_button]

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3"] [spb_image element_name="Team ajax img" image="79" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="team ajax" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Team AJAX Slideout

Show off your team members in style with Uplifts ajax team member bio slideout!

[uplift_button colour="accent" type="standard" size="standard" link="/pages/meet-the-team/" target="_self" icon="nucleo-icon-link" dropshadow="no" rounded="yes" extraclass=""]See example[/uplift_button]

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="last"] [spb_image element_name="nucleo img" image="104" image_size="full" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="nucleo icons" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Incredible Nucleo SVG Icons

400+ incredible Nucleo SVG icons. Available in 2 styles (stroke and full colour) and animated!

[uplift_button colour="accent" type="standard" size="standard" link="http://uplift.swiftideas.com/elements/icon-boxes/" target="_self" icon="nucleo-icon-link" dropshadow="no" rounded="yes" extraclass=""]See example[/uplift_button]

[/spb_text_block] [/spb_column] [/spb_row] [spb_row element_name="Features 4: Blog, One Page, Port" wrap_type="content-width" row_bg_type="color" row_bg_color="#eceff1" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="dark" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="features4" minimize_row="yes" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="50px" responsive_vis="hidden-xs_hidden-sm" width="1/1" el_position="first last"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="first"] [spb_image element_name="Blog img" image="76" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="Blog" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

10+ Blog Variations

Choose from Timeline, Masonry or Standard (with alternative styling.) Each available in a variety of options and with or without sidebars.

[uplift_button colour="accent" type="standard" size="standard" link="/blog/blog-timeline-full-width/" target="_self" icon="nucleo-icon-link" dropshadow="no" rounded="yes" extraclass=""]See example[/uplift_button]

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3"] [spb_image element_name="one page nav img" image="24" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="One Page nav" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

2 One-Page Navigation Styles

Uplift comes with 2 different types of one-page navigation. Standard with text tooltips and Counter with arrows.

[uplift_button colour="accent" type="standard" size="standard" link="/home/home-start-up/" target="_self" icon="nucleo-icon-link" dropshadow="no" rounded="yes" extraclass=""]See example[/uplift_button]

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="last"] [spb_image element_name="Port img" image="77" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="Port" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

14+ Portfolio Styles

From 2, 3 & 4 columns,Standard, Gallery, Masonry, Multi-Size Masonry, Boxed or Full Width, with or without borders.

[uplift_button colour="accent" type="standard" size="standard" link="/portfolio/portfolio-three-column-gallery/" target="_self" icon="nucleo-icon-link" dropshadow="no" rounded="yes" extraclass=""]See example[/uplift_button]

[/spb_text_block] [/spb_column] [/spb_row] [spb_row element_name="Features 5: Fonts, Retina, Translate" wrap_type="content-width" row_bg_type="color" row_bg_color="#eceff1" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="dark" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="features5" minimize_row="yes" simplified_controls="no" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 1%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="50px" responsive_vis="hidden-xs_hidden-sm" width="1/1" el_position="first last"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="no" border_styling_global="default" width="1/3" el_position="first"] [spb_image element_name="Fonts img" image="71" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="fonts" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

700+ Free Google Fonts

Choose from a huge selection of FREE Google fonts. Easily preview them and adjust the weight, size, line-height, letter-spacing and colour.

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="no" border_styling_global="default" width="1/3"] [spb_image element_name="Retina-Ready" image="74" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="Retina-Ready" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Completely Retina-Ready

We have taken great care to ensure that Uplift is fully retina-ready. So now matter what device it is being viewed on, it will always look great.

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="no" border_styling_global="default" width="1/3" el_position="last"] [spb_image element_name="Translate" image="27" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="translate" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

100% Translatable

Uplift is fully translatable using the WPML plugin and includes RTL Support. So you can truly connect with a global audience!

[/spb_text_block] [/spb_column] [/spb_row] [spb_row element_name="Features 6: Sliders, Responsive, Colours" wrap_type="content-width" row_bg_type="color" row_bg_color="#eceff1" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="dark" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="features6" minimize_row="yes" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="50px" responsive_vis="hidden-xs_hidden-sm" width="1/1" el_position="first last"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="first"] [spb_image element_name="Sliders img" image="73" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="Sliders" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

2 Awesome Sliders

Choose from the infamous Revolution Slider, and of course our new and improved Swift Slider.

[uplift_button colour="accent" type="standard" size="standard" link="http://uplift.swiftideas.com/" target="_self" icon="nucleo-icon-link" dropshadow="no" rounded="yes" extraclass=""]See example[/uplift_button]

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3"] [spb_image element_name="respsonsive img" image="109" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="respsonsive" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Fully Responsive

So your customers will have the same stunning functionality whatever device they are using.

[uplift_button colour="accent" type="bordered" size="standard" link="#main2" target="_self" icon="sf-icon-up-chevron" dropshadow="no" rounded="yes" extraclass=""]Find out more[/uplift_button]

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="last"] [spb_image element_name="colours img" image="68" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="Colours" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Unlimited Colours

Uplift can be completely customised using the Coloriser to create a unique look. Or you can use one of our 7 preset colour schemes.

[/spb_text_block] [/spb_column] [/spb_row] [spb_row element_name="Features 7: PSDs, Browsers, Support" wrap_type="content-width" row_bg_type="color" row_bg_color="#eceff1" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="dark" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="features7" minimize_row="yes" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="50px" responsive_vis="hidden-xs_hidden-sm" width="1/1" el_position="first last"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="first"] [spb_image element_name="PSDs img" image="65" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="PSDs" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

12 PSDs Included

Uplift includes PSDs containing all of Page Builder elements, shortcodes etc. All are well organised and clearly labelled.

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3"] [spb_image element_name="browsers img" image="67" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="Browsers" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Fully Browser Compatible

Uplift has been rigorously tried and tested on all major browsers to ensure it is compatible and consistent.

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="last"] [spb_image element_name="support img" image="66" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="Support" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Were here to help

We pride ourselves on professional and timely support. If you have any pre-sales questions or need any help, do not hesitate to ask.

[/spb_text_block] [/spb_column] [/spb_row] [spb_row element_name="Features 8: Mega Menu, Video Tuts, Child Theme" wrap_type="content-width" row_bg_type="color" row_bg_color="#eceff1" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="dark" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="features8" minimize_row="yes" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="50px" responsive_vis="hidden-xs_hidden-sm" width="1/1" el_position="first last"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="first"] [spb_image element_name="mega menu img" image="124" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="Mega Menu" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Mega Menu

Uplift allows you to roll out a super slick and extremely flexible mega menu. It can display menus from 1 to 8 columns, and even show widgets!

[uplift_button colour="accent" type="standard" size="standard" link="http://uplift.swiftideas.com/" target="_self" icon="nucleo-icon-link" dropshadow="no" rounded="yes" extraclass=""]See example[/uplift_button]

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3"] [spb_image element_name="video tuts img" image="103" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="Video tutorials" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Video Tutorials

As intuitive as Uplift is, we have provided a range of HD narrated tutorial videos. These cover a range of subjects, from basics to advanced tips & tricks.

[uplift_button colour="accent" type="standard" size="standard" link="https://vimeo.com/swiftideas/videos/" target="_self" icon="nucleo-icon-video" dropshadow="no" rounded="yes" extraclass=""]See Videos[/uplift_button]

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="last"] [spb_image element_name="child theme img" image="101" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="Child theme" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Child Theme

Uplift comes with a child theme ready to use out of the box. Highly recommended if you are planning template or large css changes.

[/spb_text_block] [/spb_column] [/spb_row] [spb_row element_name="Features 9: Midnight, Admin Panel, BBpress" wrap_type="content-width" row_bg_type="color" row_bg_color="#eceff1" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_header_style="dark" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="false" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="features9" minimize_row="yes" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="50px" responsive_vis="hidden-xs_hidden-sm" width="1/1" el_position="first last"] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="first"] [spb_image element_name="midnight img" image="85" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="Retina-Ready" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Midnight Header

Uplifts header can change from light to dark (and vice versa) depending on the colour of the content under it. (see it action on this page!)

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3"] [spb_image element_name="admin panel img" image="69" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="admin panel" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Advanced Admin Panel

Customise Uplift even further with a plethora of advanced options, settings & powerful page meta.

[/spb_text_block] [/spb_column] [spb_column col_animation="none" col_animation_delay="0" col_bg_type="cover" col_parallax_image_movement="fixed" col_parallax_image_speed="0.5" col_padding="0" simplified_controls="yes" border_styling_global="default" width="1/3" el_position="last"] [spb_image element_name="colours img" image="105" image_size="full" image_width="360" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/1" el_position="first last"] [spb_text_block element_name="Colours" animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 2%!important;padding-right: 2%!important;padding-bottom: 0%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

bbpress Compatible

Uplift is bbPress compatible so you can setup your forum without any hassle.

[/spb_text_block] [/spb_column] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Additional Features" wrap_type="content-width" row_bg_type="color" row_bg_color="#78909c" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" minimize_row="yes" simplified_controls="no" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 2%;padding-left: 0%;padding-right: 0%;padding-bottom: 2%;" border_styling_global="default" width="1/1" el_position="first last"] [spb_text_block element_name="but wait theres more!" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 2%;padding-left: 0%;padding-right: 0%;padding-bottom: 2%;" border_size="0" border_styling_global="default" width="1/2" el_position="first"]

But wait, theres more!

[/spb_text_block] [spb_text_block element_name="modal button" animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 4%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/2" el_position="last"]

[uplift_modal header="Additional Features" btn_colour="white" btn_type="standard" btn_size="large" btn_icon="nucleo-icon-copy" btn_text="See additional features"] [one_half] [list extraclass=""] [list_item icon="sf-icon-check"]Global Banner[/list_item] [list_item icon="sf-icon-check"]Subscribe Bar[/list_item] [list_item icon="sf-icon-check"]iLightbox Included[/list_item] [list_item icon="sf-icon-check"]Total Product Control[/list_item] [list_item icon="sf-icon-check"]Slick Add to cart Process[/list_item] [list_item icon="sf-icon-check"]5 Cart Animations[/list_item] [list_item icon="sf-icon-check"]Loaded with Shortcodes[/list_item] [list_item icon="sf-icon-check"]41 CSS3 Animations[/list_item] [list_item icon="sf-icon-check"]RTL Support[/list_item] [list_item icon="sf-icon-check"]Custom Font Integration[/list_item] [list_item icon="sf-icon-check"]Typographic Control[/list_item] [list_item icon="sf-icon-check"]Social Integration[/list_item] [list_item icon="sf-icon-check"]SEO Optimised[/list_item] [list_item icon="sf-icon-check"]5 Logo Animations[/list_item] [list_item icon="sf-icon-check"]Boxed/Full-width Layout[/list_item] [list_item icon="sf-icon-check"]Mini Header[/list_item] [list_item icon="sf-icon-check"]Inner/Outer Page Backgrounds[/list_item] [list_item icon="sf-icon-check"]Single, Dual or No Sidebars[/list_item] [list_item icon="sf-icon-check"]Advanced Footer[/list_item] [list_item icon="sf-icon-check"]10 Custom Widgets[/list_item] [list_item icon="sf-icon-check"]Custom 404 Pages[/list_item] [list_item icon="sf-icon-check"]LoveIt / Likes support[/list_item] [list_item icon="sf-icon-check"]Gradient Overlays[/list_item] [list_item icon="sf-icon-check"]Custom CSS/JS[/list_item] [list_item icon="sf-icon-check"]2 Types of Search[/list_item] [list_item icon="sf-icon-check"]Header show/hide[/list_item] [list_item icon="sf-icon-check"]Custom Admin Logo support[/list_item] [list_item icon="sf-icon-check"]Preluders + Page Transitions[/list_item] [list_item icon="sf-icon-check"]Pre-minified stylesheets/scripts[/list_item] [list_item icon="sf-icon-check"]Video Background Support (mp4, web, ogg)[/list_item] [/list] [/one_half] [one_half_last] [list extraclass=""] [list_item icon="sf-icon-check"]1-6 Column Support[/list_item] [list_item icon="sf-icon-check"]Custom Parallax Types[/list_item] [list_item icon="sf-icon-check"]Visual Composer Compatible[/list_item] [list_item icon="sf-icon-check"]Detailed Documentation[/list_item] [list_item icon="sf-icon-check"]Contact 7 Forms support[/list_item] [list_item icon="sf-icon-check"]Gravity Forms Support[/list_item] [list_item icon="sf-icon-check"]7 Colour Schemes[/list_item] [list_item icon="sf-icon-check"]Unlimited Custom Menus[/list_item] [list_item icon="sf-icon-check"]Shortcode Generator[/list_item] [list_item icon="sf-icon-check"]Smooth Scroll deep links[/list_item] [list_item icon="sf-icon-check"]Sticky Header [/list_item] [list_item icon="sf-icon-check"]Mobile 2 Click[/list_item] [list_item icon="sf-icon-check"]Back To Top[/list_item] [list_item icon="sf-icon-check"]2 Sidebar Widths[/list_item] [list_item icon="sf-icon-check"]Sticky Sidebars[/list_item] [list_item icon="sf-icon-check"]Breadcrumbs on/off[/list_item] [list_item icon="sf-icon-check"]Custom favicon[/list_item] [list_item icon="sf-icon-check"]Custom iOS Logos[/list_item] [list_item icon="sf-icon-check"]Front End Switcher[/list_item] [list_item icon="sf-icon-check"]2 Maintenance Modes[/list_item] [list_item icon="sf-icon-check"]Full-width Headers[/list_item] [list_item icon="sf-icon-check"]Vertical Headers[/list_item] [list_item icon="sf-icon-check"]Super Search[/list_item] [list_item icon="sf-icon-check"]Custom Font Support[/list_item] [list_item icon="sf-icon-check"]Custom Iconfont Support[/list_item] [list_item icon="sf-icon-check"]Custom Post Types[/list_item] [list_item icon="sf-icon-check"]Custom Self-hosted Audio Player[/list_item] [list_item icon="sf-icon-check"]Custom Self-hosted Video Player[/list_item] [list_item icon="sf-icon-check"]Site Width in pixels or percentage[/list_item] [list_item icon="sf-icon-check"]Full-screen Video Player (Vimeo & YouTube)[/list_item] [/list] [/one_half_last]

[/uplift_modal]

[/spb_text_block] [/spb_row] [spb_row element_name="Testimonials" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="reviews" minimize_row="yes" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 9%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 4%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

What people are saying
[/spb_text_block] [spb_testimonial_carousel item_count="6" order="date" category="All" page_link="no" showcase="yes" width="1/1" el_position="first last"] [spb_blank_spacer height="120px" width="1/1" el_position="first last"] [/spb_row] [spb_section element_name="Purchase" spb_section_id="19" width="1/1" el_position="first last"] [spb_row element_name="F.A.Q.s" wrap_type="content-width" row_bg_type="color" color_row_height="content-height" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="fixed" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="0" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="faqs" row_name="faqs" minimize_row="yes" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 9%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 4%!important;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

Frequently Asked Questions
[/spb_text_block] [spb_icon_box element_name="colour scheme" title="Can I change the theme colour scheme?" box_type="vertical" box_icon_type="svg" svg_icon="design-outline_palette" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#7eced5" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="first"]

Yes - we utilise the WordPress Customiser for all our colour controls. We also provide functionality which allows you to export/import and save multiple colour schemes.

[/spb_icon_box] [spb_icon_box element_name="child theme?" title="Is a child theme supplied?" box_type="vertical" box_icon_type="svg" svg_icon="design-outline_path-exclude" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#7eced5" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="last"]

Yes, a child theme is provided and ready to use out of the box. We highly recommend using a child theme if you are planning on making any template changes or large css changes.

[/spb_icon_box] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box element_name="pagebuilder?" title="Is a page builder included?" box_type="vertical" box_icon_type="svg" svg_icon="ui-2_tile-56" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#7eced5" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="first"]

Yes, not one - but two! We include our very own Swift Page Builder which we highly recommend due to the tight integration with the theme. We also include Visual Composer for those who prefer it.

[/spb_icon_box] [spb_icon_box element_name="translatable?" title="How can the theme be translated?" box_type="vertical" box_icon_type="svg" svg_icon="location-outline_world" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#7eced5" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="last"]

We provide language files for you to translate, and Uplift is also compatible with WPML, Polylang, and other translation plugins should you wish to use those.

[/spb_icon_box] [spb_blank_spacer height="30px" width="1/1" el_position="first last"] [spb_icon_box element_name="one-click demo install?" title="Does it have one-click demo install?" box_type="vertical" box_icon_type="svg" svg_icon="media-1_touch" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#7eced5" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="first"]

A one-click demo content importer plugin is included with the theme, so that you can import any of the demo sites within a few clicks, and then remove the plugin when not needed.

[/spb_icon_box] [spb_icon_box element_name="auto-update?" title="Does it have auto-update functionality?" box_type="vertical" box_icon_type="svg" svg_icon="arrows-1_refresh-69" animate_svg="yes" target="_self" animation="none" animation_delay="0" icon_color="#7eced5" animated_box_style="coloured" animated_box_rounded="yes" width="1/2" el_position="last"]

Yes, you never need to manually upload the latest theme updates. All updates are handled in the same manner as plugin updates, within Dashboard > Updates of your WordPress Admin.

[/spb_icon_box] [spb_blank_spacer height="60px" width="1/1" el_position="first last"] [spb_button button_text="Got a question? Ask us" button_size="large" button_colour="accent" button_type="standard" rounded="yes" button_dropshadow="no" button_icon="nucleo-icon-speech" button_link="#" button_target="_self" align="center" animation="none" animation_delay="0" width="1/1" el_position="first last"] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="About Us" wrap_type="content-width" row_bg_type="image" row_bg_color="#263238" color_row_height="content-height" bg_image="39" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="color" row_overlay_opacity="90" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="no" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="about" minimize_row="yes" simplified_controls="yes" custom_css="margin-top: 0%!important;margin-left: 0%!important;margin-right: 0%!important;margin-bottom: 0%!important;border-top: 0px default !important;border-left: 0px default !important;border-right: 0px default !important;border-bottom: 0px default !important;padding-top: 0%!important;padding-left: 0%!important;padding-right: 0%!important;padding-bottom: 0%!important;background-color:undefined!important;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="90px" width="1/1" el_position="first last"] [spb_blank_spacer height="1px" width="1/3" el_position="first"] [spb_image image="56" image_size="full" image_width="67" frame="noframe" caption_pos="hover" remove_rounded="yes" fullwidth="no" overflow_mode="none" el_class="pb0 mb0" link_target="_self" lightbox="no" intro_animation="none" animation_delay="200" width="1/3"] [spb_blank_spacer height="1px" width="1/3" el_position="last"] [spb_blank_spacer height="1px" width="1/6" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="no" custom_css_percentage="yes" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="2/3" el_position="last"]

Uplift is a product by Swift Ideas

Our themes power more than 33,000 websites all over the world
More about us

[/spb_text_block] [spb_blank_spacer height="110px" width="1/1" el_position="first last"] [/spb_row] [spb_row element_name="Outro" wrap_type="content-width" row_bg_type="color" row_bg_color="#222222" color_row_height="content-height" row_style="light" bg_image="39" bg_type="cover" parallax_image_height="content-height" parallax_image_movement="scroll" parallax_image_speed="0.5" bg_video_loop="yes" parallax_video_height="window-height" row_top_style="none" row_bottom_style="none" parallax_video_overlay="none" row_overlay_opacity="90" row_padding_vertical="0" row_padding_horizontal="0" row_margin_vertical="0" remove_element_spacing="yes" vertical_center="true" inner_column_height="col-natural" row_expanding="no" row_animation="none" row_animation_delay="0" row_id="end" minimize_row="yes" simplified_controls="yes" custom_css="margin-top: 0px;margin-bottom: 0px;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0px;padding-left: 0px;padding-right: 0px;padding-bottom: 0px;" border_styling_global="default" width="1/1" el_position="first last"] [spb_blank_spacer height="70px" width="1/1" el_position="first last"] [spb_column simplified_controls="yes" border_styling_global="default" width="1/2" el_position="first"] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" custom_css="margin-top: 0%;margin-bottom: 0%;border-top: 0px default ;border-left: 0px default ;border-right: 0px default ;border-bottom: 0px default ;padding-top: 0%;padding-left: 0%;padding-right: 0%;padding-bottom: 0%;" border_size="0" border_styling_global="default" width="1/1" el_position="first last"]

[one_half]

&copy;[the-year] Uplift - by Swift Ideas

[/one_half] [one_half_last]

Made with Love in the U.K.

[/one_half_last]

[/spb_text_block] [spb_blank_spacer height="8px" width="1/1" el_position="first last"] [/spb_column] [spb_text_block animation="none" animation_delay="0" simplified_controls="yes" custom_css_percentage="no" padding_vertical="0" padding_horizontal="0" margin_vertical="0" border_size="0" border_styling_global="default" width="1/4"]

[social]
[/spb_text_block] [spb_button button_text="Purchase Uplift" button_size="standard" button_colour="lightgrey" button_type="bordered" rounded="yes" button_dropshadow="no" button_icon="sf-icon-cart" button_link="http://uplift.swiftideas.com/purchase" button_target="_self" align="center" animation="none" animation_delay="0" width="1/4" el_position="last"] [spb_blank_spacer height="50px" width="1/1" el_position="first last"] [/spb_row]');
		
		return $prebuilt_templates;
	}
	add_filter('spb_prebuilt_templates', 'uplift_spb_templates');
    