<?php

    /*
    *
    *	Breacrumbs
    *	------------------------------------------------
    *	Swift Framework v3.0
    * 	Copyright Swift Ideas 2015 - http://www.swiftideas.com
    *
    *	uplift_breadcrumbs()
    *
    */


    /* PAGE HEADING
    ================================================== */
    if ( ! function_exists( 'uplift_breadcrumbs' ) ) {
        function uplift_breadcrumbs( $alt = false ) {

            global $post;
            $uplift_options = uplift_get_theme_opts();

            $remove_breadcrumbs = false;
			$breadcrumb_in_heading = true;
			if ( isset( $uplift_options['breadcrumb_in_heading'] ) ) {
				$breadcrumb_in_heading = $uplift_options['breadcrumb_in_heading'];
			}
			
			// Remove breadcrumbs
            if ( $post && is_singular() ) {
                $remove_breadcrumbs = uplift_get_post_meta( $post->ID, 'sf_no_breadcrumbs', true );
            }
            
            // Breadcrumb in heading
            if ( $breadcrumb_in_heading && !$alt ) {
				return;
            }

            if ( ! $remove_breadcrumbs ) {
                if ( function_exists( 'bcn_display' ) ) {
                    ?>
                    <div id="breadcrumbs">
                        <div class="container"><?php bcn_display(); ?></div>
                    </div>
                <?php } else if ( function_exists( 'yoast_breadcrumb' ) ) { ?>
                    <div id="breadcrumbs">
                        <div class="container"><?php yoast_breadcrumb( "", "" ); ?></div>
                    </div>
                <?php
                }
            }

        }

        add_action( 'uplift_main_container_start', 'uplift_breadcrumbs', 20 );
    }
?>