<?php
    /*
    *
    *	Footer Functions
    *	------------------------------------------------
    *	Swift Framework
    * 	Copyright Swift Ideas 2015 - http://www.swiftideas.com
    *
    *	uplift_footer_promo()
    *	uplift_footer_widgets()
    *	uplift_footer_copyright()
    *	uplift_one_page_nav()
    *	uplift_back_to_top()
    *	uplift_fw_video_area()
    *	uplift_inf_scroll_params()
    *	uplift_included()
    *	uplift_option_parameters()
    *	uplift_countdown_shortcode_locale()
    *	uplift_loveit_locale()
    *
    */

    /* NEWSLETTER/SUBSCRIBE BAR
    ================================================== */
    if ( ! function_exists( 'uplift_newsletter_bar' ) ) {
        function uplift_newsletter_bar() {
            global $post;
            $uplift_options = uplift_get_theme_opts();
			$enable_newsletter_sub_bar = $enable_newsletter_bar_page = false;

			if ( isset($uplift_options['enable_newsletter_sub_bar']) ) {
            	$enable_newsletter_sub_bar  = $uplift_options['enable_newsletter_sub_bar'];
            }

			if ( is_page() && $post ) {
            	$enable_newsletter_bar_page = uplift_get_post_meta($post->ID, 'sf_enable_newsletter_bar', true);
			}
			
			if ( isset($uplift_options['enable_newsletter_sub_bar_globally']) ) {
				$enable_newsletter_bar_page  = $uplift_options['enable_newsletter_sub_bar_globally'];
			}

            if ( ( $enable_newsletter_sub_bar && ( is_home() || is_front_page() ) ) || $enable_newsletter_bar_page ) {
            	$sub_bar_text 				= $uplift_options['sub_bar_text'];
            	$sub_bar_code 				= $uplift_options['sub_bar_code'];
            	$fullwidth_header    		= $uplift_options['fullwidth_header'];
                $page_layout             = $uplift_options['page_layout'];
                if ( isset( $_GET['layout'] ) ) {
                    $page_layout = $_GET['layout'];
                }
                ?>
                <!--// OPEN #sf-newsletter-bar //-->
                <div id="sf-newsletter-bar">

                	<?php if ( !$fullwidth_header || $page_layout == "boxed" ) { ?>
                	<div class="container">
                	<?php } ?>
                		<h3 class="sub-text"><?php echo esc_attr($sub_bar_text); ?></h3>
                		<div class="sub-code"><?php echo do_shortcode($sub_bar_code); ?></div>
                		<a href="#" class="sub-close"><i class="sf-icon-close"></i></a>

                	<?php if ( !$fullwidth_header || $page_layout == "boxed" ) { ?>
                	</div>
                	<?php } ?>

                    <!--// CLOSE #sf-newsletter-bar //-->
                </div>
            <?php
            }

        }

        add_action( 'uplift_after_page_container', 'uplift_newsletter_bar', 30 );
    }


    /* FOOTER PROMO
    ================================================== */
    if ( ! function_exists( 'uplift_footer_promo' ) ) {
        function uplift_footer_promo() {
        
        	global $post;
        	if ( $post ) {
        	    $remove_promo_bar    = uplift_get_post_meta( $post->ID, 'sf_remove_promo_bar', true );
        	    if ( $remove_promo_bar ) {
        	    	return;
        	    }
        	}
        	
            $uplift_options = uplift_get_theme_opts();

			$footer_promo_bar_text_size = "impact-text";
			$footer_promo_bar_button_type = "drop-shadow";

            $enable_footer_promo_bar        = $uplift_options['enable_footer_promo_bar'];
            $footer_promo_bar_type          = $uplift_options['footer_promo_bar_type'];
            $footer_promo_bar_text          = $uplift_options['footer_promo_bar_text'];
            $footer_promo_bar_button_color  = $uplift_options['footer_promo_bar_button_color'];
            $footer_promo_bar_button_text   = $uplift_options['footer_promo_bar_button_text'];
            $footer_promo_bar_button_link   = $uplift_options['footer_promo_bar_button_link'];
            $footer_promo_bar_button_target = $uplift_options['footer_promo_bar_button_target'];

			if ( isset($uplift_options['footer_promo_bar_text_size']) ) {
				$footer_promo_bar_text_size	    = $uplift_options['footer_promo_bar_text_size'];
			}
			if ( isset($uplift_options['footer_promo_bar_button_type']) ) {
				$footer_promo_bar_button_type	    = $uplift_options['footer_promo_bar_button_type'];
			}

            if ( $enable_footer_promo_bar ) {
                ?>
                <!--// OPEN #base-promo //-->
                <div id="base-promo" class="sf-promo-bar promo-<?php echo esc_attr($footer_promo_bar_type); ?>">
                    <?php if ( $footer_promo_bar_type == "button" ) { ?>
                        <p class="<?php echo esc_attr($footer_promo_bar_text_size); ?>"><?php echo esc_attr($footer_promo_bar_text); ?></p>
                        <a href="<?php echo esc_url($footer_promo_bar_button_link); ?>"
                           target="<?php echo esc_attr($footer_promo_bar_button_target); ?>"
                           class="sf-button <?php echo esc_attr($footer_promo_bar_button_type); ?> <?php echo esc_attr($footer_promo_bar_button_color); ?>"><?php echo esc_attr($footer_promo_bar_button_text); ?></a>
                    <?php } else if ( $footer_promo_bar_type == "arrow" ) { ?>
                        <a href="<?php echo esc_url($footer_promo_bar_button_link); ?>"
                           target="<?php echo esc_attr($footer_promo_bar_button_target); ?>"><?php echo esc_attr($footer_promo_bar_text); ?>
                            <?php echo apply_filters( 'uplift_next_icon', '<i class="ss-navigateright"></i>' ); ?></a>
                    <?php } else { ?>
                        <a href="<?php echo esc_url($footer_promo_bar_button_link); ?>"
                           target="<?php echo esc_attr($footer_promo_bar_button_target); ?>" class="<?php echo esc_attr($footer_promo_bar_text_size); ?>"><?php echo esc_attr($footer_promo_bar_text); ?></a>
                    <?php } ?>
                    <!--// CLOSE #base-promo //-->
                </div>
            <?php
            }

        }

        add_action( 'uplift_main_container_end', 'uplift_footer_promo', 20 );
    }


    /* FOOTER WIDGET AREA
    ================================================== */
    if ( ! function_exists( 'uplift_footer_widgets' ) ) {
        function uplift_footer_widgets() {
            $uplift_options = uplift_get_theme_opts();
			
			$enable_footer 		   = true;
			if ( isset( $uplift_options['enable_footer'] ) ) {
            	$enable_footer         = $uplift_options['enable_footer'];
            }
            $enable_footer_divider = $uplift_options['enable_footer_divider'];
            $footer_config         = $uplift_options['footer_layout'];
            $footer_class          = "";
            if ( $enable_footer_divider ) {
                $footer_class = "footer-divider";
            }

            if ( $enable_footer ) {
                ?>
                <!--// OPEN #footer //-->
                <footer id="footer" class="<?php echo esc_attr($footer_class); ?>">
                    <div class="container">
                        <div id="footer-widgets" class="row clearfix">
                            <?php if ( $footer_config == "footer-1" ) { ?>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-2' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-3' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-4' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else if ( $footer_config == "footer-2" ) { ?>

                                <div class="col-sm-6">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-2' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-3' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else if ( $footer_config == "footer-3" ) { ?>

                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-2' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-6">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-3' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else if ( $footer_config == "footer-4" ) { ?>

                                <div class="col-sm-6">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-6">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-2' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else if ( $footer_config == "footer-5" ) { ?>

                                <div class="col-sm-4">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-4">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-2' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-4">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-3' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else if ( $footer_config == "footer-6" ) { ?>

                                <div class="col-sm-8">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-4">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-2' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else if ( $footer_config == "footer-7" ) { ?>

                                <div class="col-sm-4">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-8">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-2' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else if ( $footer_config == "footer-8" ) { ?>

                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-6">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-2' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-3' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else { ?>

                                <div class="col-sm-12">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'footer-column-1' ); ?>
                                    <?php } ?>

                                </div>
                            <?php } ?>

                        </div>
                    </div>

                    <?php do_action( 'uplift_footer_wrap_after' ); ?>

                    <!--// CLOSE #footer //-->
                </footer>
            <?php
            }

        }

        add_action( 'uplift_footer_wrap_content', 'uplift_footer_widgets', 10 );
    }


    /* FOOTER COPYRIGHT
    ================================================== */
    if ( ! function_exists( 'uplift_footer_copyright' ) ) {
        function uplift_footer_copyright() {
            $uplift_options = uplift_get_theme_opts();

            $enable_copyright 		   = true;
            if ( isset( $uplift_options['enable_copyright'] ) ) {
            	$enable_copyright         = $uplift_options['enable_copyright'];
            }
            $enable_copyright_divider = $uplift_options['enable_copyright_divider'];
            $copyright_right          = $uplift_options['copyright_right'];
            $show_backlink            = $uplift_options['show_backlink'];
            $copyright_text           = $uplift_options['footer_copyright_text'];
            $copyright_text_right     = $uplift_options['footer_copyright_text_right'];
            $swiftideas_backlink      = $copyright_class = "";

            if ( $enable_copyright_divider ) {
                $copyright_class = "copyright-divider";
            }

            if ( $enable_copyright ) {
                ?>

                <!--// OPEN #copyright //-->
                <footer id="copyright" class="<?php echo esc_attr($copyright_class); ?>">
                    <div class="container">
                        <div class="text-left">
                                <?php echo do_shortcode( stripslashes( $copyright_text ) ); ?>
                                <?php if ( $show_backlink ) {
                                    echo apply_filters( "swiftideas_link", " <a href='http://www.swiftideas.com' rel='nofollow'>Premium WordPress Themes by Swift Ideas</a>" );
                                } ?>        
                        </div>
                        <?php if ( $copyright_right == "menu" ) { ?>
                            <nav class="footer-menu std-menu">
                                <?php
                                    $footer_menu_args = array(
                                        'echo'           => true,
                                        'theme_location' => 'footer_menu',
                                        'walker'         => new uplift_alt_menu_walker,
                                        'fallback_cb'    => ''
                                    );
                                    wp_nav_menu( $footer_menu_args );
                                ?>
                            </nav>
                        <?php } else { ?>
                            <div
                                class="text-right"><?php echo do_shortcode( stripslashes( $copyright_text_right ) ); ?></div>
                        <?php } ?>
                    </div>
                    <!--// CLOSE #copyright //-->
                </footer>

            <?php
            }

        }

        add_action( 'uplift_footer_wrap_content', 'uplift_footer_copyright', 20 );
    }

    /* ONE PAGE NAV
    ================================================== */
    if ( ! function_exists( 'uplift_one_page_nav' ) ) {
        function uplift_one_page_nav() {
            global $post;
            $enable_one_page_nav = false;
            if ( $post && !is_search() ) {
            	$enable_one_page_nav = uplift_get_post_meta( $post->ID, 'sf_enable_one_page_nav', true );
            }
            $uplift_options = uplift_get_theme_opts();
            $onepagenav_type = $uplift_options['onepagenav_type'];
            if ( $enable_one_page_nav ) {
                ?>
                <!--// ONE PAGE NAV //-->
                <div id="one-page-nav" class="opn-<?php echo esc_attr($onepagenav_type); ?>"></div>
            <?php
            }
        }

        add_action( 'uplift_main_container_end', 'uplift_one_page_nav', 30 );
    }


    /* BACK TO TOP
    ================================================== */
    if ( ! function_exists( 'uplift_back_to_top' ) ) {
        function uplift_back_to_top() {
            $uplift_options = uplift_get_theme_opts();
            $enable_backtotop = $uplift_options['enable_backtotop'];
            if ( $enable_backtotop ) {
                ?>
                <!--// BACK TO TOP //-->
                <div id="back-to-top" class="animate-top"><?php echo apply_filters( 'uplift_back_to_top_icon', '<i class="ss-navigateup"></i>' ); ?></div>
            <?php
            }
        }

        add_action( 'uplift_after_page_container', 'uplift_back_to_top', 20 );
    }


    /* FULL WIDTH VIDEO AREA
    ================================================== */
    if ( ! function_exists( 'uplift_fw_video_area' ) ) {
        function uplift_fw_video_area() {
            ?>
            <!--// FULL WIDTH VIDEO //-->
            <div class="fw-video-area">
                <div class="fw-video-close"><?php echo apply_filters( 'uplift_fullscreen_close_icon', '<i class="ss-delete"></i>' ); ?></div>
                <div class="fw-video-wrap"></div>
            </div>
            <div class="fw-video-spacer"></div>
        <?php
        }

        add_action( 'uplift_after_page_container', 'uplift_fw_video_area', 30 );
    }


    /* BACK TO TOP
    ================================================== */
    if ( ! function_exists( 'uplift_inf_scroll_params' ) ) {
        function uplift_inf_scroll_params() {
            ?>
            <!--// INFINITE SCROLL PARAMS //-->
            <div id="inf-scroll-params"
                 data-loadingimage="<?php echo get_template_directory_uri(); ?>/images/loader.gif"
                 data-msgtext="<?php _e( "Loading...", 'uplift' );
                 ?>" data-finishedmsg="<?php _e( "All items loaded", 'uplift' ); ?>"></div>
        <?php
        }

        add_action( 'uplift_after_page_container', 'uplift_inf_scroll_params', 40 );
    }


    /* FRAMEWORK INLCUDES
    ================================================== */
    if ( ! function_exists( 'uplift_included' ) ) {
        function uplift_included() {
            ?>
            <!--// FRAMEWORK INCLUDES //-->
            <div id="sf-included" class="<?php echo uplift_global_include_classes(); ?>"></div>
        <?php
        }

        add_action( 'uplift_after_page_container', 'uplift_included', 50 );
    }

    /* PLUGIN OPTION PARAMS
    ================================================== */
    if ( ! function_exists( 'uplift_option_parameters' ) ) {
        function uplift_option_parameters() {
            $uplift_options = uplift_get_theme_opts();
            $slider_slideshowSpeed    = $uplift_options['slider_slideshowSpeed'];
            $slider_animationSpeed    = $uplift_options['slider_animationSpeed'];
            $slider_autoplay          = $uplift_options['slider_autoplay'];
            $slider_loop 			  = false;
            if ( isset($uplift_options['slider_loop']) ) {
            	$slider_loop          	  = $uplift_options['slider_loop'];
            }
            $carousel_paginationSpeed = $uplift_options['carousel_paginationSpeed'];
            $carousel_slideSpeed      = $uplift_options['carousel_slideSpeed'];
            $carousel_autoplay        = $uplift_options['carousel_autoplay'];
            $carousel_pagination      = $uplift_options['carousel_pagination'];
            $lightbox_nav             = $uplift_options['lightbox_nav'];
            $lightbox_thumbs          = $uplift_options['lightbox_thumbs'];
            $lightbox_skin            = $uplift_options['lightbox_skin'];
            $lightbox_sharing         = $uplift_options['lightbox_sharing'];
            $product_zoom_type        = $uplift_options['product_zoom_type'];
            $product_slider_thumbs_pos = "bottom";
            $vertical_product_slider_height = "700";
            if ( isset( $uplift_options['product_slider_thumbs_pos'] ) ) {
           		$product_slider_thumbs_pos = $uplift_options['product_slider_thumbs_pos'];
            }
            if ( isset( $uplift_options['vertical_product_slider_height'] ) ) {
            	$vertical_product_slider_height = $uplift_options['vertical_product_slider_height'];
            }
            $quickview_text			  = __("Quickview", 'uplift');
            $cart_notification = "";
            if ( isset ($uplift_options['cart_notification']) ) {
            	$cart_notification        = $uplift_options['cart_notification'];
            }
            ?>
            <div id="sf-option-params" data-slider-slidespeed="<?php echo esc_attr($slider_slideshowSpeed); ?>"
                 data-slider-animspeed="<?php echo esc_attr($slider_animationSpeed); ?>"
                 data-slider-autoplay="<?php echo esc_attr($slider_autoplay); ?>"
                 data-slider-loop="<?php echo esc_attr($slider_loop); ?>"
                 data-carousel-pagespeed="<?php echo esc_attr($carousel_paginationSpeed); ?>"
                 data-carousel-slidespeed="<?php echo esc_attr($carousel_slideSpeed); ?>"
                 data-carousel-autoplay="<?php echo esc_attr($carousel_autoplay); ?>"
                 data-carousel-pagination="<?php echo esc_attr($carousel_pagination); ?>"
                 data-lightbox-nav="<?php echo esc_attr($lightbox_nav); ?>"
	             data-lightbox-thumbs="<?php echo esc_attr($lightbox_thumbs); ?>"
                 data-lightbox-skin="<?php echo esc_attr($lightbox_skin); ?>"
                 data-lightbox-sharing="<?php echo esc_attr($lightbox_sharing); ?>"
                 data-product-zoom-type="<?php echo esc_attr($product_zoom_type); ?>"
                 data-product-slider-thumbs-pos="<?php echo esc_attr($product_slider_thumbs_pos); ?>"
                 data-product-slider-vert-height="<?php echo esc_attr($vertical_product_slider_height); ?>"
                 data-quickview-text="<?php echo esc_attr($quickview_text); ?>"
	             data-cart-notification="<?php echo esc_attr($cart_notification); ?>"
	             data-username-placeholder="<?php _e( "Username", 'uplift' ); ?>"
	             data-email-placeholder="<?php _e( "Email", 'uplift' ); ?>"
	             data-password-placeholder="<?php _e( "Password", 'uplift' ); ?>"
	             data-username-or-email-placeholder="<?php _e( "Username or email address", 'uplift' ); ?>"
	             data-order-id-placeholder="<?php _e( "Order ID", 'uplift' ); ?>"
	             data-billing-email-placeholder="<?php _e( "Billing Email", 'uplift' ); ?>"></div>

        <?php
        }
        add_action( 'uplift_after_page_container', 'uplift_option_parameters', 60 );
    }


    /* LOVE IT LOCALE
    ================================================== */
    if ( ! function_exists( 'uplift_loveit_locale' ) ) {
        function uplift_loveit_locale() {
            $ajax_url              = admin_url( 'admin-ajax.php' );
            $nonce                 = wp_create_nonce( 'love-it-nonce' );
            $already_loved_message = __( 'You have already loved this item.', 'uplift' );
            $error_message         = __( 'Sorry, there was a problem processing your request.', 'uplift' );
            $logged_in             = is_user_logged_in() ? 'true' : 'false';

            ?>
            <div id="loveit-locale" data-ajaxurl="<?php echo esc_url($ajax_url); ?>" data-nonce="<?php echo esc_attr($nonce); ?>"
                 data-alreadyloved="<?php echo esc_attr($already_loved_message); ?>" data-error="<?php echo esc_attr($error_message); ?>"
                 data-loggedin="<?php echo esc_attr($logged_in); ?>"></div>
        <?php
        }

        add_action( 'uplift_after_page_container', 'uplift_loveit_locale', 80 );
    }

?>