<?php
    /*
    *
    *	Header Functions
    *	------------------------------------------------
    *	Swift Framework
    * 	Copyright Swift Ideas 2015 - http://www.swiftideas.com
    *
    *	uplift_framework_check()
    *	uplift_site_loading()
    *	uplift_header_wrap()
    *	uplift_header()
    *	uplift_header_aux()
    *	uplift_logo()
    *	uplift_main_menu()
    *	uplift_mobile_cart()
    *	uplift_mobile_header()
    *	uplift_mobile_menu()
    *	uplift_woo_links()
    * 	uplift_get_cart()
    *	uplift_get_wishlist()
    *	uplift_get_account()
    *	uplift_ajaxsearch()
    *	uplift_overlay_menu()
    *   uplift_add_to_wishlist()
    */

    /* SWIFT FRAMEWORK CHECK
    ================================================== */
    if ( ! function_exists( 'uplift_framework_check' ) ) {
        function uplift_framework_check() {

        	if ( class_exists( 'uplift' ) || !( current_user_can('editor') || current_user_can('administrator') ) ) {
        		return;
        	}

            echo '<div class="swift-framework-notice">';
            echo '<h3>Please install/activate the Swift Framework plugin.</h3>';
            echo '<p>If you have not installed the plugin, please go to Appearance > Install Plugins</p>';
            echo '</div>';
        }
        //add_action( 'uplift_before_page_container', 'uplift_framework_check', 0 );
    }
    
    /* REDUX CHECK
    ================================================== */
    if ( ! function_exists( 'uplift_redux_check' ) ) {
        function uplift_redux_check() {

        	if ( class_exists( 'ReduxFramework' ) || !( current_user_can('editor') || current_user_can('administrator') ) ) {
        		return;
        	}

            echo '<div class="swift-framework-notice">';
            echo '<h3>Please install/activate the Redux Framework plugin.</h3>';
            echo '<p>If you have not installed the plugin, please go to Appearance > Install Plugins</p>';
            echo '</div>';
        }
        //add_action( 'uplift_before_page_container', 'uplift_redux_check', 5 );
    }


    /* SITE LOADING
    ================================================== */
    if ( ! function_exists( 'uplift_site_loading' ) ) {
        function uplift_site_loading() {
            echo uplift_loading_animation( 'site-loading' );
        }

        add_action( 'uplift_before_page_container', 'uplift_site_loading', 5 );
    }


    /* HEADER WRAP
    ================================================== */
    if ( ! function_exists( 'uplift_header_wrap' )) {
	    function uplift_header_wrap($header_layout) {
		    global $post;
            $uplift_options = uplift_get_theme_opts();

		    $page_classes     = uplift_page_classes();
		    $header_layout    = $page_classes['header-layout'];
		    $page_header_type = "standard";

		    if ( is_page() && $post ) {
		        $page_header_type = uplift_get_post_meta( $post->ID, 'sf_page_header_type', true );
		    } else if ( is_singular( 'post' ) && $post ) {
		        $post_header_type = uplift_get_post_meta( $post->ID, 'sf_page_header_type', true );
		        $fw_media_display = uplift_get_post_meta( $post->ID, 'sf_fw_media_display', true );
		        $page_title_style = uplift_get_post_meta( $post->ID, 'sf_page_title_style', true );
		        if ( $page_title_style == "fancy" || $fw_media_display == "fw-media-title" || $fw_media_display == "fw-media" ) {
		            $page_header_type = $post_header_type;
		        }
		    }  else if (is_singular('portfolio') && $post) {
				$port_header_type = uplift_get_post_meta($post->ID, 'sf_page_header_type', true);
				$fw_media_display = uplift_get_post_meta($post->ID, 'sf_fw_media_display', true);
				$page_title = uplift_get_post_meta($post->ID, 'sf_page_title', true);
				$page_title_style = uplift_get_post_meta($post->ID, 'sf_page_title_style', true);
				if ($page_title_style == "fancy" || !$page_title) {
					$page_header_type = $port_header_type;
				}
			}

		    $fullwidth_header    	= $uplift_options['fullwidth_header'];
		    $enable_tb           	= $uplift_options['enable_tb'];
		    $tb_left_config      	= $uplift_options['tb_left_config'];
		    $tb_right_config     	= $uplift_options['tb_right_config'];
		    $tb_left_text		 	= $uplift_options['tb_left_text'];
			$tb_right_text		 	= $uplift_options['tb_right_text'];
			$enable_sticky_tb 	 	= false;
			if ( isset( $uplift_options['enable_sticky_topbar'] ) ) {
				$enable_sticky_tb 	= $uplift_options['enable_sticky_topbar'];	
			}
		    $header_left_config  	= $uplift_options['header_left_config'];
		    $header_right_config 	= $uplift_options['header_right_config'];
			
		    if ( ( $page_header_type == "naked-light" || $page_header_type == "naked-dark" ) && ( $header_layout == "header-vert" || $header_layout == "header-vert-right" ) ) {
		        $header_layout 		= apply_filters( 'uplift_naked_default_header', "header-1" );
		        $enable_tb     		= false;
		    }

		    $top_bar_class = "";
		    if ($enable_sticky_tb) {
		    	$top_bar_class = "sticky-top-bar";
		    }
		?>
		<?php if ($enable_tb) { ?>
		<!--// TOP BAR //-->
		<div id="top-bar" class="<?php echo esc_attr($top_bar_class); ?>">
		<?php if ($fullwidth_header) { ?>
		<div class="container fw-header">
		    <?php } else { ?>
		    <div class="container">
		        <?php } ?>
		        <div class="col-sm-6 tb-left">
                    <?php 
                    if ( $tb_left_config == "social" ) {
                        echo do_shortcode( '[social]' ) . "\n";
                    } else if ( $tb_left_config == "aux-links" ) {
                        echo uplift_aux_links( 'tb-menu', true, 'header-1' ) . "\n";
                    } else if ( $tb_left_config == "menu" ) {
                        echo uplift_top_bar_menu() . "\n";
                    } else if ($tb_left_config == "cart-wishlist") {
                        echo '<div class="aux-item aux-cart-wishlist"><nav class="std-menu cart-wishlist"><ul class="menu">'. "\n";
                        echo uplift_get_cart();
                        echo uplift_get_wishlist();
                        echo '</ul></nav></div>'. "\n";
                    } else {
                        echo '<div class="tb-text">' . do_shortcode( $tb_left_text ) . '</div>' . "\n";
                    } ?>     
                </div>
		        <div class="col-sm-6 tb-right">
                    <?php
                    if ( $tb_right_config == "social" ) {
                        echo do_shortcode( '[social]' ) . "\n";
                    } else if ( $tb_right_config == "aux-links" ) {
                        echo uplift_aux_links( 'tb-menu', true, 'header-1' ) . "\n";
                    } else if ( $tb_right_config == "menu" ) {
                        echo uplift_top_bar_menu() . "\n";
                    } else if ($tb_right_config == "cart-wishlist") {
                        echo '<div class="aux-item aux-cart-wishlist"><nav class="std-menu cart-wishlist"><ul class="menu">'. "\n";
                        echo uplift_get_cart();
                        echo uplift_get_wishlist();
                        echo '</ul></nav></div>'. "\n";
                    } else {
                        echo '<div class="tb-text">' . do_shortcode( $tb_right_text ) . '</div>' . "\n";
                    }
                    ?>
                </div>
		    </div>
		</div>
		<?php } ?>

		<!--// HEADER //-->
		<div class="header-wrap <?php echo esc_attr($page_classes['header-wrap']); ?> page-header-<?php echo esc_attr($page_header_type); ?>">
			
			<?php do_action('uplift_before_header_section'); ?>
			
		    <div id="header-section" class="<?php echo esc_attr($header_layout); ?> <?php echo esc_attr($page_classes['logo']); ?>">
		    	<?php do_action('uplift_header_section_start'); ?>
		        <?php echo uplift_header( $header_layout ); ?>
		        <?php do_action('uplift_header_section_end'); ?>
		    </div>
		    
		    <?php do_action('uplift_after_header_section'); ?>

		    <?php
		        // Overlay Menu
		        if ( $header_left_config == "overlay-menu" || $header_right_config == "overlay-menu" ) {
		            echo uplift_overlay_menu();
		        }
		    ?>

		    <?php
		        // Contact Slideout
		        if ( $header_left_config == "contact" || $header_right_config == "contact" ) {
		            echo uplift_contact_slideout();
		        }
		    ?>

		</div>

		<?php
	    }
	    add_action( 'uplift_container_start', 'uplift_header_wrap', 20 );
    }


    /* HEADER
    ================================================== */
    if ( ! function_exists( 'uplift_header' ) ) {
        function uplift_header( $header_layout ) {
			
			$header = "";
			
			$header .= do_action('uplift_before_header_layout');
			
            // Get layout and return output
            $header .= uplift_get_header_layout( $header_layout );
            
            $header .= do_action('uplift_after_header_layout');
            
            return $header;

        }
    }


    /* HEADER AUX
    ================================================== */
    if ( ! function_exists( 'uplift_header_aux' ) ) {
        function uplift_header_aux( $aux ) {

            $uplift_options 		 = uplift_get_theme_opts();
			$page_classes        = uplift_page_classes();
			
            $show_cart           = $uplift_options['show_cart'];
            $show_wishlist       = $uplift_options['show_wishlist'];
            $header_layout       = $page_classes['header-layout'];
            $header_left_config  = $uplift_options['header_left_config'];
            $header_right_config = $uplift_options['header_right_config'];
            $header_left_text    = $uplift_options['header_left_text'];
            $header_right_text   = $uplift_options['header_right_text'];
            $fullwidth_header    = $uplift_options['fullwidth_header'];
            $contact_icon        = apply_filters( 'uplift_header_contact_icon', '<i class="ss-mail"></i>' );

            if ( $aux == "left" ) {
                $header_left_output = "";
                if ( $header_left_config == "social" ) {
                    $header_left_output .= do_shortcode( '[social]' ) . "\n";
                } else if ( $header_left_config == "aux-links" ) {
                    $header_left_output .= uplift_aux_links( 'header-menu', true, $header_layout ) . "\n";
                } else if ( $header_left_config == "overlay-menu" ) {
                    $header_left_output .= '<a href="#" class="overlay-menu-link"><span>' . __( "Menu", 'uplift' ) . '</span></a>' . "\n";
                } else if ( $header_left_config == "contact" ) {
                    $header_left_output .= '<a href="#" class="contact-menu-link">' . $contact_icon . '</a>' . "\n";
                } else if ( $header_left_config == "currency-switcher" ) {
                	$aux_output .= '<div class="aux-item aux-currency"><nav class="std-menu currency"><ul class="menu">'. "\n";
                	$aux_output .= uplift_get_currency_switcher();
                	$aux_output .= '</ul></nav></div>'. "\n";
                } else if ( $header_left_config == "search" ) {
                    $header_left_output .= '<nav class="std-menu">' . "\n";
                    $header_left_output .= '<ul class="menu">' . "\n";
                    $header_left_output .= uplift_get_search( 'aux' );
                    $header_left_output .= '</ul>' . "\n";
                    $header_left_output .= '</nav>' . "\n";
                } else {
                    $header_left_output .= '<div class="text">' . do_shortcode( $header_left_text ) . '</div>' . "\n";
                }

                return $header_left_output;
            } else if ( $aux == "right" ) {
                $header_right_output = "";
                if ( $header_right_config == "social" ) {
                    $header_right_output .= do_shortcode( '[social]' ) . "\n";
                } else if ( $header_right_config == "aux-links" ) {
                    $header_right_output .= uplift_aux_links( 'header-menu', true, $header_layout ) . "\n";
                } else if ( $header_right_config == "overlay-menu" ) {
                    $header_right_output .= '<a href="#" class="overlay-menu-link"><span>' . __( "Menu", 'uplift' ) . '</span></a>' . "\n";
                } else if ( $header_right_config == "contact" ) {
                    $header_right_output .= '<a href="#" class="contact-menu-link">' . $contact_icon . '</a>' . "\n";
                } else if ( $header_right_config == "currency-switcher") {
                	$aux_output .= '<div class="aux-item aux-currency"><nav class="std-menu currency"><ul class="menu">'. "\n";
                	$aux_output .= uplift_get_currency_switcher();
                	$aux_output .= '</ul></nav></div>'. "\n";
                } else if ( $header_right_config == "search" ) {
                    $header_right_output .= '<nav class="std-menu">' . "\n";
                    $header_right_output .= '<ul class="menu">' . "\n";
                    $header_right_output .= uplift_get_search( 'aux' );
                    $header_right_output .= '</li>' . "\n";
                    $header_right_output .= '</ul>' . "\n";
                    $header_right_output .= '</nav>' . "\n";
                } else {
                    $header_right_output .= '<div class="text">' . do_shortcode( $header_right_text ) . '</div>' . "\n";
                }

                return $header_right_output;
            }
        }
    }


    /* LOGO
    ================================================== */
    if ( ! function_exists( 'uplift_logo' ) ) {
        function uplift_logo( $logo_class, $logo_id = "logo" ) {

            //VARIABLES
            global $post;
            $uplift_options = uplift_get_theme_opts();
            $show_cart = false;
            $sticky_header_transparent = false;
            if ( isset($uplift_options['show_cart']) ) {
            $show_cart            = $uplift_options['show_cart'];
            }
            $logo        = $light_logo = $dark_logo = $alt_logo = array();
            $header_type = "standard";
            $page_header_alt_logo = false;
            $custom_logo_id = get_theme_mod( 'custom_logo' );
            $logo = wp_get_attachment_image_src( $custom_logo_id , 'full' );

            if ( $post && !is_search() ) {
                $header_type = uplift_get_post_meta( $post->ID, 'sf_page_header_type', true );
                $page_header_alt_logo = uplift_get_post_meta( $post->ID, 'sf_page_header_alt_logo', true );
                $sticky_header_transparent = uplift_get_post_meta( $post->ID, 'sf_sticky_header_transparent', true );
            }
            
            // Shop page check
            $shop_page = false;
            if ( ( function_exists( 'is_shop' ) && is_shop() ) || ( function_exists( 'is_product_category' ) && is_product_category() ) ) {
                $shop_page = true;
            }

            if ( $shop_page ) {
                if ( isset($uplift_options['woo_page_header']) ) {
                    $header_type = $uplift_options['woo_page_header'];
                }
            }

            // Light Logo
            if ( isset( $uplift_options['light_logo_upload'] ) ) {
                $light_logo = $uplift_options['light_logo_upload'];
            }
            if ( isset( $light_logo['url'] ) && $light_logo['url'] != "" && ( $header_type == "naked-light" || $header_type == "naked-dark" || $sticky_header_transparent ) ) {
                $logo_class .= " has-light-logo";
            }

            // Dark Logo
            if ( isset( $uplift_options['dark_logo_upload'] ) ) {
                $dark_logo = $uplift_options['dark_logo_upload'];
            }
            if ( isset( $dark_logo['url'] ) && $dark_logo['url'] != "" && ( $header_type == "naked-light" || $header_type == "naked-dark" || $sticky_header_transparent ) ) {
                $logo_class .= " has-dark-logo";
            }

            // Alt Logo
            if ( isset( $uplift_options['alt_logo_upload'] ) && $page_header_alt_logo ) {
                $alt_logo = $uplift_options['alt_logo_upload'];
            }

            if ( has_custom_logo() ) {
                $logo_class .= " has-img";
            } else {
                $logo_class .= " no-img";
            }
            $logo_output         = "";
            $logo_alt            = get_bloginfo( 'name' );
            $logo_tagline        = get_bloginfo( 'description' );
            $logo_link_url       = apply_filters( 'uplift_logo_link_url', home_url() );
            $enable_logo_tagline = false;
            if ( isset( $uplift_options['enable_logo_tagline'] ) ) {
                $enable_logo_tagline = $uplift_options['enable_logo_tagline'];
            }
            
            // Animation
            $logo_anim = "";
            if ( isset( $uplift_options['logo_hover_anim'] ) ) {
                $logo_anim = $uplift_options['logo_hover_anim'];
            }


            /* LOGO OUTPUT
            ================================================== */
            $logo_output .= '<div id="' . $logo_id . '" class="' . $logo_class . ' clearfix" data-anim="' . $logo_anim . '">' . "\n";
            $logo_output .= '<a href="' . $logo_link_url . '">' . "\n";

            if ( $logo_id == "mobile-logo" && uplift_theme_supports('mobile-logo-override') ) {

	            $mobile_logo = "";

	            if ( isset( $uplift_options['mobile_logo_upload'] ) ) {
					$mobile_logo = $uplift_options['mobile_logo_upload'];
				}

				// Standard Mobile Logo
	            if ( isset( $mobile_logo['url'] ) && $mobile_logo['url'] != "" ) {
	                $logo_output .= '<img class="standard" src="' . $mobile_logo['url'] . '" alt="' . $logo_alt . '" height="' . $mobile_logo['height'] . '" width="' . $mobile_logo['width'] . '" />' . "\n";
	            } else if ( has_custom_logo() ) {
                    $logo_output .= '<img class="standard" src="' . esc_url( $logo['0'] ) . '" alt="' . esc_attr($logo_alt) . '" width="' . esc_attr($logo['1']) . '" height="' . esc_attr($logo['2']) . '" />' . "\n";
                }

	            // Alt Logo
	            if ( isset( $alt_logo['url'] ) && $alt_logo['url'] != "" && $page_header_alt_logo ) {
	                $logo_output .= '<img class="alt-logo" src="' . $alt_logo['url'] . '" alt="' . $logo_alt . '" height="' . $alt_logo['height'] . '" width="' . $alt_logo['width'] . '" />' . "\n";
	            }

	            // Text Logo
	            $logo_output .= '<div class="text-logo">';
	            $h1_output = '';
	            if ( !has_custom_logo() ) {
	                $h1_output = '<h1 class="logo-h1 standard">' . $logo_alt . '</h1>' . "\n";
	            }
	            $logo_output .= $h1_output;
	            if ( $enable_logo_tagline && $logo_tagline != "" ) {
	                $logo_output .= '<h2 class="logo-h2">' . $logo_tagline . '</h1>' . "\n";
	            }
	            $logo_output .= '</div>' . "\n";

            } else {

		        // Standard Logo
                if ( has_custom_logo() ) {
                    $logo_output .= '<img class="standard" src="' . esc_url( $logo['0'] ) . '" alt="' . esc_attr($logo_alt) . '" width="' . esc_attr($logo['1']) . '" height="' . esc_attr($logo['2']) . '" />' . "\n";
                }

	            // Light Logo
	            if ( isset( $light_logo['url'] ) && $light_logo['url'] != "" && ( $header_type == "naked-light" || $header_type == "naked-dark" || $sticky_header_transparent ) ) {
	                $logo_output .= '<img class="light-logo" src="' . $light_logo['url'] . '" alt="' . $logo_alt . '" height="' . $light_logo['height'] . '" width="' . $light_logo['width'] . '" />' . "\n";
	            }

	            // Dark Logo
	            if ( isset( $dark_logo['url'] ) && $dark_logo['url'] != "" && ( $header_type == "naked-light" || $header_type == "naked-dark" || $sticky_header_transparent ) ) {
	                $logo_output .= '<img class="dark-logo" src="' . $dark_logo['url'] . '" alt="' . $logo_alt . '" height="' . $dark_logo['height'] . '" width="' . $dark_logo['width'] . '" />' . "\n";
	            }

	            // Alt Logo
	            if ( isset( $alt_logo['url'] ) && $alt_logo['url'] != "" && $page_header_alt_logo ) {
	                $logo_output .= '<img class="alt-logo" src="' . $alt_logo['url'] . '" alt="' . $logo_alt . '" height="' . $alt_logo['height'] . '" width="' . $alt_logo['width'] . '" />' . "\n";
	            }

	            // Text Logo
	            $logo_output .= '<div class="text-logo">';
	            $h1_output = '';
	            if ( !has_custom_logo() ) {
	                $h1_output = '<h1 class="logo-h1 standard">' . $logo_alt . '</h1>' . "\n";
	            }
	            $logo_output .= $h1_output;
	            if ( $enable_logo_tagline && $logo_tagline != "" ) {
	                $logo_output .= '<h2 class="logo-h2">' . $logo_tagline . '</h1>' . "\n";
	            }
	            $logo_output .= '</div>' . "\n";

            }

            $logo_output .= '</a>' . "\n";
            $logo_output .= '</div>' . "\n";


            // LOGO RETURN
            return $logo_output;
        }
    }

    /* TOP BAR MENU
    ================================================== */
    if ( ! function_exists( 'uplift_top_bar_menu' ) ) {
        function uplift_top_bar_menu() {

            $tb_menu_args = array(
                'echo'           => false,
                'theme_location' => 'top_bar_menu',
                'walker'         => new uplift_alt_menu_walker,
                'fallback_cb'    => '',
            );

            // MENU OUTPUT
            $tb_menu_output = '<nav class="std-menu clearfix">' . "\n";

            if ( function_exists( 'wp_nav_menu' ) ) {
                if ( has_nav_menu( 'top_bar_menu' ) ) {
                    $tb_menu_output .= wp_nav_menu( $tb_menu_args );
                } else {
                    $tb_menu_output .= '<div class="no-menu">' . __( "Please assign a menu to the Top Bar Menu in Appearance > Menus", 'uplift' ) . '</div>';
                }
            }
            $tb_menu_output .= '</nav>' . "\n";

            return $tb_menu_output;
        }
    }

    /* MENU
    ================================================== */
    if ( ! function_exists( 'uplift_main_menu' ) ) {
        function uplift_main_menu( $id, $layout = "" ) {

            // VARIABLES
            global $post;
			$uplift_options = uplift_get_theme_opts();
			
			$show_cart = false;
			if ( isset($uplift_options['show_cart']) ) {
			$show_cart            = $uplift_options['show_cart'];
			}
            $show_wishlist        = $uplift_options['show_wishlist'];
            $header_search_type = "standard";
            if ( isset($uplift_options['header_search_type']) ) {
            $header_search_type = $uplift_options['header_search_type'];
            }
            $vertical_header_text = $uplift_options['vertical_header_text'];
            $page_menu            = $menu_output = $menu_full_output = $menu_with_search_output = $menu_float_output = $menu_vert_output = "";

            if ( $post && !is_search() ) {
                $page_menu = uplift_get_post_meta( $post->ID, 'sf_page_menu', true );
            }
            $main_menu_args = array(
                'echo'           => false,
                'theme_location' => 'main_navigation',
                'walker'         => new uplift_mega_menu_walker,
                'fallback_cb'    => '',
                'menu'           => $page_menu
            );


            // MENU OUTPUT
            $menu_output .= '<nav id="' . $id . '" class="std-menu clearfix">' . "\n";

            if ( function_exists( 'wp_nav_menu' ) ) {
                if ( has_nav_menu( 'main_navigation' ) ) {
                    $menu_output .= wp_nav_menu( $main_menu_args );
                } else {
                    $menu_output .= '<div class="no-menu">' . __( "Please assign a menu to the Main Menu in Appearance > Menus", 'uplift' ) . '</div>';
                }
            }
            $menu_output .= '</nav>' . "\n";


            // FULL WIDTH MENU OUTPUT
            if ( $layout == "full" ) {

                $menu_full_output .= '<div class="container">' . "\n";
                $menu_full_output .= '<div class="row">' . "\n";
                $menu_full_output .= '<div class="menu-left">' . "\n";
                $menu_full_output .= $menu_output . "\n";
                $menu_full_output .= '</div>' . "\n";
                $menu_full_output .= '<div class="menu-right">' . "\n";
                $menu_full_output .= '<nav class="std-menu">' . "\n";
                $menu_full_output .= '<ul class="menu">' . "\n";
                $menu_full_output .= uplift_get_search( $header_search_type );
                if ( $show_cart ) {
                    $menu_full_output .= uplift_get_cart();
                }
                if ( class_exists( 'YITH_WCWL_UI' ) && $show_wishlist ) {
                    $menu_full_output .= uplift_get_wishlist();
                }
                $menu_full_output .= '</ul>' . "\n";
                $menu_full_output .= '</nav>' . "\n";
                $menu_full_output .= '</div>' . "\n";
                $menu_full_output .= '</div>' . "\n";
                $menu_full_output .= '</div>' . "\n";

                $menu_output = $menu_full_output;			
				
            } else if ( $layout == "with-search" ) {

                $menu_with_search_output .= '<nav class="search-nav std-menu">' . "\n";
                $menu_with_search_output .= '<ul class="menu">' . "\n";
                $menu_with_search_output .= uplift_get_search( $header_search_type );
                $menu_with_search_output .= '</ul>' . "\n";
                $menu_with_search_output .= '</nav>' . "\n";
                $menu_with_search_output .= $menu_output . "\n";

                $menu_output = $menu_with_search_output;

            } else if ( $layout == "float" || $layout == "float-2" ) {

                $menu_float_output .= '<div class="float-menu container">' . "\n";
                $menu_float_output .= $menu_output . "\n";
                if ( $layout == "float-2" ) {
                    $menu_float_output .= '<nav class="std-menu float-alt-menu">' . "\n";
                    $menu_float_output .= '<ul class="menu">' . "\n";
                    $menu_float_output .= uplift_get_search( $header_search_type );
                    if ( $show_cart ) {
                        $menu_float_output .= uplift_get_cart();
                    }
                    if ( class_exists( 'YITH_WCWL_UI' ) && $show_wishlist ) {
                        $menu_float_output .= uplift_get_wishlist();
                    }
                    $menu_float_output .= '</ul>' . "\n";
                    $menu_float_output .= '</nav>' . "\n";
                }
                $menu_float_output .= '</div>' . "\n";

                $menu_output = $menu_float_output;

            } else if ( $layout == "vertical" ) {

                $menu_vert_output .= $menu_output . "\n";
                $menu_vert_output .= '<div class="vertical-menu-bottom">' . "\n";
                $menu_vert_output .= uplift_header_aux('right');
                $menu_vert_output .= '<div class="copyright">' . do_shortcode( stripslashes( $vertical_header_text ) ) . '</div>' . "\n";
                $menu_vert_output .= '</div>' . "\n";

                $menu_output = $menu_vert_output;
            }

            // MENU RETURN
            return $menu_output;
        }
    }


    /* MOBILE HEADER
    ================================================== */
    if ( ! function_exists( 'uplift_mobile_header' ) ) {
        function uplift_mobile_header() {

            global $woocommerce;
            $uplift_options = uplift_get_theme_opts();

            $mobile_header_layout = $uplift_options['mobile_header_layout'];
            $mobile_top_text      = $uplift_options['mobile_top_text'];
            $mobile_menu_icon     = apply_filters( 'uplift_mobile_menu_icon', '<span class="menu-bars"></span>' );
            $mobile_cart_icon     = apply_filters( 'uplift_mobile_cart_icon', '<i class="ss-cart"></i>' );
            $mobile_show_cart     = $uplift_options['mobile_show_cart'];

			$mobile_header_class = "";
			
			if ( uplift_theme_supports('hamburger-css') ) {
				$mobile_menu_type        = "slideout";
				$hamburger_class = 'hamburger--3dx';
				if ( isset( $uplift_options['mobile_menu_type'] ) ) {
				    $mobile_menu_type = $uplift_options['mobile_menu_type'];
				}
				if ( $mobile_menu_type == "overlay" ) {
					$hamburger_class = 'hamburger--3dy';
				}
				
				$mobile_menu_link = '<button class="hamburger mobile-menu-link '.$hamburger_class.'" type="button">
                    <span class="button-text">' . __( 'Menu', 'uplift' ) . '</span>
				  <span class="hamburger-box">
				    <span class="hamburger-inner"></span>
				  </span>
				</button>';
			} else {
				$mobile_menu_link = '<a href="#" class="mobile-menu-link menu-bars-link">' . $mobile_menu_icon . '</a>';
			}

            if ( $mobile_top_text != "" ) {
                echo '<div id="mobile-top-text">' . do_shortcode( $mobile_top_text ) . '</div>';
            }

            echo '<header id="mobile-header" class="mobile-' . $mobile_header_layout . ' clearfix">' . "\n";

            if ( $mobile_header_layout == "right-logo" ) {
                echo '<div class="mobile-header-opts">';
                echo wp_kses_post($mobile_menu_link) . "\n";
                if ( $mobile_show_cart && $woocommerce != "" ) {
                    echo '<nav class="std-menu float-alt-menu">' . "\n";
                    echo '<ul class="menu">' . "\n";
                    echo uplift_get_cart();
                    echo '</ul>' . "\n";
                    echo '</nav>' . "\n";
                }
                echo '</div>';
                echo uplift_logo( 'logo-right', 'mobile-logo' );
            } else if ( $mobile_header_layout == "center-logo" ) {
                echo '<div class="mobile-header-opts opts-left">';
                echo wp_kses_post($mobile_menu_link) . "\n";
                echo '</div>';
                echo uplift_logo( 'logo-center', 'mobile-logo' );
                echo '<div class="mobile-header-opts opts-right">';
                if ( $mobile_show_cart && $woocommerce != "" ) {
                    echo '<nav class="std-menu float-alt-menu">' . "\n";
                    echo '<ul class="menu">' . "\n";
                    echo uplift_get_cart();
                    echo '</ul>' . "\n";
                    echo '</nav>' . "\n";
                }
                echo '</div>';
            } else if ( $mobile_header_layout == "center-logo-alt" ) {
                echo '<div class="mobile-header-opts opts-left">';
                if ( $mobile_show_cart && $woocommerce != "" ) {
                    echo '<nav class="std-menu float-alt-menu">' . "\n";
                    echo '<ul class="menu">' . "\n";
                    echo uplift_get_cart();
                    echo '</ul>' . "\n";
                    echo '</nav>' . "\n";
                }
                echo '</div>';
                echo uplift_logo( 'logo-center', 'mobile-logo' );
                echo '<div class="mobile-header-opts opts-right">';
                echo wp_kses_post($mobile_menu_link) . "\n";
                echo '</div>';
            } else {
                echo uplift_logo( 'logo-left', 'mobile-logo' );
                echo '<div class="mobile-header-opts">';
                echo wp_kses_post($mobile_menu_link) . "\n";
                if ( $mobile_show_cart && $woocommerce != "" ) {
                    echo '<nav class="std-menu float-alt-menu">' . "\n";
                    echo '<ul class="menu">' . "\n";
                    echo uplift_get_cart();
                    echo '</ul>' . "\n";
                    echo '</nav>' . "\n";
                }
                echo '</div>';
            }
            echo '</header>' . "\n";

        }

        add_action( 'uplift_container_start', 'uplift_mobile_header', 10 );
    }


    /* MOBILE MENU
    ================================================== */
    if ( ! function_exists( 'uplift_mobile_menu' ) ) {
        function uplift_mobile_menu() {

            global $post;
            $uplift_options = uplift_get_theme_opts();
			
			$header_search_pt = $uplift_options['header_search_pt'];
			$mobile_header_layout = $uplift_options['mobile_header_layout'];
            $mobile_show_translation = $uplift_options['mobile_show_translation'];
            $mobile_show_search      = $uplift_options['mobile_show_search'];
            $mobile_menu_type        = "slideout";
            $fs_close_icon = apply_filters( 'uplift_fullscreen_close_icon', '<i class="ss-delete"></i>' );
            if ( isset( $uplift_options['mobile_menu_type'] ) ) {
                $mobile_menu_type = $uplift_options['mobile_menu_type'];
            }
            $page_menu = "";

            if ( $post && !is_search() ) {
                $page_menu = uplift_get_post_meta( $post->ID, 'sf_page_menu', true );
            }

            $mobile_menu_args = array(
                'echo'           => false,
                'theme_location' => 'mobile_menu',
                'walker'         => new uplift_alt_menu_walker,
                'fallback_cb'    => '',
                'menu'			 => $page_menu
            );

            if ( $mobile_header_layout == "left-logo" || $mobile_header_layout == "center-logo-alt" ) {
            	echo '<div id="mobile-menu-wrap" class="menu-is-right">' . "\n";
            } else {
            	echo '<div id="mobile-menu-wrap" class="menu-is-left">' . "\n";
            }

            if ( $mobile_menu_type == "overlay" ) {
                echo '<a href="#" class="mobile-overlay-close">'.$fs_close_icon.'</a>';
            }

            if ( $mobile_show_translation && ( function_exists( 'pll_the_languages' ) || function_exists( 'icl_get_languages' ) ) ) {
                echo '<ul class="mobile-language-select">' . uplift_language_flags() . '</ul>' . "\n";
            }
            if ( $mobile_show_search ) {
                echo '<form method="get" class="mobile-search-form" action="' . home_url() . '/"><input type="text" placeholder="' . __( "Enter text to search", 'uplift' ) . '" name="s" autocomplete="off" />';
                if ( $header_search_pt != "any" ) {
                    echo '<input type="hidden" name="post_type" value="' . esc_attr($header_search_pt) . '" />';
                }
                echo '</form>' . "\n";
            }
            echo '<nav id="mobile-menu" class="clearfix">' . "\n";

            if ( function_exists( 'wp_nav_menu' ) ) {
                echo wp_nav_menu( $mobile_menu_args );
            }

            echo '</nav>' . "\n";
            echo '</div>' . "\n";
        }

        add_action( 'uplift_before_page_container', 'uplift_mobile_menu', 10 );
    }

    /* MOBILE MENU
    ================================================== */
    if ( ! function_exists( 'uplift_mobile_cart' ) ) {
        function uplift_mobile_cart() {

            global $woocommerce;
            $uplift_options = uplift_get_theme_opts();

			$mobile_header_layout = $uplift_options['mobile_header_layout'];
            $mobile_show_cart    = $uplift_options['mobile_show_cart'];
            $mobile_show_account = $uplift_options['mobile_show_account'];
            $login_url           = wp_login_url();
            $logout_url          = wp_logout_url( home_url() );
            $my_account_link     = get_admin_url();
            $myaccount_page_id   = get_option( 'woocommerce_myaccount_page_id' );
            if ( $myaccount_page_id ) {
                $my_account_link = get_permalink( $myaccount_page_id );
                $logout_url      = wp_logout_url( get_permalink( $myaccount_page_id ) );
                $login_url       = get_permalink( $myaccount_page_id );
                if ( get_option( 'woocommerce_force_ssl_checkout' ) == 'yes' ) {
                    $logout_url = str_replace( 'http:', 'https:', $logout_url );
                    $login_url  = str_replace( 'http:', 'https:', $login_url );
                }
            }
            $login_url        = apply_filters( 'uplift_header_login_url', $login_url );
            $my_account_link  = apply_filters( 'uplift_header_myaccount_url', $my_account_link );
            $fs_close_icon    = apply_filters( 'uplift_fullscreen_close_icon', '<i class="ss-delete"></i>' );
            $mobile_menu_type = "slideout";
            if ( isset( $uplift_options['mobile_menu_type'] ) ) {
                $mobile_menu_type = $uplift_options['mobile_menu_type'];
            }

            if ( $mobile_show_cart && $woocommerce ) {
	            if ( $mobile_header_layout == "left-logo" || $mobile_header_layout == "center-logo-alt" ) {
	            	echo '<div id="mobile-cart-wrap" class="cart-is-left">' . "\n";
	            } else {
	            	echo '<div id="mobile-cart-wrap" class="cart-is-right">' . "\n";
	            }

                if ( $mobile_menu_type == "overlay" ) {
                    echo '<a href="#" class="mobile-overlay-close">'.$fs_close_icon.'</a>';
                }

                echo '<ul>' . "\n";
                echo uplift_get_cart();
                echo '</ul>' . "\n";
                if ( $mobile_show_account ) {
                    echo '<ul class="mobile-cart-menu">' . "\n";
                    if ( is_user_logged_in() ) {
                        echo '<li><a href="' . $my_account_link . '" class="admin-link">' . __( "My Account", 'uplift' ) . '</a></li>' . "\n";
                        echo '<li><a href="' . $logout_url . '">' . __( "Sign Out", 'uplift' ) . '</a></li>' . "\n";
                    } else {
                        echo '<li><a href="' . $login_url . '">' . __( "Login", 'uplift' ) . '</a></li>' . "\n";
                    }
                    echo '</ul>' . "\n";
                }
                echo '</div>' . "\n";
            }
        }

        add_action( 'uplift_before_page_container', 'uplift_mobile_cart', 20 );
    }


    /* WOO LINKS
    ================================================== */
    if ( ! function_exists( 'uplift_woo_links' ) ) {
        function uplift_woo_links( $position = "", $config = "" ) {

            // VARIABLES
            $uplift_options = uplift_get_theme_opts();

            $tb_search_text   = $uplift_options['tb_search_text'];
            $woo_links_output = $ss_enable = "";
			$supersearch_icon = apply_filters('uplift_header_supersearch_icon', '<i class="ss-zoomin"></i>');

            if ( isset( $uplift_options['ss_enable'] ) ) {
                $ss_enable = $uplift_options['ss_enable'];
            } else {
                $ss_enable = true;
            }

            // WOO LINKS OUTPUT
            $woo_links_output .= '<nav class="' . $position . '">' . "\n";
            $woo_links_output .= '<ul class="menu">' . "\n";
            if ( is_user_logged_in() ) {
                $current_user = wp_get_current_user();
                $woo_links_output .= '<li class="tb-welcome">' . __( "Welcome", 'uplift' ) . " " . $current_user->display_name . '</li>' . "\n";
            } else {
                $woo_links_output .= '<li class="tb-welcome">' . __( "Welcome", 'uplift' ) . '</li>' . "\n";
            }
            if ( $ss_enable ) {
                if ( $position == "top-menu" ) {
                    $woo_links_output .= '<li class="tb-woo-custom clearfix"><a class="swift-search-link" href="#">'.$supersearch_icon.'<span>' . do_shortcode( $tb_search_text ) . '</span></a></li>' . "\n";
                } else {
                    $woo_links_output .= '<li class="hs-woo-custom clearfix"><a class="swift-search-link" href="#">'.$supersearch_icon.'<span>' . do_shortcode( $tb_search_text ) . '</span></a></li>' . "\n";
                }
            }
            $woo_links_output .= '</ul>' . "\n";
            $woo_links_output .= '</nav>' . "\n";

            // RETURN
            return $woo_links_output;
        }
    }


    /* AUX LINKS
    ================================================== */
    if ( ! function_exists( 'uplift_aux_links' ) ) {
        function uplift_aux_links( $position, $alt_version = false, $header_version = "" ) {

            // VARIABLES
            $login_url         = wp_login_url();
            $logout_url        = wp_logout_url( home_url() );
            $my_account_link   = get_admin_url();
            $myaccount_page_id = get_option( 'woocommerce_myaccount_page_id' );
            if ( $myaccount_page_id ) {
                $my_account_link = get_permalink( $myaccount_page_id );
                $logout_url      = wp_logout_url( get_permalink( $myaccount_page_id ) );
                $login_url       = get_permalink( $myaccount_page_id );
                if ( get_option( 'woocommerce_force_ssl_checkout' ) == 'yes' ) {
                    $logout_url = str_replace( 'http:', 'https:', $logout_url );
                    $login_url  = str_replace( 'http:', 'https:', $login_url );
                }
            }
            $login_url       = apply_filters( 'uplift_header_login_url', $login_url );
            $my_account_link = apply_filters( 'uplift_header_myaccount_url', $my_account_link );

            $uplift_options = uplift_get_theme_opts();

            $show_sub         = $uplift_options['show_sub'];
            $show_translation = $uplift_options['show_translation'];
            $sub_code         = $uplift_options['sub_code'];
            $show_account     = $uplift_options['show_account'];
            $show_cart = $show_wishlist = false;
            if ( isset($uplift_options['show_cart']) ) {
            $show_cart            = $uplift_options['show_cart'];
            }
            if ( isset($uplift_options['show_wishlist']) ) {
            $show_wishlist            = $uplift_options['show_wishlist'];
            }
            $ss_enable        = $uplift_options['ss_enable'];
            $aux_links_output = $ss_enable = "";


            // LINKS + SEARCH OUTPUT
            $aux_links_output .= '<nav class="std-menu ' . $position . '">' . "\n";
            $aux_links_output .= '<ul class="menu">' . "\n";
            if ( $show_account ) {
                if ( is_user_logged_in() ) {
                    $aux_links_output .= '<li><a href="' . $logout_url . '">' . __( "Sign Out", 'uplift' ) . '</a></li>' . "\n";
                    $aux_links_output .= '<li><a href="' . $my_account_link . '" class="admin-link">' . __( "My Account", 'uplift' ) . '</a></li>' . "\n";
                } else {
                    $aux_links_output .= '<li><a href="' . $login_url . '">' . __( "Login", 'uplift' ) . '</a></li>' . "\n";
                }
            }
            if ( $show_sub ) {
                $aux_links_output .= '<li class="parent"><a href="#">' . __( "Subscribe", 'uplift' ) . '</a>' . "\n";
                $aux_links_output .= '<ul class="sub-menu">' . "\n";
                $aux_links_output .= '<li><div class="header-subscribe clearfix">' . "\n";
                $aux_links_output .= do_shortcode( $sub_code ) . "\n";
                $aux_links_output .= '</div></li>' . "\n";
                $aux_links_output .= '</ul>' . "\n";
                $aux_links_output .= '</li>' . "\n";
            }
            if ( $show_translation ) {
                $aux_links_output .= '<li class="parent aux-languages"><a href="#">' . __( "Language", 'uplift' ) . '</a>' . "\n";
                $aux_links_output .= '<ul class="header-languages sub-menu">' . "\n";
                if ( function_exists( 'uplift_language_flags' ) ) {
                    $aux_links_output .= uplift_language_flags();
                }
                $aux_links_output .= '</ul>' . "\n";
                $aux_links_output .= '</li>' . "\n";
            }
            if ( $header_version != "header-1" ) {
                if ( $show_cart ) {
                    $aux_links_output .= uplift_get_cart();
                }
                if ( class_exists( 'YITH_WCWL_UI' ) && $show_wishlist ) {
                    $aux_links_output .= uplift_get_wishlist();
                }
            }
            $aux_links_output .= '</ul>' . "\n";
            $aux_links_output .= '</nav>' . "\n";

            // RETURN
            return $aux_links_output;
        }
    }


    /* SEARCH DROPDOWN
    ================================================== */
    if ( ! function_exists( 'uplift_get_search' ) ) {
        function uplift_get_search( $type ) {

            if ( $type == "search-off" ) {
                return;
            }

            $uplift_options = uplift_get_theme_opts();

            $header_search_pt = $uplift_options['header_search_pt'];
            $ajax_url         = admin_url( 'admin-ajax.php' );
            $search_icon 	  = apply_filters( 'uplift_header_search_icon' , '<i class="ss-search"></i>' );

            $search_output = "";

            $search_output .= '<li class="menu-search parent"><a href="#" class="header-search-link-alt">'.$search_icon.'</a>' . "\n";
            $search_output .= '<div class="ajax-search-wrap" data-ajaxurl="' . $ajax_url . '"><div class="ajax-loading"></div><form method="get" class="ajax-search-form" action="' . home_url() . '/">';
            if ( $header_search_pt != "any" ) {
                $search_output .= '<input type="hidden" name="post_type" value="' . $header_search_pt . '" />';
            }
            $search_output .= '<input type="text" placeholder="' . __( "Search", 'uplift' ) . '" name="s" autocomplete="off" /></form><div class="ajax-search-results"></div></div>' . "\n";
            $search_output .= '</li>' . "\n";

            return $search_output;
        }
    }


    /* CART DROPDOWN
    ================================================== */
    if ( ! function_exists( 'uplift_get_cart' ) ) {
        function uplift_get_cart() {

            $cart_output = "";

            // Check if WooCommerce is active
            if ( uplift_woocommerce_activated() ) {

                global $woocommerce;
                $uplift_options = uplift_get_theme_opts();

                $show_cart_count = false;
                if ( isset( $uplift_options['show_cart_count'] ) ) {
                    $show_cart_count = $uplift_options['show_cart_count'];
                }
				
				$cart_total =  WC()->cart->get_cart_subtotal();
				
                $cart_count          = $woocommerce->cart->cart_contents_count;
                $cart_count_text     = uplift_product_items_text( $cart_count );
                $cart_count_text_alt = uplift_product_items_text( $cart_count, true );
				$view_cart_icon 	 = apply_filters( 'uplift_view_cart_icon', '<i class="ss-view"></i>' );
				$checkout_icon 	 	 = apply_filters( 'uplift_checkout_icon', '<i class="ss-creditcard"></i>' );
				$go_to_shop_icon  	 = apply_filters( 'uplift_go_to_shop_icon', '<i class="ss-cart"></i>' );

                if ( $show_cart_count ) {
                    $cart_output .= '<li class="parent shopping-bag-item"><a class="cart-contents" href="' . esc_url( wc_get_cart_url() ) . '" title="' . __( "View your shopping cart", 'uplift' ) . '">'. apply_filters( 'uplift_header_cart_icon', '<i class="ss-cart"></i>' ) . '<span class="cart-text">' . __( "Cart", 'uplift' ) . '</span>' . $cart_total . '<span class="num-items cart-count-enabled">' . $cart_count_text_alt . '</span></a>';
                } else {
                    $cart_output .= '<li class="parent shopping-bag-item"><a class="cart-contents" href="' . esc_url( wc_get_cart_url() ) . '" title="' . __( "View your shopping cart", 'uplift' ) . '">'. apply_filters( 'uplift_header_cart_icon', '<i class="ss-cart"></i>' ) . '<span class="cart-text">' . __( "Cart", 'uplift' ) . '</span>' . $cart_total . '<span class="num-items">' . $cart_count_text_alt . '</span></a>';
                }
                $cart_output .= '<ul class="sub-menu">';
                $cart_output .= '<li>';

                $cart_output .= '<div class="shopping-bag">';

                $cart_output .= '<div class="loading-overlay"><i class="sf-icon-loader"></i></div>';

                if ( $cart_count != "0" ) {

                    $cart_output .= '<div class="bag-header">' . $cart_count_text . ' ' . __( 'in the cart', 'uplift' ) . '</div>';

                    $cart_output .= '<div class="bag-contents">';

                    foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {

                        $_product     		 = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                        $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
                        
						if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
						
							$product_price     = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
							$product_title       = $_product->get_title();
							$product_short_title = ( strlen( $product_title ) > 25 ) ? substr( $product_title, 0, 22 ) . '...' : $product_title;
							
                            $cart_output .= '<div class="bag-product clearfix">';
                            $cart_output .= '<figure><a class="bag-product-img" href="' . get_permalink( $cart_item['product_id'] ) . '">' . $_product->get_image() . '</a></figure>';
                            $cart_output .= '<div class="bag-product-details">';
                            $cart_output .= '<div class="bag-product-title"><a href="' . get_permalink( $cart_item['product_id'] ) . '">' . apply_filters( 'woocommerce_cart_widget_product_title', $product_short_title, $_product ) . '</a></div>';
                            $cart_output .= '<div class="bag-product-price">' . __( "Unit Price:", 'uplift' ) . '
	                        ' . $product_price . '</div>';
                            $cart_output .= '<div class="bag-product-quantity">' . __( 'Quantity:', 'uplift' ) . ' ' . apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf( '%s &times; %s', $cart_item['quantity'], $product_price ) . '</span>', $cart_item, $cart_item_key ) . '</div>';
                            $cart_output .= '</div>';
                            if (function_exists('wc_get_cart_remove_url')) {
                                $cart_output .= apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
                                    '<a href="%s" class="remove remove-product" title="%s" data-ajaxurl="'.admin_url( 'admin-ajax.php' ).'" data-product-qty="'. $cart_item['quantity'] .'"  data-product-id="%s" data-product_sku="%s" data-variation-id="%s">&times;</a>',
                                    esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
                                    __( 'Remove this item', 'uplift' ),
                                    esc_attr( $product_id ),
                                    esc_attr( $_product->get_sku() ),
                                    esc_attr( $product_id )
                                ), $cart_item_key );
                            } else {
                                $cart_output .= apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
                                    '<a href="%s" class="remove remove-product" title="%s" data-ajaxurl="'.admin_url( 'admin-ajax.php' ).'" data-product-qty="'. $cart_item['quantity'] .'"  data-product-id="%s" data-product_sku="%s" data-variation-id="%s">&times;</a>',
                                    esc_url( WC()->cart->get_remove_url( $cart_item_key ) ),
                                    __( 'Remove this item', 'uplift' ),
                                    esc_attr( $product_id ),
                                    esc_attr( $_product->get_sku() ),
                                    esc_attr( $product_id )
                                ), $cart_item_key );
                            }
                            $cart_output .= '</div>';
                        }
                    }

                    $cart_output .= '</div>';

                    $cart_output .= '<div class="bag-total">';
                    if ( class_exists( 'Woocommerce_German_Market' ) ) {
                    $cart_output .= '<span class="total-title">' . __( "Total incl. tax", 'uplift' ) . '</span>';
                    } else {
                    $cart_output .= '<span class="total-title">' . __( "Total", 'uplift' ) . '</span>';
                    }
                    $cart_output .= '<span class="total-amount">' .  WC()->cart->get_cart_total() . '</span>';
                    $cart_output .= '</div>';

                    $cart_output .= '<div class="bag-buttons">';

                    $cart_output .= '<a class="sf-button standard sf-icon-reveal bag-button" href="' . esc_url( wc_get_cart_url() ) . '">'.$view_cart_icon.'<span class="text">' . __( 'View cart', 'uplift' ) . '</span></a>';

                    $cart_output .= '<a class="sf-button standard sf-icon-reveal checkout-button" href="' . esc_url( wc_get_checkout_url() ) . '">'.$checkout_icon.'<span class="text">' . __( 'Checkout', 'uplift' ) . '</span></a>';

                    $cart_output .= '</div>';

                } else {

                    $cart_output .= '<div class="bag-empty">' . __( 'Your cart is empty.', 'uplift' ) . '</div>';

                }

                $cart_output .= '</div>';
                $cart_output .= '</li>';
                $cart_output .= '</ul>';
                $cart_output .= '</li>';
            }

            return $cart_output;
        }
    }


    /* WISHLIST DROPDOWN
    ================================================== */
    if ( ! function_exists( 'uplift_get_wishlist' ) ) {
        function uplift_get_wishlist() {

            global $wpdb, $yith_wcwl, $woocommerce;

            if ( ! $yith_wcwl || ! $woocommerce ) {
                return;
            }

            $wishlist_output = "";

            if ( is_user_logged_in() ) {
                $user_id = get_current_user_id();
            }

            $wishlist_icon = apply_filters( 'uplift_view_wishlist_icon', '<i class="ss-star"></i>' );

            $count = array();

            if ( is_user_logged_in() ) {
                $count = $wpdb->get_results( $wpdb->prepare( 'SELECT COUNT(*) as `cnt` FROM `' . YITH_WCWL_TABLE . '` WHERE `user_id` = %d', $user_id ), ARRAY_A );
                $count = $count[0]['cnt'];
            } else{
                $count[0]['cnt'] = count( yith_getcookie( 'yith_wcwl_products' ) );
                $count           = $count[0]['cnt'];
            }

            if ( is_array( $count ) ) {
                $count = 0;
            }

			$wishlist_output .= '<li class="parent wishlist-item"><a class="wishlist-link" href="' . $yith_wcwl->get_wishlist_url() . '" title="' . __( "View your wishlist", 'uplift' ) . '"><span class="menu-item-title">' . __( "Wishlist", 'uplift' ) . '</span> ' . apply_filters( 'uplift_wishlist_menu_icon', '<i class="ss-star"></i>' ) . '<span class="count">' . $count . '</span><span class="star"></span></a>';

            $wishlist_output .= '<ul class="sub-menu">';
            $wishlist_output .= '<li>';
            $wishlist_output .= '<div class="wishlist-bag">';

            $current_page = 1;
            $limit_sql    = '';
            $count_limit  = 0;

            if ( is_user_logged_in() ) {
                $wishlist = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `" . YITH_WCWL_TABLE . "` WHERE `user_id` = %s" . $limit_sql, $user_id ), ARRAY_A );
            } else {
                $wishlist = yith_getcookie( 'yith_wcwl_products' );
            }

            $wishlist_output .= '<div class="bag-contents">';

            $wishlist_output .= do_action( 'yith_wcwl_before_wishlist' );

            if ( count( $wishlist ) > 0 ) :

                foreach ( $wishlist as $values ) :

                    if ( $count_limit < 3 ) {

                        if ( ! is_user_logged_in() ) {
                            if ( isset( $values['add-to-wishlist'] ) && is_numeric( $values['add-to-wishlist'] ) ) {
                                $values['prod_id'] = $values['add-to-wishlist'];
                                $values['ID']      = $values['add-to-wishlist'];
                            } else {
                            	if ( isset($values['product_id'] )){
								   $values['prod_id'] = $values['product_id'];
                                   $values['ID']      = $values['product_id'];	
								}else{
									 $values['ID']      = $values['prod_id'];	
								}
                                
                            }
                        }

                        $product_obj = wc_get_product( $values['prod_id'] );
						$product_obj_id = method_exists( $product_obj, 'get_id' ) ? $product_obj->get_id() : $product_obj->id;
						
                        if ( $product_obj !== false && $product_obj->exists() ) :

                            $wishlist_output .= '<div id="wishlist-' . $values['ID'] . '" class="bag-product clearfix prod-' .  $values['prod_id'] . '">';

                            if ( has_post_thumbnail( $product_obj_id ) ) {
                                $image_link = wp_get_attachment_url( get_post_thumbnail_id( $product_obj_id ) );
                                $image      = wp_get_attachment_image_src( get_post_thumbnail_id( $product_obj_id ), 'thumbnail' );

                                if ( $image ) {
                                    $wishlist_output .= '<figure><a class="bag-product-img" href="' . esc_url( get_permalink( apply_filters( 'woocommerce_in_cart_product', $values['prod_id'] ) ) ) . '"><img itemprop="image" src="' . $image[0] . '" width="' . $image[1] . '" height="' . $image[2] . '" /></a></figure>';
                                }
                            }

                            $wishlist_output .= '<div class="bag-product-details">';
                            $wishlist_output .= '<div class="bag-product-title"><a href="' . esc_url( get_permalink( apply_filters( 'woocommerce_in_cart_product', $values['prod_id'] ) ) ) . '">' . apply_filters( 'woocommerce_in_cartproduct_obj_title', $product_obj->get_title(), $product_obj ) . '</a></div>';

                            if ( get_option( 'woocommerce_display_cart_prices_excluding_tax' ) == 'yes' ) {
                                $wishlist_output .= '<div class="bag-product-price">' . apply_filters( 'woocommerce_cart_item_price_html', wc_price( $product_obj->get_price_excluding_tax() ), $values, '' ) . '</div>';
                            } else {
                                $wishlist_output .= '<div class="bag-product-price">' . apply_filters( 'woocommerce_cart_item_price_html', wc_price( $product_obj->get_price() ), $values, '' ) . '</div>';
                            }
                            $wishlist_output .= '</div>';
                            $wishlist_output .= '</div>';

                        endif;

                        $count_limit ++;
                    }

                endforeach;

            else :
                $wishlist_output .= '<div class="wishlist-empty">' . __( 'Your wishlist is empty.', 'uplift' ) . '</div>';
            endif;

            $wishlist_output .= '</div>';

            if ( count( $wishlist ) > 0 ) {
				$wishlist_output .= '<div class="bag-buttons">';
			} else {
				$wishlist_output .= '<div class="bag-buttons no-items">';
			}
            $wishlist_output .= '<a class="sf-button standard sf-icon-reveal wishlist-button" href="' . $yith_wcwl->get_wishlist_url() . '">'.$wishlist_icon.'<span class="text">' . __( 'View Wishlist', 'uplift' ) . '</span></a>';

            $wishlist_output .= '</div>';

            $wishlist_output .= '</div>';
            $wishlist_output .= '</li>';
            $wishlist_output .= '</ul>';
            $wishlist_output .= '</li>';

            return $wishlist_output;
        }
    }

	/* CURRENCY DROPDOWN
	================================================== */
	if ( ! function_exists( 'uplift_get_currency_switcher' ) ) {
	    function uplift_get_currency_switcher() {
	    	$currency_switch_output = "";
	    	if ( class_exists('WCML_Multi_Currency') ) {
	    		$currency_code = get_option('woocommerce_currency');
	    		$currency_switch_output .= '<li class="parent currency-switch-item">';
	    		$currency_switch_output .= '<span class="current-currency">' . get_woocommerce_currency_symbol() . '</span>';
	    		if ( uplift_theme_supports('nucleo-svg-icons') ) {
	    			$currency_switch_output .= uplift_get_preloader_svg(true);
	    		}
	    		$currency_switch_output .= do_shortcode('[currency_switcher switcher_style="list" format="%code% (%symbol%)"]');
	    		$currency_switch_output .= '</li>';
	    		return $currency_switch_output;
	    	} else {
	    		$currency_switch_output = '<li><span class="current-currency">&times;</span><ul class="sub-menu"><li><span>WPML + WooCommerce Multilingual plugins are required for this functionality.</span></li></ul></li>';
	    		return $currency_switch_output;
	    	}
	    }
	}

    /* ACCOUNT
    ================================================== */
    if ( ! function_exists( 'uplift_get_account' ) ) {
        function uplift_get_account( $aux = "" ) {

        	// VARIABLES
            $login_url         = wp_login_url();
            $logout_url        = wp_logout_url( home_url() );
            $my_account_link   = get_admin_url();
            $myaccount_page_id = get_option( 'woocommerce_myaccount_page_id' );
            if ( $myaccount_page_id ) {
                $my_account_link = get_permalink( $myaccount_page_id );
                $logout_url      = wp_logout_url( get_permalink( $myaccount_page_id ) );
                $login_url       = get_permalink( $myaccount_page_id );
                if ( get_option( 'woocommerce_force_ssl_checkout' ) == 'yes' ) {
                    $logout_url = str_replace( 'http:', 'https:', $logout_url );
                    $login_url  = str_replace( 'http:', 'https:', $login_url );
                }
            }
            $login_url       = apply_filters( 'uplift_header_login_url', $login_url );
            $register_url	 = apply_filters( 'uplift_header_register_url', wp_registration_url() );
            $my_account_link = apply_filters( 'uplift_header_myaccount_url', $my_account_link );

			if ( get_option( 'woocommerce_enable_myaccount_registration' ) && $myaccount_page_id ) {
				$register_url = apply_filters( 'uplift_header_register_url', $my_account_link );
			}

            $uplift_options = uplift_get_theme_opts();

            $show_sub         = $uplift_options['show_sub'];
            $show_translation = false;
            if ( isset($uplift_options['show_translation']) ) {
            	$show_translation = $uplift_options['show_translation'];
            }
            $sub_code         = $uplift_options['sub_code'];
            $account_output = "";


            // LINKS + SEARCH OUTPUT
            $account_output .= '<nav class="std-menu">' . "\n";
            $account_output .= '<ul class="menu">' . "\n";
            $account_output .= '<li class="parent account-item">' . "\n";
            
            if ( $aux == "aux-text" ) {
            	$account_output .= '<a href="#">' . __( "My Account", 'uplift' ) . '</a>' . "\n";  
            } else {
				$account_output .= '<a href="#"><i class="sf-icon-account"></i></a>' . "\n";            
            }
            
			$account_output .= '<ul class="sub-menu">' . "\n";
            if ( is_user_logged_in() ) {
                $account_output .= '<li class="menu-item"><a href="' . $my_account_link . '" class="admin-link">' . __( "My Account", 'uplift' ) . '</a></li>' . "\n";
                $account_output .= '<li class="menu-item"><a href="' . $logout_url . '">' . __( "Sign Out", 'uplift' ) . '</a></li>' . "\n";
            } else {
                $account_output .= '<li class="menu-item"><a href="' . $login_url . '">' . __( "Login", 'uplift' ) . '</a></li>' . "\n";
                $account_output .= '<li class="menu-item"><a href="' . $register_url . '">' . __( "Sign Up", 'uplift' ) . '</a></li>' . "\n";
            }
            if ( $show_sub && $sub_code != "" ) {
                $account_output .= '<li class="parent"><a href="#">' . __( "Subscribe", 'uplift' ) . '</a>' . "\n";
                $account_output .= '<ul class="sub-menu">' . "\n";
                $account_output .= '<li><div class="header-subscribe clearfix">' . "\n";
                $account_output .= do_shortcode( $sub_code ) . "\n";
                $account_output .= '</div></li>' . "\n";
                $account_output .= '</ul>' . "\n";
                $account_output .= '</li>' . "\n";
            }
            if ( $show_translation ) {
                $account_output .= '<li class="parent aux-languages"><a href="#">' . __( "Language", 'uplift' ) . '</a>' . "\n";
                $account_output .= '<ul class="header-languages sub-menu">' . "\n";
                if ( function_exists( 'uplift_language_flags' ) ) {
                    $account_output .= uplift_language_flags();
                }
                $account_output .= '</ul>' . "\n";
                $account_output .= '</li>' . "\n";
            }
            $account_output .= '</ul>' . "\n";
            $account_output .= '</li>' . "\n";
            $account_output .= '</ul>' . "\n";
            $account_output .= '</nav>' . "\n";

            // RETURN
            return $account_output;

        }
    }
	
	
	/* LANGUAGE
    ================================================== */
    if ( ! function_exists( 'uplift_get_language_aux' ) ) {
        function uplift_get_language_aux( $aux = "" ) {

            $language_output = "";

            $language_output .= '<nav class="std-menu">' . "\n";
            $language_output .= '<ul class="menu">' . "\n";
            $language_output .= '<li class="parent language-item">' . "\n";
            
            if ( $aux == "aux-text" ) {
            	$language_output .= '<a href="#">' . __( "Language", 'uplift' ) . '</a>' . "\n";  
            } else {
				$language_output .= '<a href="#"><i class="sf-icon-uk"></i></a>' . "\n";            
            }
            
            $language_output .= '<ul class="header-languages sub-menu">' . "\n";
            if ( function_exists( 'uplift_language_flags' ) ) {
                $language_output .= uplift_language_flags();
            }
            $language_output .= '</ul>' . "\n";
            $language_output .= '</li>' . "\n";
            $language_output .= '</ul>' . "\n";
            $language_output .= '</nav>' . "\n";

            // RETURN
            return $language_output;
        }
    }
    

    /* AJAX SEARCH
    ================================================== */
    if ( ! function_exists( 'uplift_ajaxsearch' ) ) {
        function uplift_ajaxsearch() {
            $uplift_options = uplift_get_theme_opts();
            $page_classes       = uplift_page_classes();
            $header_layout      = $page_classes['header-layout'];
            $header_search_type = "standard";
            if ( isset($uplift_options['header_search_type']) ) {
            $header_search_type = $uplift_options['header_search_type'];
            }
            $header_search_pt   = $uplift_options['header_search_pt'];
            if ( $header_search_pt == "" ) {
				$header_search_pt = "any";
			}
            $remove_dates  = $uplift_options['remove_dates'];
            $search_term        = trim( $_POST['s'] );
            $search_query_args  = array(
                's'                => $search_term,
                'post_type'        => $header_search_pt,
                'post_status'      => 'publish',
                'suppress_filters' => false,
                'numberposts'      => - 1
            );
            $search_query_args  = http_build_query( $search_query_args );
            $search_results     = get_posts( $search_query_args );
            $count              = count( $search_results );
            $shown_results      = 5;

            if ( $header_layout == "header-vert" || $header_layout == "header-vert-right" ) {
                $shown_results = 2;
            }

            if ( $header_search_type == "fs-search-on" ) {
                $shown_results = 20;
            }

            if ( ! empty( $search_results ) ) {

                $sorted_posts = $post_type = array();

                foreach ( $search_results as $search_result ) {
                    $sorted_posts[ $search_result->post_type ][] = $search_result;
                    // Check we don't already have this post type in the post_type array
                    if ( empty( $post_type[ $search_result->post_type ] ) ) {
                        // Add the post type object to the post_type array
                        $post_type[ $search_result->post_type ] = get_post_type_object( $search_result->post_type );
                    }
                }

                $i = 0;
                foreach ( $sorted_posts as $key => $type ) {
                    echo '<div class="search-result-pt">';
                    if ( isset( $post_type[ $key ]->labels->name ) ) {
                        echo "<h6>" . $post_type[ $key ]->labels->name . "</h6>";
                    } else if ( isset( $key ) ) {
                        echo "<h6>" . $key . "</h6>";
                    } else {
                        echo "<h6>" . __( "Other", 'uplift' ) . "</h6>";
                    }

                    foreach ( $type as $post ) {

                        $img_icon = "";

                        $post_format = get_post_format( $post->ID );
                        if ( $post_format == "" ) {
                            $post_format = 'standard';
                        }
                        $post_type = get_post_type( $post );
                    	$product = array();
                    
                    	if ( $post_type == "product" ) {
                    	    $product = new WC_Product( $post->ID );
                    	    if (!$product->is_visible()) {
                    	    	return;
                    	    }
                    	}

                        if ( $post_type == "post" ) {
                            if ( $post_format == "quote" || $post_format == "status" ) {
                                $img_icon = "ss-quote";
                            } else if ( $post_format == "image" ) {
                                $img_icon = "ss-picture";
                            } else if ( $post_format == "chat" ) {
                                $img_icon = "ss-chat";
                            } else if ( $post_format == "audio" ) {
                                $img_icon = "ss-music";
                            } else if ( $post_format == "video" ) {
                                $img_icon = "ss-video";
                            } else if ( $post_format == "link" ) {
                                $img_icon = "ss-link";
                            } else {
                                $img_icon = "ss-pen";
                            }
                        } else if ( $post_type == "product" ) {
                            $img_icon = "ss-cart";
                        } else if ( $post_type == "portfolio" ) {
                            $img_icon = "ss-picture";
                        } else if ( $post_type == "team" ) {
                            $img_icon = "ss-user";
                        } else if ( $post_type == "galleries" ) {
                            $img_icon = "ss-picture";
                        } else {
                            $img_icon = "ss-file";
                        }

                        $post_title     = get_the_title( $post->ID );
                        $post_date      = get_the_date();
                        $post_permalink = get_permalink( $post->ID );

                        $image = get_the_post_thumbnail( $post->ID, 'thumbnail' );

                        echo '<div class="search-result">';
                        
                        echo '<a href="'.$post_permalink.'" class="search-result-link"></a>';

                        if ( $image ) {
                            echo '<div class="search-item-img"><a href="' . $post_permalink . '">' . $image . '</div>';
                        } else {
                            echo '<div class="search-item-img"><a href="' . $post_permalink . '" class="img-holder"><i class="' . $img_icon . '"></i></a></div>';
                        }

                        echo '<div class="search-item-content">';
                        echo '<h5><a href="' . $post_permalink . '">' . $post_title . '</a></h5>';
                        if ( $post_type == "product" ) {
                            echo wp_kses_post($product->get_price_html());
                        } else if (!$remove_dates) {
                            echo '<time>' . $post_date . '</time>';
                        }
                        echo '</div>';

                        echo '</div>';

                        $i ++;
                        if ( $i == $shown_results ) {
                            break;
                        }
                    }

                    echo '</div>';
                    if ( $i == $shown_results ) {
                        break;
                    }
                }

                if ( $count > 1 ) {
                	$search_link = get_search_link( $search_term );
                	
                	if (strpos($search_link,'?') !== false) {
                		$search_link .= '&post_type='. $header_search_pt;
                	} else {
                		$search_link .= '?post_type='. $header_search_pt;
                	}
                    echo '<a href="' . $search_link . '" class="all-results">' . sprintf( __( "View all %d results", 'uplift' ), $count ) . '</a>';
                }

            } else {

                echo '<div class="no-search-results">';
                echo '<h6>' . __( "No results", 'uplift' ) . '</h6>';
                echo '<p>' . __( "No search results could be found, please try another query.", 'uplift' ) . '</p>';
                echo '</div>';

            }

            die();
        }

        add_action( 'wp_ajax_uplift_ajaxsearch', 'uplift_ajaxsearch' );
        add_action( 'wp_ajax_nopriv_uplift_ajaxsearch', 'uplift_ajaxsearch' );
    }


    /* OVERLAY MENU
    ================================================== */
    if ( ! function_exists( 'uplift_overlay_menu' ) ) {
        function uplift_overlay_menu() {

			global $post;

            $overlayMenu = $page_menu = "";

            if ( $post && !is_search() ) {
                $page_menu = uplift_get_post_meta( $post->ID, 'sf_page_menu', true );
            }

            $overlay_menu_args = array(
                'echo'           => false,
                'theme_location' => 'overlay_menu',
                'fallback_cb'    => '',
                'menu'			 => $page_menu
            );

            $overlayMenu .= '<div id="overlay-menu">';
            $overlayMenu .= '<nav>';
            if ( function_exists( 'wp_nav_menu' ) ) {
                $overlayMenu .= wp_nav_menu( $overlay_menu_args );
            }
            $overlayMenu .= '</nav>';
            $overlayMenu .= '</div>';


            return $overlayMenu;
        }
    }


    /* CONTACT SLIDEOUT
    ================================================== */
    if ( ! function_exists( 'uplift_contact_slideout' ) ) {
        function uplift_contact_slideout() {

            $uplift_options = uplift_get_theme_opts();

            $contact_slideout_page = $uplift_options['contact_slideout_page'];

            $contact_slideout = "";

            $contact_slideout .= '<div id="contact-slideout">';
            $contact_slideout .= '<div class="container">';
            if ( $contact_slideout_page ) {
                $page    = get_post( $contact_slideout_page );
                $content = apply_filters( 'the_content', $page->post_content );
                $contact_slideout .= $content;
            } else {
                $contact_slideout .= __( "Please select a page for the Contact Slideout in Theme Options > Header Options", 'uplift' );
            }
            $contact_slideout .= '</div>';
            $contact_slideout .= '</div>';

            return $contact_slideout;
        }
    }


	 /* WISHLIST PRODUCT HTML
    ================================================== */
    if ( ! function_exists( 'uplift_get_wishlist_product' ) ) {
        function uplift_get_wishlist_product($product_id) {
        	 global $yith_wcwl;
			 $wishlist_output = "";
             $product_obj = wc_get_product( $product_id );
			 $product_obj_id = method_exists( $product_obj, 'get_id' ) ? $product_obj->get_id() : $product_obj->id;
             
             $wishlist_icon = apply_filters( 'uplift_view_wishlist_icon', '<i class="ss-star"></i>' );

             if ( $product_obj !== false && $product_obj->exists() ) {

                  $wishlist_output .= '<div id="wishlist-' . $product_id . '" class="bag-product clearfix">';

                  if ( has_post_thumbnail( $product_obj_id ) ) {
                      $image_link = wp_get_attachment_url( get_post_thumbnail_id( $product_obj_id ) );
                      $image      = wp_get_attachment_image_src( get_post_thumbnail_id( $product_obj_id ), 'thumbnail' );

                      if ( $image ) {
                          $wishlist_output .= '<figure><a class="bag-product-img" href="' . esc_url( get_permalink( apply_filters( 'woocommerce_in_cart_product', $product_obj_id  ) ) ) . '"><img itemprop="image" src="' . $image[0] . '" width="' . $image[1] . '" height="' . $image[2] . '" /></a></figure>';
                                }
                            }

                            $wishlist_output .= '<div class="bag-product-details">';
                            $wishlist_output .= '<div class="bag-product-title"><a href="' . esc_url( get_permalink( apply_filters( 'woocommerce_in_cart_product', $product_obj_id ) ) ) . '">' . apply_filters( 'woocommerce_in_cartproduct_obj_title', $product_obj->get_title(), $product_obj ) . '</a></div>';

                            if ( get_option( 'woocommerce_display_cart_prices_excluding_tax' ) == 'yes' ) {
                                $wishlist_output .= '<div class="bag-product-price">' . apply_filters( 'woocommerce_cart_item_price_html', wc_price( $product_obj->get_price_excluding_tax() ), '' ) . '</div>';
                            } else {
                                $wishlist_output .= '<div class="bag-product-price">' . apply_filters( 'woocommerce_cart_item_price_html', wc_price( $product_obj->get_price() ), '' ) . '</div>';
                            }
                            $wishlist_output .= '</div>';
                            $wishlist_output .= '</div>';

                        }

			return $wishlist_output;


			}

	}


	 /* WISHLIST UPDATE
    ================================================== */
    if ( ! function_exists( 'uplift_add_to_wishlist' ) ) {
        function uplift_add_to_wishlist() {

        	if ( ! empty( $_REQUEST['product_id'] ) ) {
                $product_id = $_REQUEST['product_id'];
            }

            $wishlist_itens = array();
           	$wishlist_itens['wishlist_output'] = uplift_get_wishlist_product($product_id);

            echo json_encode( $wishlist_itens );
            die();

		}
		add_action( 'wp_ajax_uplift_add_to_wishlist', 'uplift_add_to_wishlist' );
	    add_action( 'wp_ajax_nopriv_uplift_add_to_wishlist', 'uplift_add_to_wishlist' );
	}


	/* GLOBAL HEADER BANNER
    ================================================== */
    if ( ! function_exists( 'uplift_header_banner_bar' ) ) {
        function uplift_header_banner_bar() {
            global $post;
            $uplift_options = uplift_get_theme_opts();
			$enable_global_banner = false;

			if ( isset($uplift_options['enable_global_banner']) ) {
            	$enable_global_banner  = $uplift_options['enable_global_banner'];
            }

            if ( $enable_global_banner ) {
            	$gb_layout 			= $uplift_options['global_banner_layout'];
            	$fullwidth_header   = $uplift_options['fullwidth_header'];

                ?>
                <!--// OPEN #sf-header-banner //-->
                <?php if ( $fullwidth_header ) { ?>
	            <div id="sf-header-banner" class="banner-fw-header clearfix">
                <?php } else { ?>
                <div id="sf-header-banner" class="clearfix">
				<?php } ?>

                	<div class="container">

                		<div id="sf-banner-widgets" class="row clearfix">
                            <?php if ( $gb_layout == "gb-1" ) { ?>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-2' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-3' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-4' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else if ( $gb_layout == "gb-2" ) { ?>

                                <div class="col-sm-6">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-2' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-3' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else if ( $gb_layout == "gb-3" ) { ?>

                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-2' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-6">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-3' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else if ( $gb_layout == "gb-4" ) { ?>

                                <div class="col-sm-6">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-6">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-2' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else if ( $gb_layout == "gb-5" ) { ?>

                                <div class="col-sm-4">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-4">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-2' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-4">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-3' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else if ( $gb_layout == "gb-6" ) { ?>

                                <div class="col-sm-8">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-4">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-2' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else if ( $gb_layout == "gb-7" ) { ?>

                                <div class="col-sm-4">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-8">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-2' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else if ( $gb_layout == "gb-8" ) { ?>

                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-1' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-6">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-2' ); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-3' ); ?>
                                    <?php } ?>
                                </div>

                            <?php } else { ?>

                                <div class="col-sm-12">
                                    <?php if ( function_exists( 'dynamic_sidebar' ) ) { ?>
                                        <?php dynamic_sidebar( 'gb-column-1' ); ?>
                                    <?php } ?>

                                </div>
                            <?php } ?>

                		</div>

                	</div>

                    <!--// CLOSE #sf-header-banner //-->
                </div>
            <?php
            }

        }

        add_action( 'uplift_container_start', 'uplift_header_banner_bar', 30 );
    }

?>
