<?php

    /*
    *
    *	Page Heading
    *	------------------------------------------------
    *	Swift Framework v3.0
    * 	Copyright Swift Ideas 2015 - http://www.swiftideas.com
    *
    *	uplift_page_heading()
    *
    */


    /* PAGE HEADING
    ================================================== */
    if ( ! function_exists( 'uplift_page_heading' ) ) {
        function uplift_page_heading() {

            global $wp_query, $post;
            $uplift_options = uplift_get_theme_opts();
            
            $shop_page  = false;
            $page_title = $page_subtitle = $page_title_style = $page_title_overlay_effect = $fancy_title_image_url = $page_heading_el_class = $page_heading_wrap_el_class = $page_design_style = $page_title_text_align = $woo_category_desc = "";

            $show_page_title    = apply_filters( 'uplift_page_heading_ns_pagetitle', 1 );
            $remove_breadcrumbs = apply_filters( 'uplift_page_heading_ns_removebreadcrumbs', 0 );
            $breadcrumb_in_heading = 0;
            if ( isset( $uplift_options['breadcrumb_in_heading'] ) ) {
            	$breadcrumb_in_heading = $uplift_options['breadcrumb_in_heading'];
            }
            $hero_heading_fixed_height = false;
            if ( isset( $uplift_options['hero_heading_fixed_height'] ) ) {
            	$hero_heading_fixed_height = $uplift_options['hero_heading_fixed_height'];	
            }
            $page_title_height  = 300;
            $heading_img_width = 0;
            $heading_img_height = 0;
            $page_title_style   = "standard";
			$page_title_text_align = "center";
            $next_icon = apply_filters( 'uplift_next_icon', '<i class="ss-navigateright"></i>' );
            $prev_icon = apply_filters( 'uplift_prev_icon', '<i class="ss-navigateleft"></i>' );

			// Shop page check
            if ( ( function_exists( 'is_shop' ) && is_shop() ) || ( function_exists( 'is_product_category' ) && is_product_category() ) ) {
                $shop_page = true;
            }

            // Defaults
            $default_show_page_heading = 1;
            if ( isset( $uplift_options['default_show_page_heading'] ) ) {
            	$default_show_page_heading = $uplift_options['default_show_page_heading'];
            }
            $pagination_style          = "standard";
            if ( isset( $uplift_options['pagination_style'] ) ) {
                $pagination_style = $uplift_options['pagination_style'];
            }

            // Post meta
            if ( $post && is_singular() ) {
                $show_page_title       = uplift_get_post_meta( $post->ID, 'sf_page_title', true );
                $remove_breadcrumbs    = uplift_get_post_meta( $post->ID, 'sf_no_breadcrumbs', true );
                $page_title_style      = uplift_get_post_meta( $post->ID, 'sf_page_title_style', true );
                $page_title            = uplift_get_post_meta( $post->ID, 'sf_page_title_one', true );
                $page_subtitle         = uplift_get_post_meta( $post->ID, 'sf_page_subtitle', true );
                $fancy_title_image     = rwmb_meta( 'sf_page_title_image', 'type=image&size=full' );
                $page_title_text_style = uplift_get_post_meta( $post->ID, 'sf_page_title_text_style', true );
                $page_title_overlay_effect = uplift_get_post_meta( $post->ID, 'sf_page_title_overlay_effect', true );
                $page_title_text_align = uplift_get_post_meta( $post->ID, 'sf_page_title_text_align', true );
                $page_title_height     = uplift_get_post_meta( $post->ID, 'sf_page_title_height', true );
            }

            if ( is_singular( 'post' ) ) {
                $fw_media_display = uplift_get_post_meta( $post->ID, 'sf_fw_media_display', true );
                $page_design_style 	  = uplift_get_post_meta( $post->ID, 'sf_page_design_style', true );
                if ( $fw_media_display == "fw-media-title" ) {
                    return;
                }
            }

            // Portfolio category navigation
            $enable_category_navigation = $uplift_options['enable_category_navigation'];

            // Woo setup
            if ( $shop_page ) {
                $show_page_title       = $uplift_options['woo_show_page_heading'];
                $page_title_style      = $uplift_options['woo_page_heading_style'];
                $fancy_title_image     = $uplift_options['woo_page_heading_image'];
                $page_title_text_style = $uplift_options['woo_page_heading_text_style'];
                if ( isset( $uplift_options['woo_page_heading_text_align'] ) ) {
                	$page_title_text_align = $uplift_options['woo_page_heading_text_align'];
                }

                if ( isset( $fancy_title_image ) && isset( $fancy_title_image['url'] ) ) {
                    $fancy_title_image_url = $fancy_title_image['url'];
                }

                if ( is_product_category() ) {
                	$category = $wp_query->get_queried_object();
                	$hero_id = get_term_meta( $category->term_id, 'hero_id', true  );
                	if ( $hero_id != "" && $hero_id != 0 ) {
                		$fancy_title_image_url = wp_get_attachment_url($hero_id, 'full');
                		$fancy_title_image_meta = wp_get_attachment_metadata( $hero_id );
                		$heading_img_width = isset($fancy_title_image_meta['width']) ? $fancy_title_image_meta['width'] : 0;
                		$heading_img_height = isset($fancy_title_image_meta['height']) ? $fancy_title_image_meta['height'] : 0;
                	}
                	if ( $fancy_title_image_url != '' ) {
                		//$page_title_style = "fancy";
                	}
                	if ( uplift_theme_supports( 'page-heading-woo-description' ) ) {
                		if ( $page_title_height == 300 ) {
                			$page_title_height = 400;
                		}
                		$woo_category_desc = uplift_woo_get_product_category_description( $category, true );
                	}
                }
            }
            if ( function_exists( 'is_product' ) && is_product() ) {
                $product_layout = uplift_get_post_meta( $post->ID, 'sf_product_layout', true );
                if ( $product_layout == "fw-split" ) {
                    return;
                }
            }
            
            // Page Title Style Filter
            $page_title_style = apply_filters( 'uplift_page_title_style', $page_title_style );

            // Page Title
            if ( $show_page_title == "" ) {
                $show_page_title = $default_show_page_heading;
            }

            if ( $page_title == "" ) {
                $page_title = get_the_title();
            }
            if ( $page_title_height == "" ) {
                $page_title_height = apply_filters( 'uplift_shop_fancy_page_height', 300 );
            }

            // Fancy heading image
            if ( ( $page_title_style == "fancy" || $page_title_style == "fancy-tabbed" ) && $fancy_title_image_url == "" ) {
                foreach ( $fancy_title_image as $detail_image ) {
                    if ( isset( $detail_image['url'] ) ) {
                        $fancy_title_image_url = $detail_image['url'];
                        $heading_img_width = isset($detail_image['width']) ? $detail_image['width'] : 0;
                        $heading_img_height = isset($detail_image['height']) ? $detail_image['height'] : 0;
                        break;
                    }
                }
                if ( ! $fancy_title_image ) {
                    $fancy_title_image     = get_post_thumbnail_id();
                    $fancy_title_image_url = wp_get_attachment_url( $fancy_title_image, 'full' );
                    $fancy_title_image_meta = wp_get_attachment_metadata( $fancy_title_image );
                    $heading_img_width = isset($fancy_title_image_meta['width']) ? $fancy_title_image_meta['width'] : 0;
                    $heading_img_height = isset($fancy_title_image_meta['height']) ? $fancy_title_image_meta['height'] : 0;
                }
            }

            // Page Title Hidden
            if ( ! $show_page_title ) {
                $page_heading_el_class = "page-heading-hidden";
                $page_heading_wrap_el_class = "page-heading-wrap-hidden";
            }

            // Breadcrumb in heading
            if ( $breadcrumb_in_heading ) {
            	$page_heading_el_class .= " page-heading-breadcrumbs";
            }

            if ( $page_title_style == "fancy-tabbed" ) {
            	$page_title_text_align = "left";
            }
            
            // Hero styles output
            $hero_styles = array();
            $hero_styles[] = "background-image: url(" . esc_url($fancy_title_image_url) . ");";
            
            // Fixed height, no animation
            if ( $hero_heading_fixed_height ) {
	            $page_heading_el_class .= " fixed-height";
	            $page_title_height = $page_title_height != "" ? $page_title_height : "400";
				$hero_styles[] = 'height: '.$page_title_height.'px;';
			}

            // Return if product & inner heading
            if ( function_exists( 'is_product' ) && is_product() && uplift_theme_supports( 'product-inner-heading' ) && ( $page_title_style == "standard" || $page_title_style == "" ) ) {
            	return;
            }

            // Dont' allow fancy-tabbed on product pages
            if ( function_exists( 'is_product' ) && is_product() && uplift_theme_supports( 'product-inner-heading' ) && $page_title_style == "fancy-tabbed" ) {
            	$page_title_style = "fancy";
            }

            if ( isset($uplift_options['minimal_checkout']) ) {
				if ( function_exists('is_checkout') && is_checkout() ) {
					global $woocommerce;
		        	if ( $uplift_options['minimal_checkout'] ) { ?>

		            	<div class="minimal-checkout-return container"><a href="<?php echo esc_url( wc_get_cart_url() ); ?>"><?php _e("Return to cart", 'uplift'); ?></a></div>

		        	<?php }
            	}
        	}

            if ( !is_home() ) {
                ?>
                <?php if ( $page_title_style == "fancy" || $page_title_style == "fancy-tabbed" ) { ?>

                    <div class="fancy-heading-wrap <?php echo esc_attr($page_heading_wrap_el_class); ?> <?php echo esc_attr($page_title_style); ?>-style">

                    <?php if ( $fancy_title_image_url != ""  ) {

                    ?>
                        <div class="page-heading fancy-heading clearfix <?php echo esc_attr($page_title_text_style); ?>-style fancy-image <?php echo esc_attr($page_heading_el_class); ?>" style="<?php echo implode('', $hero_styles); ?>" data-height="<?php echo esc_attr($page_title_height); ?>" data-img-width="<?php echo esc_attr($heading_img_width); ?>" data-img-height="<?php echo esc_attr($heading_img_height); ?>">
                        	<span class="media-overlay"></span>

                    <?php } else { ?>
                        <div class="page-heading fancy-heading <?php echo esc_attr($page_heading_el_class); ?> clearfix" data-height="<?php echo esc_attr($page_title_height); ?>">
                    <?php } ?>

                    <?php if ( $page_title_style == "fancy" && $page_design_style == "hero-content-split" ) {
                    	uplift_post_split_heading_buttons();
                    } ?>

                    <?php if ( $page_title_style == "fancy-tabbed" ) { ?>
                    <div class="tabbed-heading-wrap">
                    <?php } ?>

                    <div class="heading-text container" data-textalign="<?php echo esc_attr($page_title_text_align); ?>">
                        <?php if ( uplift_woocommerce_activated() && is_woocommerce() ) { ?>

                            <?php if ( is_product() ) { ?>

                                <h1 class="entry-title"><?php echo wp_kses_post($page_title); ?></h1>

                            <?php } else { ?>

                                <h1 class="entry-title"><?php woocommerce_page_title(); ?></h1>

                            <?php } ?>

                        <?php } else { ?>

                            <h1 class="entry-title"><?php echo wp_kses_post($page_title); ?></h1>

                        <?php } ?>

                        <?php if ( $page_subtitle ) { ?>
                            <h3><?php echo wp_kses_post($page_subtitle); ?></h3>
                        <?php } ?>
                        
                        <?php if ( $woo_category_desc != "" ) { ?>
                        	<div class="category-desc"><?php echo do_shortcode($woo_category_desc); ?></div>
                        <?php } ?>
               

						<?php if ( !$remove_breadcrumbs && $breadcrumb_in_heading ) {
							echo uplift_breadcrumbs( true );
						} ?>

                        <?php if ( is_singular( 'portfolio' ) && ! ( uplift_theme_opts_name() == "uplift_joyn_options" && $pagination_style == "fs-arrow" ) ) { ?>
                            <div
                                class="prev-item"><?php next_post_link( '%link', $prev_icon, $enable_category_navigation, '', 'portfolio-category' ); ?></div>
                            <div
                                class="next-item"><?php previous_post_link( '%link', $next_icon, $enable_category_navigation, '', 'portfolio-category' ); ?></div>
                        <?php } ?>

                        <?php if ( is_singular( 'galleries' ) && ! ( uplift_theme_opts_name() == "uplift_joyn_options" && $pagination_style == "fs-arrow" ) ) { ?>
                            <div
                                class="prev-item"><?php next_post_link( '%link', $prev_icon, false, '', 'gallery-category' ); ?></div>
                            <div
                                class="next-item"><?php previous_post_link( '%link', $next_icon, false, '', 'gallery-category' ); ?></div>
                        <?php } ?>

                    </div>

                    <?php if ( $page_title_style == "fancy-tabbed" ) { ?>
                    </div>
                    <?php } ?>

					<?php if ($page_title_overlay_effect != "" && $page_title_overlay_effect != "none") { ?>

						<div class="sf-canvas-effect" data-type="<?php echo esc_attr($page_title_overlay_effect); ?>">
							<canvas id="page-heading-canvas" data-canvas_id="page-heading-canvas"></canvas>
						</div>

					<?php } ?>

                    </div>

                    </div>

                <?php } else { ?>

                    <?php if ( $show_page_title == 2 ) { ?>
                        <div class="page-heading ph-sort clearfix">
                    <?php } else { ?>
                        <div class="page-heading <?php echo esc_attr($page_heading_el_class); ?> clearfix">
                    <?php } ?>
                    <div class="container">
                    	
                    	<?php if ( is_singular( 'portfolio' ) ) {
                    			$portfolio_page = $uplift_options['portfolio_page'];
                    		?>                    			
                			<div class="post-nav">
                				<?php if ( isset($portfolio_page) ) { ?>
                				<div class="view-all"><a href="<?php echo get_permalink($portfolio_page); ?>"><?php echo apply_filters( 'uplift_index_icon', '<i class="sf-icon-portfolio"></i>' ); ?></a></div>
                				<div class="divide"></div>
                				<?php } ?>
                				<div class="prev-item"><?php next_post_link( '%link', $prev_icon, $enable_category_navigation, '', 'portfolio-category' ); ?></div>
                				<div class="next-item"><?php previous_post_link( '%link', $next_icon, $enable_category_navigation, '', 'portfolio-category' ); ?></div>		
                			</div>
                    	<?php } ?>
                    	
                        <div class="heading-text">

                            <?php if ( uplift_woocommerce_activated() && is_woocommerce() ) { ?>

                                <?php if ( is_product() ) { ?>

                                    <h1 class="entry-title"><?php echo wp_kses_post($page_title); ?></h1>

                                <?php } else { ?>

                                    <h1 class="entry-title"><?php woocommerce_page_title(); ?></h1>

                                <?php } ?>

                            <?php } else if ( is_search() ) {

                                $count     = $wp_query->found_posts;
                                
                                if ( $count == 1 ) : ?>
                                    <?php printf( __( '<h1>%1$s result for <span>%2$s</span></h1>', 'uplift' ), $count, get_search_query() ); ?>
                                <?php else : ?>
                                    <?php printf( __( '<h1>%1$s results for <span>%2$s</span></h1>', 'uplift' ), $count, get_search_query() ); ?>
                                <?php endif; ?>

                            <?php } else if ( is_category() ) { ?>

                                <h1><?php single_cat_title(); ?></h1>
							
							<?php } else if ( is_tax() ) {	
								global $wp_query;
								$term = $wp_query->get_queried_object();
							?>
								<h1><?php echo wp_kses_post($term->name); ?></h1>
								
                            <?php } else if ( is_archive() ) { ?>

                                <?php /* If this is a tag archive */
                                if ( is_tag() ) { ?>
                                    <h1><?php _e( "Posts tagged with", 'uplift' ); ?>
                                        &#8216;<?php single_tag_title(); ?>&#8217;</h1>
                                    <?php /* If this is a daily archive */
                                } elseif ( is_day() ) { ?>
                                    <h1><?php _e( "Archive for", 'uplift' ); ?> <?php the_time( 'F jS, Y' ); ?></h1>
                                    <?php /* If this is a monthly archive */
                                } elseif ( is_month() ) { ?>
                                    <h1><?php _e( "Archive for", 'uplift' ); ?> <?php the_time( 'F, Y' ); ?></h1>
                                    <?php /* If this is a yearly archive */
                                } elseif ( is_year() ) { ?>
                                    <h1><?php _e( "Archive for", 'uplift' ); ?> <?php the_time( 'Y' ); ?></h1>
                                    <?php /* If this is an author archive */
                                } elseif ( is_author() ) { ?>
                                    <?php $author = get_userdata( get_query_var( 'author' ) ); ?>
                                    <?php if ( class_exists( 'ATCF_Campaigns' ) ) { ?>
                                        <h1><?php _e( "Projects by", 'uplift' ); ?> <?php echo esc_attr($author->display_name); ?></h1>
                                    <?php } else { ?>
                                        <h1><?php _e( "Author archive for", 'uplift' ); ?> <?php echo esc_attr($author->display_name); ?></h1>
                                    <?php } ?>
                                    <?php /* If this is a paged archive */
                                } elseif ( isset( $_GET['paged'] ) && ! empty( $_GET['paged'] ) ) { ?>
                                    <h1><?php _e( "Blog Archives", 'uplift' ); ?></h1>
                                <?php } else { ?>
                                    <h1><?php post_type_archive_title(); ?></h1>
                                <?php } ?>

                            <?php } else if ( is_404() ) { ?>

                                <h1 class="entry-title"><?php _e( "404", 'uplift' ); ?></h1>
							
							<?php } else if ( is_home() && get_option('page_for_posts') ) { ?>
							
							     <h1 class="entry-title"><?php echo apply_filters('the_title',get_page( get_option('page_for_posts') )->post_title); ?></h1>
				
                            <?php } else { ?>

                                <h1 class="entry-title"><?php echo wp_kses_post($page_title); ?></h1>

                            <?php } ?>

                        </div>


                        <?php if ( is_singular( 'galleries' ) && $pagination_style != "fs-arrow" ) { ?>
                            <div class="next-item"><?php previous_post_link( '%link', $next_icon, false, '', 'gallery-category' ); ?></div>
                            <div class="prev-item"><?php next_post_link( '%link', $prev_icon, false, '', 'gallery-category' ); ?></div>
                        <?php } ?>

						<?php if ( !$remove_breadcrumbs && $breadcrumb_in_heading ) {
							echo uplift_breadcrumbs( true );
						} ?>

                        <?php if ( $shop_page && uplift_theme_supports( 'page-heading-woocommerce' ) ) {
                            woocommerce_catalog_ordering();
                            woocommerce_result_count();
                        } ?>

                    </div>
                </div>
                <?php
                }
            }
        }

        add_action( 'uplift_main_container_start', 'uplift_page_heading', 20 );
    }


    /* POST SPLIT CONTENT HEADING BUTTONS
    ================================================== */
    if ( ! function_exists( 'uplift_post_split_heading_buttons' ) ) {
        function uplift_post_split_heading_buttons() {
			$uplift_options = uplift_get_theme_opts();
			
        	$blog_page   = $uplift_options['blog_page'];

    	    $prev_post = get_next_post();
    	    $next_post = get_previous_post();
    	    $has_both  = false;

    	    if ( ! empty( $next_post ) && ! empty( $prev_post ) ) {
    	        $has_both = true;
    	    }
    	    ?>

    	    <?php if ( $blog_page != "" ) { ?>
    	    	<div class="blog-button">
	    	        <a class="sf-button medium white rounded bordered" href="<?php echo get_permalink( $blog_page ); ?>">
	    	        	<i class="fa-long-arrow-left"></i>
	    	        	<span class="text"><?php _e( "View all posts", 'uplift' ); ?></span>
	    	        </a>
	    	    </div>
    	    <?php } ?>

    	    <?php if ( ! empty( $next_post ) || ! empty( $prev_post )) { ?>
    	    <?php if ($has_both) { ?>
    	    <div class="post-pagination prev-next">
    	    <?php } else { ?>
    	    <div class="post-pagination">
    	        <?php } ?>

	            <?php if ( ! empty( $next_post ) ) {
	                $author_id       = $next_post->post_author;
	                $author_name     = get_the_author_meta( 'display_name', $author_id );
	                $author_url      = get_author_posts_url( $author_id );
	                $post_date       = get_the_date();
	                $post_date_str   = get_the_date('Y-m-d');
	                $post_categories = get_the_category_list( ', ', '', $next_post->ID );
	                ?>
	                <a class="next-article" href="<?php echo get_permalink( $next_post->ID ); ?>">
	                    <h4><?php _e( "Older", 'uplift' ); ?></h4>
	                    <h3><?php echo esc_attr($next_post->post_title); ?></h3>
	                </a>
	            <?php } ?>

	            <?php if ( ! empty( $prev_post ) ) {
	                $author_id       = $prev_post->post_author;
	                $author_name     = get_the_author_meta( 'display_name', $author_id );
	                $author_url      = get_author_posts_url( $author_id );
	                $post_date       = get_the_date();
	                $post_date_str   = get_the_date('Y-m-d');
	                $post_categories = get_the_category_list( ', ', '', $prev_post->ID );
	                ?>
	                <a class="prev-article" href="<?php echo get_permalink( $prev_post->ID ); ?>">
	                    <h4><?php _e( "Newer", 'uplift' ); ?></h4>
	                    <h3><?php echo esc_attr($prev_post->post_title); ?></h3>
	                </a>
	            <?php } ?>

    	    </div>

      	<?php }
        }
    }
?>