<?php
    $uplift_options = uplift_get_theme_opts();
    $type = "";
    if ( isset($uplift_options['404_type']) ) {
    	$type = $uplift_options['404_type'];
    }
    
    if ( $type == "page" ) {
    	$page = $uplift_options['404_page'];
        $current_page_URL = uplift_current_page_url();
        $page_URL = get_permalink( $page );

	    if ( $current_page_URL != $page_URL ) {
            wp_redirect( $page_URL );
            exit;
        }
    }
    
    $error_content = $uplift_options['404_page_content'];
?>

<div class="help-text">
    <?php echo wp_kses_post($error_content); ?>
</div>
<form method="get" class="search-form" action="<?php echo home_url(); ?>/">
    <input type="text" placeholder="<?php _e( 'Search', 'uplift' ); ?>" name="s"/>
</form>