<?php
    $uplift_options = uplift_get_theme_opts();
	
    $blog_type      = $uplift_options['archive_display_type'];
	$blog_classes 	= uplift_blog_classes( $blog_type );
    $columns   		= 2;
    $pagination 	= "standard";
    if ( isset($uplift_options['archive_display_columns']) ) {
    $columns   = $uplift_options['archive_display_columns'];
    }
    if ( isset($uplift_options['archive_display_pagination']) ) {
    $pagination   = $uplift_options['archive_display_pagination'];
    }
    $content_output = $uplift_options['archive_content_output'];
	$item_class 	= $blog_classes['item'];
	$show_read_more = "no";
	
	if ( $blog_type == "masonry" ) {
		if ( $columns == "5" ) {
		    $item_class = "col-sm-sf-5";
		} else if ( $columns == "4" ) {
		    $item_class = "col-sm-3";
		} else if ( $columns == "3" ) {
		    $item_class = "col-sm-4";
		} else if ( $columns == "2" ) {
		    $item_class = "col-sm-6";
		} else if ( $columns == "1" ) {
		    $item_class = "col-sm-12";
		}
		
	    if ( $content_output == "excerpt" ) {
	        $show_read_more = "yes";
	    }
    }
	
	// Enqueue script
    if ( $blog_type == "masonry" || $blog_type == "standard" ) {
    	wp_enqueue_script( 'isotope' );
	}
	wp_enqueue_script( 'lightSlider' );
		
?>

<div class="blog-wrap blog-items-wrap blog-<?php echo esc_attr($blog_type); ?>">

	<?php if ( have_posts() ) : ?>
	
	        <?php if ( $blog_type == "timeline" ) { ?>
	            <div class="timeline"></div>
	        <?php } ?>
	
	        <!-- OPEN .blog-items -->
	        <ul class="blog-items row <?php echo esc_attr($blog_classes['list']); ?> clearfix"
	            data-blog-type="<?php echo esc_attr($blog_type); ?>">
	
	            <?php while ( have_posts() ) : the_post(); ?>
	
	                <?php
	                $post_format = get_post_format( $post->ID );
	                if ( $post_format == "" ) {
	                    $post_format = 'standard';
	                }
	                ?>
	                <li <?php post_class( 'blog-item ' . $item_class . ' format-' . $post_format ); ?> itemscope itemtype="http://schema.org/BlogPosting">
	                    <?php echo uplift_get_post_item( $post->ID, $blog_type, "yes", "yes", "yes", "20", $content_output, $show_read_more ); ?>
	                </li>
	
	            <?php endwhile; ?>
	
	            <!-- CLOSE .blog-items -->
	        </ul>
	
	
	
	<?php else: ?>
	
	    <h3><?php _e( 'Sorry, there are no results to display.', 'uplift' ); ?></h3>
	
	<?php endif; ?>
        
	<?php if ( $pagination == "infinite-scroll" ) {
	
	    echo '<div class="pagination-wrap hidden infinite-scroll-enabled">';
	    echo pagenavi( $wp_query );
	    echo '</div>';
	
	} else if ( $pagination == "load-more" ) {
	
	    echo '<a href="#" class="load-more-btn">' . __( 'Load More', 'uplift' ) . '</a>';
	
	    echo '<div class="pagination-wrap load-more hidden infinite-scroll-enabled">';
	    echo pagenavi( $wp_query );
	    echo '</div>';
	
	} else if ( $pagination == "standard" ) {
	    if ( $blog_type == "masonry" ) {
	        echo '<div class="pagination-wrap masonry-pagination">';
	    } else {
	        echo '<div class="pagination-wrap">';
	    }
	    echo pagenavi( $wp_query );
	    echo '</div>';
	}
	?>

</div>