<?php
    global $post;
    $uplift_options = uplift_get_theme_opts();

    $media_type = $media_image = $media_video = $media_gallery = '';

    $default_detail_media = $uplift_options['default_detail_media'];
    $fw_media_display     = uplift_get_post_meta( $post->ID, 'sf_fw_media_display', true );
    $custom_media_height  = uplift_get_post_meta( $post->ID, 'sf_media_height', true );
    $use_thumb_content    = uplift_get_post_meta( $post->ID, 'sf_thumbnail_content_main_detail', true );
    $post_format          = get_post_format( $post->ID );
    if ( $post_format == "" ) {
        $post_format = 'standard';
    }
    if ( $use_thumb_content ) {
        $media_type = uplift_get_post_meta( $post->ID, 'sf_thumbnail_type', true );
    } else {
        $media_type = uplift_get_post_meta( $post->ID, 'sf_detail_type', true );
    }
    if ( $media_type == "" ) {
        $media_type = $default_detail_media;
    }

    $media_slider      = uplift_get_post_meta( $post->ID, 'sf_detail_rev_slider_alias', true );
    $media_layerslider = uplift_get_post_meta( $post->ID, 'sf_detail_layer_slider_alias', true );
    $custom_media      = uplift_get_post_meta( $post->ID, 'sf_custom_media', true );

    $media_width  = 1170;
    $media_height = null;
    if ( $custom_media_height != "" && $fw_media_display == "fw-media-title" ) {
        $media_height = $custom_media_height;
    }
    if ( $fw_media_display == "fw-media-title" || $fw_media_display == "fw-media" ) {
        $media_width = 1920;
    }
    $video_height = 658;

    echo '<figure class="media-wrap media-type-' . $media_type . '" itemscope>';

    if ( $post_format == "standard" ) {

        if ( $media_type == "video" ) {

            echo uplift_video_post( $post->ID, $media_width, $video_height, $use_thumb_content ) . "\n";

        } else if ( $media_type == "slider" ) {

            echo uplift_gallery_post( $post->ID, $use_thumb_content ) . "\n";

        } else if ( $media_type == "gallery-stacked" ) {

            echo uplift_gallery_stacked_post( $post->ID, $use_thumb_content ) . "\n";

        } else if ( $media_type == "layer-slider" ) {

            echo '<div class="layerslider">' . "\n";

            if ( $media_slider != "" ) {

                echo do_shortcode( '[rev_slider ' . $media_slider . ']' ) . "\n";

            } else {

                echo do_shortcode( '[layerslider id="' . $media_layerslider . '"]' ) . "\n";

            }

            echo '</div>' . "\n";

        } else if ( $media_type == "audio" ) {

            echo '<div class="audio-detail">' . uplift_audio_post( $post->ID, $use_thumb_content ) . '</div>' . "\n";

        } else if ( $media_type == "sh-video" ) {

            echo '<div class="sh-video-wrap">' . uplift_sh_video_post( $post->ID, $use_thumb_content ) . '</div>' . "\n";

        } else if ( $media_type == "custom" ) {

            echo do_shortcode( $custom_media ) . "\n";

        } else if ( $media_type == "image" ) {

            echo uplift_image_post( $post->ID, $media_width, $media_height, $use_thumb_content ) . "\n";

        }

    } else {

        echo uplift_get_post_media( $post->ID, $media_width, $media_height, $video_height, $use_thumb_content );

    }

    echo '</figure>' . "\n";
