<?php
    $uplift_options = uplift_get_theme_opts();

    $portfolio_archive_display_type = $uplift_options['portfolio_archive_display_type'];
    $portfolio_archive_columns      = $uplift_options['portfolio_archive_columns'];
    $category_slug                  = get_query_var( 'portfolio-category' );
	
	// Enqueue script
    if ( $portfolio_archive_display_type == "masonry" ) {
    	wp_enqueue_script( 'isotope' );
	}
?>

<?php if ( have_posts() ) : ?>

    <div class="portfolio-wrap">

        <?php echo do_shortcode( '[spb_portfolio display_type="' . $portfolio_archive_display_type . '" fullwidth="no" gutters="yes" columns="' . $portfolio_archive_columns . '" show_title="yes" show_subtitle="yes" show_excerpt="no" hover_show_excerpt="no" excerpt_length="20" item_count="-1" category="' . $category_slug . '" portfolio_filter="no" pagination="no" button_enabled="no" width="1/1" el_position="first last"]' ); ?>

    </div>

<?php else: ?>

    <h3><?php _e( 'Sorry, there are no results to display.', 'uplift' ); ?></h3>

<?php endif; ?>