<?php
    /*
    *
    *	Single Portfolio
    *	------------------------------------------------
    *	Swift Framework v3.0
    * 	Copyright Swift Ideas 2015 - http://www.swiftideas.com
    *
    *
    */
?>

<?php

    /* PORTFOLIO COMMENTS
    ================================================== */
    if ( ! function_exists( 'uplift_portfolio_comments' ) ) {
        function uplift_portfolio_comments() {

            $uplift_options = uplift_get_theme_opts();
            $disable_pagecomments = $uplift_options['disable_pagecomments'];

            $comments_class = apply_filters( 'uplift_post_comments_wrap_class', 'col-sm-8 col-sm-offset-2' );

            if ( comments_open() ) {
                ?>
                <div class="comments-wrap">
                    <div id="comment-area" class="<?php echo esc_attr($comments_class); ?>">
                        <?php comments_template( '', true ); ?>
                    </div>
                </div>
            <?php
            }
        }

        add_action( 'uplift_portfolio_article_end', 'uplift_portfolio_comments', 10 );
    }

?>

<?php while (have_posts()) : the_post(); ?>

    <?php
    uplift_set_sidebar_global( 'no-sidebars' );
    $page_content_class = $content_wrap_class = "";
    $portfolio_data     = uplift_get_post_meta( $post->ID, 'portfolio', true );
    $current_item_id    = $post->ID;
    $hide_details       = uplift_get_post_meta( $post->ID, 'sf_hide_details', true );
    $pb_active          = uplift_get_post_meta( $post->ID, '_spb_status', true );
    $fw_media_display   = uplift_get_post_meta( $post->ID, 'sf_fw_media_display', true );
    $page_content_class = "container";
    if ( ! $hide_details && $pb_active != "true" ) {
        $content_wrap_class = "col-sm-9";
    }
    if ( $fw_media_display == "split" ) {
        $page_content_class = "col-sm-3";
        $content_wrap_class = "";
        add_action( 'uplift_portfolio_article_start', 'uplift_output_container_row_open', 5 );
        add_action( 'uplift_portfolio_article_end', 'uplift_output_container_row_close', 5 );
    }
    if ( $hide_details ) {
        remove_action( 'uplift_after_portfolio_content', 'uplift_portfolio_item_details', 0 );
    }
    ?>

    <?php do_action( 'uplift_portfolio_before_article' ); ?>

    <!-- OPEN article -->
    <article <?php post_class( 'clearfix single-portfolio-' . $fw_media_display ); ?> id="<?php the_ID(); ?>" itemscope
                                                                                      itemtype="http://schema.org/CreativeWork">

        <?php
            /**
             * @hooked - uplift_output_container_row_open - 5 (if media display is set to "split")
             * @hooked - uplift_post_detail_media - 20
             **/
            do_action( 'uplift_portfolio_article_start' );
        ?>

        <section class="page-content clearfix <?php echo esc_attr($page_content_class); ?>">

            <?php do_action( 'uplift_before_portfolio_content' ); ?>

            <div class="content-wrap <?php echo esc_attr($content_wrap_class); ?> clearfix"
                 itemprop="description"><?php the_content(); ?></div>

            <?php
                /**
                 * @hooked - uplift_portfolio_item_details - 0
                 **/
                do_action( 'uplift_after_portfolio_content' );
            ?>

        </section>

        <?php
            /**
             * @hooked - uplift_output_container_row_close - 5 (if media display is set to "split")
             **/
            do_action( 'uplift_portfolio_article_end' );
        ?>

        <!-- CLOSE article -->
    </article>

    <?php
    /**
     * @hooked - uplift_portfolio_related_projects - 0
     **/
    do_action( 'uplift_portfolio_after_article' );
    ?>

<?php endwhile; ?>
