<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

wp_enqueue_script( 'owlcarousel' );

	
if ( $related_products ) :

global $uplift_options;

$woocommerce_loop['columns'] = 4;

$uplift_carouselID = uplift_get_carousel_id();

$product_display_type = $uplift_options['product_display_type'];
$product_display_gutters = $uplift_options['product_display_gutters'];

$gutter_class = "";

if (!$product_display_gutters && $product_display_type == "gallery") {
	$gutter_class = 'no-gutters';
} else {
	$gutter_class = 'gutters';
}
$woocommerce_loop['style-override'] = $product_display_type;

$related_heading = $uplift_options['related_heading_text'];

?>

	<div class="product-carousel related-products spb_content_element">
	
		<div class="title-wrap clearfix">
			<h3 class="spb-heading"><span><?php echo esc_attr($related_heading); ?></span></h3>
			<div class="carousel-arrows"><a href="#" class="carousel-prev"><i class="sf-icon-left-chevron"></i></a><a href="#" class="carousel-next"><i class="sf-icon-right-chevron"></i></a></div>
		</div>

		<ul class="related products carousel-items <?php echo esc_attr($gutter_class); ?> product-type-<?php echo esc_attr($product_display_type); ?>" id="carousel-<?php echo esc_attr($uplift_carouselID); ?>" data-columns="<?php echo esc_attr($woocommerce_loop['columns']); ?>">
						
			<?php foreach ( $related_products as $related_product ) : ?>

				<?php
				 	$post_object = get_post( $related_product->get_id() );

					setup_postdata( $GLOBALS['post'] =& $post_object ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found

					wc_get_template_part( 'content', 'product' ); ?>

			<?php endforeach; ?>

		</ul>

	</div>

<?php endif;

global $uplift_include_carousel, $uplift_include_isotope;
$uplift_include_carousel = true;
$uplift_include_isotope = true;

wp_reset_postdata();
