<?php

	/*
	*
	*	Uplift Functions - Child Theme
	*	------------------------------------------------
	*	These functions will override the parent theme
	*	functions. We have provided some examples below.
	*
	*
	*/

	/* LOAD PARENT THEME STYLES
	================================================== */
	function uplift_child_enqueue_styles() {
	    wp_enqueue_style( 'uplift-parent-style', get_template_directory_uri() . '/style.css' );

	}
	add_action( 'wp_enqueue_scripts', 'uplift_child_enqueue_styles' );


	/* LOAD THEME LANGUAGE
	================================================== */
	/*
	*	You can uncomment the line below to include your own translations
	*	into your child theme, simply create a "language" folder and add your po/mo files
	*/

	// load_theme_textdomain('swiftframework', get_stylesheet_directory().'/language');


	/* REMOVE PAGE BUILDER ASSETS
	================================================== */
	/*
	*	You can uncomment the line below to remove selected assets from the page builder
	*/

	// function spb_remove_assets( $pb_assets ) {
	//     unset($pb_assets['parallax']);
	//     return $pb_assets;
	// }
	// add_filter( 'spb_assets_filter', 'spb_remove_assets' );


	/* ADD/EDIT PAGE BUILDER TEMPLATES
	================================================== */
	function custom_prebuilt_templates($prebuilt_templates) {

		/*
		*	You can uncomment the lines below to add custom templates
		*/
		// $prebuilt_templates["custom"] = array(
		// 	'id' => "custom",
		// 	'name' => 'Custom',
		// 	'code' => 'your-code-here'
		// );

		/*
		*	You can uncomment the lines below to remove default templates
		*/
		// unset($prebuilt_templates['home-1']);
		// unset($prebuilt_templates['home-2']);

		// return templates array
	    return $prebuilt_templates;

	}
	//add_filter( 'spb_prebuilt_templates', 'custom_prebuilt_templates' );


	function owl_carousel() {
	    wp_enqueue_style( 'owl-carousel-css', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.2.1/assets/owl.carousel.min.css' );
		wp_enqueue_style( 'owl-carousel-theme', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.2.1/assets/owl.theme.default.min.css' );
		wp_register_script( 'owlcarousel', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.2.1/owl.carousel.min.js', array('jquery'), '2.2.1', true);
		wp_enqueue_script( 'main-child-js', get_stylesheet_directory_uri().'/app-child.js', array('jquery'), '1.0.0', true);
        wp_enqueue_script('isotope');
	}
	add_action( 'wp_enqueue_scripts', 'owl_carousel' );

	function nocdurnaSlider($atts){

		$a = shortcode_atts( array(
			'category' => 'slider-nocdurna-efficacy',
			'disable_navigation' => false
		), $atts );

		$args = array(
			'nopaging' => true,
			'posts_per_page' => '-1',
			'meta_key' => 'ordre',
			'orderby' => 'meta_value',
			'order' => 'ASC',
			'category_name' => $a['category'],
		);

		$query = new WP_Query( $args );

		if( $a['disable_navigation'] != true ) {
			if ( $query->have_posts() ) {
				$result = '<div class="scroll-wrapper"><ul class="scroll-menu">';
				$i = 0;
				while ( $query->have_posts() ) {
					$query->the_post();
					if($i == 0): $class = "link selected"; else: $class = "link"; endif;
					$result = $result.'<li class="'.$class.'" data-target="'.$i.'"><div class="gradient"></div><div class="icn"><img src="'.get_field('icon', get_the_ID()).'" /></div><div class="icn_hover"><img src="'.get_field('icon_hover', get_the_ID()).'" /></div><span>'.get_field('label', get_the_ID()).'</span></li>';
					$i++;
				}
				$result = $result.'</ul><div class="paddles"><button class="left-paddle paddle hidden"><i class="fa fa-arrow-left"></i></button><button class="right-paddle paddle"><i class="fa fa-arrow-right"></i></i></button></div></div>';
			}
		}

		if ( $query->have_posts() ) {
			$result = $result.'<div class="owl-carousel" id="slider_'.$a['category'].'">';
			while ( $query->have_posts() ) {
				$query->the_post();
				$result = $result.'<div class="item">'.apply_filters( 'the_content', get_post_field('post_content', get_the_ID()) ).'</div>';
			}
			$result = $result.'</div>';
		}

		wp_reset_postdata();

		echo $result;
	}

	add_shortcode('nocdurna-slider', 'nocdurnaSlider');

    function sf_highlight_search_term ($text){
        if(is_search()){
            $keys = implode('|', explode(' ', get_search_query()));
            $text = preg_replace('/(' . $keys .')/iu', '<span class="searched-term">\0</span>', $text);
        }
        return $text;
    }
    add_filter('the_content', 'sf_highlight_search_term');
    add_filter('the_excerpt', 'sf_highlight_search_term');
    add_filter('the_title', 'sf_highlight_search_term');


    /* GET ARCHIVED POST
    ================================================== */
    if ( ! function_exists( 'sf_get_searched_post' ) ) {
        function sf_get_searched_post( $postID, $show_title, $show_excerpt, $show_details, $show_read_more, $content_output, $excerpt_length ) {

            $sf_options = sf_get_theme_opts();
            $single_author = $sf_options['single_author'];
            $remove_dates  = $sf_options['remove_dates'];

            // Get Post Object
            $post_object = sf_build_post_object( $postID , $content_output, $excerpt_length );

            // Link config
            $post_links_match_thumb = false;
            if ( isset( $sf_options['post_links_match_thumb'] ) ) {
                $post_links_match_thumb = $sf_options['post_links_match_thumb'];
            }
            $post_permalink_config = 'href="' . $post_object['permalink'] . '" class="link-to-post"';
            if ( $post_links_match_thumb ) {
                $link_config = sf_post_item_link();
                $post_permalink_config = $link_config['config'];
            }

            // Variable setup
            $post_item = "";

            // DETAILS SETUP
            $item_details = '<div class="blog-item-details">' . sprintf( __( '<time datetime="%3$s">%4$s</time> - <span class="author">By <a href="%2$s" rel="author" itemprop="author">%1$s</a></span>', 'uplift' ), $post_object['author'], get_author_posts_url( get_the_author_meta( 'ID' ) ), $post_object['date_str'], $post_object['date'] ) . '</div>';

            // Open output
            if ( sf_theme_opts_name() == "sf_atelier_options" && $show_details == "yes" ) {
                $post_item .= '<div class="side-details">';
                if ( !$remove_dates ) {
                    $post_date_month = get_the_date('M');
                    $post_date_day = get_the_date('d');
                    $post_date_year = get_the_date('Y');
                    $post_item .= '<div class="side-post-date narrow-date-block" itemprop="datePublished"><span class="month">'.$post_date_month.'</span><span class="day">'.$post_date_day.'</span><span class="year">'.$post_date_year.'</span></div>';
                }

                if ( function_exists( 'lip_love_it_link' ) ) {
                    $post_item .= lip_love_it_link( get_the_ID(), false, '', 'narrow-date-block' );
                }

                $post_item .= '</div>';

                $post_item .= '<div class="post-content-wrap">';
            }

            $post_item .= '<div class="standard-post-content no-thumb clearfix">'; // open standard-post-content

            if ( $show_title == "yes" && $post_object['format'] != "link" && $post_object['format'] != "quote" ) {
                $post_item .= '<h1 itemprop="name headline"><a ' . $post_permalink_config . '>' . $post_object['title'] . '</a></h1>';
            }

            if ($show_details == "yes" && $post_object['format'] != "quote" && $post_object['format'] != "link" ) {
                if ( sf_theme_opts_name() == "sf_atelier_options" ) {
                    if ( ! $single_author ) {
                        $post_item .= '<div class="blog-item-details">' . sprintf( __( '<span class="author">By <a href="%2$s" rel="author" itemprop="author">%1$s</a></span> in %3$s', 'uplift' ), $post_object['author'], get_author_posts_url( get_the_author_meta( 'ID' ) ), $post_object['categories'] ) . '</div>';
                    }

                } else {
                    $post_item .= $item_details;
                }
            }

            if ( $show_excerpt == "yes" ) {
                $post_item .= '<div class="excerpt" itemprop="description">' . $post_object['excerpt'] . '</div>';
            }

            if ( $show_read_more == "yes" && $post_object['format'] != "quote" && $post_object['format'] != "link" ) {
                $post_item .= '<a class="read-more-button" href="' . $post_object['permalink'] . '">' . __( "Read more", 'uplift' ) . '</a>';
            }

            $post_item .= '</div>'; // close standard-post-content

            if ( sf_theme_opts_name() == "sf_atelier_options" && $show_details == "yes" ) {
                $post_item .= '</div>'; // close post-content-wrap
            }


            // Return
            return $post_item;
        }
    }

//CUSTOM POST TYPES CREATION
function create__quiz_posttype() {
	register_post_type( 'quiz',
		array(
			'labels' => array(
				'name' => __( 'Quiz' ),
				'singular_name' => __( 'Quiz' ),
				'menu_name' => __( 'Quiz' )
			),
			'public' => true,
			'has_archive' => false,
			'menu_icon' => 'dashicons-screenoptions',
			'supports' => array( 'title', 'editor', 'thumbnail', 'revisions' )
		)
	);
}
add_action( 'init', 'create__quiz_posttype' );

add_action('init', 'my_custom_init');
function my_custom_init() {

	add_theme_support( 'post-thumbnails' );
	add_post_type_support( 'quiz', 'thumbnail' );
	post_type_supports( 'quiz', 'thumbnail' );

}
//add_filter( 'gform_userregistration_login_form', 'change_form', 10, 1 );
function change_form( $form ) {
    $fields = $form['fields'];
    print_r($fields);
    foreach ( $fields as &$field )
    {
        if ( $field['label'] == 'Username' ){
            $field['label'] = 'Please enter your username';
        }
    }
    return $form;
}

    // Validate filed Email :

  add_filter( 'gform_field_validation_1_1', 'rekovelle_validate_email_login', 10, 4 );
    function rekovelle_validate_email_login($result, $value, $form, $field ){

        if ( email_exists( $value ) ) {
            // Stuff to do when email address exists
            $result['is_valid'] = true;

        }else{
            $result['is_valid'] = false;
            $result['message']= 'There’s no such user in our database';
        }
        $_POST['email_user']= $value;

        return $result;
    }

    // Validate password :

    add_filter( 'gform_field_validation_1_2', 'rekovelle_validate_password_login', 10, 4 );

    function rekovelle_validate_password_login($result, $value, $form, $field ){
        if($_POST['email_user']){
            $email = $_POST['email_user'];
        }
       // echo $email.'//'.$value;


        $user = get_user_by( 'email', $email );
        if ( $user && wp_check_password( $value, $user->data->user_pass, $user->ID) ){
            $result['is_valid'] = true;

        }else{
            $result['is_valid'] = false;
            $result['message']= 'Invalid pass';
        }
        return $result;
    }

  //  Field label visibility
  add_filter( 'gform_enable_field_label_visibility_settings', '__return_true' );

// Upload SVG:
	function cc_mime_types($mimes) {
	  $mimes['svg'] = 'image/svg+xml';
	  return $mimes;
	}
	add_filter('upload_mimes', 'cc_mime_types');