<?php
	if ( have_posts() ): the_post();
		if( have_rows('step') ):
			$steps = [];
			while ( have_rows('step') ) : the_row();
				if( have_rows('answers') ):
					$answers = [];
					while ( have_rows('answers') ) : the_row();
						array_push( $answers, [ 'proposition' => get_sub_field('proposition'), 'correct' => get_sub_field('correct') ] );
					endwhile;
				endif;
				array_push( $steps, [ 'question' => get_sub_field('question'), 'image' => get_sub_field('image'), 'answers' => $answers ] );
			endwhile;
		endif;
		$data = [
			'title' => get_the_title(),
			'steps' => $steps,
			'txt_fail' => get_field('text_fail'),
			'txt_middle' => get_field('text_middle'),
			'txt_success' => get_field('text_success')
		];
	endif;

	function escapeJsonString($value) { # list from www.json.org: (\b backspace, \f formfeed)
		$escapers = array("\\", "/", "\"", "\n", "\r", "\t", "\x08", "\x0c");
		$replacements = array("\\\\", "\\/", "\\\"", "\\n", "\\r", "\\t", "\\f", "\\b");
		$result = str_replace($escapers, $replacements, $value);
		return $result;
	}
?>
<!DOCTYPE html>
<html class="no-js" lang="">
<head>
	<meta charset="utf-8">
	<meta http-equiv="x-ua-compatible" content="ie=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<?php wp_head(); ?>
	<link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri() ?>/public/css/app.css?_=<?php echo date('U'); ?>" />
</head>
<body>
	<?php
		// $sf_options = sf_get_theme_opts(); print_r($data);
		// echo(escapeJsonString(json_encode($data)))
	?>
	<div id="app"></div>
	<noscript>
		<div class="browsehappy">
			<p>
				Your browser seems to have JavaScript disabled!<br>
				Please active Javascript to experience this site.
			</p>
		</div>
	</noscript>
	<script>
		if (Function('/*@cc_on return document.documentMode===10@*/')())
			document.write(
				'<div class="browsehappy">' +
					'<p>' +
						'Your browser is way too old!' +
						'<br />' +
						'<a href="http://browsehappy.com/">Upgrade to a different browser</a> to experience this site.' +
					'</p>' +
				'</div>'
			);
	</script>
	<script type="text/javascript">
		try { var data = JSON.parse('<?php echo(escapeJsonString(json_encode($data))) ?>'); }
		catch(e) { var data = false; };

		var dataConfig = {
			logoSrc: '<?php echo $sf_options['logo_upload']['url']; ?>',
			homeURL: '<?php echo get_home_url(); ?>',
			closeURL: '<?php echo get_permalink(451); ?>',
			nextTimeout: 2000,
		};
	</script>
	<script type="text/javascript" src="<?php echo get_stylesheet_directory_uri() ?>/public/js/app.js?_=<?php echo date('U'); ?>"></script>
	<?php wp_footer(); ?>
</body>
</html>
