<?php

	/*
	*
	*	Uplift Functions - Child Theme
	*	------------------------------------------------
	*	These functions will override the parent theme
	*	functions. We have provided some examples below.
	*
	*
	*/
	
	//Remove Gutenberg Block Library CSS from loading on the frontend
    function smartwp_remove_wp_block_library_css(){
     wp_dequeue_style( 'wp-block-library' ); //Remove gutenberg related css
     wp_dequeue_style( 'font-awesome' ); // Remove gdpr enqueued fontawesome css
     wp_dequeue_style( 'site-categories-styles' ); // Remove site category css
     wp_dequeue_style( 'site-categories-styles' ); // Remove site category css
     
    }
    add_action( 'wp_enqueue_scripts', 'smartwp_remove_wp_block_library_css', 100 );
    
    

    function my_deregister_styles()    { 
       //wp_deregister_style( 'amethyst-dashicons-style' ); 
        if (is_user_logged_in() != 1){
            wp_deregister_style( 'dashicons' ); // Remove admin dashicons css in cient side
            wp_dequeue_style( 'dashicons' ); // Remove gdpr enqueued fontawesome css
            wp_deregister_style( 'wpml-tm-admin-bar' );
            wp_dequeue_style( 'wpml-tm-admin-bar' );
        }
        
    }
    
    function deregister_reduxstyle(){
        wp_deregister_style( 'redux-google-fonts-sf_uplift_options-css' );
        wp_dequeue_style( 'redux-google-fonts-sf_uplift_options-css' );
    }
    
    function dequeue_unwanted_js(){
        wp_dequeue_script('site-categories');
        wp_deregister_script( 'site-categories' );
        wp_dequeue_script( 'wp-embed' );
        wp_deregister_script( 'wp-embed' );
        wp_dequeue_script('som_reset_password_script');
    }
        
    add_action( 'wp_print_scripts', 'dequeue_unwanted_js' );
    add_action( 'wp_print_styles', 'my_deregister_styles' );
    add_action( 'wp_print_styles', 'deregister_reduxstyle', 100 );

	/* LOAD PARENT THEME STYLES
	================================================== */
	function uplift_child_enqueue_styles() {
	    wp_enqueue_style( 'uplift-parent-style', get_template_directory_uri() . '/style.css' );
	    wp_enqueue_style( 'ferring-custom-style', get_stylesheet_directory_uri() . '/custom-ferring2.css' );
	    

	}
	add_action( 'wp_enqueue_scripts', 'uplift_child_enqueue_styles',11 );


	/* LOAD THEME LANGUAGE
	================================================== */
	/*
	*	You can uncomment the line below to include your own translations
	*	into your child theme, simply create a "language" folder and add your po/mo files
	*/

	// load_theme_textdomain('swiftframework', get_stylesheet_directory().'/language');


	/* REMOVE PAGE BUILDER ASSETS
	================================================== */
	/*
	*	You can uncomment the line below to remove selected assets from the page builder
	*/

	// function spb_remove_assets( $pb_assets ) {
	//     unset($pb_assets['parallax']);
	//     return $pb_assets;
	// }
	// add_filter( 'spb_assets_filter', 'spb_remove_assets' );


	/* ADD/EDIT PAGE BUILDER TEMPLATES
	================================================== */
	function custom_prebuilt_templates($prebuilt_templates) {

		/*
		*	You can uncomment the lines below to add custom templates
		*/
		// $prebuilt_templates["custom"] = array(
		// 	'id' => "custom",
		// 	'name' => 'Custom',
		// 	'code' => 'your-code-here'
		// );

		/*
		*	You can uncomment the lines below to remove default templates
		*/
		// unset($prebuilt_templates['home-1']);
		// unset($prebuilt_templates['home-2']);

		// return templates array
	    return $prebuilt_templates;

	}
	//add_filter( 'spb_prebuilt_templates', 'custom_prebuilt_templates' );


	function owl_carousel() {
	   // wp_enqueue_style( 'owl-carousel-css', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.2.1/assets/owl.carousel.min.css' );
// 		wp_enqueue_style( 'owl-carousel-theme', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.2.1/assets/owl.theme.default.min.css' );
// 		wp_register_script( 'owlcarousel', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.2.1/owl.carousel.min.js', array('jquery'), '2.2.1', true);
		wp_enqueue_script( 'main-child-js', get_stylesheet_directory_uri().'/app-child.js', array('jquery'), '1.0.0', true);
        wp_enqueue_script('isotope');
	}
	add_action( 'wp_enqueue_scripts', 'owl_carousel' );

// 	function nocdurnaSlider($atts){

// 		$a = shortcode_atts( array(
// 			'category' => 'slider-nocdurna-efficacy',
// 			'disable_navigation' => false
// 		), $atts );

// 		$args = array(
// 			'nopaging' => true,
// 			'posts_per_page' => '-1',
// 			'meta_key' => 'ordre',
// 			'orderby' => 'meta_value',
// 			'order' => 'ASC',
// 			'category_name' => $a['category'],
// 		);

// 		$query = new WP_Query( $args );

// 		if( $a['disable_navigation'] != true ) {
// 			if ( $query->have_posts() ) {
// 				$result = '<div class="scroll-wrapper"><ul class="scroll-menu">';
// 				$i = 0;
// 				while ( $query->have_posts() ) {
// 					$query->the_post();
// 					if($i == 0): $class = "link selected"; else: $class = "link"; endif;
// 					$result = $result.'<li class="'.$class.'" data-target="'.$i.'"><div class="gradient"></div><div class="icn"><img src="'.get_field('icon', get_the_ID()).'" /></div><div class="icn_hover"><img src="'.get_field('icon_hover', get_the_ID()).'" /></div><span>'.get_field('label', get_the_ID()).'</span></li>';
// 					$i++;
// 				}
// 				$result = $result.'</ul><div class="paddles"><button class="left-paddle paddle hidden"><i class="fa fa-arrow-left"></i></button><button class="right-paddle paddle"><i class="fa fa-arrow-right"></i></i></button></div></div>';
// 			}
// 		}

// 		if ( $query->have_posts() ) {
// 			$result = $result.'<div class="owl-carousel" id="slider_'.$a['category'].'">';
// 			while ( $query->have_posts() ) {
// 				$query->the_post();
// 				$result = $result.'<div class="item">'.apply_filters( 'the_content', get_post_field('post_content', get_the_ID()) ).'</div>';
// 			}
// 			$result = $result.'</div>';
// 		}

// 		wp_reset_postdata();

// 		echo $result;
// 	}

// 	add_shortcode('nocdurna-slider', 'nocdurnaSlider');

    function sf_highlight_search_term ($text){
        if(is_search()){
            $keys = implode('|', explode(' ', get_search_query()));
            $text = preg_replace('/(' . $keys .')/iu', '<span class="searched-term">\0</span>', $text);
        }
        return $text;
    }
    add_filter('the_content', 'sf_highlight_search_term');
    add_filter('the_excerpt', 'sf_highlight_search_term');
    add_filter('the_title', 'sf_highlight_search_term');


    /* GET ARCHIVED POST
    ================================================== */
    if ( ! function_exists( 'sf_get_searched_post' ) ) {
        function sf_get_searched_post( $postID, $show_title, $show_excerpt, $show_details, $show_read_more, $content_output, $excerpt_length ) {

            $sf_options = sf_get_theme_opts();
            $single_author = $sf_options['single_author'];
            $remove_dates  = $sf_options['remove_dates'];

            // Get Post Object
            $post_object = sf_build_post_object( $postID , $content_output, $excerpt_length );

            // Link config
            $post_links_match_thumb = false;
            if ( isset( $sf_options['post_links_match_thumb'] ) ) {
                $post_links_match_thumb = $sf_options['post_links_match_thumb'];
            }
            $post_permalink_config = 'href="' . $post_object['permalink'] . '" class="link-to-post"';
            if ( $post_links_match_thumb ) {
                $link_config = sf_post_item_link();
                $post_permalink_config = $link_config['config'];
            }

            // Variable setup
            $post_item = "";

            // DETAILS SETUP
            $item_details = '<div class="blog-item-details">' . sprintf( __( '<time datetime="%3$s">%4$s</time> - <span class="author">By <a href="%2$s" rel="author" itemprop="author">%1$s</a></span>', 'uplift' ), $post_object['author'], get_author_posts_url( get_the_author_meta( 'ID' ) ), $post_object['date_str'], $post_object['date'] ) . '</div>';

            // Open output
            if ( sf_theme_opts_name() == "sf_atelier_options" && $show_details == "yes" ) {
                $post_item .= '<div class="side-details">';
                if ( !$remove_dates ) {
                    $post_date_month = get_the_date('M');
                    $post_date_day = get_the_date('d');
                    $post_date_year = get_the_date('Y');
                    $post_item .= '<div class="side-post-date narrow-date-block" itemprop="datePublished"><span class="month">'.$post_date_month.'</span><span class="day">'.$post_date_day.'</span><span class="year">'.$post_date_year.'</span></div>';
                }

                if ( function_exists( 'lip_love_it_link' ) ) {
                    $post_item .= lip_love_it_link( get_the_ID(), false, '', 'narrow-date-block' );
                }

                $post_item .= '</div>';

                $post_item .= '<div class="post-content-wrap">';
            }

            $post_item .= '<div class="standard-post-content no-thumb clearfix">'; // open standard-post-content

            if ( $show_title == "yes" && $post_object['format'] != "link" && $post_object['format'] != "quote" ) {
                $post_item .= '<h1 itemprop="name headline"><a ' . $post_permalink_config . '>' . $post_object['title'] . '</a></h1>';
            }

            if ($show_details == "yes" && $post_object['format'] != "quote" && $post_object['format'] != "link" ) {
                if ( sf_theme_opts_name() == "sf_atelier_options" ) {
                    if ( ! $single_author ) {
                        $post_item .= '<div class="blog-item-details">' . sprintf( __( '<span class="author">By <a href="%2$s" rel="author" itemprop="author">%1$s</a></span> in %3$s', 'uplift' ), $post_object['author'], get_author_posts_url( get_the_author_meta( 'ID' ) ), $post_object['categories'] ) . '</div>';
                    }

                } else {
                    $post_item .= $item_details;
                }
            }

            if ( $show_excerpt == "yes" ) {
                $post_item .= '<div class="excerpt" itemprop="description">' . $post_object['excerpt'] . '</div>';
            }

            if ( $show_read_more == "yes" && $post_object['format'] != "quote" && $post_object['format'] != "link" ) {
                $post_item .= '<a class="read-more-button" href="' . $post_object['permalink'] . '">' . __( "Read more", 'uplift' ) . '</a>';
            }

            $post_item .= '</div>'; // close standard-post-content

            if ( sf_theme_opts_name() == "sf_atelier_options" && $show_details == "yes" ) {
                $post_item .= '</div>'; // close post-content-wrap
            }


            // Return
            return $post_item;
        }
    }

// //CUSTOM POST TYPES CREATION
// function create__quiz_posttype() {
// 	register_post_type( 'quiz',
// 		array(
// 			'labels' => array(
// 				'name' => __( 'Quiz' ),
// 				'singular_name' => __( 'Quiz' ),
// 				'menu_name' => __( 'Quiz' )
// 			),
// 			'public' => true,
// 			'has_archive' => false,
// 			'menu_icon' => 'dashicons-screenoptions',
// 			'supports' => array( 'title', 'editor', 'thumbnail', 'revisions' )
// 		)
// 	);
// }
// add_action( 'init', 'create__quiz_posttype' );

// add_action('init', 'my_custom_init');
// function my_custom_init() {

// 	add_theme_support( 'post-thumbnails' );
// 	add_post_type_support( 'quiz', 'thumbnail' );
// 	post_type_supports( 'quiz', 'thumbnail' );

// }
//add_filter( 'gform_userregistration_login_form', 'change_form', 10, 1 );
// function change_form( $form ) {
//     $fields = $form['fields'];
//     print_r($fields);
//     foreach ( $fields as &$field )
//     {
//         if ( $field['label'] == 'Username' ){
//             $field['label'] = 'Please enter your username';
//         }
//     }
//     return $form;
// }

    // Validate filed Email :

//   add_filter( 'gform_field_validation_1_1', 'rekovelle_validate_email_login', 10, 4 );
//     function rekovelle_validate_email_login($result, $value, $form, $field ){

//         if ( email_exists( $value ) ) {
//             // Stuff to do when email address exists
//             $result['is_valid'] = true;

//         }else{
//             $result['is_valid'] = false;
//             $result['message']= 'There’s no such user in our database';
//         }
//         $_POST['email_user']= $value;

//         return $result;
//     }

    // Validate password :

    // add_filter( 'gform_field_validation_1_2', 'rekovelle_validate_password_login', 10, 4 );

    // function rekovelle_validate_password_login($result, $value, $form, $field ){
    //     if($_POST['email_user']){
    //         $email = $_POST['email_user'];
    //     }
    //   // echo $email.'//'.$value;


    //     $user = get_user_by( 'email', $email );
    //     if ( $user && wp_check_password( $value, $user->data->user_pass, $user->ID) ){
    //         $result['is_valid'] = true;

    //     }else{
    //         $result['is_valid'] = false;
    //         $result['message']= 'Invalid pass';
    //     }
    //     return $result;
    // }

  //  Field label visibility
  add_filter( 'gform_enable_field_label_visibility_settings', '__return_true' );

    // Upload SVG:
	function cc_mime_types($mimes) {
	  $mimes['svg'] = 'image/svg+xml';
	  return $mimes;
	}
	add_filter('upload_mimes', 'cc_mime_types');
	
	/* VARIABLE DEFINITIONS
	================================================== */
	define('SF_TEMPLATE_PATH', get_template_directory());
	define('SF_INCLUDES_PATH', SF_TEMPLATE_PATH . '/includes');
	define('SF_FRAMEWORK_PATH', SF_TEMPLATE_PATH . '/swift-framework');
	define('SF_WIDGETS_PATH', SF_INCLUDES_PATH . '/widgets');
	define('SF_LOCAL_PATH', get_template_directory_uri());
	
	/**
	 * Add postMessage support for site title and description for the Theme Customizer.
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 */

    /* INCLUDE FRAMEWORK
	================================================== */
	define('SF_TEMPLATE_PATH', get_template_directory());
	define('SF_INCLUDES_PATH', SF_TEMPLATE_PATH . '/includes');
	define('SF_FRAMEWORK_PATH', SF_TEMPLATE_PATH . '/swift-framework');
	define('SF_WIDGETS_PATH', SF_INCLUDES_PATH . '/widgets');
	define('SF_LOCAL_PATH', get_template_directory_uri());
    if (!function_exists('sf_include_framework')) {
		function sf_include_framework() {
			
			//Overrides
			 require_once(SF_INCLUDES_PATH . '/overrides/sf-theme-functions.php');
			require_once(SF_INCLUDES_PATH . '/overrides/sf-header-overrides.php');
			 require_once(SF_INCLUDES_PATH . '/overrides/sf-blog-overrides.php');
			 require_once(SF_INCLUDES_PATH . '/overrides/sf-portfolio-overrides.php');
			 require_once(SF_INCLUDES_PATH . '/overrides/sf-gallery-overrides.php');
			 require_once(SF_INCLUDES_PATH . '/overrides/sf-spb-overrides.php');
			
			// Base Framework
			require_once(SF_FRAMEWORK_PATH . '/swift-framework.php');	
			
			// Customizer functionality
			require_once(get_template_directory()   . '/includes/customizer/customizer.php');

			// Style Switcher
			include_once(SF_INCLUDES_PATH . '/sf-styleswitcher/sf-styleswitcher.php');
			
			// Category Colors
			include_once(SF_INCLUDES_PATH . '/sf-category-colors.php');
			
			// Framework overrides
			include_once(SF_INCLUDES_PATH . '/overrides/sf-framework-overrides.php');
			
			// WooCommerce
			require_once(SF_INCLUDES_PATH . '/overrides/sf-woocommerce-overrides.php');
		}
		add_action('init', 'sf_include_framework', 6);
	}
    
	add_action( 'init', 'remove_include_action');
	function remove_include_action() {
		 remove_action( 'init','sf_include_framework',5 );
	}
	
	function sf_customizer_child($wp_customize){
	    
        /**
		 * Remove Default Sections
		 */
		 
		 
	    $wp_customize->remove_section('colors');
		$wp_customize->remove_section('background_image');
		
	    /**
         * Sections
         *
         * $sf_customizer['section'][] = array( 'id', 'label', 'priority' );
         */
        
        $sf_customizer['section'][] = array( 'sf_customizer_general', __( 'Color - General', 'uplift' ), '', 30 );
        $sf_customizer['section'][] = array( 'sf_customizer_top_bar', __( 'Color - Top Bar', 'uplift' ), '', 32 );
        $sf_customizer['section'][] = array( 'sf_customizer_header', __( 'Color - Header', 'uplift' ), '', 33 );
        $sf_customizer['section'][] = array( 'sf_customizer_navigation', __( 'Color - Navigation', 'uplift' ), '', 34 );
        $sf_customizer['section'][] = array( 'sf_customizer_fullscreen', __( 'Color - Fullscreen Overlays', 'uplift' ), __( 'These colours are used for various fullscreen overlays within the theme, and also the Push Navigation.', 'uplift' ), 35 );
        $sf_customizer['section'][] = array( 'sf_customizer_slideout_menu', __( 'Color - Slideout Menu', 'uplift' ), '', 36 );
        $sf_customizer['section'][] = array( 'sf_customizer_mobile_menu', __( 'Color - Mobile Menu', 'uplift' ), '', 37 );
        $sf_customizer['section'][] = array( 'sf_customizer_header_banner', __( 'Color - Header Banner', 'uplift' ), '', 38 );
        $sf_customizer['section'][] = array( 'sf_customizer_page_heading', __( 'Color - Page Heading', 'uplift' ), '', 39 );
        $sf_customizer['section'][] = array( 'sf_customizer_breadcrumbs', __( 'Color - Breadcrumbs', 'uplift' ), '', 39 );
        $sf_customizer['section'][] = array( 'sf_customizer_newsletter_bar', __( 'Color - Newsletter Bar', 'uplift' ), '', 40 );
        $sf_customizer['section'][] = array( 'sf_customizer_footer', __( 'Color - Footer', 'uplift' ), '', 41 );
        $sf_customizer['section'][] = array( 'sf_customizer_ui_elements', __( 'Color - UI Elements', 'uplift' ), '', 42 );
        $sf_customizer['section'][] = array( 'sf_customizer_content_sliders', __( 'Color - Content Sliders', 'uplift' ), '', 43 );
        $sf_customizer['section'][] = array( 'sf_customizer_shortcodes', __( 'Color - Shortcodes', 'uplift' ), '', 44 );
        
        
        /**
         * Settings
         *
         * $sf_customizer['setting'][] = array( 'id', 'default', 'transport', 'sanitize_callback' );
         * $sf_customizer['control'][] = array( 'id', 'type', 'label', 'choices', 'section' );
         */
        
        
        /*
         * Color - General
         */
        $sf_customizer['setting'][] = array( 'sf_customizer[page_bg_color]', '#fff', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[page_bg_color]', 'color', __( 'Outer Page / Loading Background Colors', 'uplift' ), '', 'sf_customizer_general' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[inner_page_bg_color]', '#fff', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[inner_page_bg_color]', 'color', __( 'Inner Page Background Color', 'uplift' ), '', 'sf_customizer_general' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[section_divide_color]', '#eaeaea', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[section_divide_color]', 'color', __( 'Section Divide Color', 'uplift' ), '', 'sf_customizer_general' );
                
        $sf_customizer['setting'][] = array( 'sf_customizer[accent_color]', '#7eced5', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[accent_color]', 'color', __( 'Accent Color', 'uplift' ), '', 'sf_customizer_general' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[body_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[body_color]', 'color', __( 'Body Color', 'uplift' ), '', 'sf_customizer_general' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[body_alt_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[body_alt_color]', 'color', __( 'Body Alt Color', 'uplift' ), '', 'sf_customizer_general' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[link_color]', '#999', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[link_color]', 'color', __( 'Link Color', 'uplift' ), '', 'sf_customizer_general' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[link_hover_color]', '#7eced5', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[link_hover_color]', 'color', __( 'Link Hover Color', 'uplift' ), '', 'sf_customizer_general' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[h1_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[h1_color]', 'color', __( 'H1 Color', 'uplift' ), '', 'sf_customizer_general' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[h2_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[h2_color]', 'color', __( 'H2 Color', 'uplift' ), '', 'sf_customizer_general' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[h3_color]', '#333', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[h3_color]', 'color', __( 'H3 Color', 'uplift' ), '', 'sf_customizer_general' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[h4_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[h4_color]', 'color', __( 'H4 Color', 'uplift' ), '', 'sf_customizer_general' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[h5_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[h5_color]', 'color', __( 'H5 Color', 'uplift' ), '', 'sf_customizer_general' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[h6_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[h6_color]', 'color', __( 'H6 Color', 'uplift' ), '', 'sf_customizer_general' );
                    
        
        /*
         * Top Bar
         */
        $sf_customizer['setting'][] = array( 'sf_customizer[topbar_bg_color]', '#fff', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[topbar_bg_color]', 'color', __( 'Top Bar Background Color', 'uplift' ), '', 'sf_customizer_top_bar' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[topbar_text_color]', '#444', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[topbar_text_color]', 'color', __( 'Top Bar Text Color', 'uplift' ), '', 'sf_customizer_top_bar' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[topbar_link_color]', '#999', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[topbar_link_color]', 'color', __( 'Top Bar Link Color', 'uplift' ), '', 'sf_customizer_top_bar' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[topbar_link_hover_color]', '#7eced5', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[topbar_link_hover_color]', 'color', __( 'Top Bar Link Hover Color', 'uplift' ), '', 'sf_customizer_top_bar' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[topbar_divider_color]', '#eaeaea', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[topbar_divider_color]', 'color', __( 'Top Bar Divider Color', 'uplift' ), '', 'sf_customizer_top_bar' );
         
        
        /*
         * Header
         */
        $sf_customizer['setting'][] = array( 'sf_customizer[header_bg_color]', '#fff', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[header_bg_color]', 'color', __( 'Header Background Color', 'uplift' ), '', 'sf_customizer_header' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[header_border_color]', '#eaeaea', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[header_border_color]', 'color', __( 'Header Border Color', 'uplift' ), '', 'sf_customizer_header' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[header_text_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[header_text_color]', 'color', __( 'Header Text Color', 'uplift' ), '', 'sf_customizer_header' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[header_link_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[header_link_color]', 'color', __( 'Header Link Color', 'uplift' ), '', 'sf_customizer_header' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[header_link_hover_color]', '#7eced5', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[header_link_hover_color]', 'color', __( 'Header Link Hover Color', 'uplift' ), '', 'sf_customizer_header' );
        
        
        /*
         * Navigation
         */
        $sf_customizer['setting'][] = array( 'sf_customizer[nav_bg_color]', '#fff', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[nav_bg_color]', 'color', __( 'Nav Background Color', 'uplift' ), '', 'sf_customizer_navigation' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[nav_text_color]', '#414141', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[nav_text_color]', 'color', __( 'Menu Item Text Color', 'uplift' ), '', 'sf_customizer_navigation' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[nav_text_hover_color]', '#7eced5', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[nav_text_hover_color]', 'color', __( 'Menu Item Text Hover Color', 'uplift' ), '', 'sf_customizer_navigation' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[nav_selected_text_color]', '#303030', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[nav_selected_text_color]', 'color', __( 'Menu Item Active Text Color', 'uplift' ), '', 'sf_customizer_navigation' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[nav_sm_bg_color]', '#f9f9f9', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[nav_sm_bg_color]', 'color', __( 'Sub Menu Background Color', 'uplift' ), '', 'sf_customizer_navigation' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[nav_sm_text_color]', '#999', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[nav_sm_text_color]', 'color', __( 'Sub Menu Text Color', 'uplift' ), '', 'sf_customizer_navigation' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[nav_sm_text_hover_color]', '#7eced5', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[nav_sm_text_hover_color]', 'color', __( 'Sub Menu Text Hover Color', 'uplift' ), '', 'sf_customizer_navigation' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[nav_sm_selected_text_color]', '#333333', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[nav_sm_selected_text_color]', 'color', __( 'Sub Menu Active Text Color', 'uplift' ), '', 'sf_customizer_navigation' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[nav_divider_color]', '#f0f0f0', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[nav_divider_color]', 'color', __( 'Nav Divider Color', 'uplift' ), '', 'sf_customizer_navigation' );
                  
        
        /*
         * Fullscreen Overlays
         */
        $sf_customizer['setting'][] = array( 'sf_customizer[overlay_menu_bg_color]', '#7eced5', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[overlay_menu_bg_color]', 'color', __( 'Overlay Menu Background Color', 'uplift' ), '', 'sf_customizer_fullscreen' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[overlay_menu_text_color]', '#c5e7eb', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[overlay_menu_text_color]', 'color', __( 'Overlay Menu Text Color', 'uplift' ), '', 'sf_customizer_fullscreen' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[overlay_menu_link_color]', '#d9f0f2', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[overlay_menu_link_color]', 'color', __( 'Overlay Menu Link Color', 'uplift' ), '', 'sf_customizer_fullscreen' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[overlay_menu_link_hover_color]', '#ffffff', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[overlay_menu_link_hover_color]', 'color', __( 'Overlay Menu Link Hover Color', 'uplift' ), '', 'sf_customizer_fullscreen' );
          
        
        /*
         * Side Slideout Menu
         */		 
        $sf_customizer['setting'][] = array( 'sf_customizer[slideout_menu_bg_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[slideout_menu_bg_color]', 'color', __( 'Slideout Background Color', 'uplift' ), '', 'sf_customizer_slideout_menu' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[slideout_menu_bg_image]', '', 'refresh', 'esc_url_raw' );
        $sf_customizer['control'][] = array( 'sf_customizer[slideout_menu_bg_image]', 'image', __( 'Slideout Background Image', 'uplift' ), '', 'sf_customizer_slideout_menu' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[slideout_menu_link_color]', '#fff', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[slideout_menu_link_color]', 'color', __( 'Slideout Link Color', 'uplift' ), '', 'sf_customizer_slideout_menu' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[slideout_menu_link_hover_color]', '#7eced5', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[slideout_menu_link_hover_color]', 'color', __( 'Slideout Link Hover Color', 'uplift' ), '', 'sf_customizer_slideout_menu' );
                
        $sf_customizer['setting'][] = array( 'sf_customizer[slideout_menu_divider_color]', '#ccc', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[slideout_menu_divider_color]', 'color', __( 'Slideout Divider Color', 'uplift' ), '', 'sf_customizer_slideout_menu' );
        
        
        /*
         * Mobile Menu
         */		 
        $sf_customizer['setting'][] = array( 'sf_customizer[mobile_menu_bg_color]', '#fff', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[mobile_menu_bg_color]', 'color', __( 'Mobile Menu Background Color', 'uplift' ), '', 'sf_customizer_mobile_menu' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[mobile_menu_text_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[mobile_menu_text_color]', 'color', __( 'Mobile Menu Text Color', 'uplift' ), '', 'sf_customizer_mobile_menu' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[mobile_menu_link_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[mobile_menu_link_color]', 'color', __( 'Mobile Menu Link Color', 'uplift' ), '', 'sf_customizer_mobile_menu' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[mobile_menu_link_hover_color]', '#7eced5', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[mobile_menu_link_hover_color]', 'color', __( 'Mobile Menu Link Hover Color', 'uplift' ), '', 'sf_customizer_mobile_menu' );
                
        $sf_customizer['setting'][] = array( 'sf_customizer[mobile_menu_divider_color]', '#eee', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[mobile_menu_divider_color]', 'color', __( 'Mobile Menu Divider Color', 'uplift' ), '', 'sf_customizer_mobile_menu' );
        
        
        /*
         * Header Banner
         */		 
        $sf_customizer['setting'][] = array( 'sf_customizer[header_banner_bg_color]', '#fff', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[header_banner_bg_color]', 'color', __( 'Header Banner Background Color', 'uplift' ), '', 'sf_customizer_header_banner' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[header_banner_text_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[header_banner_text_color]', 'color', __( 'Header Banner Text Color', 'uplift' ), '', 'sf_customizer_header_banner' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[header_banner_link_color]', '#333', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[header_banner_link_color]', 'color', __( 'Header Banner Link Color', 'uplift' ), '', 'sf_customizer_header_banner' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[header_banner_link_hover_color]', '#7eced5', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[header_banner_link_hover_color]', 'color', __( 'Header Banner Link Hover Color', 'uplift' ), '', 'sf_customizer_header_banner' );
                
        $sf_customizer['setting'][] = array( 'sf_customizer[header_banner_border_color]', '#e3e3e3', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[header_banner_border_color]', 'color', __( 'Header Banner Divider Color', 'uplift' ), '', 'sf_customizer_header_banner' );
        
        
        /*
         * Page Heading
         */		 
        $sf_customizer['setting'][] = array( 'sf_customizer[page_heading_bg_color]', '#f7f7f7', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[page_heading_bg_color]', 'color', __( 'Page Heading Background Color', 'uplift' ), '', 'sf_customizer_page_heading' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[page_heading_text_color]', '#333', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[page_heading_text_color]', 'color', __( 'Page Heading Text Color', 'uplift' ), '', 'sf_customizer_page_heading' );
                
        
        /*
         * Breadcrumbs
         */		 
        $sf_customizer['setting'][] = array( 'sf_customizer[breadcrumb_text_color]', '#777', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[breadcrumb_text_color]', 'color', __( 'Breadcrumb Text Color', 'uplift' ), '', 'sf_customizer_breadcrumbs' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[breadcrumb_link_color]', '#aaa', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[breadcrumb_link_color]', 'color', __( 'Breadcrumb Link Color', 'uplift' ), '', 'sf_customizer_breadcrumbs' );
          
        
        
        /*
         * Newsletter Bar
         */		 
        $sf_customizer['setting'][] = array( 'sf_customizer[newsletter_bar_bg_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[newsletter_bar_bg_color]', 'color', __( 'Newsletter Bar Background Color', 'uplift' ), '', 'sf_customizer_newsletter_bar' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[newsletter_bar_text_color]', '#ccc', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[newsletter_bar_text_color]', 'color', __( 'Newsletter Bar Text', 'uplift' ), '', 'sf_customizer_newsletter_bar' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[newsletter_bar_link_hover_color]', '#fff', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[newsletter_bar_link_hover_color]', 'color', __( 'Newsletter Bar Link Hover Color', 'uplift' ), '', 'sf_customizer_newsletter_bar' );
                
            
        /*
         * Footer
         */
        $sf_customizer['setting'][] = array( 'sf_customizer[footer_bg_color]', '#f9f9f9', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[footer_bg_color]', 'color', __( 'Footer Background Color', 'uplift' ), '', 'sf_customizer_footer' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[footer_text_color]', '#999', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[footer_text_color]', 'color', __( 'Footer Text Color', 'uplift' ), '', 'sf_customizer_footer' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[footer_link_color]', '#666', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[footer_link_color]', 'color', __( 'Footer Link Color', 'uplift' ), '', 'sf_customizer_footer' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[footer_link_hover_color]', '#444', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[footer_link_hover_color]', 'color', __( 'Footer Link Hover Color', 'uplift' ), '', 'sf_customizer_footer' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[footer_border_color]', '#eee', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[footer_border_color]', 'color', __( 'Footer Border Color', 'uplift' ), '', 'sf_customizer_footer' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[copyright_bg_color]', '#f7f7f7', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[copyright_bg_color]', 'color', __( 'Copyright Background Color', 'uplift' ), '', 'sf_customizer_footer' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[copyright_text_color]', '#999', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[copyright_text_color]', 'color', __( 'Copyright Text Color', 'uplift' ), '', 'sf_customizer_footer' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[copyright_link_color]', '#666', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[copyright_link_color]', 'color', __( 'Copyright Link Color', 'uplift' ), '', 'sf_customizer_footer' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[copyright_link_hover_color]', '#444', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[copyright_link_hover_color]', 'color', __( 'Copyright Link Hover Color', 'uplift' ), '', 'sf_customizer_footer' );
        
        
        /*
         * UI Elements
         */		 
        $sf_customizer['setting'][] = array( 'sf_customizer[input_bg_color]', '#fff', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[input_bg_color]', 'color', __( 'Input/Textarea Background Color', 'uplift' ), '', 'sf_customizer_ui_elements' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[input_text_color]', '#999', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[input_text_color]', 'color', __( 'Input/Textarea Text Color', 'uplift' ), '', 'sf_customizer_ui_elements' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[overlay_bg_color]', '#7eced5', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[overlay_bg_color]', 'color', __( 'Thumb Hover Overlay Background Color', 'uplift' ), '', 'sf_customizer_ui_elements' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[overlay_text_color]', '#fff', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[overlay_text_color]', 'color', __( 'Thumb Hover Overlay Text Color', 'uplift' ), '', 'sf_customizer_ui_elements' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[preview_slider_bg_color]', '#f7f7f7', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[preview_slider_bg_color]', 'color', __( 'Product Preview Slider Background Color', 'uplift' ), '', 'sf_customizer_ui_elements' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[sale_tag_color]', '#ff8a80', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[sale_tag_color]', 'color', __( 'Sale Tag Color', 'uplift' ), '', 'sf_customizer_ui_elements' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[new_tag_color]', '#7eced5', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[new_tag_color]', 'color', __( 'New Tag Color', 'uplift' ), '', 'sf_customizer_ui_elements' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[oos_tag_color]', '#ccc', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[oos_tag_color]', 'color', __( 'Out of Stock Tag Color', 'uplift' ), '', 'sf_customizer_ui_elements' );
        
            
        /*
         * Content Sliders
         */		 
        $sf_customizer['setting'][] = array( 'sf_customizer[tweet_slider_bg]', '#1dc6df', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[tweet_slider_bg]', 'color', __( 'Tweet Slider Background Color', 'uplift' ), '', 'sf_customizer_content_sliders' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[tweet_slider_text]', '#fff', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[tweet_slider_text]', 'color', __( 'Tweet Slider Text Color', 'uplift' ), '', 'sf_customizer_content_sliders' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[tweet_slider_link]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[tweet_slider_link]', 'color', __( 'Tweet Slider Link Color', 'uplift' ), '', 'sf_customizer_content_sliders' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[tweet_slider_link_hover]', '#fb3c2d', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[tweet_slider_link_hover]', 'color', __( 'Tweet Slider Link Hover Color', 'uplift' ), '', 'sf_customizer_content_sliders' );
          
        $sf_customizer['setting'][] = array( 'sf_customizer[testimonial_slider_bg]', '#7eced5', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[testimonial_slider_bg]', 'color', __( 'Testimonial Slider Background Color', 'uplift' ), '', 'sf_customizer_content_sliders' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[testimonial_slider_text]', '#fff', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[testimonial_slider_text]', 'color', __( 'Testimonial Slider Text Color', 'uplift' ), '', 'sf_customizer_content_sliders' );
          
        
        /*
         * Shortcodes
         */		 
        $sf_customizer['setting'][] = array( 'sf_customizer[promo_bar_bg_color]', '#e4e4e4', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[promo_bar_bg_color]', 'color', __( 'Promo Bar Background Color', 'uplift' ), '', 'sf_customizer_shortcodes' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[promo_bar_text_color]', '#222', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[promo_bar_text_color]', 'color', __( 'Promo Bar Text Color', 'uplift' ), '', 'sf_customizer_shortcodes' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[icon_container_border_color]', '#eaeaea', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[icon_container_border_color]', 'color', __( 'Icon Container Border Color', 'uplift' ), '', 'sf_customizer_shortcodes' );
        
        $sf_customizer['setting'][] = array( 'sf_customizer[icon_container_hover_border_color]', '#7eced5', 'postMessage', 'sanitize_hex_color' );
        $sf_customizer['control'][] = array( 'sf_customizer[icon_container_hover_border_color]', 'color', __( 'Icon Container Hover Border Color', 'uplift' ), '', 'sf_customizer_shortcodes' );
        
        
        //
        // LOOP - Add Section
        //
        
        foreach ( $sf_customizer['section'] as $customizer_section ) {
          $wp_customize->add_section( $customizer_section[0], array(
            'title'    	=> $customizer_section[1],
            'description' => $customizer_section[2],
            'priority' 	=> $customizer_section[3],
          ) );
        }
        
        
        //
        // Loop - Add Setting
        //
        
        foreach ( $sf_customizer['setting'] as $customizer_setting ) {
          $wp_customize->add_setting( $customizer_setting[0], array(
            'type'      => 'option',
            'default'   => $customizer_setting[1],
            'transport' => $customizer_setting[2],
            'sanitize_callback' => $customizer_setting[3]
          ));
        }
        
        
        //
        // Loop - Add Control
        //
        
        foreach ( $sf_customizer['control'] as $customizer_control ) {
        
          static $i = 1;
        
          if ( $customizer_control[1] == 'text' ) {
        
            $wp_customize->add_control( $customizer_control[0], array(
              'type'     => $customizer_control[1],
              'label'    => $customizer_control[2],
              'section'  => $customizer_control[4],
              'priority' => $i
            ));
        
          } elseif ( $customizer_control[1] == 'select' ) {
        
            $wp_customize->add_control( $customizer_control[0], array(
              'type'     => $customizer_control[1],
              'label'    => $customizer_control[2],
              'section'  => $customizer_control[4],
              'priority' => $i,
              'choices'  => $customizer_control[3]
            ));
        
          } else if ( $customizer_control[1] == 'image' ) {
        
            $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, $customizer_control[0], array(
                'label'    => $customizer_control[2],
                'section'  => $customizer_control[4],
                'settings' => $customizer_control[0],
                'priority' => $i
              ))
            );
        
          } else if ( $customizer_control[1] == 'radio' ) {
        
            $wp_customize->add_control( $customizer_control[0], array(
              'type'     => $customizer_control[1],
              'label'    => $customizer_control[2],
              'section'  => $customizer_control[4],
              'priority' => $i,
              'choices'  => $customizer_control[3]
            ));
        
          } else if ( $customizer_control[1] == 'checkbox' ) {
        
            $wp_customize->add_control( $customizer_control[0], array(
              'type'     => $customizer_control[1],
              'label'    => $customizer_control[2],
              'section'  => $customizer_control[3],
              'priority' => $i
            ));
        
          } else 
          
          if ( $customizer_control[1] == 'color' ) {
        
            $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $customizer_control[0], array(
              'type'     => $customizer_control[1],
              'label'    => $customizer_control[2],
              'section'  => $customizer_control[4],
              'settings' => $customizer_control[0],
              'priority' => $i
              ))
            );
            
          } else if ( $customizer_control[1] == 'slider' ) {
        
            $wp_customize->add_control( new SF_Customize_Slider_Control( $wp_customize, $customizer_control[0], array(
              'type'     => $customizer_control[1],
              'label'    => $customizer_control[2],
              'section'  => $customizer_control[4],
              'priority' => $i,
              'choices'  => $customizer_control[3]
              ))
            );
        
          }
        
          $i++;
        
        }

	}


add_action( 'customize_register', 'sf_customizer_child',100 );