<?php

/**
 * Default functions and definitions
 *
 * For more information on hooks, actions, and filters, see http://codex.wordpress.org/Plugin_API.
 *
 * @package 	WordPress
 * @subpackage 	Default
 * @since 		Default 4.0
 */

/* ========================================================================================================================
	
	Required external files
	
	======================================================================================================================== */

require_once('external/default-utilities.php');

/* ========================================================================================================================
	
	Theme specific settings

	Uncomment register_nav_menus to enable a single menu with the title of "Primary Navigation" in your theme
	
	======================================================================================================================== */

add_theme_support('post-thumbnails');

register_nav_menus(array('primary' => 'Primary Navigation'));
// register_nav_menus(array('fertility-sub-menu' => 'Fertility sub menu'));
// register_nav_menus(array('rekovelle-sub-menu' => 'Rekovelle sub menu'));
// register_nav_menus(array('lutigest-sub-menu' => 'Lutigest sub menu'));
// register_nav_menus(array('menopur-sub-menu' => 'Menopur sub menu'));
// register_nav_menus(array('fyremadel-sub-menu' => 'Fyremadel sub menu'));

/**
 * Register Custom Navigation Walker
 */
function register_navwalker()
{
	require_once get_template_directory() . '/class-wp-bootstrap-navwalker.php';
}
add_action('after_setup_theme', 'register_navwalker');

if (function_exists('acf_add_options_page')) {
	acf_add_options_page();
}

/* ========================================================================================================================
	
	Actions and Filters
	
	======================================================================================================================== */

add_action('wp_enqueue_scripts', 'default_script_enqueuer');

add_filter('body_class', array('Default_Utilities', 'add_slug_to_body_class'));

// remove_filter ('the_content', 'wpautop');

/* ========================================================================================================================
	
	Custom Post Types - include custom post types and taxonimies here e.g.

	e.g. require_once( 'custom-post-types/your-custom-post-type.php' );
	
	======================================================================================================================== */



/* ========================================================================================================================
	
	Scripts
	
	======================================================================================================================== */

/**
 * Add scripts via wp_head()
 *
 * @return void
 * @author Keir Whitaker
 */

function default_script_enqueuer()
{
	wp_register_script('jquery', 'https://code.jquery.com/jquery-3.6.0.min.js');
	wp_enqueue_script('jquery');
	//Bootstrap js 
	wp_register_script('bootstrap.min.js', get_template_directory_uri() . '/assets/dist/js/bootstrap.min.js');
	wp_enqueue_script('bootstrap.min.js');

	wp_register_script('bootstrap.min.js.map', get_template_directory_uri() . '/assets/dist/js/bootstrap.min.js.map');
	wp_enqueue_script('bootstrap.min.js.map');

	// add main js for frontend functionalities
	wp_register_script('main', get_template_directory_uri() . '/js/site.js', array('jquery'));
	wp_enqueue_script('main');

	// add fitVid js so video embeds will be responsive
	wp_register_script('fitvid', get_template_directory_uri() . '/js/jquery.fitvids.min.js', array('jquery'));
	wp_enqueue_script('fitvid');

	// add parallax js for the banner effect
	wp_register_script('parallax', 'https://cdn.jsdelivr.net/parallax.js/1.4.2/parallax.min.js', array('jquery'));
	wp_enqueue_script('parallax');

	/** import theme style.css **/
	wp_register_style('screen', get_template_directory_uri() . '/assets/dist/css/style.css', '', '', 'screen');
	wp_enqueue_style('screen');
}

// need to manually add html5 shim for IE versions not supporting html5
add_action('wp_head', 'add_ie_fixes');
function add_ie_fixes()
{
	global $is_IE;
	if ($is_IE) {
		echo '<!--[if lt IE 9]>';
		// html5 shim for IE versions not supporting html5
		echo '<script src="' . get_template_directory_uri() . '/js/html5shiv.js"></script>';
		// fix so that ie8 supports media queries
		echo '<script src="' . get_template_directory_uri() . '/js/respond.min.js"></script>';
		echo '<![endif]-->';
	}
}

/* ========================================================================================================================
	
	Comments
	
	======================================================================================================================== */

/**
 * Custom callback for outputting comments 
 *
 * @return void
 * @author Keir Whitaker
 */
function default_comment($comment, $args, $depth)
{
	$GLOBALS['comment'] = $comment;
?>
<?php if ($comment->comment_approved == '1') : ?>
<li>
    <article id="comment-<?php comment_ID() ?>">
        <?php echo get_avatar($comment); ?>
        <h4><?php comment_author_link() ?></h4>
        <time><a href="#comment-<?php comment_ID() ?>" pubdate><?php comment_date() ?> at
                <?php comment_time() ?></a></time>
        <?php comment_text() ?>
    </article>
    <?php endif;
}

/* ========================================================================================================================

	Sidebars

	======================================================================================================================== */

if (function_exists('register_sidebar')) {
	register_sidebar(array(
		'name' => 'Sidebar 1',
		'id' => 'sidebar-1',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h2>',
		'after_title' => '</h2>',
	));
}

/* ========================================================================================================================

	Footer

	======================================================================================================================== */

if (function_exists('register_sidebar')) {
	register_sidebar(array(
		'name' => 'footer',
		'id' => 'footer-1',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h2>',
		'after_title' => '</h2>',
	));
}
/* ========================================================================================================================

	Misc.

	======================================================================================================================== */

// Hide annoying frontend toolbar
add_filter('show_admin_bar', '__return_false');

function theme_prefix_setup()
{
	add_theme_support('custom-logo', array(
		'flex-width' => true,
	));
}
add_action('after_setup_theme', 'theme_prefix_setup');

function theme_prefix_the_custom_logo()
{
	if (function_exists('the_custom_logo')) {
		the_custom_logo();
	}
}

add_action('init', 'tatwerat_startSession', 1);
function tatwerat_startSession() {
    if(!session_id()) {
        session_start();
    }
}
