<?php

/**
 * Template Name: Home page template 
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * Please see /external/default-utilities.php for info on Default_Utilities::get_template_parts()
 *
 * @package 	WordPress
 * @subpackage 	Default
 * @since 		Default 4.0
 */
?>
<?php Default_Utilities::get_template_parts(array('parts/shared/html-header', 'parts/shared/header-common')); ?>
<?php if (have_posts()) while (have_posts()) : the_post(); ?>
<section class="home-page-banner" style="background-image: url('<?php echo get_field('banner_image'); ?>');">
    <div class="container">
        <div class="row">
            <div class="col-md-12 home-page-banner--content">
                <?php echo get_field('banner-content'); ?>
            </div>
        </div>
    </div>
</section>

<article class="span_8">
    <?php the_content(); ?>
    <?php endwhile; ?>
</article>

<script>
(function($, undefined) {
    "use strict";
    $(function() {
        var $form = $("#home-popup");
        $form.on("submit", function(event) {
            var link = $("#home-popup").serialize();
            link = link.replace("page=", "");
            if (link) {
                location.replace("/" + link);
            } else {
                $('.modal').modal('toggle');
            }
            event.preventDefault();
        });
    });
})(jQuery);

</script>
<?php Default_Utilities::get_template_parts(array('parts/shared/footer-common', 'parts/shared/html-footer')); ?>
