<?php

/**
 * Template Name: Product Fertility page template 
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * Please see /external/default-utilities.php for info on Default_Utilities::get_template_parts()
 *
 * @package 	WordPress
 * @subpackage 	Default
 * @since 		Default 4.0
 */
?>
<?php Default_Utilities::get_template_parts(array('parts/shared/html-header', 'parts/shared/header-common')); ?>
<?php if (have_posts()) while (have_posts()) : the_post(); ?>
<section class="product-page-banner product-page-banner-left" style="background-image: url('<?php echo get_field('product_page_banner'); ?>');">
    <div class="container">
        <div class="row">
            <div class="col-md-5 product-page-banner--content">
                <?php echo get_field('product_page_content'); ?>
            </div>
        </div>
    </div>
</section>

<section class="product-page-sub-menu" id="secondary-menu" style="background:<?php echo get_field('product_page_color_picker'); ?>;">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <?php
                    $sub_menu = get_field('product_page_sub_menu');
                    $menu_list = '';
                    $bool = false;
                    $menu_items = wp_get_nav_menu_items($sub_menu, 'nav_menu');
                    $menu_list .= '<nav class="navbar navbar-light  navbar-expand-lg" role="navigation">' . "\n";
                    $menu_list .= '<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#bs-example-navbar-collapse-2" aria-controls="bs-example-navbar-collapse-2" aria-expanded="false" aria-label="Toggle navigation">' . esc_html(get_the_title()) . ' <i class="fas fa-chevron-down text-right"></i></button>' . "\n";
                    $menu_list .= '<div id="bs-example-navbar-collapse-2" class="navbar-collapse collapse">' . "\n";
                    $menu_list .= '<ul id="menu-main-menu" class="nav navbar-nav">' . "\n";
                    foreach ($menu_items as $menu_item) {
                        if ($menu_item->menu_item_parent == 0) {
                            $parent = $menu_item->ID;
                            $menu_array = array();
                            foreach ($menu_items as $submenu) {
                                if ($submenu->menu_item_parent == $parent) {
                                    $bool = true;
                                    $menu_sub_items = '<li itemscope="itemscope" class="';
                                    foreach ($menu_item->classes as $class) {
                                        $menu_sub_items .= $class;
                                    }
                                    $menu_sub_items .= '"><a href="' . $submenu->url . '"';
                                    if($menu_item->target){
                                        $menu_sub_items .= 'target="'.$menu_item->target.'"';
                                    }
                                    $menu_sub_items .= '>' . $submenu->title . '</a></li>' . "\n";
                                    $menu_array[] = $menu_sub_items;
                                }
                            }
                            if ($bool == true && count($menu_array) > 0) {
                                $menu_list .= '<li class="dropdown ';
                                foreach ($menu_item->classes as $class) {
                                    $menu_list .= $class;
                                }
                                $menu_list .= '">' . "\n";
                                $menu_list .= '<a href="' . $menu_item->url . '" class="dropdown-toggle" data-toggle="dropdown"
                    role="button" aria-haspopup="true" aria-expanded="false">' . $menu_item->title . ' <span
                        class="caret"></span></a>' . "\n";

                                $menu_list .= '<ul class="dropdown-menu">' . "\n";
                                $menu_list .= implode("\n", $menu_array);
                                $menu_list .= '</ul>' . "\n";
                            } else {
                                $menu_list .= '
                            <li class="';
                                foreach ($menu_item->classes as $class) {
                                    $menu_list .= $class;
                                }
                                $menu_list .= '">' . "\n";
                                $menu_list .= '<a href="' . $menu_item->url . '"';
                                if($menu_item->target){
                                    $menu_list .= 'target="'.$menu_item->target.'"';
                                }
                                $menu_list .= '>' . $menu_item->title . '</a>' . "\n";
                            }
                        }
                        $menu_list .= '</li>' . "\n";
                    }
                    $menu_list .= '
                </ul>' . "\n";
                    $menu_list .= '
            </div>' . "\n";
                    $menu_list .= '</nav>' . "\n";
                    echo $menu_list;
                    ?>
            </div>
        </div>
    </div>
</section>
<article class="col span_8" style="background: <?php the_field('product_page_body_background'); ?>;">
    <?php the_content(); ?>

</article>

<section class="blog-suggestion">
    <div class="container">
        <div class="row justify-content-center" style="position: relative;top:-40px">
            <div class="col-md-10">
                <h4 class="title-forth" style="font-weight: 400;">My Fertility Journey</h4>
            </div>
        </div>
        <?php
            global $post;
            $categories = get_field('cate');;
            if ($categories) {
                $args = array(
                    'category__in' => $categories,
                    'post__not_in' => array($post->ID),
                    'order' => 'ASC',
                    'posts_per_page' => 99,
                );
                $my_query = new wp_query($args);
                if ($my_query->have_posts()) {
                    $i = 1;
                    while ($my_query->have_posts()) {
                        $my_query->the_post();

            ?>
        <div class="row justify-content-center">
            <div class="col-md-11">
               <div class="row mySlides fades" id="suggetion-post-<?php echo $i; ?>"
                style="display: <?php echo ($i == 1) ? "flex" : "none"; ?>;">
                <div class="col-md-6 col-mobile-only">
                    <div class="blog-carousel-text">
                        <h3><?php the_title() ?></h3>

                        <p><?php the_excerpt() ?></p>

                        <div class="blog-suggestion-readMore">
                            <a class="blog-read-morecta" rel="prev" href="<?php the_permalink() ?>">READ MORE</a>
                            <div class="read-time">
                                <i class="far fa-clock">&nbsp;</i>
                                <span><?php echo do_shortcode('[rt_reading_time]'); ?> mins read</span>
                            </div>
                            <div class="blog-nav-btns">
                                <a onclick="previous(<?php echo $i; ?>)">
                                    <i class="fas fa-chevron-left"></i> </a>
                                <a onclick="next(<?php echo $i; ?>)"> <i class="fas fa-chevron-right"></i> </a>
                            </div>
                        </div>
                    </div>
                    <div class="blog-sugg-white-img">
                        <img src="<?php echo site_url(); ?>/wp-content/uploads/2021/04/blog-sug-vrnpng.png" alt=""
                            class="img-fluid">
                    </div>
                </div>
                <div class="col-md-6 col-mobile-only-blogimg">
                    <div class="blog-suggestion-img">
                        <?php echo the_post_thumbnail() ?>
                    </div>

                    <div class="blog-sg-img-bg">
                        <img src="<?php echo site_url(); ?>/wp-content/uploads/2021/04/shapes-grp-3@2x.png" alt=""
                            class="img-fluid">
                    </div>
                </div>
            </div> 
            </div>
        </div>  
        <?php
                        $i++;
                    }
                }
            }

            ?>
        <div class="row justify-content-center dop-section">
            <div class="col-md-10">
                <?php the_field('dop'); ?>
                <p><small class="dop">UK-FYR-2100001 | Date of preparation: June 2021</small></p>
            </div>
        </div>
    </div>
</section>
<?php endwhile; ?>
<script>
var slideIndex = 0;
showSlides();

function next(id) {
    if (document.getElementById('suggetion-post-' + (id + 1))) {
        document.getElementById('suggetion-post-' + id).style.display = 'none';
        document.getElementById('suggetion-post-' + (id + 1)).style.display = 'flex';
    } else {
        document.getElementById('suggetion-post-' + id).style.display = 'none';
        document.getElementById('suggetion-post-' + 1).style.display = 'flex';
    }
    slideIndex++;
}

function previous(id) {
    if (document.getElementById('suggetion-post-' + (id - 1))) {
        document.getElementById('suggetion-post-' + id).style.display = 'none';
        document.getElementById('suggetion-post-' + (id - 1)).style.display = 'flex';
    } else {
        document.getElementById('suggetion-post-' + id).style.display = 'none';
        document.getElementById('suggetion-post-' + 11).style.display = 'flex';
    }
    slideIndex--;
}

function showSlides() {
  var i;
  var slides = document.getElementsByClassName("mySlides");
  for (i = 0; i < slides.length; i++) {
    slides[i].style.display = "none";  
  }
  slideIndex++;
  if (slideIndex > slides.length) {slideIndex = 1}    
  slides[slideIndex-1].style.display = "flex";
  setTimeout(showSlides, 6000);
}
</script>

<script>
(function($, undefined) {
    "use strict";
    $(function() {
        var $form = $("#home-popup");
        $form.on("submit", function(event) {
            var link = $("#home-popup").serialize();
            link = link.replace("page=", "").replace(/[0-9]/g, '').replace(/&/g, '').replace(
                "pum_form_popup_id=", '');
            if (link) {
                location.replace("/" + link);
            } else {
                $('.modal').modal('toggle');
            }
            console.log(link);
            event.preventDefault();
        });
    });
})(jQuery);
(function($, undefined) {
    "use strict";
    $(function() {
        var $form = $("#learn-popup");
        $form.on("submit", function(event) {
            var link = $("#learn-popup").serialize();
            link = link.replace("page=", "").replace(/[0-9]/g, '').replace(/&/g, '').replace(
                "pum_form_popup_id=", '');
            if (link) {
                location.replace("/" + link);
            } else {
                $('.modal').modal('toggle');
            }
            console.log(link);
            event.preventDefault();
        });
    });
})(jQuery);
</script>

<?php Default_Utilities::get_template_parts(array('parts/shared/footer-common', 'parts/shared/html-footer')); ?>
