<?php
/**
 * The template for displaying Category Archive pages
 *
 * Please see /external/default-utilities.php for info on Default_Utilities::get_template_parts()
 *
 * @package 	WordPress
 * @subpackage 	Default
 * @since 		Default 4.0
 */
?>
<?php Default_Utilities::get_template_parts( array( 'parts/shared/html-header', 'parts/shared/header' ) ); ?>

<section class="col span_8">
	<?php if ( have_posts() ): ?>
	<h2>Category Archive: <?php echo single_cat_title( '', false ); ?></h2>
	<ol>
	<?php while ( have_posts() ) : the_post(); ?>
		<li>
			<article>
				<h2><a href="<?php esc_url( the_permalink() ); ?>" title="Permalink to <?php the_title(); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
				<time datetime="<?php the_time( 'Y-m-d' ); ?>" pubdate><?php the_date(); ?> <?php the_time(); ?></time> <?php comments_popup_link('Leave a Comment', '1 Comment', '% Comments'); ?>
				<?php the_content(); ?>
			</article>
		</li>
	<?php endwhile; ?>
	</ol>
	<?php else: ?>
	<h2>No posts to display in <?php echo single_cat_title( '', false ); ?></h2>
	<?php endif; ?>
</section>

<?php get_sidebar(); ?>
<?php Default_Utilities::get_template_parts( array( 'parts/shared/footer','parts/shared/html-footer' ) ); ?>
