<?php
/*
 * Template Name: New Template
 * Template Post Type: post
 */
Default_Utilities::get_template_parts(array('parts/shared/html-header', 'parts/shared/header-common')); ?>
<section class="blog-page-sub-menu" id="secondary-menu" style="background:<?php echo get_field('product_page_color_picker'); ?>;">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <?php
                    $sub_menu = get_field('post_sub_menu');
                    $menu_list = '';
                    $bool = false;
                    $menu_items = wp_get_nav_menu_items($sub_menu, 'nav_menu');
                    $menu_list .= '<nav class="navbar navbar-light  navbar-expand-lg" role="navigation">' . "\n";
                    $menu_list .= '<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#bs-example-navbar-collapse-2" aria-controls="bs-example-navbar-collapse-2" aria-expanded="false" aria-label="Toggle navigation">' . esc_html(get_the_title()) . ' <i class="fas fa-chevron-down text-right"></i></button>' . "\n";
                    $menu_list .= '<div id="bs-example-navbar-collapse-2" class="navbar-collapse collapse">' . "\n";
                    $menu_list .= '<ul id="menu-main-menu" class="nav navbar-nav">' . "\n";
                    foreach ($menu_items as $menu_item) {
                        if ($menu_item->menu_item_parent == 0) {
                            $parent = $menu_item->ID;
                            $menu_array = array();
                            foreach ($menu_items as $submenu) {
                                if ($submenu->menu_item_parent == $parent) {
                                    $bool = true;
                                    $menu_sub_items = '<li itemscope="itemscope" class="';
                                    foreach ($menu_item->classes as $class) {
                                        $menu_sub_items .= $class;
                                    }
                                    $menu_sub_items .= '"><a href="' . $submenu->url . '"';
                                    if($menu_item->target){
                                        $menu_sub_items .= 'target="'.$menu_item->target.'"';
                                    }
                                    $menu_sub_items .= '>' . $submenu->title . '</a></li>' . "\n";
                                    $menu_array[] = $menu_sub_items;
                                }
                            }
                            if ($bool == true && count($menu_array) > 0) {
                                $menu_list .= '<li class="dropdown ';
                                foreach ($menu_item->classes as $class) {
                                    $menu_list .= $class;
                                }
                                $menu_list .= '">' . "\n";
                                $menu_list .= '<a href="' . $menu_item->url . '" class="dropdown-toggle" data-toggle="dropdown"
                    role="button" aria-haspopup="true" aria-expanded="false">' . $menu_item->title . ' <span
                        class="caret"></span></a>' . "\n";

                                $menu_list .= '<ul class="dropdown-menu">' . "\n";
                                $menu_list .= implode("\n", $menu_array);
                                $menu_list .= '</ul>' . "\n";
                            } else {
                                $menu_list .= '
                            <li class="';
                                foreach ($menu_item->classes as $class) {
                                    $menu_list .= $class;
                                }
                                $menu_list .= '">' . "\n";
                                $menu_list .= '<a href="' . $menu_item->url . '"';
                                if($menu_item->target){
                                    $menu_list .= 'target="'.$menu_item->target.'"';
                                }
                                $menu_list .= '>' . $menu_item->title . '</a>' . "\n";
                            }
                        }
                        $menu_list .= '</li>' . "\n";
                    }
                    $menu_list .= '
                </ul>' . "\n";
                    $menu_list .= '
            </div>' . "\n";
                    $menu_list .= '</nav>' . "\n";
                    echo $menu_list;
                    ?>
            </div>
        </div>
</section>
<article class="col span_8 blog-article">
    <?php if (have_posts()) while (have_posts()) : the_post(); ?>
        <!-- <div class="blog-header-image">
        <?php the_post_thumbnail();  ?>
    </div> -->


        <div class="blog-header-top-image" style="background-image: url('<?php echo wp_get_attachment_url(get_post_thumbnail_id($post->ID)); ?>');"> </div>


        <section class="blog-content-secton">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="blog-content-inner">
                            
                            <?php the_content(); ?>
                        </div>
                    </div>

                </div>
                <?php $post_id = $post->ID; ?>
            </div>
        </section>
    <?php endwhile; ?>
</article>

<section class="blog-suggestion">
    <div class="container">
        <?php
        global $post;
        $categories = get_the_category($post_id);
        $ids = 0;
        if ($categories) {
            $category_ids = array();
            foreach ($categories as $individual_category) $category_ids[] = $individual_category->term_id;
            $args = array(
                'category__in' => $category_ids,
                'post__not_in' => array($post->ID),
                'order' => 'ASC',
                'posts_per_page' => 99,
            );
            $my_query = new wp_query($args);
            if ($my_query->have_posts()) {
                $nextpostid = false;
                while ($my_query->have_posts()) {
                    $my_query->the_post();
                    if (($post->ID > $post_id) && !$nextpostid) {
                        $ids = $post->ID;
                        $nextpostid = true;
                    }
                }
                $i = 1;
                while ($my_query->have_posts()) {
                    $my_query->the_post();

        ?>
                    <div class="row mySlides fades" id="suggetion-post-<?php echo $i; ?>" style="display: <?php echo (($ids == $post->ID) || (!$nextpostid)) ? "flex" : "none"; ?>;">
                    <?php if(($ids == $post->ID) || (!$nextpostid)){
                        $id = $i;
                    } ?>
                        <div class="col-md-6 col-mobile-only">
                            <div class="blog-carousel-text">
                                <h3><?php the_title() ?></h3>
                                <p><?php the_excerpt() ?></p>
                                <div class="blog-suggestion-readMore">
                                    <a class="blog-read-morecta" rel="prev" href="<?php the_permalink() ?>">READ MORE</a>
                                    <div class="read-time">
                                        <i class="far fa-clock">&nbsp;</i>
                                        <span><?php echo do_shortcode('[rt_reading_time]'); ?> mins read</span>
                                    </div>
                                    <div class="blog-nav-btns">
                                        <a onclick="previous(<?php echo $i; ?>)">
                                            <i class="fas fa-chevron-left"></i> </a>
                                        <a onclick="next(<?php echo $i; ?>)"> <i class="fas fa-chevron-right"></i> </a>
                                    </div>
                                </div>
                            </div>
                            <div class="blog-sugg-white-img">
                                <img src="<?php echo site_url(); ?>/wp-content/uploads/2021/04/blog-sug-vrnpng.png" alt="" class="img-fluid">
                            </div>
                        </div>
                        <div class="col-md-6 col-mobile-only-blogimg">
                            <div class="blog-suggestion-img">
                                <?php echo the_post_thumbnail() ?>
                            </div>

                            <div class="blog-sg-img-bg">
                                <img src="<?php echo site_url(); ?>/wp-content/uploads/2021/04/shapes-grp-3@2x.png" alt="" class="img-fluid">
                            </div>
                        </div>
                    </div>
        <?php
                    if (!$ids || !$nextpostid) {
                        $ids = 1;
                        $nextpostid = true;
                    }
                    $i++;
                }
            }
        }

        ?>
    </div>
</section>

<script>
var slideIndex = 3;
var i;
  var slides = document.getElementsByClassName("mySlides");
  for (i = 0; i < slides.length; i++) {
    if(slides[i].style.display === "flex"){
        slideIndex = i;
    }
}
showSlides();

function next(id) {
    if (document.getElementById('suggetion-post-' + (id + 1))) {
        document.getElementById('suggetion-post-' + id).style.display = 'none';
        document.getElementById('suggetion-post-' + (id + 1)).style.display = 'flex';
    } else {
        document.getElementById('suggetion-post-' + id).style.display = 'none';
        document.getElementById('suggetion-post-' + 1).style.display = 'flex';
    }
    slideIndex++;
}

function previous(id) {
    if (document.getElementById('suggetion-post-' + (id - 1))) {
        document.getElementById('suggetion-post-' + id).style.display = 'none';
        document.getElementById('suggetion-post-' + (id - 1)).style.display = 'flex';
    } else {
        document.getElementById('suggetion-post-' + id).style.display = 'none';
        document.getElementById('suggetion-post-' + 11).style.display = 'flex';
    }
    slideIndex--;
}

function showSlides() {
  var i;
  var slides = document.getElementsByClassName("mySlides");
  for (i = 0; i < slides.length; i++) {
    slides[i].style.display = "none";   
  }
  slideIndex++;
  if (slideIndex > slides.length) {slideIndex = 1}    
  slides[slideIndex-1].style.display = "flex";
  setTimeout(showSlides, 6000);
}
</script>

<?php Default_Utilities::get_template_parts(array('parts/shared/footer-common', 'parts/shared/html-footer')); ?>
