<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * Please see /external/default-utilities.php for info on Default_Utilities::get_template_parts()
 *
 * @package 	WordPress
 * @subpackage 	Default
 * @since 		Default 4.0
 * Template name: Landing Page Consent
 */
?>
<?php Default_Utilities::get_template_parts( array( 'parts/shared/html-header' ) ); ?>
<div id="landingPage" style="background-image: url('<?php echo get_field('top_banner')['url']; ?>');">
	<div class="container">
    	<div class="row align-self-center bkg-transparent w-100Desktop">
	        <div class="col-md-12 bg-dblue">
		        <div class="row bg-dblue">
			        <div class="col-md-12 text-right pb-3 pt-4">
				        <a class="globalSiteLink" href="https://www.ferring.com" target="_blank"><i class="fas fa-globe-africa"></i> Go to Global Site</a>
				        <!--<btn class="globalSiteLink" id="comingSoon" target="_blank"></i> Go to Ferring UK Patient Hub</btn>-->
			        </div>
		        </div>
		        <div class="row ">
			        
			        <div class="col-md-12 text-center">
				        <img class="text-center py-3 headerLogo float-left" src="<?php bloginfo("template_url"); ?>/images/FerringLogo.png">
				        <h2 class="text-center py-3 font-weight-light text-white">Welcome to the Ferring Pharmaceuticals Ltd UK HCP Hub</h2>
			        </div>
		        </div>
		        <div class="row bg-white">
			        <div class="col-md-12 text-center">
						<h4 class="pb-3 pt-5 mb-0 font-weight-normal text-dblue">Here you will find information on Ferring's products and educational support</h4>
			        </div>
		        </div>
				<div class="row row-eq-height pb-4 bg-white">
					<div class="col-md-5 offset-md-1 py-3">
						<div class="consentBox card bg-lblue text-center">
							<h5 class="pb-2 font-weight-normal">I am a UK Health Care professional</h5>
							<div class="align">
								<p><span class="text-dblue">Important notice:</span><br> The Ferring UK Hub site is intended for registered UK healthcare professional only. By entering this site, you are confirming that you are a UK healthcare professional. This site may contain promotional information.</p>
							</div>
							<div class=" mt-auto">
								<a href="<?php echo $_COOKIE['previous']; ?>" class="btn btn-primary btn-consent text-uppercase">Enter UK Hub</a>
							</div>
						</div>
					</div>
					<div class="col-md-5 py-3">
						<div class="consentBox card bg-lblue text-center">
							<h5 class="pb-3 font-weight-normal">I am a member of the UK public</h5>
							<div class="align">
								<p><span class="text-dblue">Click below to be redirected</span><br />The website <span class="text-dblue">ferring.co.uk</span> is intended for members of the UK public.</p>
							</div>
							<div class=" mt-auto">
								<a href="http://www.ferring.co.uk" class="btn btn-primary btn-consent text-uppercase">www.ferring.co.uk</a>
							</div>
						</div>
					</div>
					<div class="bg-white">
						<div class="col-md-12 text-center">
							<p class="small">Job Code: <?php if(get_field('zinc_code')) { echo get_field('zinc_code'); } else { echo get_field('zinc_code', 380); } ?> DOP: <?php if(get_field('prep_date')) { echo get_field('prep_date'); } else { echo get_field('prep_date', 380); } ?></p>
						</div>
					</div>
				</div>
			</div>
    	</div>
    </div>
</div>
<script type="text/javascript">
  document.getElementById("comingSoon").addEventListener("click", function(){ 

       alert("Coming Soon");
       event.preventDefault();
   });
</script>
<script>
    var a = document.getElementsByTagName('a');
    var b = a.length;

    while(b--){
        a[b].onclick = function(){
            if(this.href.indexOf('ferringukhub.co.uk')<0 && this.href.indexOf('ferring.co.uk')<0 && this.href.indexOf('ferringukhcp.co.uk')<0 && this.href.indexOf('testavan.co.uk')<0 && this.href.indexOf('ferringforfertility.co.uk')<0){ 
                //They have clicked an external domain, display the message and open in a new tab
                confirm('You are now leaving our site, as per our terms and conditions we are not responsible for content published on other sites. Some of the products on the global site are not licensed in the UK');
                event.preventDefault();
				event.stopPropagation();
				window.open(this.href, '_blank');
            }
            else{
                //Internal links don't need allerting
            }
        };
    }
</script>
<?php Default_Utilities::get_template_parts( array( 'parts/shared/html-footer' ) ); ?>