<?php
/**
 * The Template for displaying all single posts
 *
 * Please see /external/default-utilities.php for info on Default_Utilities::get_template_parts()
 *
 * @package 	WordPress
 * @subpackage 	Default
 * @since 		Default 4.0
 */
?>
<?php Default_Utilities::get_template_parts( array( 'parts/shared/html-header', 'parts/shared/header' ) ); ?>

<article class="col span_8">

	<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>

		<h2><?php the_title(); ?></h2>
		<time datetime="<?php the_time( 'Y-m-d' ); ?>" pubdate><?php the_date(); ?> <?php the_time(); ?></time> <?php comments_popup_link('Leave a Comment', '1 Comment', '% Comments'); ?>
		<?php the_content(); ?>			

		<?php if ( get_the_author_meta( 'description' ) ) : ?>
		<?php echo get_avatar( get_the_author_meta( 'user_email' ) ); ?>
		<h3>About <?php echo get_the_author() ; ?></h3>
		<?php the_author_meta( 'description' ); ?>
		<?php endif; ?>

		<?php comments_template( '', true ); ?>

	<?php endwhile; ?>
</article>

<?php get_sidebar(); ?>
<?php Default_Utilities::get_template_parts( array( 'parts/shared/footer','parts/shared/html-footer' ) ); ?>
