<?php get_header();?>
<link href="<?php echo get_stylesheet_directory_uri();?>/style.css" rel="stylesheet">
<section class="Hero-Banner">
<?php 
			$image = get_field('_hero_image');
			if( !empty($image) ): ?>
			<div id="mainPhoto" style="background-image: url(<?php echo $image['url']; ?>);">
				<div class="container banner-container">
					<div class="row banner-row center-xs middle-xs start-sm">
						<div class="col-xs-12 col-lg-6">
							<div id="pageTitle">
								<div class="Banner-title">
									<?php if( get_field('_hero_title') ): ?>
										<h2><?php the_field('_hero_title'); ?></h2>
									<?php endif; ?>
								</div>
								<div class="Banner-subtitle"><?php the_field('_hero_subtitle'); ?></div>
								<!-- <div class="Banner-button">
									<?php /*
										$link = get_field('_hero_button_url');
										if( $link ): ?>
										    <a class="button" href="<?php echo esc_url( $link ); ?>">Read More</a>
									<?php endif;*/ ?>
								</div> -->
							</div>
						</div>
					</div>
			</div>
		<?php endif; ?>
</section>
<section class="Study">
	<div class="container study-container">
					<div class="row study-row center-xs middle-xs start-sm">
						<div class="col-lg-3"></div>
						<div class="study-column col-lg-6">
								<div class="study-title">
									<?php if( get_field('_study_section') ): ?>
											<h2><?php the_field('_study_section'); ?></h2>
									<?php endif; ?>
								</div>
								<div class="study-subtitle">
									<?php the_field('_study_description'); ?>
								</div>
						</div>
						<div class="col-lg-3"></div>
					</div>
	</div>
</section>
<section class="Study-involve">
	<div class="container study-involve-container">
					<div class="row study-involve-row center-xs middle-xs start-sm">
						<div class="col-lg-3"></div>
						<div class="study-involve-column col-lg-12">
								<div class="study-involve-title">
									<?php if( get_field('_study_involve_title') ): ?>
											<h2><?php the_field('_study_involve_title'); ?></h2>
									<?php endif; ?>
								</div>
								<div class="study-involve-subtitle">
									<?php if( have_rows('timeline') ): ?>
										    <ul class="study-timeline">
										    <?php while ( have_rows('timeline') ) : the_row(); ?>
										        <li><?php the_sub_field('study_timeline_column1'); ?></li>
										        <li><?php the_sub_field('study_timeline_column2'); ?></li>
										        <li><?php the_sub_field('study_timeline_column3'); ?></li>
										        <li><?php the_sub_field('study_timeline_column4'); ?></li>
										    <?php endwhile; ?>
										    </ul>
									<?php else : ?>
									    <p>No todos found.</p>
									<?php endif; ?>
											
								</div>
						</div>
					</div>
	</div>
</section>
<section class="Participate">
<?php 
			$img = get_field('_participate_bg_image');
			if( !empty($img) ): ?>
			<div id="participatePhoto" style="background-image: url(<?php echo $img['url']; ?>);">
				<div class="container participate-container">
					<div class="row participate-row center-xs middle-xs start-sm">
						<div class="col-lg-6">	
						</div>
						<div class="col-lg-6">
							<div id="participateTitle">
								<div class="participate-title">
										<?php if( get_field('_participate_title') ): ?>
											<h2><?php the_field('_participate_title'); ?></h2>
										<?php endif; ?>
								</div>	
								<div class="participate-iconbox">
										<div class="col-lg-6 participate-iconbox1">
											<?php if( get_field('_iconbox_text') ): ?>
												<p><?php the_field('_iconbox_text'); ?></p>
											<?php endif; ?>
										</div>
										<div class="col-lg-6 participate-iconbox2">
											<?php if( get_field('_iconbox_text2') ): ?>
												<p><?php the_field('_iconbox_text2'); ?></p>
											<?php endif; ?>
										</div>
										
								</div>					
								<div class="participate-iconbox-2">
										<div class="col-lg-6 participate-iconbox3">
											<?php if( get_field('_iconbox_text3') ): ?>
												<p><?php the_field('_iconbox_text3'); ?></p>
											<?php endif; ?>
										</div>
										<div class="col-lg-6 participate-iconbox4">
											<?php if( get_field('_iconbox_text4') ): ?>
												<p><?php the_field('_iconbox_text4'); ?></p>
											<?php endif; ?>
										</div>
								</div>						
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>
</section>

<section class="FAQ">
	<div class="container FAQ-container">
					<div class="row FAQ-row center-xs middle-xs start-sm">
						<div class="FAQ-column col-lg-12">
							<div class="FAQ-main-title">
									<?php if( get_field('faq_main_title') ): ?>
											<h2><?php the_field('faq_main_title'); ?></h2>
									<?php endif; ?>
								</div>
								<div class="FAQ-Description">

									<?php while( have_rows('faq') ): the_row();

									// vars
									$question = get_sub_field('faq_title');
									$answer = get_sub_field('faq_description');

									?>

									<div class="faq-container">
										<p class="faq-question"><?php echo $question; ?></p>
										<p class="faq-answer"><?php echo $answer; ?></p>
																		
										<?php if( get_sub_field('enable_reference') == 'Yes' ){ ?> 
											<div class="side-button-dark">
												<?php if( get_sub_field('faq_refer') ){ ?>
													<p><?php echo get_sub_field('faq_refer'); ?></p> 
												<?php } ?>
											</div> 
										<?php } ?>	
										</div>
										<?php endwhile; ?>			
								</div>
						</div>
					</div>
	</div>
</section>


<section class="MyData">
	<div class="container MyData-container">
					<div class="row MyData-row center-xs middle-xs start-sm">
						<div class="MyData-column col-lg-5">

							<div class="MyData-image" >
								<?php 
									$image = get_field('mydata_image');
									$size = 'full'; // (thumbnail, medium, large, full or custom size)
									if( $image ) {
									    echo wp_get_attachment_image( $image, $size );
									}
									?>
								</div>
								
						</div>
						<div class="MyData-content col-lg-7">
									<?php if( get_field('my_data_title') ): ?>
											<h2><?php the_field('my_data_title'); ?></h2>
											<p class="mydata-bullet"><?php the_field('mydata_content'); ?></p>
									<?php endif; ?>

								</div>
					</div>
	</div>
</section>

<section class="Map">
	<div class="container map-container">
					<div class="row map-row center-xs middle-xs start-sm">
						<div class="map-column col-lg-12">
							<?php if( get_field('clinic_location_title') ): ?>
											<h2><?php the_field('clinic_location_title'); ?></h2>
								<?php endif; ?>
									    <div class="acf-map" data-zoom="16">
											<?php 
												$location = get_field('clinic_location');
												if( $location ): ?>
												    <div class="acf-map" data-zoom="14">
												        <div class="marker" data-lat="<?php echo esc_attr($location['lat']); ?>" data-lng="<?php echo esc_attr($location['lng']); ?>"></div>
												    </div>
											<?php endif; ?>
									    </div>
								
								
						</div>
					</div>
	</div>
</section>


<section class="cta-Banner">
			<?php 
				$ctaimage = get_field('_cta_background');
			if( !empty($ctaimage) ): ?>
			<div id="ctaPhoto" style="background-image: url(<?php echo $ctaimage['url']; ?>);">
				<div class="container cta-container">
					<div class="row cta-row center-xs middle-xs start-sm">
						<div class="col-lg-12">
							<div id="ctaTitle">
								<div class="CTA-title">
									<?php if( get_field('cta_title') ): ?>
										<h2><?php the_field('cta_title'); ?></h2>
									<?php endif; ?>
								</div>
								
								<div class="CTA-button">
									<?php 
										$link = get_field('cta_button_url');
										if( $link ): ?>
										    <a class="cta-button" href="<?php echo esc_url( $link ); ?>">Visit CT.gov</a>
									<?php endif; ?>
								</div> 
							</div>
						</div>
					</div>
			</div>
		</div>
		<?php endif; ?>
</section>
<?php get_footer();?>